/* # site_url: https://stellaradvisoryservices.com */;
/* # home_url: https://stellaradvisoryservices.com */;
/* # content_url: https://stellaradvisoryservices.com/wp-content */;
/* # upload_url: https://stellaradvisoryservices.com/wp-content/uploads */;
/* # table_prefix: wpnc_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `wpnc_e_events`
--

DROP TABLE IF EXISTS `wpnc_e_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_e_events`
--

LOCK TABLES `wpnc_e_events` WRITE;
/*!40000 ALTER TABLE `wpnc_e_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_e_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_links`
--

DROP TABLE IF EXISTS `wpnc_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_links`
--

LOCK TABLES `wpnc_links` WRITE;
/*!40000 ALTER TABLE `wpnc_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_term_relationships`
--

DROP TABLE IF EXISTS `wpnc_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_term_relationships`
--

LOCK TABLES `wpnc_term_relationships` WRITE;
/*!40000 ALTER TABLE `wpnc_term_relationships` DISABLE KEYS */;
INSERT INTO `wpnc_term_relationships` VALUES (1,1,0);
INSERT INTO `wpnc_term_relationships` VALUES (8,2,0);
INSERT INTO `wpnc_term_relationships` VALUES (13,3,0);
INSERT INTO `wpnc_term_relationships` VALUES (24,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (78,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (120,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (129,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (134,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (137,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (229,5,0);
INSERT INTO `wpnc_term_relationships` VALUES (256,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (275,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (278,2,0);
INSERT INTO `wpnc_term_relationships` VALUES (280,6,0);
INSERT INTO `wpnc_term_relationships` VALUES (281,6,0);
INSERT INTO `wpnc_term_relationships` VALUES (282,6,0);
INSERT INTO `wpnc_term_relationships` VALUES (283,6,0);
INSERT INTO `wpnc_term_relationships` VALUES (290,4,0);
INSERT INTO `wpnc_term_relationships` VALUES (293,2,0);
INSERT INTO `wpnc_term_relationships` VALUES (306,7,0);
INSERT INTO `wpnc_term_relationships` VALUES (322,7,0);
INSERT INTO `wpnc_term_relationships` VALUES (327,8,0);
INSERT INTO `wpnc_term_relationships` VALUES (338,9,0);
INSERT INTO `wpnc_term_relationships` VALUES (371,4,0);
/*!40000 ALTER TABLE `wpnc_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_commentmeta`
--

DROP TABLE IF EXISTS `wpnc_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_commentmeta`
--

LOCK TABLES `wpnc_commentmeta` WRITE;
/*!40000 ALTER TABLE `wpnc_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_e_submissions_values`
--

DROP TABLE IF EXISTS `wpnc_e_submissions_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_e_submissions_values`
--

LOCK TABLES `wpnc_e_submissions_values` WRITE;
/*!40000 ALTER TABLE `wpnc_e_submissions_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_e_submissions_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_litespeed_url`
--

DROP TABLE IF EXISTS `wpnc_litespeed_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_litespeed_url`
--

LOCK TABLES `wpnc_litespeed_url` WRITE;
/*!40000 ALTER TABLE `wpnc_litespeed_url` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_litespeed_url` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_term_taxonomy`
--

DROP TABLE IF EXISTS `wpnc_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_term_taxonomy`
--

LOCK TABLES `wpnc_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `wpnc_term_taxonomy` DISABLE KEYS */;
INSERT INTO `wpnc_term_taxonomy` VALUES (1,1,'category','',0,1);
INSERT INTO `wpnc_term_taxonomy` VALUES (2,2,'elementor_library_type','',0,3);
INSERT INTO `wpnc_term_taxonomy` VALUES (3,3,'wp_theme','',0,1);
INSERT INTO `wpnc_term_taxonomy` VALUES (4,4,'elementor_library_type','',0,8);
INSERT INTO `wpnc_term_taxonomy` VALUES (5,5,'wp_theme','',0,1);
INSERT INTO `wpnc_term_taxonomy` VALUES (6,6,'nav_menu','',0,4);
INSERT INTO `wpnc_term_taxonomy` VALUES (7,7,'elementor_library_type','',0,2);
INSERT INTO `wpnc_term_taxonomy` VALUES (8,8,'elementor_library_type','',0,1);
INSERT INTO `wpnc_term_taxonomy` VALUES (9,9,'elementor_library_type','',0,1);
/*!40000 ALTER TABLE `wpnc_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_termmeta`
--

DROP TABLE IF EXISTS `wpnc_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_termmeta`
--

LOCK TABLES `wpnc_termmeta` WRITE;
/*!40000 ALTER TABLE `wpnc_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_terms`
--

DROP TABLE IF EXISTS `wpnc_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_terms`
--

LOCK TABLES `wpnc_terms` WRITE;
/*!40000 ALTER TABLE `wpnc_terms` DISABLE KEYS */;
INSERT INTO `wpnc_terms` VALUES (1,'Uncategorized','uncategorized',0);
INSERT INTO `wpnc_terms` VALUES (2,'section','section',0);
INSERT INTO `wpnc_terms` VALUES (3,'twentytwentyfive','twentytwentyfive',0);
INSERT INTO `wpnc_terms` VALUES (4,'page','page',0);
INSERT INTO `wpnc_terms` VALUES (5,'hello-elementor','hello-elementor',0);
INSERT INTO `wpnc_terms` VALUES (6,'Default','default',0);
INSERT INTO `wpnc_terms` VALUES (7,'container','container',0);
INSERT INTO `wpnc_terms` VALUES (8,'header','header',0);
INSERT INTO `wpnc_terms` VALUES (9,'footer','footer',0);
/*!40000 ALTER TABLE `wpnc_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_usermeta`
--

DROP TABLE IF EXISTS `wpnc_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_usermeta`
--

LOCK TABLES `wpnc_usermeta` WRITE;
/*!40000 ALTER TABLE `wpnc_usermeta` DISABLE KEYS */;
INSERT INTO `wpnc_usermeta` VALUES (1,1,'nickname','Excom');
INSERT INTO `wpnc_usermeta` VALUES (2,1,'first_name','');
INSERT INTO `wpnc_usermeta` VALUES (3,1,'last_name','');
INSERT INTO `wpnc_usermeta` VALUES (4,1,'description','');
INSERT INTO `wpnc_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `wpnc_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `wpnc_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `wpnc_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `wpnc_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `wpnc_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `wpnc_usermeta` VALUES (11,1,'locale','');
INSERT INTO `wpnc_usermeta` VALUES (12,1,'wpnc_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wpnc_usermeta` VALUES (13,1,'wpnc_user_level','10');
INSERT INTO `wpnc_usermeta` VALUES (14,1,'dismissed_wp_pointers','');
INSERT INTO `wpnc_usermeta` VALUES (15,1,'show_welcome_panel','1');
INSERT INTO `wpnc_usermeta` VALUES (17,1,'wpnc_dashboard_quick_press_last_post_id','441');
INSERT INTO `wpnc_usermeta` VALUES (18,1,'community-events-location','a:1:{s:2:"ip";s:11:"103.52.69.0";}');
INSERT INTO `wpnc_usermeta` VALUES (19,1,'wpnc_persisted_preferences','a:3:{s:4:"core";a:1:{s:26:"isComplementaryAreaVisible";b:1;}s:14:"core/edit-post";a:1:{s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2025-01-08T07:30:54.616Z";}');
INSERT INTO `wpnc_usermeta` VALUES (20,1,'elementor_introduction','a:2:{s:27:"ai-get-started-announcement";b:1;s:20:"globals_introduction";b:1;}');
INSERT INTO `wpnc_usermeta` VALUES (21,1,'wpnc_user-settings','libraryContent=browse&editor=tinymce');
INSERT INTO `wpnc_usermeta` VALUES (22,1,'wpnc_user-settings-time','1736388304');
INSERT INTO `wpnc_usermeta` VALUES (23,1,'elementor_dismissed_editor_notices','a:1:{i:0;s:20:"image_optimizer_hint";}');
INSERT INTO `wpnc_usermeta` VALUES (24,1,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `wpnc_usermeta` VALUES (25,1,'metaboxhidden_nav-menus','a:1:{i:0;s:12:"add-post_tag";}');
INSERT INTO `wpnc_usermeta` VALUES (26,2,'nickname','owner');
INSERT INTO `wpnc_usermeta` VALUES (27,2,'first_name','Stellar');
INSERT INTO `wpnc_usermeta` VALUES (28,2,'last_name','Advisory');
INSERT INTO `wpnc_usermeta` VALUES (29,2,'description','');
INSERT INTO `wpnc_usermeta` VALUES (30,2,'rich_editing','true');
INSERT INTO `wpnc_usermeta` VALUES (31,2,'syntax_highlighting','true');
INSERT INTO `wpnc_usermeta` VALUES (32,2,'comment_shortcuts','false');
INSERT INTO `wpnc_usermeta` VALUES (33,2,'admin_color','fresh');
INSERT INTO `wpnc_usermeta` VALUES (34,2,'use_ssl','0');
INSERT INTO `wpnc_usermeta` VALUES (35,2,'show_admin_bar_front','true');
INSERT INTO `wpnc_usermeta` VALUES (36,2,'locale','');
INSERT INTO `wpnc_usermeta` VALUES (37,2,'wpnc_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wpnc_usermeta` VALUES (38,2,'wpnc_user_level','10');
INSERT INTO `wpnc_usermeta` VALUES (39,2,'dismissed_wp_pointers','');
INSERT INTO `wpnc_usermeta` VALUES (41,2,'wpnc_dashboard_quick_press_last_post_id','440');
INSERT INTO `wpnc_usermeta` VALUES (42,2,'community-events-location','a:1:{s:2:"ip";s:12:"58.147.190.0";}');
INSERT INTO `wpnc_usermeta` VALUES (43,1,'session_tokens','a:1:{s:64:"107b0e4d82a320091c7ebbb267a814e053cd0ed3da7d8ac9b031b742a514179c";a:4:{s:10:"expiration";i:1766987526;s:2:"ip";s:11:"103.52.69.5";s:2:"ua";s:111:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36";s:5:"login";i:1766814726;}}');
/*!40000 ALTER TABLE `wpnc_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_users`
--

DROP TABLE IF EXISTS `wpnc_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_users`
--

LOCK TABLES `wpnc_users` WRITE;
/*!40000 ALTER TABLE `wpnc_users` DISABLE KEYS */;
INSERT INTO `wpnc_users` VALUES (1,'Excom','$P$BQr28Md5U9LR9BaNCvPRSOgwm9dtRt/','excom','venture.publish@gmail.com','https://stellaradvisoryservices.com','2025-01-08 06:58:46','',0,'Excom');
INSERT INTO `wpnc_users` VALUES (2,'owner','$P$BAyMi86W3Wod.Qu2mjol67EdPIUCjO.','owner','stellaradvisoryservices.sas@gmail.com','','2025-01-29 06:24:27','',0,'Stellar Advisory');
/*!40000 ALTER TABLE `wpnc_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_comments`
--

DROP TABLE IF EXISTS `wpnc_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_comments`
--

LOCK TABLES `wpnc_comments` WRITE;
/*!40000 ALTER TABLE `wpnc_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_litespeed_url_file`
--

DROP TABLE IF EXISTS `wpnc_litespeed_url_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_litespeed_url_file`
--

LOCK TABLES `wpnc_litespeed_url_file` WRITE;
/*!40000 ALTER TABLE `wpnc_litespeed_url_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_litespeed_url_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_e_submissions_actions_log`
--

DROP TABLE IF EXISTS `wpnc_e_submissions_actions_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_e_submissions_actions_log`
--

LOCK TABLES `wpnc_e_submissions_actions_log` WRITE;
/*!40000 ALTER TABLE `wpnc_e_submissions_actions_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_e_submissions_actions_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_e_submissions`
--

DROP TABLE IF EXISTS `wpnc_e_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_e_submissions`
--

LOCK TABLES `wpnc_e_submissions` WRITE;
/*!40000 ALTER TABLE `wpnc_e_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpnc_e_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpnc_options`
--

DROP TABLE IF EXISTS `wpnc_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpnc_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=24203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpnc_options`
--

LOCK TABLES `wpnc_options` WRITE;
/*!40000 ALTER TABLE `wpnc_options` DISABLE KEYS */;
INSERT INTO `wpnc_options` VALUES (1,'cron','a:15:{i:1766815051;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"3f9df668d26228af44ce2007c9ece7a3";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-f36997a968247";}}}}i:1766815058;a:1:{s:29:"rsssl_every_five_minutes_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:18:"rsssl_five_minutes";s:4:"args";a:0:{}s:8:"interval";i:300;}}}i:1766815127;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1766818726;a:2:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1766818727;a:1:{s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1766818814;a:3:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1766818816;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1766820158;a:2:{s:20:"rsssl_every_day_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:11:"rsssl_daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:28:"rsssl_every_three_hours_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:23:"rsssl_every_three_hours";s:4:"args";a:0:{}s:8:"interval";i:10800;}}}i:1766820240;a:1:{s:28:"elementor/tracker/send_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1766963912;a:1:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1767165681;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1767165758;a:1:{s:21:"rsssl_every_week_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:12:"rsssl_weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1767250726;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1767424958;a:1:{s:22:"rsssl_every_month_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:13:"rsssl_monthly";s:4:"args";a:0:{}s:8:"interval";i:2592000;}}}s:7:"version";i:2;}','on');
INSERT INTO `wpnc_options` VALUES (2,'siteurl','https://stellaradvisoryservices.com','on');
INSERT INTO `wpnc_options` VALUES (3,'home','https://stellaradvisoryservices.com','on');
INSERT INTO `wpnc_options` VALUES (4,'blogname','STELLAR ADVISORY SERVICES','on');
INSERT INTO `wpnc_options` VALUES (5,'blogdescription','Empowering People To Succeed','on');
INSERT INTO `wpnc_options` VALUES (6,'users_can_register','0','auto');
INSERT INTO `wpnc_options` VALUES (7,'admin_email','venture.publish@gmail.com','on');
INSERT INTO `wpnc_options` VALUES (8,'start_of_week','1','on');
INSERT INTO `wpnc_options` VALUES (9,'use_balanceTags','0','on');
INSERT INTO `wpnc_options` VALUES (10,'use_smilies','1','on');
INSERT INTO `wpnc_options` VALUES (11,'require_name_email','1','on');
INSERT INTO `wpnc_options` VALUES (12,'comments_notify','1','on');
INSERT INTO `wpnc_options` VALUES (13,'posts_per_rss','10','on');
INSERT INTO `wpnc_options` VALUES (14,'rss_use_excerpt','0','on');
INSERT INTO `wpnc_options` VALUES (15,'mailserver_url','mail.example.com','on');
INSERT INTO `wpnc_options` VALUES (16,'mailserver_login','login@example.com','on');
INSERT INTO `wpnc_options` VALUES (17,'mailserver_pass','','on');
INSERT INTO `wpnc_options` VALUES (18,'mailserver_port','110','on');
INSERT INTO `wpnc_options` VALUES (19,'default_category','1','on');
INSERT INTO `wpnc_options` VALUES (20,'default_comment_status','open','on');
INSERT INTO `wpnc_options` VALUES (21,'default_ping_status','open','on');
INSERT INTO `wpnc_options` VALUES (22,'default_pingback_flag','1','on');
INSERT INTO `wpnc_options` VALUES (23,'posts_per_page','10','on');
INSERT INTO `wpnc_options` VALUES (24,'date_format','F j, Y','on');
INSERT INTO `wpnc_options` VALUES (25,'time_format','g:i a','on');
INSERT INTO `wpnc_options` VALUES (26,'links_updated_date_format','F j, Y g:i a','on');
INSERT INTO `wpnc_options` VALUES (27,'comment_moderation','0','on');
INSERT INTO `wpnc_options` VALUES (28,'moderation_notify','1','on');
INSERT INTO `wpnc_options` VALUES (29,'permalink_structure','/%postname%/','on');
INSERT INTO `wpnc_options` VALUES (30,'rewrite_rules','a:123:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:46:"e-floating-buttons/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:56:"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:76:"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:71:"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:71:"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:52:"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:35:"e-floating-buttons/([^/]+)/embed/?$";s:51:"index.php?e-floating-buttons=$matches[1]&embed=true";s:39:"e-floating-buttons/([^/]+)/trackback/?$";s:45:"index.php?e-floating-buttons=$matches[1]&tb=1";s:47:"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$";s:58:"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]";s:54:"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$";s:58:"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]";s:43:"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$";s:57:"index.php?e-floating-buttons=$matches[1]&page=$matches[2]";s:35:"e-floating-buttons/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:45:"e-floating-buttons/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:65:"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:41:"e-floating-buttons/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:38:"metform-form/.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:48:"metform-form/.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:68:"metform-form/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"metform-form/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"metform-form/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:44:"metform-form/.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:27:"metform-form/(.+?)/embed/?$";s:45:"index.php?metform-form=$matches[1]&embed=true";s:31:"metform-form/(.+?)/trackback/?$";s:39:"index.php?metform-form=$matches[1]&tb=1";s:39:"metform-form/(.+?)/page/?([0-9]{1,})/?$";s:52:"index.php?metform-form=$matches[1]&paged=$matches[2]";s:46:"metform-form/(.+?)/comment-page-([0-9]{1,})/?$";s:52:"index.php?metform-form=$matches[1]&cpage=$matches[2]";s:35:"metform-form/(.+?)(?:/([0-9]+))?/?$";s:51:"index.php?metform-form=$matches[1]&page=$matches[2]";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:12:"sitemap\\.xml";s:23:"index.php?sitemap=index";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:39:"index.php?&page_id=12&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}','on');
INSERT INTO `wpnc_options` VALUES (31,'hack_file','0','on');
INSERT INTO `wpnc_options` VALUES (32,'blog_charset','UTF-8','on');
INSERT INTO `wpnc_options` VALUES (33,'moderation_keys','','off');
INSERT INTO `wpnc_options` VALUES (34,'active_plugins','a:7:{i:0;s:31:"elementor-pro/elementor-pro.php";i:1;s:23:"elementor/elementor.php";i:2;s:39:"jeg-elementor-kit/jeg-elementor-kit.php";i:3;s:19:"metform/metform.php";i:4;s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";i:5;s:29:"wpt-whatsapp/wpt-whatsapp.php";i:6;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','on');
INSERT INTO `wpnc_options` VALUES (35,'category_base','','on');
INSERT INTO `wpnc_options` VALUES (36,'ping_sites','https://rpc.pingomatic.com/','on');
INSERT INTO `wpnc_options` VALUES (37,'comment_max_links','2','on');
INSERT INTO `wpnc_options` VALUES (38,'gmt_offset','','on');
INSERT INTO `wpnc_options` VALUES (39,'default_email_category','1','on');
INSERT INTO `wpnc_options` VALUES (40,'recently_edited','','off');
INSERT INTO `wpnc_options` VALUES (41,'template','hello-elementor','on');
INSERT INTO `wpnc_options` VALUES (42,'stylesheet','hello-elementor','on');
INSERT INTO `wpnc_options` VALUES (43,'comment_registration','0','on');
INSERT INTO `wpnc_options` VALUES (44,'html_type','text/html','on');
INSERT INTO `wpnc_options` VALUES (45,'use_trackback','0','on');
INSERT INTO `wpnc_options` VALUES (46,'default_role','subscriber','on');
INSERT INTO `wpnc_options` VALUES (47,'db_version','60717','on');
INSERT INTO `wpnc_options` VALUES (48,'uploads_use_yearmonth_folders','1','on');
INSERT INTO `wpnc_options` VALUES (49,'upload_path','','on');
INSERT INTO `wpnc_options` VALUES (50,'blog_public','1','on');
INSERT INTO `wpnc_options` VALUES (51,'default_link_category','2','on');
INSERT INTO `wpnc_options` VALUES (52,'show_on_front','page','on');
INSERT INTO `wpnc_options` VALUES (53,'tag_base','','on');
INSERT INTO `wpnc_options` VALUES (54,'show_avatars','1','on');
INSERT INTO `wpnc_options` VALUES (55,'avatar_rating','G','on');
INSERT INTO `wpnc_options` VALUES (56,'upload_url_path','','on');
INSERT INTO `wpnc_options` VALUES (57,'thumbnail_size_w','150','on');
INSERT INTO `wpnc_options` VALUES (58,'thumbnail_size_h','150','on');
INSERT INTO `wpnc_options` VALUES (59,'thumbnail_crop','1','on');
INSERT INTO `wpnc_options` VALUES (60,'medium_size_w','300','on');
INSERT INTO `wpnc_options` VALUES (61,'medium_size_h','300','on');
INSERT INTO `wpnc_options` VALUES (62,'avatar_default','mystery','on');
INSERT INTO `wpnc_options` VALUES (63,'large_size_w','1024','on');
INSERT INTO `wpnc_options` VALUES (64,'large_size_h','1024','on');
INSERT INTO `wpnc_options` VALUES (65,'image_default_link_type','none','on');
INSERT INTO `wpnc_options` VALUES (66,'image_default_size','','on');
INSERT INTO `wpnc_options` VALUES (67,'image_default_align','','on');
INSERT INTO `wpnc_options` VALUES (68,'close_comments_for_old_posts','0','on');
INSERT INTO `wpnc_options` VALUES (69,'close_comments_days_old','14','on');
INSERT INTO `wpnc_options` VALUES (70,'thread_comments','1','on');
INSERT INTO `wpnc_options` VALUES (71,'thread_comments_depth','5','on');
INSERT INTO `wpnc_options` VALUES (72,'page_comments','0','on');
INSERT INTO `wpnc_options` VALUES (73,'comments_per_page','50','on');
INSERT INTO `wpnc_options` VALUES (74,'default_comments_page','newest','on');
INSERT INTO `wpnc_options` VALUES (75,'comment_order','asc','on');
INSERT INTO `wpnc_options` VALUES (76,'sticky_posts','a:0:{}','on');
INSERT INTO `wpnc_options` VALUES (77,'widget_categories','a:0:{}','on');
INSERT INTO `wpnc_options` VALUES (78,'widget_text','a:0:{}','on');
INSERT INTO `wpnc_options` VALUES (79,'widget_rss','a:0:{}','on');
INSERT INTO `wpnc_options` VALUES (80,'uninstall_plugins','a:4:{s:23:"elementor/elementor.php";a:2:{i:0;s:21:"Elementor\\Maintenance";i:1;s:9:"uninstall";}s:35:"litespeed-cache/litespeed-cache.php";s:47:"LiteSpeed\\Activation::uninstall_litespeed_cache";s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";s:56:"ReallySimplePlugins\\RSS\\Core\\Bootstrap\\Plugin::uninstall";s:46:"under-construction-page/under-construction.php";a:2:{i:0;s:3:"UCP";i:1;s:9:"uninstall";}}','off');
INSERT INTO `wpnc_options` VALUES (81,'timezone_string','Asia/Jakarta','on');
INSERT INTO `wpnc_options` VALUES (82,'page_for_posts','0','on');
INSERT INTO `wpnc_options` VALUES (83,'page_on_front','12','on');
INSERT INTO `wpnc_options` VALUES (84,'default_post_format','0','on');
INSERT INTO `wpnc_options` VALUES (85,'link_manager_enabled','0','on');
INSERT INTO `wpnc_options` VALUES (86,'finished_splitting_shared_terms','1','on');
INSERT INTO `wpnc_options` VALUES (87,'site_icon','49','on');
INSERT INTO `wpnc_options` VALUES (88,'medium_large_size_w','768','on');
INSERT INTO `wpnc_options` VALUES (89,'medium_large_size_h','0','on');
INSERT INTO `wpnc_options` VALUES (90,'wp_page_for_privacy_policy','3','on');
INSERT INTO `wpnc_options` VALUES (91,'show_comments_cookies_opt_in','1','on');
INSERT INTO `wpnc_options` VALUES (92,'admin_email_lifespan','1751871526','on');
INSERT INTO `wpnc_options` VALUES (93,'disallowed_keys','','off');
INSERT INTO `wpnc_options` VALUES (94,'comment_previously_approved','1','on');
INSERT INTO `wpnc_options` VALUES (95,'auto_plugin_theme_update_emails','a:0:{}','off');
INSERT INTO `wpnc_options` VALUES (96,'auto_update_core_dev','enabled','on');
INSERT INTO `wpnc_options` VALUES (97,'auto_update_core_minor','enabled','on');
INSERT INTO `wpnc_options` VALUES (98,'auto_update_core_major','enabled','on');
INSERT INTO `wpnc_options` VALUES (99,'wp_force_deactivated_plugins','a:0:{}','on');
INSERT INTO `wpnc_options` VALUES (100,'wp_attachment_pages_enabled','0','on');
INSERT INTO `wpnc_options` VALUES (101,'initial_db_version','58975','on');
INSERT INTO `wpnc_options` VALUES (102,'wpnc_user_roles','a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:62:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:15:"manage_security";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}','on');
INSERT INTO `wpnc_options` VALUES (103,'fresh_site','0','off');
INSERT INTO `wpnc_options` VALUES (104,'user_count','2','off');
INSERT INTO `wpnc_options` VALUES (105,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (106,'sidebars_widgets','a:2:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:13:"array_version";i:3;}','auto');
INSERT INTO `wpnc_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (121,'recovery_keys','a:0:{}','off');
INSERT INTO `wpnc_options` VALUES (122,'theme_mods_twentytwentyfive','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1736388462;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}','off');
INSERT INTO `wpnc_options` VALUES (123,'_transient_wp_core_block_css_files','a:2:{s:7:"version";s:3:"6.9";s:5:"files";a:584:{i:0;s:31:"accordion-heading/style-rtl.css";i:1;s:35:"accordion-heading/style-rtl.min.css";i:2;s:27:"accordion-heading/style.css";i:3;s:31:"accordion-heading/style.min.css";i:4;s:28:"accordion-item/style-rtl.css";i:5;s:32:"accordion-item/style-rtl.min.css";i:6;s:24:"accordion-item/style.css";i:7;s:28:"accordion-item/style.min.css";i:8;s:29:"accordion-panel/style-rtl.css";i:9;s:33:"accordion-panel/style-rtl.min.css";i:10;s:25:"accordion-panel/style.css";i:11;s:29:"accordion-panel/style.min.css";i:12;s:23:"accordion/style-rtl.css";i:13;s:27:"accordion/style-rtl.min.css";i:14;s:19:"accordion/style.css";i:15;s:23:"accordion/style.min.css";i:16;s:23:"archives/editor-rtl.css";i:17;s:27:"archives/editor-rtl.min.css";i:18;s:19:"archives/editor.css";i:19;s:23:"archives/editor.min.css";i:20;s:22:"archives/style-rtl.css";i:21;s:26:"archives/style-rtl.min.css";i:22;s:18:"archives/style.css";i:23;s:22:"archives/style.min.css";i:24;s:20:"audio/editor-rtl.css";i:25;s:24:"audio/editor-rtl.min.css";i:26;s:16:"audio/editor.css";i:27;s:20:"audio/editor.min.css";i:28;s:19:"audio/style-rtl.css";i:29;s:23:"audio/style-rtl.min.css";i:30;s:15:"audio/style.css";i:31;s:19:"audio/style.min.css";i:32;s:19:"audio/theme-rtl.css";i:33;s:23:"audio/theme-rtl.min.css";i:34;s:15:"audio/theme.css";i:35;s:19:"audio/theme.min.css";i:36;s:21:"avatar/editor-rtl.css";i:37;s:25:"avatar/editor-rtl.min.css";i:38;s:17:"avatar/editor.css";i:39;s:21:"avatar/editor.min.css";i:40;s:20:"avatar/style-rtl.css";i:41;s:24:"avatar/style-rtl.min.css";i:42;s:16:"avatar/style.css";i:43;s:20:"avatar/style.min.css";i:44;s:21:"button/editor-rtl.css";i:45;s:25:"button/editor-rtl.min.css";i:46;s:17:"button/editor.css";i:47;s:21:"button/editor.min.css";i:48;s:20:"button/style-rtl.css";i:49;s:24:"button/style-rtl.min.css";i:50;s:16:"button/style.css";i:51;s:20:"button/style.min.css";i:52;s:22:"buttons/editor-rtl.css";i:53;s:26:"buttons/editor-rtl.min.css";i:54;s:18:"buttons/editor.css";i:55;s:22:"buttons/editor.min.css";i:56;s:21:"buttons/style-rtl.css";i:57;s:25:"buttons/style-rtl.min.css";i:58;s:17:"buttons/style.css";i:59;s:21:"buttons/style.min.css";i:60;s:22:"calendar/style-rtl.css";i:61;s:26:"calendar/style-rtl.min.css";i:62;s:18:"calendar/style.css";i:63;s:22:"calendar/style.min.css";i:64;s:25:"categories/editor-rtl.css";i:65;s:29:"categories/editor-rtl.min.css";i:66;s:21:"categories/editor.css";i:67;s:25:"categories/editor.min.css";i:68;s:24:"categories/style-rtl.css";i:69;s:28:"categories/style-rtl.min.css";i:70;s:20:"categories/style.css";i:71;s:24:"categories/style.min.css";i:72;s:19:"code/editor-rtl.css";i:73;s:23:"code/editor-rtl.min.css";i:74;s:15:"code/editor.css";i:75;s:19:"code/editor.min.css";i:76;s:18:"code/style-rtl.css";i:77;s:22:"code/style-rtl.min.css";i:78;s:14:"code/style.css";i:79;s:18:"code/style.min.css";i:80;s:18:"code/theme-rtl.css";i:81;s:22:"code/theme-rtl.min.css";i:82;s:14:"code/theme.css";i:83;s:18:"code/theme.min.css";i:84;s:22:"columns/editor-rtl.css";i:85;s:26:"columns/editor-rtl.min.css";i:86;s:18:"columns/editor.css";i:87;s:22:"columns/editor.min.css";i:88;s:21:"columns/style-rtl.css";i:89;s:25:"columns/style-rtl.min.css";i:90;s:17:"columns/style.css";i:91;s:21:"columns/style.min.css";i:92;s:33:"comment-author-name/style-rtl.css";i:93;s:37:"comment-author-name/style-rtl.min.css";i:94;s:29:"comment-author-name/style.css";i:95;s:33:"comment-author-name/style.min.css";i:96;s:29:"comment-content/style-rtl.css";i:97;s:33:"comment-content/style-rtl.min.css";i:98;s:25:"comment-content/style.css";i:99;s:29:"comment-content/style.min.css";i:100;s:26:"comment-date/style-rtl.css";i:101;s:30:"comment-date/style-rtl.min.css";i:102;s:22:"comment-date/style.css";i:103;s:26:"comment-date/style.min.css";i:104;s:31:"comment-edit-link/style-rtl.css";i:105;s:35:"comment-edit-link/style-rtl.min.css";i:106;s:27:"comment-edit-link/style.css";i:107;s:31:"comment-edit-link/style.min.css";i:108;s:32:"comment-reply-link/style-rtl.css";i:109;s:36:"comment-reply-link/style-rtl.min.css";i:110;s:28:"comment-reply-link/style.css";i:111;s:32:"comment-reply-link/style.min.css";i:112;s:30:"comment-template/style-rtl.css";i:113;s:34:"comment-template/style-rtl.min.css";i:114;s:26:"comment-template/style.css";i:115;s:30:"comment-template/style.min.css";i:116;s:42:"comments-pagination-numbers/editor-rtl.css";i:117;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:118;s:38:"comments-pagination-numbers/editor.css";i:119;s:42:"comments-pagination-numbers/editor.min.css";i:120;s:34:"comments-pagination/editor-rtl.css";i:121;s:38:"comments-pagination/editor-rtl.min.css";i:122;s:30:"comments-pagination/editor.css";i:123;s:34:"comments-pagination/editor.min.css";i:124;s:33:"comments-pagination/style-rtl.css";i:125;s:37:"comments-pagination/style-rtl.min.css";i:126;s:29:"comments-pagination/style.css";i:127;s:33:"comments-pagination/style.min.css";i:128;s:29:"comments-title/editor-rtl.css";i:129;s:33:"comments-title/editor-rtl.min.css";i:130;s:25:"comments-title/editor.css";i:131;s:29:"comments-title/editor.min.css";i:132;s:23:"comments/editor-rtl.css";i:133;s:27:"comments/editor-rtl.min.css";i:134;s:19:"comments/editor.css";i:135;s:23:"comments/editor.min.css";i:136;s:22:"comments/style-rtl.css";i:137;s:26:"comments/style-rtl.min.css";i:138;s:18:"comments/style.css";i:139;s:22:"comments/style.min.css";i:140;s:20:"cover/editor-rtl.css";i:141;s:24:"cover/editor-rtl.min.css";i:142;s:16:"cover/editor.css";i:143;s:20:"cover/editor.min.css";i:144;s:19:"cover/style-rtl.css";i:145;s:23:"cover/style-rtl.min.css";i:146;s:15:"cover/style.css";i:147;s:19:"cover/style.min.css";i:148;s:22:"details/editor-rtl.css";i:149;s:26:"details/editor-rtl.min.css";i:150;s:18:"details/editor.css";i:151;s:22:"details/editor.min.css";i:152;s:21:"details/style-rtl.css";i:153;s:25:"details/style-rtl.min.css";i:154;s:17:"details/style.css";i:155;s:21:"details/style.min.css";i:156;s:20:"embed/editor-rtl.css";i:157;s:24:"embed/editor-rtl.min.css";i:158;s:16:"embed/editor.css";i:159;s:20:"embed/editor.min.css";i:160;s:19:"embed/style-rtl.css";i:161;s:23:"embed/style-rtl.min.css";i:162;s:15:"embed/style.css";i:163;s:19:"embed/style.min.css";i:164;s:19:"embed/theme-rtl.css";i:165;s:23:"embed/theme-rtl.min.css";i:166;s:15:"embed/theme.css";i:167;s:19:"embed/theme.min.css";i:168;s:19:"file/editor-rtl.css";i:169;s:23:"file/editor-rtl.min.css";i:170;s:15:"file/editor.css";i:171;s:19:"file/editor.min.css";i:172;s:18:"file/style-rtl.css";i:173;s:22:"file/style-rtl.min.css";i:174;s:14:"file/style.css";i:175;s:18:"file/style.min.css";i:176;s:23:"footnotes/style-rtl.css";i:177;s:27:"footnotes/style-rtl.min.css";i:178;s:19:"footnotes/style.css";i:179;s:23:"footnotes/style.min.css";i:180;s:23:"freeform/editor-rtl.css";i:181;s:27:"freeform/editor-rtl.min.css";i:182;s:19:"freeform/editor.css";i:183;s:23:"freeform/editor.min.css";i:184;s:22:"gallery/editor-rtl.css";i:185;s:26:"gallery/editor-rtl.min.css";i:186;s:18:"gallery/editor.css";i:187;s:22:"gallery/editor.min.css";i:188;s:21:"gallery/style-rtl.css";i:189;s:25:"gallery/style-rtl.min.css";i:190;s:17:"gallery/style.css";i:191;s:21:"gallery/style.min.css";i:192;s:21:"gallery/theme-rtl.css";i:193;s:25:"gallery/theme-rtl.min.css";i:194;s:17:"gallery/theme.css";i:195;s:21:"gallery/theme.min.css";i:196;s:20:"group/editor-rtl.css";i:197;s:24:"group/editor-rtl.min.css";i:198;s:16:"group/editor.css";i:199;s:20:"group/editor.min.css";i:200;s:19:"group/style-rtl.css";i:201;s:23:"group/style-rtl.min.css";i:202;s:15:"group/style.css";i:203;s:19:"group/style.min.css";i:204;s:19:"group/theme-rtl.css";i:205;s:23:"group/theme-rtl.min.css";i:206;s:15:"group/theme.css";i:207;s:19:"group/theme.min.css";i:208;s:21:"heading/style-rtl.css";i:209;s:25:"heading/style-rtl.min.css";i:210;s:17:"heading/style.css";i:211;s:21:"heading/style.min.css";i:212;s:19:"html/editor-rtl.css";i:213;s:23:"html/editor-rtl.min.css";i:214;s:15:"html/editor.css";i:215;s:19:"html/editor.min.css";i:216;s:20:"image/editor-rtl.css";i:217;s:24:"image/editor-rtl.min.css";i:218;s:16:"image/editor.css";i:219;s:20:"image/editor.min.css";i:220;s:19:"image/style-rtl.css";i:221;s:23:"image/style-rtl.min.css";i:222;s:15:"image/style.css";i:223;s:19:"image/style.min.css";i:224;s:19:"image/theme-rtl.css";i:225;s:23:"image/theme-rtl.min.css";i:226;s:15:"image/theme.css";i:227;s:19:"image/theme.min.css";i:228;s:29:"latest-comments/style-rtl.css";i:229;s:33:"latest-comments/style-rtl.min.css";i:230;s:25:"latest-comments/style.css";i:231;s:29:"latest-comments/style.min.css";i:232;s:27:"latest-posts/editor-rtl.css";i:233;s:31:"latest-posts/editor-rtl.min.css";i:234;s:23:"latest-posts/editor.css";i:235;s:27:"latest-posts/editor.min.css";i:236;s:26:"latest-posts/style-rtl.css";i:237;s:30:"latest-posts/style-rtl.min.css";i:238;s:22:"latest-posts/style.css";i:239;s:26:"latest-posts/style.min.css";i:240;s:18:"list/style-rtl.css";i:241;s:22:"list/style-rtl.min.css";i:242;s:14:"list/style.css";i:243;s:18:"list/style.min.css";i:244;s:22:"loginout/style-rtl.css";i:245;s:26:"loginout/style-rtl.min.css";i:246;s:18:"loginout/style.css";i:247;s:22:"loginout/style.min.css";i:248;s:19:"math/editor-rtl.css";i:249;s:23:"math/editor-rtl.min.css";i:250;s:15:"math/editor.css";i:251;s:19:"math/editor.min.css";i:252;s:18:"math/style-rtl.css";i:253;s:22:"math/style-rtl.min.css";i:254;s:14:"math/style.css";i:255;s:18:"math/style.min.css";i:256;s:25:"media-text/editor-rtl.css";i:257;s:29:"media-text/editor-rtl.min.css";i:258;s:21:"media-text/editor.css";i:259;s:25:"media-text/editor.min.css";i:260;s:24:"media-text/style-rtl.css";i:261;s:28:"media-text/style-rtl.min.css";i:262;s:20:"media-text/style.css";i:263;s:24:"media-text/style.min.css";i:264;s:19:"more/editor-rtl.css";i:265;s:23:"more/editor-rtl.min.css";i:266;s:15:"more/editor.css";i:267;s:19:"more/editor.min.css";i:268;s:30:"navigation-link/editor-rtl.css";i:269;s:34:"navigation-link/editor-rtl.min.css";i:270;s:26:"navigation-link/editor.css";i:271;s:30:"navigation-link/editor.min.css";i:272;s:29:"navigation-link/style-rtl.css";i:273;s:33:"navigation-link/style-rtl.min.css";i:274;s:25:"navigation-link/style.css";i:275;s:29:"navigation-link/style.min.css";i:276;s:33:"navigation-submenu/editor-rtl.css";i:277;s:37:"navigation-submenu/editor-rtl.min.css";i:278;s:29:"navigation-submenu/editor.css";i:279;s:33:"navigation-submenu/editor.min.css";i:280;s:25:"navigation/editor-rtl.css";i:281;s:29:"navigation/editor-rtl.min.css";i:282;s:21:"navigation/editor.css";i:283;s:25:"navigation/editor.min.css";i:284;s:24:"navigation/style-rtl.css";i:285;s:28:"navigation/style-rtl.min.css";i:286;s:20:"navigation/style.css";i:287;s:24:"navigation/style.min.css";i:288;s:23:"nextpage/editor-rtl.css";i:289;s:27:"nextpage/editor-rtl.min.css";i:290;s:19:"nextpage/editor.css";i:291;s:23:"nextpage/editor.min.css";i:292;s:24:"page-list/editor-rtl.css";i:293;s:28:"page-list/editor-rtl.min.css";i:294;s:20:"page-list/editor.css";i:295;s:24:"page-list/editor.min.css";i:296;s:23:"page-list/style-rtl.css";i:297;s:27:"page-list/style-rtl.min.css";i:298;s:19:"page-list/style.css";i:299;s:23:"page-list/style.min.css";i:300;s:24:"paragraph/editor-rtl.css";i:301;s:28:"paragraph/editor-rtl.min.css";i:302;s:20:"paragraph/editor.css";i:303;s:24:"paragraph/editor.min.css";i:304;s:23:"paragraph/style-rtl.css";i:305;s:27:"paragraph/style-rtl.min.css";i:306;s:19:"paragraph/style.css";i:307;s:23:"paragraph/style.min.css";i:308;s:35:"post-author-biography/style-rtl.css";i:309;s:39:"post-author-biography/style-rtl.min.css";i:310;s:31:"post-author-biography/style.css";i:311;s:35:"post-author-biography/style.min.css";i:312;s:30:"post-author-name/style-rtl.css";i:313;s:34:"post-author-name/style-rtl.min.css";i:314;s:26:"post-author-name/style.css";i:315;s:30:"post-author-name/style.min.css";i:316;s:25:"post-author/style-rtl.css";i:317;s:29:"post-author/style-rtl.min.css";i:318;s:21:"post-author/style.css";i:319;s:25:"post-author/style.min.css";i:320;s:33:"post-comments-count/style-rtl.css";i:321;s:37:"post-comments-count/style-rtl.min.css";i:322;s:29:"post-comments-count/style.css";i:323;s:33:"post-comments-count/style.min.css";i:324;s:33:"post-comments-form/editor-rtl.css";i:325;s:37:"post-comments-form/editor-rtl.min.css";i:326;s:29:"post-comments-form/editor.css";i:327;s:33:"post-comments-form/editor.min.css";i:328;s:32:"post-comments-form/style-rtl.css";i:329;s:36:"post-comments-form/style-rtl.min.css";i:330;s:28:"post-comments-form/style.css";i:331;s:32:"post-comments-form/style.min.css";i:332;s:32:"post-comments-link/style-rtl.css";i:333;s:36:"post-comments-link/style-rtl.min.css";i:334;s:28:"post-comments-link/style.css";i:335;s:32:"post-comments-link/style.min.css";i:336;s:26:"post-content/style-rtl.css";i:337;s:30:"post-content/style-rtl.min.css";i:338;s:22:"post-content/style.css";i:339;s:26:"post-content/style.min.css";i:340;s:23:"post-date/style-rtl.css";i:341;s:27:"post-date/style-rtl.min.css";i:342;s:19:"post-date/style.css";i:343;s:23:"post-date/style.min.css";i:344;s:27:"post-excerpt/editor-rtl.css";i:345;s:31:"post-excerpt/editor-rtl.min.css";i:346;s:23:"post-excerpt/editor.css";i:347;s:27:"post-excerpt/editor.min.css";i:348;s:26:"post-excerpt/style-rtl.css";i:349;s:30:"post-excerpt/style-rtl.min.css";i:350;s:22:"post-excerpt/style.css";i:351;s:26:"post-excerpt/style.min.css";i:352;s:34:"post-featured-image/editor-rtl.css";i:353;s:38:"post-featured-image/editor-rtl.min.css";i:354;s:30:"post-featured-image/editor.css";i:355;s:34:"post-featured-image/editor.min.css";i:356;s:33:"post-featured-image/style-rtl.css";i:357;s:37:"post-featured-image/style-rtl.min.css";i:358;s:29:"post-featured-image/style.css";i:359;s:33:"post-featured-image/style.min.css";i:360;s:34:"post-navigation-link/style-rtl.css";i:361;s:38:"post-navigation-link/style-rtl.min.css";i:362;s:30:"post-navigation-link/style.css";i:363;s:34:"post-navigation-link/style.min.css";i:364;s:27:"post-template/style-rtl.css";i:365;s:31:"post-template/style-rtl.min.css";i:366;s:23:"post-template/style.css";i:367;s:27:"post-template/style.min.css";i:368;s:24:"post-terms/style-rtl.css";i:369;s:28:"post-terms/style-rtl.min.css";i:370;s:20:"post-terms/style.css";i:371;s:24:"post-terms/style.min.css";i:372;s:31:"post-time-to-read/style-rtl.css";i:373;s:35:"post-time-to-read/style-rtl.min.css";i:374;s:27:"post-time-to-read/style.css";i:375;s:31:"post-time-to-read/style.min.css";i:376;s:24:"post-title/style-rtl.css";i:377;s:28:"post-title/style-rtl.min.css";i:378;s:20:"post-title/style.css";i:379;s:24:"post-title/style.min.css";i:380;s:26:"preformatted/style-rtl.css";i:381;s:30:"preformatted/style-rtl.min.css";i:382;s:22:"preformatted/style.css";i:383;s:26:"preformatted/style.min.css";i:384;s:24:"pullquote/editor-rtl.css";i:385;s:28:"pullquote/editor-rtl.min.css";i:386;s:20:"pullquote/editor.css";i:387;s:24:"pullquote/editor.min.css";i:388;s:23:"pullquote/style-rtl.css";i:389;s:27:"pullquote/style-rtl.min.css";i:390;s:19:"pullquote/style.css";i:391;s:23:"pullquote/style.min.css";i:392;s:23:"pullquote/theme-rtl.css";i:393;s:27:"pullquote/theme-rtl.min.css";i:394;s:19:"pullquote/theme.css";i:395;s:23:"pullquote/theme.min.css";i:396;s:39:"query-pagination-numbers/editor-rtl.css";i:397;s:43:"query-pagination-numbers/editor-rtl.min.css";i:398;s:35:"query-pagination-numbers/editor.css";i:399;s:39:"query-pagination-numbers/editor.min.css";i:400;s:31:"query-pagination/editor-rtl.css";i:401;s:35:"query-pagination/editor-rtl.min.css";i:402;s:27:"query-pagination/editor.css";i:403;s:31:"query-pagination/editor.min.css";i:404;s:30:"query-pagination/style-rtl.css";i:405;s:34:"query-pagination/style-rtl.min.css";i:406;s:26:"query-pagination/style.css";i:407;s:30:"query-pagination/style.min.css";i:408;s:25:"query-title/style-rtl.css";i:409;s:29:"query-title/style-rtl.min.css";i:410;s:21:"query-title/style.css";i:411;s:25:"query-title/style.min.css";i:412;s:25:"query-total/style-rtl.css";i:413;s:29:"query-total/style-rtl.min.css";i:414;s:21:"query-total/style.css";i:415;s:25:"query-total/style.min.css";i:416;s:20:"query/editor-rtl.css";i:417;s:24:"query/editor-rtl.min.css";i:418;s:16:"query/editor.css";i:419;s:20:"query/editor.min.css";i:420;s:19:"quote/style-rtl.css";i:421;s:23:"quote/style-rtl.min.css";i:422;s:15:"quote/style.css";i:423;s:19:"quote/style.min.css";i:424;s:19:"quote/theme-rtl.css";i:425;s:23:"quote/theme-rtl.min.css";i:426;s:15:"quote/theme.css";i:427;s:19:"quote/theme.min.css";i:428;s:23:"read-more/style-rtl.css";i:429;s:27:"read-more/style-rtl.min.css";i:430;s:19:"read-more/style.css";i:431;s:23:"read-more/style.min.css";i:432;s:18:"rss/editor-rtl.css";i:433;s:22:"rss/editor-rtl.min.css";i:434;s:14:"rss/editor.css";i:435;s:18:"rss/editor.min.css";i:436;s:17:"rss/style-rtl.css";i:437;s:21:"rss/style-rtl.min.css";i:438;s:13:"rss/style.css";i:439;s:17:"rss/style.min.css";i:440;s:21:"search/editor-rtl.css";i:441;s:25:"search/editor-rtl.min.css";i:442;s:17:"search/editor.css";i:443;s:21:"search/editor.min.css";i:444;s:20:"search/style-rtl.css";i:445;s:24:"search/style-rtl.min.css";i:446;s:16:"search/style.css";i:447;s:20:"search/style.min.css";i:448;s:20:"search/theme-rtl.css";i:449;s:24:"search/theme-rtl.min.css";i:450;s:16:"search/theme.css";i:451;s:20:"search/theme.min.css";i:452;s:24:"separator/editor-rtl.css";i:453;s:28:"separator/editor-rtl.min.css";i:454;s:20:"separator/editor.css";i:455;s:24:"separator/editor.min.css";i:456;s:23:"separator/style-rtl.css";i:457;s:27:"separator/style-rtl.min.css";i:458;s:19:"separator/style.css";i:459;s:23:"separator/style.min.css";i:460;s:23:"separator/theme-rtl.css";i:461;s:27:"separator/theme-rtl.min.css";i:462;s:19:"separator/theme.css";i:463;s:23:"separator/theme.min.css";i:464;s:24:"shortcode/editor-rtl.css";i:465;s:28:"shortcode/editor-rtl.min.css";i:466;s:20:"shortcode/editor.css";i:467;s:24:"shortcode/editor.min.css";i:468;s:24:"site-logo/editor-rtl.css";i:469;s:28:"site-logo/editor-rtl.min.css";i:470;s:20:"site-logo/editor.css";i:471;s:24:"site-logo/editor.min.css";i:472;s:23:"site-logo/style-rtl.css";i:473;s:27:"site-logo/style-rtl.min.css";i:474;s:19:"site-logo/style.css";i:475;s:23:"site-logo/style.min.css";i:476;s:27:"site-tagline/editor-rtl.css";i:477;s:31:"site-tagline/editor-rtl.min.css";i:478;s:23:"site-tagline/editor.css";i:479;s:27:"site-tagline/editor.min.css";i:480;s:26:"site-tagline/style-rtl.css";i:481;s:30:"site-tagline/style-rtl.min.css";i:482;s:22:"site-tagline/style.css";i:483;s:26:"site-tagline/style.min.css";i:484;s:25:"site-title/editor-rtl.css";i:485;s:29:"site-title/editor-rtl.min.css";i:486;s:21:"site-title/editor.css";i:487;s:25:"site-title/editor.min.css";i:488;s:24:"site-title/style-rtl.css";i:489;s:28:"site-title/style-rtl.min.css";i:490;s:20:"site-title/style.css";i:491;s:24:"site-title/style.min.css";i:492;s:26:"social-link/editor-rtl.css";i:493;s:30:"social-link/editor-rtl.min.css";i:494;s:22:"social-link/editor.css";i:495;s:26:"social-link/editor.min.css";i:496;s:27:"social-links/editor-rtl.css";i:497;s:31:"social-links/editor-rtl.min.css";i:498;s:23:"social-links/editor.css";i:499;s:27:"social-links/editor.min.css";i:500;s:26:"social-links/style-rtl.css";i:501;s:30:"social-links/style-rtl.min.css";i:502;s:22:"social-links/style.css";i:503;s:26:"social-links/style.min.css";i:504;s:21:"spacer/editor-rtl.css";i:505;s:25:"spacer/editor-rtl.min.css";i:506;s:17:"spacer/editor.css";i:507;s:21:"spacer/editor.min.css";i:508;s:20:"spacer/style-rtl.css";i:509;s:24:"spacer/style-rtl.min.css";i:510;s:16:"spacer/style.css";i:511;s:20:"spacer/style.min.css";i:512;s:20:"table/editor-rtl.css";i:513;s:24:"table/editor-rtl.min.css";i:514;s:16:"table/editor.css";i:515;s:20:"table/editor.min.css";i:516;s:19:"table/style-rtl.css";i:517;s:23:"table/style-rtl.min.css";i:518;s:15:"table/style.css";i:519;s:19:"table/style.min.css";i:520;s:19:"table/theme-rtl.css";i:521;s:23:"table/theme-rtl.min.css";i:522;s:15:"table/theme.css";i:523;s:19:"table/theme.min.css";i:524;s:24:"tag-cloud/editor-rtl.css";i:525;s:28:"tag-cloud/editor-rtl.min.css";i:526;s:20:"tag-cloud/editor.css";i:527;s:24:"tag-cloud/editor.min.css";i:528;s:23:"tag-cloud/style-rtl.css";i:529;s:27:"tag-cloud/style-rtl.min.css";i:530;s:19:"tag-cloud/style.css";i:531;s:23:"tag-cloud/style.min.css";i:532;s:28:"template-part/editor-rtl.css";i:533;s:32:"template-part/editor-rtl.min.css";i:534;s:24:"template-part/editor.css";i:535;s:28:"template-part/editor.min.css";i:536;s:27:"template-part/theme-rtl.css";i:537;s:31:"template-part/theme-rtl.min.css";i:538;s:23:"template-part/theme.css";i:539;s:27:"template-part/theme.min.css";i:540;s:24:"term-count/style-rtl.css";i:541;s:28:"term-count/style-rtl.min.css";i:542;s:20:"term-count/style.css";i:543;s:24:"term-count/style.min.css";i:544;s:30:"term-description/style-rtl.css";i:545;s:34:"term-description/style-rtl.min.css";i:546;s:26:"term-description/style.css";i:547;s:30:"term-description/style.min.css";i:548;s:23:"term-name/style-rtl.css";i:549;s:27:"term-name/style-rtl.min.css";i:550;s:19:"term-name/style.css";i:551;s:23:"term-name/style.min.css";i:552;s:28:"term-template/editor-rtl.css";i:553;s:32:"term-template/editor-rtl.min.css";i:554;s:24:"term-template/editor.css";i:555;s:28:"term-template/editor.min.css";i:556;s:27:"term-template/style-rtl.css";i:557;s:31:"term-template/style-rtl.min.css";i:558;s:23:"term-template/style.css";i:559;s:27:"term-template/style.min.css";i:560;s:27:"text-columns/editor-rtl.css";i:561;s:31:"text-columns/editor-rtl.min.css";i:562;s:23:"text-columns/editor.css";i:563;s:27:"text-columns/editor.min.css";i:564;s:26:"text-columns/style-rtl.css";i:565;s:30:"text-columns/style-rtl.min.css";i:566;s:22:"text-columns/style.css";i:567;s:26:"text-columns/style.min.css";i:568;s:19:"verse/style-rtl.css";i:569;s:23:"verse/style-rtl.min.css";i:570;s:15:"verse/style.css";i:571;s:19:"verse/style.min.css";i:572;s:20:"video/editor-rtl.css";i:573;s:24:"video/editor-rtl.min.css";i:574;s:16:"video/editor.css";i:575;s:20:"video/editor.min.css";i:576;s:19:"video/style-rtl.css";i:577;s:23:"video/style-rtl.min.css";i:578;s:15:"video/style.css";i:579;s:19:"video/style.min.css";i:580;s:19:"video/theme-rtl.css";i:581;s:23:"video/theme-rtl.min.css";i:582;s:15:"video/theme.css";i:583;s:19:"video/theme.min.css";}}','on');
INSERT INTO `wpnc_options` VALUES (130,'_transient_wp_styles_for_blocks','a:2:{s:4:"hash";s:32:"dc1b8f8e8ae79f2cb16614078265e3f4";s:6:"blocks";a:6:{s:11:"core/button";s:0:"";s:14:"core/site-logo";s:0:"";s:18:"core/post-template";s:0:"";s:18:"core/term-template";s:0:"";s:12:"core/columns";s:0:"";s:14:"core/pullquote";s:69:":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}";}}','on');
INSERT INTO `wpnc_options` VALUES (156,'finished_updating_comment_type','1','auto');
INSERT INTO `wpnc_options` VALUES (157,'_site_transient_wp_plugin_dependencies_plugin_data','a:1:{s:9:"elementor";a:35:{s:4:"name";s:63:"Elementor Website Builder &#8211; More Than Just a Page Builder";s:4:"slug";s:9:"elementor";s:7:"version";s:6:"3.34.0";s:6:"author";s:64:"<a href="https://profiles.wordpress.org/elemntor/">Elementor</a>";s:14:"author_profile";s:40:"https://profiles.wordpress.org/elemntor/";s:12:"contributors";a:1:{s:8:"elemntor";a:3:{s:7:"profile";s:40:"https://profiles.wordpress.org/elemntor/";s:6:"avatar";s:120:"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g";s:12:"display_name";s:9:"Elementor";}}s:8:"requires";s:3:"6.6";s:6:"tested";s:3:"6.9";s:12:"requires_php";s:3:"7.4";s:16:"requires_plugins";a:0:{}s:6:"rating";i:90;s:7:"ratings";a:5:{i:5;i:6088;i:4;i:218;i:3;i:110;i:2;i:106;i:1;i:636;}s:11:"num_ratings";i:7158;s:11:"support_url";s:47:"https://wordpress.org/support/plugin/elementor/";s:15:"support_threads";i:109;s:24:"support_threads_resolved";i:90;s:15:"active_installs";i:10000000;s:12:"last_updated";s:22:"2025-12-22 12:28pm GMT";s:5:"added";s:10:"2016-05-30";s:8:"homepage";s:87:"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash";s:8:"sections";a:6:{s:11:"description";s:25581:"<p><iframe loading="lazy" title="Elementor - The Leading Platform for Web Creators" width="750" height="422" src="https://www.youtube.com/embed/le72grP_Q6k?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href="https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/" rel="nofollow ugc">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href="https://elemn.to/repo-hosting" rel="nofollow ugc">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href="https://go.elementor.com/feature-page-editor/" rel="nofollow ugc">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/" rel="nofollow ugc">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/" rel="nofollow ugc">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href="https://go.elementor.com/feature-page-editor/" rel="nofollow ugc">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-elementor-ai/" rel="nofollow ugc">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href="https://go.elementor.com/feature-page-global-settings/" rel="nofollow ugc">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href="https://go.elementor.com/feature-page-responsive-design/" rel="nofollow ugc">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href="https://elementor.com/features/#SaveBackup" rel="nofollow ugc">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-developers-developers-website/" rel="nofollow ugc">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/" rel="nofollow ugc">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/" rel="nofollow ugc">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/" rel="nofollow ugc">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/" rel="nofollow ugc">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/" rel="nofollow ugc">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href="https://go.elementor.com/features-page-notes/" rel="nofollow ugc">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href="https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/" rel="nofollow ugc">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>Heading</strong>. Add eye-catching headlines.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>Icon</strong>. Place one or more of 600+ icons available.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>Icon List</strong>. Use any icon to create a bullet list.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>Progress Bar</strong>. Include an escalating progress bar.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Toggle</strong>. Use the Toggle to hide or display content, like FAQ.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>Alert</strong>. Include a colored alert box to draw visitor’s attention.</li>\n<li><strong>HTML</strong>. Insert code into the page.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>Menu Anchor</strong>. Link any menu to this anchor.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>Google Maps</strong>. Embed maps into the page.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>Divider</strong>. Separate content with a designed divider.</li>\n<li><strong>Spacer</strong>. Add space between elements.</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>And counting&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href="https://go.elementor.com/wp-repo-description-tab-performance-performance-page/" rel="nofollow ugc">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href="https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/" rel="nofollow ugc">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>Mega Menu</strong>: Customize advanced menus for better navigation and displaying complex content.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href="https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/" rel="nofollow ugc">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href="https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/" rel="nofollow ugc">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href="https://go.elementor.com/trust-center/" rel="nofollow ugc">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href="https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/" rel="nofollow ugc">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href="https://go.elementor.com/wp-repo-description-tab-help-center-translate/" rel="nofollow ugc">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href="https://policies.google.com/terms" rel="nofollow ugc">TOS</a> and <a href="https://policies.google.com/privacy" rel="nofollow ugc">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href="https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/" rel="nofollow ugc">TOS</a> and <a href="https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/" rel="nofollow ugc">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href="https://go.elementor.com/wp-repo-description-tab-elementor-io/" rel="nofollow ugc">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href="https://go.elementor.com/wp-repo-description-tab-elementor-sm/" rel="nofollow ugc">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href="https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/" rel="ugc">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href="https://wordpress.org/support/topic/a-wonderful-experience/" rel="ugc">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href="https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/" rel="ugc">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href="https://wordpress.org/support/topic/love-elementor-17/" rel="ugc">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href="https://wordpress.org/support/topic/excellent-product-with-great-tech-support/" rel="ugc">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href="https://wordpress.org/support/plugin/elementor/reviews/?filter=5" rel="ugc">More testimonials</a></em></p>\n<h4>🌍 Join a Global Community</h4>\n<p>Join a global community that helps each other achieve their goals.</p>\n<ul>\n<li><a href="https://elemn.to/discord" rel="nofollow ugc">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href="https://go.elementor.com/wp-repo-description-tab-facebook-group/" rel="nofollow ugc">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href="https://go.elementor.com/wp-repo-description-tab-github-repo/" rel="nofollow ugc">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href="https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/" rel="nofollow ugc">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href="https://go.elementor.com/wp-repo-description-tab-youtube-channel/" rel="nofollow ugc">YouTube Channel</a>.</li>\n<li>Access our <a href="https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/" rel="nofollow ugc">Academy</a> and <a href="https://go.elementor.com/wp-repo-description-tab-help-center-help-center/" rel="nofollow ugc">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href="https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/" rel="nofollow ugc">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href="https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/" rel="nofollow ugc">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n";s:12:"installation";s:1461:"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP version 7.4 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<h4>Recommended Requirements</h4>\n<ul>\n<li>PHP version 8.1 or greater</li>\n<li>MySQL version 5.6 or greater</li>\n<li>WordPress Memory limit of 64 MB or greater (128 MB or higher is preferred)</li>\n</ul>\n<p><iframe loading="lazy" title="Installing Elementor on WordPress" width="750" height="422" src="https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe></p>\n<h4>Installation</h4>\n<ol>\n<li>Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the <code>wp-content/plugins/</code> directory of your WordPress installation.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n<li>Go to Pages &gt; Add New</li>\n<li>Press the &#8216;Edit with Elementor&#8217; button.</li>\n<li>Now you can drag and drop widgets from the left panel onto the content area, as well as add new sections and columns that make up the page structure.</li>\n</ol>\n<p>For documentation and tutorials visit our <a href="https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme" rel="nofollow ugc">Knowledge Base</a>.</p>\n";s:3:"faq";s:4862:"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nHow do I install Elementor?\n</h4>\n<p>\n<p>To install the free version of Elementor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nDoes Elementor work with all the themes?\n</h4>\n<p>\n<p>Elementor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href="https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/" rel="nofollow ugc">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor, and optimize your experience.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nIs Elementor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nCan I create an online store?\n</h4>\n<p>\n<p>Yes, with the Elementor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nDoes it work with other WordPress plugins?\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nDo I need to know how to code?\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of Elementor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nIs my site secure with Elementor?\n</h4>\n<p>\n<p>The security of your website is extremely important to us and we take proactive measures to assure that your websites are secure. Elementor is ISO 27001 certified, and has a dedicated team of security professionals that implements industry best-practices for maximum security and compliance, 24/7.</p>\n<p>There is also a managed security Bug Bounty program, utilizing the community power by enabling 24/7/365 crowdsourced vulnerability detection.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nCan I buy templates separately?\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nIs Elementor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>Of course! You can set which post types will enable Elementor in the settings page.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nWhat is the difference between Elementor&#8217;s free Plugin and Elementor Pro\n</h4>\n<p>\n<p>Elementor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nHow can I become a Contributor\n</h4>\n<p>\n<p>If you want to contribute, go to our <a href="https://github.com/elementor/elementor" rel="nofollow ugc">Elementor GitHub Repository</a> and see where you can help.<br />\nYou can also add a new language via <a href="https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/" rel="nofollow ugc">translate.wordpress.org</a>. We’ve built a short guide explaining <a href="https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/" rel="nofollow ugc">how to translate and localize the plugin</a>.</p>\n</p>\n\n";s:9:"changelog";s:2300:"<h4>3.34.0 &#8211; 2025-12-22</h4>\n<ul>\n<li>New: Introducing Atomic Tabs &#8211; enabling flexible and fully customizable tab layouts with nested Atomic Elements &#8211; Editor V4</li>\n<li>New: Introducing Entrance Interactions to add lightweight motion and bring elements to life as they appear &#8211; Editor V4</li>\n<li>Tweak: Replaced the legacy V3 container wrapper with the optimized V4 wrapper for improved markup &#8211; Editor V4</li>\n<li>Tweak: Improved frontend link control output to ensure consistent rendering &#8211; Editor V4 (<a href="https://github.com/elementor/elementor/issues/32233" rel="nofollow ugc">#32233</a>)</li>\n<li>Tweak: Added reset option inside popovers &#8211; Editor V4</li>\n<li>Tweak: Updated Border control layout for a clearer and more consistent editing workflow &#8211; Editor V4</li>\n<li>Tweak: Added <code>span</code> option inside the Paragraph atom &#8211; Editor V4</li>\n<li>Tweak: Improved transitions to better support logical properties &#8211; Editor V4</li>\n<li>Tweak: Improved dropdown folder behavior and resolved related UI issues in Template Library</li>\n<li>Tweak: Merged &#8220;Import/Export Customization&#8221; feature into the version</li>\n<li>Tweak: Added <code>builder_content_data</code> filter for extending Template Library and Global Widget content (props <a href="https://github.com/dgwatkins" rel="nofollow ugc">@dgwatkins</a>)</li>\n<li>Tweak: Applied CSS logical properties in Icon Box widget</li>\n<li>Tweak: Applied CSS logical properties in Icon List widget</li>\n<li>Tweak: Applied CSS logical properties in text alignment controls and fixed RTL rendering in the Editor</li>\n<li>Fix: Local Transform values overridden Class-level Transform defaults even when unchanged &#8211; Editor V4</li>\n<li>Fix: Fatal error when opening pages containing atomic elements while the V4 experiment is deactivated &#8211; Editor V4</li>\n<li>Fix: Hover Scale transform set through Class did not save correctly &#8211; Editor V4</li>\n<li>Fix: PHP 8.4 deprecation notices related to deprecated <code>E_STRICT</code> constant</li>\n<li>Fix: Missing CSS regeneration after clearing cached files on pages containing dynamic tags</li>\n</ul>\n<p><a href="https://go.elementor.com/full-changelog/" rel="nofollow ugc">See changelog for all versions.</a></p>\n";s:11:"screenshots";s:3148:"<ol><li><a href="https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087" alt="&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs."></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href="https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087" alt="&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time."></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href="https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087" alt="&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device."></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href="https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087" alt="&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization."></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href="https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087" alt="&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility."></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href="https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087"><img src="https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087" alt="&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors."></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>";s:7:"reviews";s:18236:"<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Très bon constructeur.</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="5 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="5" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/gbosbm/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/16363652899d37f0387fc9b2370595e64e3ec528054422925a25c1ce18aea8d2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/16363652899d37f0387fc9b2370595e64e3ec528054422925a25c1ce18aea8d2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/gbosbm/" class="reviewer-name">BONNET <small>(gbosbm)</small></a> on <span class="review-date">December 25, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>Elementor facilite la création de site web grâce à ses nombreuses fonctions, et les personnalisations qui permettent de se distinguer des autres sites. Il offre également une prise en main intuitive, accessible aussi bien aux débutants qu’aux utilisateurs avancés</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Very good overall!</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="5 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="5" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/jsug34/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3b43aa50d7a26772b257dc9f78dc2d00e40c9e996a7f574d2b242385b4b67dc9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3b43aa50d7a26772b257dc9f78dc2d00e40c9e996a7f574d2b242385b4b67dc9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/jsug34/" class="reviewer-name">jsug34</a> on <span class="review-date">December 23, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>I’ve been using Elementor for 2 years and I’m very happy with it. It’s easy to use, creative, and helped me build the exact website I wanted. However, recent updates can be unstable. After updating to 3.34.0 yesterday, I noticed unexpected spacing/line breaks and some overlapping elements, even on layouts that were previously perfectly calibrated. Waiting for a patch before making further edits.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">One of the best page bulder.</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="5 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="5" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/rakibhossainraju/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/rakibhossainraju/" class="reviewer-name">Rakib Hossain Raju <small>(rakibhossainraju)</small></a> on <span class="review-date">December 21, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>I have been using this page builder for quite some time. Before that I have used other Page Builders but this one is so far the best for me. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The ecosystem is huge and the community is realy nice.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Easy to Use and Powerful Page Builder</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="5 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="5" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/deepanshigarg/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/deepanshigarg/" class="reviewer-name">deepanshigarg</a> on <span class="review-date">December 19, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>Elementor Website Builder makes designing pages very easy, even for beginners. The drag-and-drop editor is smooth and intuitive, and there are many useful widgets and design options. It helped me create professional-looking pages without coding. A great choice for building and customizing WordPress websites.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Elementor 3.33.5 Update several critical front-end widgets stopped working</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="1 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="1" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/ulgo/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/ulgo/" class="reviewer-name">ulgo</a> on <span class="review-date">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>After updating from <strong>Elementor 3.33.4 to 3.33.5</strong>, several critical front-end widgets stopped working:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>The <strong>Google Reviews / Rating widget</strong> no longer renders and disappears completely.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Custom HTML/JS widgets</strong> (e.g., small interactive tools) only display as static text blocks, and embedded JavaScript does not execute.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Rolling back to <strong>3.33.4</strong> immediately restores full functionality.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Environment:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Hosting: <strong>IONOS Managed WordPress</strong></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Elementor Pro active</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>No other changes to theme or plugins except the Elementor update.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Impact:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Essential front-end functionality is broken.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Custom tools and third-party widgets cannot be used.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>A rollback is currently the only way to keep the site operational.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Expectation:</strong><br />Please release a <strong>hotfix or patch (3.33.6 or 3.34.x)</strong> to restore compatibility for Google Reviews and allow custom HTML/JS widgets to function as before.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Love it!</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="5 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="5" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/rbmueller/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/rbmueller/" class="reviewer-name">Robin <small>(rbmueller)</small></a> on <span class="review-date">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>Very easy to understand and powerfull. Best pagebuilder we have used so far.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">The last update broke the whole site, I had to rollback</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="1 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="1" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/kris006/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/kris006/" class="reviewer-name">kris006</a> on <span class="review-date">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>The last update broke the whole site, I had to rollback</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Update Broke many websites</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="1 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="1" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/atx/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/atx/" class="reviewer-name">Testing Things <small>(AtX)</small></a> on <span class="review-date">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>I\'m sorry but a popular plugin like this one should never break websites. This happened to many people during the last update which doesn\'t make us feel comfortable using it... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And that is not the first time by the way... My website broke at least three times during the past years, and not because of a misconfiguration or another plugin, but because of an automated Elementor update overnight.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This time the woocommerce login and account pages were impacted</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">VERSION 3.33.5 BROKE THE TEXT EDITOR - THANKS FOR NOTHING!!!</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="1 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="1" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/wordoppressed345345/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/wordoppressed345345/" class="reviewer-name">wordoppressed345345</a> on <span class="review-date">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>WE USED TO BE ABLE TO DROP SHORTCODES INTO THE TEXT EDITOR WHICH MADE CHANGING ATTRIBUTES (EX. TEXT SIZE, ORIENTATION, ETC.) QUICK AND EASY. OF COURSE THEY KILLED THAT FUNCTIONALITY.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>EVER NOTICE THAT THESE UPDATES ONLY BREAK THINGS?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class="review">\n	<div class="review-head">\n		<div class="reviewer-info">\n			<div class="review-title-section">\n				<h4 class="review-title">Works ok but feel trapped in it</h4>\n				<div class="star-rating">\n				<div class="wporg-ratings" aria-label="3 out of 5 stars" data-title-template="%s out of 5 stars" data-rating="3" style="color:#ffb900;"><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-filled"></span><span class="star dashicons dashicons-star-empty"></span><span class="star dashicons dashicons-star-empty"></span></div>				</div>\n			</div>\n			<p class="reviewer">\n				By <a href="https://profiles.wordpress.org/petersonrk/"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href="https://profiles.wordpress.org/petersonrk/" class="reviewer-name">petersonrk</a> on <span class="review-date">December 17, 2025</span>			</p>\n		</div>\n	</div>\n	<div class="review-body"><!-- wp:paragraph -->\n<p>Elementor feels like it gets worse as they add features that I don\'t use. It now takes too long to load and sometimes won\'t let me edit a page. </p>\n<!-- /wp:paragraph --></div>\n</div>\n";}s:17:"short_description";s:145:"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!";s:13:"download_link";s:59:"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip";s:14:"upgrade_notice";a:0:{}s:11:"screenshots";a:6:{i:1;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087";s:7:"caption";s:144:"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.";}i:2;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087";s:7:"caption";s:185:"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.";}i:3;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087";s:7:"caption";s:170:"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.";}i:4;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087";s:7:"caption";s:193:"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.";}i:5;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087";s:7:"caption";s:190:"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.";}i:6;a:2:{s:3:"src";s:62:"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087";s:7:"caption";s:127:"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.";}}s:4:"tags";a:5:{s:13:"drag-and-drop";s:13:"drag-and-drop";s:6:"editor";s:6:"editor";s:9:"elementor";s:9:"elementor";s:12:"landing-page";s:12:"landing page";s:12:"page-builder";s:12:"page builder";}s:8:"versions";a:387:{s:5:"3.0.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip";s:5:"3.0.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip";s:6:"3.0.10";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip";s:6:"3.0.11";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip";s:6:"3.0.12";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip";s:6:"3.0.13";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip";s:6:"3.0.14";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip";s:6:"3.0.15";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip";s:6:"3.0.16";s:59:"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip";s:5:"3.0.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip";s:5:"3.0.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip";s:5:"3.0.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip";s:5:"3.0.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip";s:5:"3.0.6";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip";s:5:"3.0.7";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip";s:5:"3.0.8";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip";s:7:"3.0.8.1";s:60:"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip";s:5:"3.0.9";s:58:"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip";s:5:"3.1.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip";s:11:"3.1.0-beta1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip";s:11:"3.1.0-beta2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip";s:11:"3.1.0-beta3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip";s:11:"3.1.0-beta4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip";s:10:"3.1.0-dev1";s:63:"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip";s:10:"3.1.0-dev2";s:63:"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip";s:10:"3.1.0-dev3";s:63:"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip";s:5:"3.1.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip";s:5:"3.1.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip";s:5:"3.1.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip";s:5:"3.1.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip";s:6:"3.10.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip";s:11:"3.10.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip";s:6:"3.10.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip";s:6:"3.10.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip";s:6:"3.11.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip";s:12:"3.11.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip";s:12:"3.11.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip";s:12:"3.11.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip";s:11:"3.11.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip";s:11:"3.11.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip";s:11:"3.11.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip";s:6:"3.11.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip";s:6:"3.11.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip";s:6:"3.11.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip";s:6:"3.11.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip";s:6:"3.11.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip";s:6:"3.12.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip";s:6:"3.12.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip";s:6:"3.12.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip";s:6:"3.13.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip";s:12:"3.13.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip";s:12:"3.13.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip";s:12:"3.13.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip";s:11:"3.13.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip";s:11:"3.13.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip";s:6:"3.13.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip";s:6:"3.13.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip";s:6:"3.13.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip";s:6:"3.13.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip";s:6:"3.14.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip";s:12:"3.14.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip";s:12:"3.14.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip";s:12:"3.14.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip";s:12:"3.14.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip";s:12:"3.14.0-beta5";s:65:"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip";s:6:"3.14.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip";s:6:"3.15.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip";s:6:"3.15.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip";s:6:"3.15.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip";s:6:"3.15.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip";s:6:"3.16.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip";s:12:"3.16.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip";s:12:"3.16.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip";s:11:"3.16.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip";s:11:"3.16.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip";s:6:"3.16.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip";s:6:"3.16.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip";s:6:"3.16.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip";s:6:"3.16.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip";s:6:"3.16.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip";s:6:"3.16.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip";s:6:"3.17.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip";s:11:"3.17.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip";s:11:"3.17.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip";s:11:"3.17.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip";s:6:"3.17.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip";s:6:"3.17.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip";s:6:"3.17.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip";s:6:"3.18.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip";s:12:"3.18.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip";s:12:"3.18.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip";s:12:"3.18.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip";s:12:"3.18.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip";s:11:"3.18.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip";s:6:"3.18.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip";s:6:"3.18.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip";s:6:"3.18.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip";s:6:"3.19.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip";s:12:"3.19.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip";s:12:"3.19.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip";s:12:"3.19.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip";s:12:"3.19.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip";s:12:"3.19.0-beta5";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip";s:12:"3.19.0-beta6";s:65:"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip";s:11:"3.19.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip";s:11:"3.19.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip";s:11:"3.19.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip";s:11:"3.19.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip";s:11:"3.19.0-dev5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip";s:11:"3.19.0-dev6";s:64:"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip";s:6:"3.19.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip";s:6:"3.19.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip";s:6:"3.19.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip";s:6:"3.19.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip";s:5:"3.2.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip";s:5:"3.2.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip";s:5:"3.2.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip";s:5:"3.2.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip";s:5:"3.2.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip";s:5:"3.2.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip";s:6:"3.20.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip";s:12:"3.20.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip";s:12:"3.20.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip";s:12:"3.20.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip";s:12:"3.20.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip";s:11:"3.20.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip";s:11:"3.20.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip";s:11:"3.20.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip";s:11:"3.20.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip";s:6:"3.20.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip";s:6:"3.20.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip";s:6:"3.20.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip";s:6:"3.20.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip";s:6:"3.21.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip";s:12:"3.21.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip";s:12:"3.21.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip";s:12:"3.21.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip";s:11:"3.21.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip";s:11:"3.21.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip";s:11:"3.21.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip";s:6:"3.21.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip";s:6:"3.21.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip";s:6:"3.21.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip";s:6:"3.21.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip";s:6:"3.21.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip";s:6:"3.21.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip";s:6:"3.21.7";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip";s:6:"3.21.8";s:59:"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip";s:6:"3.22.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip";s:12:"3.22.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip";s:12:"3.22.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip";s:12:"3.22.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip";s:12:"3.22.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip";s:12:"3.22.0-beta5";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip";s:12:"3.22.0-beta6";s:65:"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip";s:11:"3.22.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip";s:11:"3.22.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip";s:11:"3.22.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip";s:11:"3.22.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip";s:11:"3.22.0-dev5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip";s:11:"3.22.0-dev6";s:64:"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip";s:6:"3.22.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip";s:6:"3.22.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip";s:6:"3.22.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip";s:6:"3.23.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip";s:12:"3.23.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip";s:12:"3.23.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip";s:12:"3.23.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip";s:12:"3.23.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip";s:12:"3.23.0-beta5";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip";s:12:"3.23.0-beta6";s:65:"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip";s:11:"3.23.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip";s:11:"3.23.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip";s:11:"3.23.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip";s:11:"3.23.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip";s:11:"3.23.0-dev5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip";s:11:"3.23.0-dev6";s:64:"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip";s:6:"3.23.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip";s:6:"3.23.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip";s:6:"3.23.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip";s:6:"3.23.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip";s:6:"3.24.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip";s:12:"3.24.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip";s:12:"3.24.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip";s:12:"3.24.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip";s:11:"3.24.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip";s:11:"3.24.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip";s:11:"3.24.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip";s:6:"3.24.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip";s:6:"3.24.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip";s:6:"3.24.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip";s:6:"3.24.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip";s:6:"3.24.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip";s:6:"3.24.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip";s:6:"3.24.7";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip";s:6:"3.24.8";s:59:"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip";s:6:"3.25.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip";s:12:"3.25.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip";s:12:"3.25.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip";s:12:"3.25.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip";s:11:"3.25.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip";s:11:"3.25.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip";s:11:"3.25.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip";s:6:"3.25.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip";s:7:"3.25.10";s:60:"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip";s:7:"3.25.11";s:60:"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip";s:6:"3.25.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip";s:6:"3.25.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip";s:6:"3.25.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip";s:6:"3.25.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip";s:6:"3.25.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip";s:6:"3.25.7";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip";s:6:"3.25.8";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip";s:6:"3.25.9";s:59:"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip";s:6:"3.26.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip";s:12:"3.26.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip";s:12:"3.26.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip";s:12:"3.26.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip";s:12:"3.26.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip";s:12:"3.26.0-beta5";s:65:"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip";s:11:"3.26.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip";s:11:"3.26.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip";s:11:"3.26.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip";s:11:"3.26.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip";s:11:"3.26.0-dev5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip";s:6:"3.26.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip";s:6:"3.26.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip";s:6:"3.26.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip";s:6:"3.26.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip";s:6:"3.26.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip";s:6:"3.27.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip";s:12:"3.27.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip";s:12:"3.27.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip";s:11:"3.27.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip";s:11:"3.27.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip";s:6:"3.27.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip";s:6:"3.27.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip";s:6:"3.27.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip";s:6:"3.27.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip";s:6:"3.27.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip";s:6:"3.27.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip";s:6:"3.27.7";s:59:"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip";s:6:"3.28.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip";s:12:"3.28.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip";s:12:"3.28.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip";s:12:"3.28.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip";s:11:"3.28.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip";s:11:"3.28.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip";s:11:"3.28.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip";s:6:"3.28.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip";s:6:"3.28.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip";s:6:"3.28.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip";s:6:"3.28.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip";s:6:"3.29.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip";s:12:"3.29.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip";s:12:"3.29.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip";s:12:"3.29.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip";s:12:"3.29.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip";s:11:"3.29.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip";s:11:"3.29.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip";s:11:"3.29.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip";s:11:"3.29.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip";s:6:"3.29.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip";s:6:"3.29.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip";s:5:"3.3.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip";s:5:"3.3.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip";s:6:"3.30.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip";s:12:"3.30.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip";s:12:"3.30.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip";s:12:"3.30.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip";s:11:"3.30.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip";s:11:"3.30.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip";s:11:"3.30.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip";s:6:"3.30.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip";s:6:"3.30.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip";s:6:"3.30.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip";s:6:"3.30.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip";s:6:"3.31.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip";s:12:"3.31.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip";s:12:"3.31.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip";s:11:"3.31.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip";s:11:"3.31.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip";s:6:"3.31.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip";s:6:"3.31.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip";s:6:"3.31.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip";s:6:"3.31.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip";s:6:"3.31.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip";s:6:"3.32.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip";s:12:"3.32.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip";s:12:"3.32.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip";s:12:"3.32.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip";s:11:"3.32.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip";s:11:"3.32.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip";s:11:"3.32.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip";s:6:"3.32.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip";s:6:"3.32.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip";s:6:"3.32.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip";s:6:"3.32.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip";s:6:"3.32.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip";s:6:"3.33.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip";s:12:"3.33.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip";s:12:"3.33.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip";s:12:"3.33.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip";s:12:"3.33.0-beta4";s:65:"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip";s:11:"3.33.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip";s:11:"3.33.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip";s:11:"3.33.0-dev3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip";s:11:"3.33.0-dev4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip";s:6:"3.33.1";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip";s:6:"3.33.2";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip";s:6:"3.33.3";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.3.zip";s:6:"3.33.4";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.4.zip";s:6:"3.33.5";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.5.zip";s:6:"3.33.6";s:59:"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip";s:6:"3.34.0";s:59:"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip";s:12:"3.34.0-beta1";s:65:"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta1.zip";s:12:"3.34.0-beta2";s:65:"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta2.zip";s:12:"3.34.0-beta3";s:65:"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta3.zip";s:11:"3.34.0-dev1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev1.zip";s:11:"3.34.0-dev2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev2.zip";s:5:"3.4.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip";s:10:"3.4.0-dev7";s:63:"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip";s:10:"3.4.0-dev8";s:63:"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip";s:10:"3.4.0-dev9";s:63:"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip";s:5:"3.4.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip";s:5:"3.4.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip";s:5:"3.4.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip";s:5:"3.4.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip";s:5:"3.4.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip";s:5:"3.4.6";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip";s:5:"3.4.7";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip";s:5:"3.4.8";s:58:"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip";s:5:"3.5.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip";s:11:"3.5.0-beta1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip";s:11:"3.5.0-beta2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip";s:11:"3.5.0-beta3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip";s:11:"3.5.0-beta4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip";s:11:"3.5.0-beta5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip";s:11:"3.5.0-beta7";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip";s:11:"3.5.0-beta8";s:64:"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip";s:10:"3.5.0-dev8";s:63:"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip";s:10:"3.5.0-dev9";s:63:"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip";s:5:"3.5.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip";s:5:"3.5.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip";s:5:"3.5.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip";s:5:"3.5.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip";s:5:"3.5.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip";s:5:"3.5.6";s:58:"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip";s:5:"3.6.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip";s:11:"3.6.0-beta1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip";s:11:"3.6.0-beta2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip";s:11:"3.6.0-beta3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip";s:11:"3.6.0-beta4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip";s:11:"3.6.0-beta5";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip";s:10:"3.6.0-dev1";s:63:"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip";s:11:"3.6.0-dev10";s:64:"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip";s:5:"3.6.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip";s:5:"3.6.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip";s:5:"3.6.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip";s:5:"3.6.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip";s:5:"3.6.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip";s:5:"3.6.6";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip";s:5:"3.6.7";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip";s:5:"3.6.8";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip";s:5:"3.7.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip";s:11:"3.7.0-beta1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip";s:11:"3.7.0-beta2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip";s:11:"3.7.0-beta3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip";s:11:"3.7.0-beta4";s:64:"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip";s:10:"3.7.0-dev1";s:63:"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip";s:5:"3.7.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip";s:5:"3.7.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip";s:5:"3.7.3";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip";s:5:"3.7.4";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip";s:5:"3.7.5";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip";s:5:"3.7.6";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip";s:5:"3.7.7";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip";s:5:"3.7.8";s:58:"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip";s:5:"3.8.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip";s:11:"3.8.0-beta1";s:64:"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip";s:11:"3.8.0-beta2";s:64:"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip";s:11:"3.8.0-beta3";s:64:"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip";s:5:"3.8.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip";s:5:"3.9.0";s:58:"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip";s:5:"3.9.1";s:58:"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip";s:5:"3.9.2";s:58:"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip";s:5:"trunk";s:52:"https://downloads.wordpress.org/plugin/elementor.zip";}s:14:"business_model";s:10:"commercial";s:14:"repository_url";s:0:"";s:22:"commercial_support_url";s:94:"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support";s:11:"donate_link";s:0:"";s:7:"banners";a:2:{s:3:"low";s:64:"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133";s:4:"high";s:65:"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133";}s:5:"icons";a:2:{s:2:"1x";s:62:"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597";s:2:"2x";s:62:"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597";}s:12:"preview_link";s:0:"";s:4:"Name";s:63:"Elementor Website Builder &#8211; More Than Just a Page Builder";}}','off');
INSERT INTO `wpnc_options` VALUES (158,'recently_activated','a:1:{s:35:"litespeed-cache/litespeed-cache.php";i:1766814882;}','off');
INSERT INTO `wpnc_options` VALUES (173,'rsssl_show_onboarding','1','off');
INSERT INTO `wpnc_options` VALUES (176,'rsssl_encryption_keys_set','1','off');
INSERT INTO `wpnc_options` VALUES (179,'rsssl_options','a:36:{s:12:"site_has_ssl";s:1:"1";s:8:"redirect";s:8:"htaccess";s:19:"mixed_content_fixer";i:1;s:11:"ssl_enabled";s:1:"1";s:24:"enabled_captcha_provider";s:4:"none";s:25:"password_change_frequency";s:2:"12";s:23:"login_cookie_expiration";s:2:"48";s:22:"404_blocking_threshold";s:3:"lax";s:29:"404_blocking_lockout_duration";s:0:"";s:27:"disable_anyone_can_register";i:1;s:20:"disable_file_editing";i:1;s:28:"block_code_execution_uploads";i:1;s:22:"hide_wordpress_version";i:1;s:22:"disable_login_feedback";i:1;s:16:"disable_indexing";i:1;s:24:"disable_user_enumeration";i:1;s:27:"disable_x_powered_by_header";i:1;s:22:"block_display_is_login";i:1;s:27:"limit_login_attempts_amount";s:1:"5";s:29:"limit_login_attempts_duration";s:2:"15";s:40:"limit_login_attempts_locked_out_duration";s:2:"30";s:16:"x_xss_protection";s:4:"zero";s:15:"x_frame_options";s:0:"";s:15:"referrer_policy";s:31:"strict-origin-when-cross-origin";s:12:"hsts_max_age";s:8:"63072000";s:26:"cross_origin_opener_policy";s:8:"disabled";s:28:"cross_origin_resource_policy";s:8:"disabled";s:28:"cross_origin_embedder_policy";s:8:"disabled";s:19:"csp_frame_ancestors";s:4:"self";s:24:"login_protection_enabled";i:1;s:19:"two_fa_grace_period";s:2:"10";s:28:"enable_vulnerability_scanner";i:1;s:36:"vulnerability_notification_dashboard";s:1:"l";s:35:"vulnerability_notification_sitewide";s:1:"h";s:38:"vulnerability_notification_email_admin";s:1:"c";s:19:"review_notice_shown";s:1:"1";}','auto');
INSERT INTO `wpnc_options` VALUES (184,'rsssl_current_version','9.5.5','off');
INSERT INTO `wpnc_options` VALUES (197,'rsssl_6_notice_dismissed','1','off');
INSERT INTO `wpnc_options` VALUES (199,'rsssl_last_tested_http_method','19','off');
INSERT INTO `wpnc_options` VALUES (200,'rsssl_http_methods_allowed','a:2:{s:11:"not-allowed";a:0:{}s:7:"allowed";a:18:{i:0;s:3:"GET";i:1;s:4:"POST";i:2;s:3:"PUT";i:3;s:6:"DELETE";i:4;s:4:"HEAD";i:5;s:7:"OPTIONS";i:6;s:7:"CONNECT";i:7;s:5:"TRACE";i:8;s:5:"TRACK";i:9;s:5:"PATCH";i:10;s:4:"COPY";i:11;s:4:"LINK";i:12;s:6:"UNLINK";i:13;s:5:"PURGE";i:14;s:4:"LOCK";i:15;s:6:"UNLOCK";i:16;s:8:"PROPFIND";i:17;s:4:"VIEW";}}','off');
INSERT INTO `wpnc_options` VALUES (205,'rsssl_activation_timestamp','1766814749','off');
INSERT INTO `wpnc_options` VALUES (212,'rsssl_folder_name','really-simple-ssl/7721a5c9eeb656d508ed7c40cb281edd','auto');
INSERT INTO `wpnc_options` VALUES (213,'rsssl_onboarding_dismissed','1','off');
INSERT INTO `wpnc_options` VALUES (216,'rsssl_wp_version_token','3770161023','auto');
INSERT INTO `wpnc_options` VALUES (218,'elementor_active_kit','8','auto');
INSERT INTO `wpnc_options` VALUES (219,'elementor_font_display','swap','auto');
INSERT INTO `wpnc_options` VALUES (222,'elementor_checklist','{"last_opened_timestamp":null,"first_closed_checklist_in_editor":true,"is_popup_minimized":false,"steps":{"add_logo":{"is_marked_completed":false,"is_immutable_completed":false},"set_fonts_and_colors":{"is_marked_completed":false,"is_immutable_completed":false},"create_pages":{"is_marked_completed":false,"is_immutable_completed":false},"setup_header":{"is_marked_completed":false,"is_immutable_completed":false},"assign_homepage":{"is_marked_completed":false,"is_immutable_completed":false},"setup_header_pro":{"is_marked_completed":false,"is_immutable_completed":false}},"should_open_in_editor":false}','auto');
INSERT INTO `wpnc_options` VALUES (223,'elementor_version','3.26.4','auto');
INSERT INTO `wpnc_options` VALUES (224,'elementor_install_history','a:1:{s:6:"3.26.4";i:1736321040;}','auto');
INSERT INTO `wpnc_options` VALUES (226,'elementor_events_db_version','1.0.0','off');
INSERT INTO `wpnc_options` VALUES (228,'elementor_disable_color_schemes','yes','auto');
INSERT INTO `wpnc_options` VALUES (229,'elementor_disable_typography_schemes','yes','auto');
INSERT INTO `wpnc_options` VALUES (234,'metform__banner_last_check','1766814732','auto');
INSERT INTO `wpnc_options` VALUES (235,'metform__banner_data','O:8:"stdClass":10:{s:8:"10022095";O:8:"stdClass":7:{s:2:"id";i:10022095;s:5:"title";s:31:"Wpmet Holiday Sale Ownpage 2025";s:4:"type";s:6:"notice";s:6:"screen";s:11:"plugin_page";s:5:"start";i:1766361600;s:3:"end";i:1768089600;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:22:"https://wpmet.com/4mb9";s:11:"button_text";s:16:"Save $3,397 Now!";s:11:"notice_body";s:441:"<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;"><span style="color: #ff0000;">Wpmet’s Holiday Sale is live</span><em data-start="1852" data-end="1881"><span style="color: #ff0000;">!</span></em></strong>\r\n\r\n<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;"><strong style="font-size: 16px;">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10022094";O:8:"stdClass":7:{s:2:"id";i:10022094;s:5:"title";s:28:"Wpmet Holiday Sale Dashboard";s:4:"type";s:6:"notice";s:6:"screen";s:9:"dashboard";s:5:"start";b:0;s:3:"end";b:0;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:22:"https://wpmet.com/4mb9";s:11:"button_text";s:16:"Save $3,397 Now!";s:11:"notice_body";s:441:"<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;"><span style="color: #ff0000;">Wpmet’s Holiday Sale is live</span><em data-start="1852" data-end="1881"><span style="color: #ff0000;">!</span></em></strong>\r\n\r\n<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;"><strong style="font-size: 16px;">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10021821";O:8:"stdClass":7:{s:2:"id";i:10021821;s:5:"title";s:32:"Wpmet Notice BFCM Dashboard 2025";s:4:"type";s:6:"notice";s:6:"screen";s:9:"dashboard";s:5:"start";i:1762819200;s:3:"end";i:1765843200;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:29:"https://wpmet.com/wpnoticeh80";s:11:"button_text";s:16:"Save $3,397 Now!";s:11:"notice_body";s:259:"<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Wpmet’s Black Friday Sale is live<em data-start="1852" data-end="1881">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10021820";O:8:"stdClass":7:{s:2:"id";i:10021820;s:5:"title";s:24:"Wpmet BFCM Own page 2025";s:4:"type";s:6:"notice";s:6:"screen";s:11:"plugin_page";s:5:"start";i:1762819200;s:3:"end";i:1765843200;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:29:"https://wpmet.com/wpnoticeh80";s:11:"button_text";s:16:"Save $3,397 Now!";s:11:"notice_body";s:257:"<strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Wpmet’s Black Friday Sale is live<em data-start="1852" data-end="1881">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10020931";O:8:"stdClass":7:{s:2:"id";i:10020931;s:5:"title";s:29:"Wpmet Halloween Own page 2025";s:4:"type";s:6:"notice";s:6:"screen";s:11:"plugin_page";s:5:"start";i:1760486400;s:3:"end";i:1762128000;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:29:"https://wpmet.com/wpnoticeh78";s:11:"button_text";s:16:"Save $2,936 Now!";s:11:"notice_body";s:475:"<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Wpmet’s Halloween Sale is live<em data-start="1852" data-end="1881">!</em></strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start="794" data-end="830">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>";s:12:"notice_image";s:64:"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10020929";O:8:"stdClass":7:{s:2:"id";i:10020929;s:5:"title";s:30:"Wpmet Halloween Dashboard 2025";s:4:"type";s:6:"notice";s:6:"screen";s:9:"dashboard";s:5:"start";i:1760486400;s:3:"end";i:1762128000;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:29:"https://wpmet.com/wpnoticeh78";s:11:"button_text";s:16:"Save $2,936 Now!";s:11:"notice_body";s:432:"<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start="794" data-end="830">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>";s:12:"notice_image";s:64:"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10019444";O:8:"stdClass":7:{s:2:"id";i:10019444;s:5:"title";s:27:"Wpmet Birthday 2025 ownpage";s:4:"type";s:6:"notice";s:6:"screen";s:11:"plugin_page";s:5:"start";i:1753920000;s:3:"end";i:1755561600;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:26:"https://wpmet.com/notice51";s:11:"button_text";s:20:"Claim Your Discount!";s:11:"notice_body";s:589:"<h3><strong style="color: #; text-transform: sentencecase; font-size: 14px;"><span style="color: #e60073;">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10018928";O:8:"stdClass":7:{s:2:"id";i:10018928;s:5:"title";s:29:"Wpmet Birthday 2025 dashboard";s:4:"type";s:6:"notice";s:6:"screen";s:9:"dashboard";s:5:"start";i:1753920000;s:3:"end";i:1755561600;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:26:"https://wpmet.com/notice50";s:11:"button_text";s:20:"Claim Your Discount!";s:11:"notice_body";s:589:"<h3><strong style="color: #; text-transform: sentencecase; font-size: 14px;"><span style="color: #e60073;">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10018688";O:8:"stdClass":7:{s:2:"id";i:10018688;s:5:"title";s:42:"Wpmet 4th of July Flash Sale 2025 Ownpages";s:4:"type";s:6:"notice";s:6:"screen";s:11:"plugin_page";s:5:"start";i:1751328000;s:3:"end";i:1752019200;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:26:"https://wpmet.com/notice35";s:11:"button_text";s:20:"Claim Your Discount!";s:11:"notice_body";s:585:"<h3><strong style="color: #; text-transform: uppercase; font-size: 14px;"><span style="color: #e60073;">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}s:8:"10018687";O:8:"stdClass":7:{s:2:"id";i:10018687;s:5:"title";s:43:"Wpmet 4th of July Flash Sale 2025 Dashboard";s:4:"type";s:6:"notice";s:6:"screen";s:9:"dashboard";s:5:"start";i:1751328000;s:3:"end";i:1752019200;s:4:"data";O:8:"stdClass":9:{s:4:"type";s:6:"notice";s:11:"button_link";s:26:"https://wpmet.com/notice35";s:11:"button_text";s:20:"Claim Your Discount!";s:11:"notice_body";s:585:"<h3><strong style="color: #; text-transform: uppercase; font-size: 14px;"><span style="color: #e60073;">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style="font-size: 24px; padding: 8px 0 5px; color: #; display: block;">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style="font-size: 16px; margin-left: -2px;"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>";s:12:"notice_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";s:10:"unique_key";s:0:"";}}}','auto');
INSERT INTO `wpnc_options` VALUES (236,'_elementor_installed_time','1736321424','auto');
INSERT INTO `wpnc_options` VALUES (237,'elementor_connect_site_key','6dd2d94c8263931b86552ffc3c797969','auto');
INSERT INTO `wpnc_options` VALUES (238,'elementor_remote_info_library','a:3:{s:10:"types_data";a:4:{s:5:"block";a:2:{s:10:"categories";a:30:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:10:"ehp-footer";i:9;s:10:"ehp-header";i:10;s:3:"faq";i:11;s:8:"features";i:12;s:6:"footer";i:13;s:7:"Gallery";i:14;s:6:"header";i:15;s:4:"hero";i:16;s:11:"Link in Bio";i:17;s:9:"portfolio";i:18;s:7:"pricing";i:19;s:15:"product archive";i:20;s:5:"Quote";i:21;s:15:"Service Details";i:22;s:8:"services";i:23;s:11:"single page";i:24;s:11:"single post";i:25;s:14:"single product";i:26;s:5:"stats";i:27;s:9:"subscribe";i:28;s:4:"team";i:29;s:12:"testimonials";}s:4:"sets";a:5:{i:0;s:11:"Boxing Club";i:1;s:19:"Business Consultant";i:2;s:16:"Marketing Agency";i:3;s:9:"Wireframe";i:4;s:15:"Workshop Center";}}s:5:"popup";a:1:{s:10:"categories";a:6:{i:0;s:10:"bottom bar";i:1;s:7:"classic";i:2;s:6:"fly-in";i:3;s:11:"full screen";i:4;s:9:"hello bar";i:5;s:8:"slide-in";}}s:2:"lp";a:1:{s:10:"categories";a:15:{i:0;s:8:"Business";i:1;s:16:"Coming Soon Page";i:2;s:9:"eCommerce";i:3;s:9:"Education";i:4;s:6:"Events";i:5;s:18:"Health and Fitness";i:6;s:3:"NFT";i:7;s:14:"Online Service";i:8;s:7:"Product";i:9;s:11:"Real Estate";i:10;s:18:"Social Involvement";i:11;s:14:"Thank You Page";i:12;s:6:"Travel";i:13;s:18:"Under Construction";i:14;s:9:"Wireframe";}}s:2:"lb";a:1:{s:10:"categories";a:2:{i:0;s:4:"post";i:1;s:7:"product";}}}s:10:"categories";a:30:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:10:"ehp-footer";i:9;s:10:"ehp-header";i:10;s:3:"faq";i:11;s:8:"features";i:12;s:6:"footer";i:13;s:7:"Gallery";i:14;s:6:"header";i:15;s:4:"hero";i:16;s:11:"Link in Bio";i:17;s:9:"portfolio";i:18;s:7:"pricing";i:19;s:15:"product archive";i:20;s:5:"Quote";i:21;s:15:"Service Details";i:22;s:8:"services";i:23;s:11:"single page";i:24;s:11:"single post";i:25;s:14:"single product";i:26;s:5:"stats";i:27;s:9:"subscribe";i:28;s:4:"team";i:29;s:12:"testimonials";}s:9:"templates";a:4:{i:0;a:20:{s:4:"tmpl";i:1254;s:2:"id";i:20472;s:5:"title";s:10:"test ido f";s:9:"thumbnail";s:153:"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png";s:12:"tmpl_created";i:1751356263;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:1;a:20:{s:4:"tmpl";i:1227;s:2:"id";i:19968;s:5:"title";s:12:"Zeyad Test 1";s:9:"thumbnail";s:83:"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg";s:12:"tmpl_created";i:1670765723;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:5:"about";s:4:"tags";s:2:"[]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:20;}i:2;a:20:{s:4:"tmpl";i:1231;s:2:"id";i:19494;s:5:"title";s:5:"test2";s:9:"thumbnail";s:83:"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg";s:12:"tmpl_created";i:1672308146;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:2;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:20;}i:3;a:20:{s:4:"tmpl";i:1209;s:2:"id";i:9631;s:5:"title";s:38:"Slide-in | Sale | Register | Subscribe";s:9:"thumbnail";s:87:"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png";s:12:"tmpl_created";i:1660034300;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:2:"[]";s:10:"menu_order";i:142;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}}}','off');
INSERT INTO `wpnc_options` VALUES (239,'elementor_remote_info_feed_data','a:3:{i:0;a:5:{s:5:"title";s:79:"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!";s:7:"excerpt";s:340:"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.";s:7:"created";i:1762944115;s:5:"badge";s:3:"NEW";s:3:"url";s:145:"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:1;a:5:{s:5:"title";s:76:"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More";s:7:"excerpt";s:250:"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.";s:7:"created";i:1759243152;s:5:"badge";s:3:"NEW";s:3:"url";s:138:"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:2;a:5:{s:5:"title";s:70:"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More";s:7:"excerpt";s:294:"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.";s:7:"created";i:1755094220;s:5:"badge";s:3:"NEW";s:3:"url";s:140:"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}}','off');
INSERT INTO `wpnc_options` VALUES (248,'e_editor_counter','39','auto');
INSERT INTO `wpnc_options` VALUES (249,'_elementor_free_to_pro_upsell','a:2:{s:7:"timeout";i:1736417176;s:5:"value";s:593:"[{"id":"animated_headline","imageSrc":"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg"},{"id":"video_playlist","imageSrc":"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg"},{"id":"cta","imageSrc":"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg"},{"id":"testimonial_widget","imageSrc":"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg"},{"id":"image_carousel","imageSrc":"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg"}]";}','off');
INSERT INTO `wpnc_options` VALUES (250,'_elementor_notifications_data','a:2:{s:7:"timeout";i:1738160065;s:5:"value";s:14101:"[{"id":"dynamic-off-canvas-3.26","title":"Dynamic Off-Canvas for Loop Grids","description":"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.","topic":"Elementor Pro 3.26","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"dynamic-off-canvas-3.26","title":"Dynamic Off-Canvas for Loop Grids","description":"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.","topic":"Elementor Pro 3.26","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png","chipTags":["New Feature"],"cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/"},{"id":"hello-biz-theme","title":"A Brand New Theme From Elementor: Introducing Hello BIZ","description":"Meet Hello Biz. The new theme empowers you with Hello+ Widgets that accelerate your workflow. It\'s FREE and fully compatible with Elementor & Elementor Pro.","topic":"Hello Biz","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-theme.png","chipTags":["New Theme"],"link":"https:\\/\\/elementor.com\\/blog\\/introducing-hello-biz\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"hello-biz-theme","title":"A Brand New Theme From Elementor: Introducing Hello BIZ","description":"Meet Hello Biz. The new theme that lets you build a website within minutes. And it\'s FREE. Perfect for a business website, and fully compatible with Elementor & Elementor Pro.","topic":"Hello Biz","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-theme.png","chipTags":["New Theme"],"link":"https:\\/\\/elementor.com\\/blog\\/introducing-hello-biz\\/","readMoreText":"Learn More"},{"id":"ai-site-planner","title":"Instant Sitemaps & Wireframes","description":"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/","readMoreText":"Learn More"},{"id":"css-loading-3.25","title":"Boost Performance with Conditional CSS Loading","description":"Boost performance by conditionally loading only the styles that each page needs, reducing the page CSS size by up to 668kb.","topic":"Elementor 3.25","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.25-css-Loading.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-25-blog\\/","readMoreText":"Learn More"},{"id":"image-optimizer-3.19","title":"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.","description":"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.","topic":"Image Optimizer Plugin by Elementor","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png","chipTags":["New plugin"],"cta":"Get the Image Optimizer","ctaLink":"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/","conditions":[[{"type":"plugin","operator":"!=","plugin":"image-optimization\\/image-optimization.php"}]]},{"id":"variable-fonts-3.24","title":"Elevate text design with Variable Fonts","description":"Experience unparalleled fluidity in your design with precise control over text width and weight.","topic":"Elementor Pro 3.24","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-variable-fonts.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"variable-fonts-3.24","title":"Elevate text design with Variable Fonts","description":"Experience unparalleled fluidity in your design with precise control over text width and weight.","topic":"Elementor Pro 3.24","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-variable-fonts.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-24-variable-fonts\\/"},{"id":"floating-bars-3.24","title":"Increase conversion with Floating Bars","description":"Place your most important messages and promotions at the top or bottom of your page seamlessly with over 30 pre-made templates.","topic":"Elementor 3.24","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-floating-bar.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/","readMoreText":"Learn More"},{"id":"ai-featured-image","title":"Featured Image: Let AI Do the Work","description":"Say goodbye to image searches! Let AI craft stunning featured images with a click, perfectly matching your content. No prompts needed. Discover how easy it is.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/featured_ai.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/ai-notification-featured-image-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"introduction_meta","meta":"ai_get_started"}]],"cta":"Start Free Trial","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-featured-image\\/"},{"id":"ai-featured-image","title":"Featured Image: Let AI Do the Work","description":"Say goodbye to image searches! Let AI craft stunning featured images with a click, perfectly matching your content. No prompts needed. Discover how easy it is.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/featured_ai.png","chipTags":["New Feature"],"cta":"Start Free Trial","link":"https:\\/\\/go.elementor.com\\/ai-notification-featured-image-blog\\/","readMoreText":"Learn More","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-featured-image\\/\\/"},{"id":"search-widget-3.23","title":"Increases site exploration with AJAX loading & live results","description":"Enabling faster, more accurate content discovery and helping visitors find what they\'re looking for.","topic":"Elementor Pro 3.23","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/search-widget-3.23.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"search-widget-3.23","title":"Increases site exploration with AJAX loading & live results","description":"Enabling faster, more accurate content discovery and helping visitors find what they\'re looking for.","topic":"Elementor Pro 3.23","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/search-widget-3.23.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-search-widget\\/"},{"id":"floating-buttons-3.23","title":"Get more leads with Floating Buttons","description":"Empowering you to increase conversion by seamlessly integrating a direct link to a chat or different platforms in the form of a floating button.","topic":"Elementor 3.23","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/floating-buttons-3.23.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features-blog\\/","readMoreText":"Learn More"},{"id":"link-in-bio-3.23","title":"New Link in Bio Widgets for any Purpose","description":"Create a polished and professional page with just a few clicks and effectively showcase all your important links. Choose from 7 unique widgets and over 60 templates!","topic":"Elementor 3.23","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/link-in-bio-3.23.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-link-in-bio-3-23-blog\\/","readMoreText":"Learn More"},{"id":"nested-elements-3.23","title":"Work faster on Nested Elements","description":"Customize Nested Elements faster with version 3.23. Now every change to a Nested Element will only affect the relevant element and not require reloading the entire widget, improving Editor interaction time by 60%-98%.","topic":"Elementor 3.23","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/nested-elements-3.23.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features-blog\\/","readMoreText":"Learn More"},{"id":"element-caching-3.22","title":"Accelerate Loading Times with Element Caching","description":"Ensure a smooth and engaging experience for visitors by activating Element Caching.","topic":"Elementor 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/performance-caching.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-element-caching-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"element-caching-3.22","title":"Accelerate Loading Times with Element Caching","description":"Ensure a smooth and engaging experience for visitors by activating Element Caching.","topic":"Elementor 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/performance-caching.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-element-caching-blog\\/","readMoreText":"Learn More"},{"id":"off-canvas-3.22","title":"Build Interactive Layouts with the New Off-Canvas Widget","description":"Tigger containers from a connected link to allow them to slide into view anywhere on the page.","topic":"Elementor Pro 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"off-canvas-3.22","title":"Build Interactive Layouts with the New Off-Canvas Widget","description":"Tigger containers from a connected link to allow them to slide into view anywhere on the page.","topic":"Elementor Pro 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas\\/\\/"},{"id":"5-star-rating-prompt","title":"Love the New Features? Let Us Know with 5 Stars!","description":"Help spread the word by telling the world what you love about Elementor.","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png","cta":"Leave a Review","ctaLink":"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/"},{"id":"site-mailer-introducing","title":"Introducing Site Mailer","description":"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.","topic":"Site Mailer Plugin by Elementor","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png","chipTags":["New plugin"],"cta":"Start Free Trial","ctaLink":"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/","conditions":[[{"type":"plugin","operator":"!=","plugin":"site-mailer\\/site-mailer.php"}]]},{"id":"display-conditions-dynamic-content-3.20","title":"Display Conditions for Dynamic Content","description":"Transform your single post and page templates into dynamic designs that fit their content by setting display conditions based on Dynamic Tags, including native WordPress Custom Fields.","topic":"Version Pro 3.20","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/dynamic-content-pro-3.20.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-display-conditions-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"display-conditions-dynamic-content-3.20","title":"Display Content on Your Terms: Decide When, Where, and by Who the Content is Viewed","description":"Tailor the content on your page to visitors based on various rules to create a powerful experience.","topic":"Version Pro 3.20","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/display-conditions-3.20.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-display-conditions-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-dispaly-conditions\\/"},{"id":"elementor-add-ons","title":"Exciting Add-Ons & Plugins to Enhance Elementor Websites","description":"Uncover a treasure trove of tools from Elementor and others, put together to boost your website\'s capabilities and enhance its overall appeal.","topic":"Elementor Add-Ons","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/elementor-add-ons.png","cta":"Check it out","ctaLink":"https:\\/\\/go.elementor.com\\/wp-dash-notification-addons\\/"}]";}','off');
INSERT INTO `wpnc_options` VALUES (267,'metform__stories_last_check','1766814729','auto');
INSERT INTO `wpnc_options` VALUES (268,'metform__stories_data','O:8:"stdClass":10:{s:8:"10022097";O:8:"stdClass":9:{s:2:"id";i:10022097;s:5:"title";s:26:"GetGenie Holiday Sale 2025";s:11:"description";s:0:"";s:7:"plugins";a:2:{i:0;s:8:"getgenie";i:1;s:12:"getgenie-pro";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1766361600;s:3:"end";i:1768089600;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:31:"https://getgenie.ai/holidaysale";s:11:"story_image";s:79:"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Getgenie-Holiday-Sale.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10022091";O:8:"stdClass":9:{s:2:"id";i:10022091;s:5:"title";s:23:"Wpmet Holiday Sale 2025";s:11:"description";s:0:"";s:7:"plugins";a:7:{i:0;s:16:"elementskit-lite";i:1;s:8:"emailkit";i:2;s:21:"gutenkit-blocks-addon";i:3;s:7:"metform";i:4;s:10:"shopengine";i:5;s:9:"wp-social";i:6;s:18:"wp-ultimate-review";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1766361600;s:3:"end";i:1768089600;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:22:"https://wpmet.com/4mb9";s:11:"story_image";s:76:"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Wpmet-Holiday-Sale.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10021822";O:8:"stdClass":9:{s:2:"id";i:10021822;s:5:"title";s:18:"BFCM GetGenie 2025";s:11:"description";s:0:"";s:7:"plugins";a:2:{i:0;s:8:"getgenie";i:1;s:12:"getgenie-pro";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1762819200;s:3:"end";i:1765843200;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:33:"https://getgenie.ai/geniestoryh50";s:11:"story_image";s:68:"https://api.wpmet.com/auth/wp-content/uploads/2025/11/GetGenie-1.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10021818";O:8:"stdClass":9:{s:2:"id";i:10021818;s:5:"title";s:15:"Wpmet BFCM 2025";s:11:"description";s:0:"";s:7:"plugins";a:7:{i:0;s:16:"elementskit-lite";i:1;s:8:"emailkit";i:2;s:21:"gutenkit-blocks-addon";i:3;s:7:"metform";i:4;s:10:"shopengine";i:5;s:9:"wp-social";i:6;s:18:"wp-ultimate-review";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1762819200;s:3:"end";i:1765843200;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:28:"https://wpmet.com/wpstoryh80";s:11:"story_image";s:65:"https://api.wpmet.com/auth/wp-content/uploads/2025/11/Wpmet-2.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10020924";O:8:"stdClass":9:{s:2:"id";i:10020924;s:5:"title";s:23:"Halloween GetGenie 2025";s:11:"description";s:0:"";s:7:"plugins";a:2:{i:0;s:8:"getgenie";i:1;s:12:"getgenie-pro";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1760486400;s:3:"end";i:1762128000;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:33:"https://getgenie.ai/geniestoryh45";s:11:"story_image";s:66:"https://api.wpmet.com/auth/wp-content/uploads/2025/10/GetGenie.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10020922";O:8:"stdClass":9:{s:2:"id";i:10020922;s:5:"title";s:20:"Hallowwen Wpmet 2025";s:11:"description";s:0:"";s:7:"plugins";a:7:{i:0;s:16:"elementskit-lite";i:1;s:8:"emailkit";i:2;s:21:"gutenkit-blocks-addon";i:3;s:7:"metform";i:4;s:10:"shopengine";i:5;s:9:"wp-social";i:6;s:18:"wp-ultimate-review";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1760486400;s:3:"end";i:1762128000;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:28:"https://wpmet.com/wpstoryh78";s:11:"story_image";s:65:"https://api.wpmet.com/auth/wp-content/uploads/2025/10/Wpmet-1.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10020276";O:8:"stdClass":9:{s:2:"id";i:10020276;s:5:"title";s:17:"GetGenie 30K Deal";s:11:"description";s:0:"";s:7:"plugins";a:2:{i:0;s:8:"getgenie";i:1;s:12:"getgenie-pro";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1757203200;s:3:"end";i:1758499200;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:28:"https://getgenie.ai/30kstory";s:11:"story_image";s:71:"https://api.wpmet.com/auth/wp-content/uploads/2025/09/Genie-30K-GIF.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10019442";O:8:"stdClass":9:{s:2:"id";i:10019442;s:5:"title";s:23:"Wpmet Birthday 25 Genie";s:11:"description";s:0:"";s:7:"plugins";a:1:{i:0;s:8:"getgenie";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1753920000;s:3:"end";i:1755561600;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:32:"https://wpmet.com/gbday-story-25";s:11:"story_image";s:63:"https://api.wpmet.com/auth/wp-content/uploads/2025/07/Genie.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10019440";O:8:"stdClass":9:{s:2:"id";i:10019440;s:5:"title";s:19:"Wpmet Birthday 2025";s:11:"description";s:0:"";s:7:"plugins";a:6:{i:0;s:8:"emailkit";i:1;s:21:"gutenkit-blocks-addon";i:2;s:7:"metform";i:3;s:10:"shopengine";i:4;s:9:"wp-social";i:5;s:18:"wp-ultimate-review";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1753920000;s:3:"end";i:1755561600;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:31:"https://wpmet.com/bday-story-25";s:11:"story_image";s:60:"https://api.wpmet.com/auth/wp-content/uploads/2025/07/WP.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}s:8:"10018690";O:8:"stdClass":9:{s:2:"id";i:10018690;s:5:"title";s:36:"GetGenie 4th of July Flash Sale 2025";s:11:"description";s:0:"";s:7:"plugins";a:2:{i:0;s:8:"getgenie";i:1;s:12:"getgenie-pro";}s:4:"type";s:6:"banner";s:8:"priority";s:4:"high";s:5:"start";i:1751328000;s:3:"end";i:1752019200;s:4:"data";O:8:"stdClass":6:{s:4:"type";s:6:"banner";s:10:"story_link";s:27:"https://getgenie.ai/story45";s:11:"story_image";s:71:"https://api.wpmet.com/auth/wp-content/uploads/2025/07/GetGenie__Gif.gif";s:9:"blacklist";s:0:"";s:9:"whitelist";s:0:"";s:9:"style_css";s:0:"";}}}','auto');
INSERT INTO `wpnc_options` VALUES (269,'metform_install_date','2025-01-08 09:50:02','auto');
INSERT INTO `wpnc_options` VALUES (283,'WPLANG','','auto');
INSERT INTO `wpnc_options` VALUES (284,'new_admin_email','venture.publish@gmail.com','auto');
INSERT INTO `wpnc_options` VALUES (301,'rsssl_404_cache','a:506:{s:12:"34.73.81.151";a:1:{i:0;i:1736332067;}s:12:"58.147.190.5";a:1:{i:9;i:1736840754;}s:14:"35.202.220.145";a:1:{i:0;i:1736405279;}s:13:"85.208.96.209";a:1:{i:0;i:1736473804;}s:13:"159.223.38.28";a:4:{i:0;i:1736484103;i:1;i:1736484104;i:2;i:1736484105;i:3;i:1736484106;}s:15:"165.232.117.180";a:1:{i:0;i:1736491068;}s:11:"4.227.36.15";a:1:{i:1;i:1737469645;}s:14:"92.205.199.215";a:3:{i:1;i:1736567750;i:2;i:1736567751;i:3;i:1736567752;}s:13:"128.90.170.15";a:3:{i:11;i:1736577266;i:12;i:1736577267;i:13;i:1736577269;}s:13:"85.208.96.207";a:1:{i:0;i:1736586085;}s:15:"103.234.209.234";a:2:{i:767;i:1741462391;i:768;i:1741462393;}s:12:"161.97.107.3";a:3:{i:1;i:1736665725;i:2;i:1736665726;i:3;i:1736665728;}s:14:"216.244.66.197";a:1:{i:3;i:1737155700;}s:13:"176.53.216.17";a:1:{i:0;i:1736766890;}s:13:"89.104.100.37";a:3:{i:4;i:1736766902;i:5;i:1736766903;i:6;i:1736766905;}s:14:"152.228.221.99";a:3:{i:1;i:1736780194;i:2;i:1736780196;i:3;i:1736780197;}s:13:"85.208.96.212";a:1:{i:0;i:1736820116;}s:12:"34.168.21.15";a:1:{i:0;i:1736917028;}s:14:"176.96.241.209";a:2:{i:2;i:1736924492;i:3;i:1736924495;}s:13:"159.89.168.47";a:2:{i:0;i:1736925020;i:1;i:1736925022;}s:13:"62.182.85.138";a:1:{i:0;i:1736947660;}s:15:"178.128.121.194";a:1:{i:0;i:1736951585;}s:11:"4.227.36.46";a:1:{i:0;i:1736956332;}s:13:"66.249.71.160";a:1:{i:0;i:1736972338;}s:13:"66.249.71.174";a:1:{i:0;i:1737003376;}s:11:"4.227.36.79";a:1:{i:0;i:1737017603;}s:13:"52.167.144.24";a:1:{i:0;i:1737024581;}s:14:"52.167.144.194";a:1:{i:0;i:1737028203;}s:12:"66.249.65.46";a:1:{i:0;i:1737081978;}s:13:"82.165.147.48";a:1:{i:1;i:1737101295;}s:12:"40.77.167.23";a:1:{i:1;i:1741575978;}s:12:"87.106.158.5";a:3:{i:1;i:1737142373;i:2;i:1737142374;i:3;i:1737142376;}s:14:"35.198.245.190";a:1:{i:0;i:1737203438;}s:13:"159.203.6.112";a:1:{i:0;i:1737212531;}s:13:"157.55.39.202";a:1:{i:0;i:1737283154;}s:14:"82.180.146.110";a:1:{i:0;i:1737303886;}s:11:"40.77.167.9";a:1:{i:0;i:1737370054;}s:12:"34.48.166.15";a:1:{i:0;i:1737374259;}s:13:"66.249.81.196";a:1:{i:1;i:1741095035;}s:14:"52.167.144.136";a:1:{i:1;i:1766013810;}s:13:"82.165.125.69";a:1:{i:0;i:1737500698;}s:13:"170.205.28.91";a:2:{i:19;i:1737523429;i:20;i:1737523432;}s:15:"206.189.113.180";a:1:{i:0;i:1737565769;}s:12:"35.223.55.15";a:1:{i:0;i:1737629883;}s:12:"212.30.36.96";a:1:{i:0;i:1737714067;}s:12:"138.68.64.24";a:1:{i:0;i:1737736917;}s:12:"4.227.36.100";a:1:{i:0;i:1737752499;}s:11:"4.227.36.44";a:1:{i:0;i:1737948936;}s:13:"52.167.144.20";a:1:{i:0;i:1738187254;}s:13:"34.127.11.213";a:1:{i:0;i:1738218454;}s:11:"4.227.36.72";a:1:{i:0;i:1738236268;}s:13:"66.249.88.165";a:1:{i:0;i:1738250206;}s:14:"52.167.144.234";a:1:{i:0;i:1738351932;}s:10:"4.227.36.0";a:1:{i:0;i:1738459829;}s:14:"149.56.150.214";a:2:{i:2;i:1738507693;i:3;i:1738507696;}s:12:"66.249.93.72";a:1:{i:1;i:1740512015;}s:13:"35.231.229.83";a:1:{i:0;i:1739263673;}s:13:"194.226.97.54";a:1:{i:0;i:1739299660;}s:14:"195.208.21.250";a:1:{i:0;i:1739299661;}s:11:"45.82.15.54";a:4:{i:0;i:1739333750;i:1;i:1739333754;i:2;i:1739333754;i:3;i:1739333754;}s:14:"20.171.207.168";a:1:{i:0;i:1739345039;}s:12:"45.90.60.241";a:1:{i:0;i:1739414343;}s:14:"176.53.216.224";a:2:{i:0;i:1739414354;i:1;i:1739414357;}s:13:"176.53.217.20";a:1:{i:0;i:1739414361;}s:12:"66.249.93.73";a:1:{i:1;i:1741879569;}s:13:"176.53.223.76";a:1:{i:1;i:1739462995;}s:12:"176.53.218.9";a:1:{i:1;i:1739463004;}s:14:"89.104.101.105";a:2:{i:0;i:1739463008;i:1;i:1739463012;}s:13:"176.53.223.37";a:2:{i:0;i:1739463016;i:1;i:1739463020;}s:14:"154.223.139.74";a:2:{i:0;i:1739463026;i:1;i:1739463029;}s:12:"45.90.63.110";a:2:{i:0;i:1739463034;i:1;i:1739463037;}s:11:"45.90.60.27";a:2:{i:0;i:1739463041;i:1;i:1739463045;}s:14:"89.104.101.100";a:2:{i:0;i:1739463049;i:1;i:1739463052;}s:14:"176.53.219.187";a:2:{i:0;i:1739463056;i:1;i:1739463060;}s:14:"89.104.100.237";a:2:{i:0;i:1739463066;i:1;i:1739463069;}s:14:"176.53.220.159";a:1:{i:1;i:1739463081;}s:12:"45.90.63.223";a:2:{i:0;i:1739463086;i:1;i:1739463089;}s:11:"45.90.60.44";a:2:{i:0;i:1739463094;i:1;i:1739463097;}s:14:"89.104.111.235";a:1:{i:1;i:1739463108;}s:14:"176.53.220.194";a:2:{i:0;i:1739463115;i:1;i:1739463119;}s:12:"45.90.62.175";a:2:{i:0;i:1739463124;i:1;i:1739463127;}s:14:"176.53.223.218";a:1:{i:2;i:1739463267;}s:12:"45.90.63.131";a:1:{i:1;i:1739463143;}s:12:"45.90.62.190";a:1:{i:1;i:1739463154;}s:14:"89.104.110.244";a:2:{i:0;i:1739463159;i:1;i:1739463162;}s:12:"156.226.7.40";a:1:{i:0;i:1739463169;}s:14:"154.223.139.21";a:1:{i:1;i:1739463180;}s:14:"154.223.139.78";a:2:{i:0;i:1739463186;i:1;i:1739463190;}s:13:"89.104.111.32";a:1:{i:0;i:1739463195;}s:13:"176.53.222.21";a:1:{i:0;i:1739463210;}s:13:"89.104.100.42";a:2:{i:0;i:1739463218;i:1;i:1739463222;}s:14:"176.53.221.120";a:1:{i:0;i:1739463228;}s:11:"156.226.7.3";a:1:{i:1;i:1739463238;}s:14:"176.53.218.222";a:2:{i:0;i:1739463242;i:1;i:1739463246;}s:14:"176.53.219.110";a:2:{i:0;i:1739463251;i:1;i:1739463254;}s:14:"176.53.223.134";a:2:{i:0;i:1739463259;i:1;i:1739463263;}s:13:"34.138.248.49";a:1:{i:0;i:1739480536;}s:12:"13.39.49.189";a:1:{i:8;i:1739485720;}s:12:"45.90.63.112";a:1:{i:0;i:1739491005;}s:14:"176.53.216.208";a:2:{i:0;i:1739491009;i:1;i:1739491013;}s:13:"89.104.101.38";a:1:{i:0;i:1739491017;}s:14:"198.140.141.50";a:1:{i:0;i:1739550881;}s:12:"35.230.75.29";a:1:{i:0;i:1739553109;}s:14:"176.53.222.244";a:1:{i:0;i:1739574541;}s:12:"45.90.60.220";a:2:{i:0;i:1739574545;i:1;i:1739574549;}s:13:"89.104.111.59";a:1:{i:0;i:1739574552;}s:11:"34.57.56.72";a:1:{i:0;i:1739580278;}s:12:"45.55.60.131";a:1:{i:0;i:1739593765;}s:12:"104.197.93.6";a:1:{i:0;i:1739593815;}s:15:"178.128.113.190";a:5:{i:0;i:1739619204;i:1;i:1739619205;i:2;i:1739619206;i:3;i:1739619206;i:4;i:1739619207;}s:14:"89.104.101.224";a:1:{i:0;i:1739662290;}s:11:"45.90.63.41";a:2:{i:0;i:1739662303;i:1;i:1739662307;}s:14:"89.104.111.100";a:1:{i:0;i:1739662321;}s:11:"45.61.161.9";a:1:{i:0;i:1739694022;}s:14:"176.53.219.253";a:1:{i:0;i:1739749124;}s:15:"154.223.139.136";a:1:{i:0;i:1739749131;}s:14:"176.53.216.217";a:1:{i:0;i:1739749135;}s:12:"45.90.60.197";a:1:{i:0;i:1739749153;}s:11:"45.61.161.4";a:1:{i:0;i:1739876154;}s:14:"64.233.173.101";a:1:{i:2;i:1741345966;}s:12:"157.55.39.61";a:1:{i:1;i:1742312923;}s:14:"185.100.87.166";a:2:{i:1;i:1739997954;i:2;i:1739997957;}s:13:"35.198.254.72";a:1:{i:0;i:1740014631;}s:14:"35.240.192.161";a:1:{i:0;i:1740038062;}s:12:"157.55.39.59";a:1:{i:0;i:1740049610;}s:13:"212.30.37.141";a:1:{i:0;i:1740050650;}s:13:"212.30.37.158";a:1:{i:0;i:1740050662;}s:13:"212.30.37.157";a:1:{i:0;i:1740050695;}s:13:"212.30.37.163";a:1:{i:0;i:1740050702;}s:12:"182.1.132.99";a:2:{i:0;i:1740098904;i:1;i:1740098904;}s:12:"207.46.13.87";a:1:{i:0;i:1740137945;}s:12:"34.31.161.56";a:1:{i:0;i:1740147073;}s:14:"196.251.113.74";a:3:{i:14;i:1740177686;i:15;i:1740177688;i:16;i:1740177690;}s:13:"34.90.144.114";a:1:{i:0;i:1740207849;}s:12:"13.39.50.225";a:2:{i:0;i:1740312112;i:1;i:1740312114;}s:13:"34.77.205.110";a:1:{i:0;i:1740380727;}s:14:"149.56.150.236";a:3:{i:1;i:1740382257;i:2;i:1740382259;i:3;i:1740382260;}s:13:"64.233.173.99";a:1:{i:5;i:1745581396;}s:13:"35.180.139.95";a:1:{i:8;i:1740463214;}s:13:"35.243.246.34";a:2:{i:0;i:1740470241;i:1;i:1740470243;}s:12:"34.127.31.97";a:1:{i:0;i:1740569625;}s:13:"20.171.207.26";a:1:{i:5;i:1740608305;}s:13:"35.224.98.163";a:1:{i:0;i:1740656794;}s:14:"196.251.87.151";a:2:{i:6;i:1740831641;i:7;i:1740831644;}s:11:"159.65.8.42";a:1:{i:0;i:1740849785;}s:14:"128.199.111.34";a:1:{i:15;i:1740927374;}s:14:"159.65.128.140";a:3:{i:12;i:1741619553;i:13;i:1741619554;i:14;i:1741619555;}s:14:"196.251.81.198";a:1:{i:0;i:1740931536;}s:14:"52.167.144.162";a:1:{i:0;i:1740968918;}s:14:"149.56.150.147";a:4:{i:0;i:1741044644;i:1;i:1741044645;i:2;i:1741044647;i:3;i:1741044648;}s:12:"52.48.38.139";a:1:{i:0;i:1741079123;}s:11:"34.21.72.20";a:1:{i:0;i:1741109344;}s:14:"52.167.144.219";a:1:{i:0;i:1741109804;}s:11:"40.77.167.7";a:1:{i:1;i:1766774503;}s:13:"35.247.154.84";a:1:{i:0;i:1741170423;}s:14:"35.203.151.174";a:1:{i:0;i:1741209725;}s:13:"149.56.150.48";a:3:{i:1;i:1741250115;i:2;i:1741250116;i:3;i:1741250118;}s:11:"103.52.69.5";a:1:{i:0;i:1741275205;}s:13:"45.149.205.64";a:1:{i:0;i:1741297756;}s:14:"128.199.78.232";a:3:{i:0;i:1741337882;i:1;i:1741337883;i:2;i:1741337884;}s:13:"5.189.203.174";a:1:{i:0;i:1741569276;}s:14:"64.233.173.100";a:1:{i:3;i:1744917172;}s:12:"40.77.167.72";a:1:{i:0;i:1741646587;}s:11:"86.54.42.67";a:1:{i:0;i:1741674337;}s:13:"195.20.18.175";a:1:{i:0;i:1741721979;}s:14:"35.227.106.176";a:1:{i:0;i:1741783877;}s:11:"86.54.42.68";a:1:{i:0;i:1741808553;}s:13:"34.58.152.230";a:1:{i:0;i:1741850164;}s:12:"138.199.48.4";a:1:{i:0;i:1741860362;}s:10:"34.58.18.7";a:1:{i:0;i:1741971745;}s:13:"40.77.167.136";a:1:{i:0;i:1741975854;}s:14:"89.248.172.183";a:1:{i:3;i:1745196516;}s:12:"23.158.56.51";a:1:{i:0;i:1742015969;}s:13:"165.22.30.107";a:2:{i:5;i:1742028294;i:6;i:1742028296;}s:14:"138.68.171.240";a:1:{i:0;i:1742033378;}s:14:"23.137.105.195";a:1:{i:0;i:1742037031;}s:13:"161.97.132.59";a:1:{i:0;i:1742079511;}s:13:"13.40.223.147";a:2:{i:0;i:1742105280;i:1;i:1742105282;}s:15:"159.203.113.125";a:2:{i:6;i:1742131084;i:7;i:1742131088;}s:12:"40.77.167.78";a:1:{i:0;i:1742226955;}s:14:"52.167.144.204";a:1:{i:1;i:1753557621;}s:12:"13.40.237.54";a:1:{i:8;i:1742256502;}s:12:"13.79.60.209";a:3:{i:174;i:1742286148;i:175;i:1742286150;i:176;i:1742286152;}s:14:"196.251.72.191";a:3:{i:14;i:1742339890;i:15;i:1742339892;i:16;i:1742339893;}s:12:"206.81.19.37";a:1:{i:0;i:1742384139;}s:11:"86.54.42.62";a:1:{i:0;i:1742385773;}s:12:"207.46.13.83";a:1:{i:0;i:1742399563;}s:13:"157.55.39.194";a:1:{i:0;i:1742403302;}s:10:"46.8.15.14";a:1:{i:0;i:1742582171;}s:14:"206.189.234.64";a:1:{i:0;i:1742583134;}s:13:"66.249.82.232";a:1:{i:0;i:1742850018;}s:11:"47.82.11.23";a:1:{i:0;i:1742889292;}s:12:"47.82.11.154";a:1:{i:0;i:1742889735;}s:12:"47.82.11.195";a:1:{i:0;i:1742890840;}s:14:"23.137.105.186";a:1:{i:1;i:1743159220;}s:13:"165.227.84.46";a:1:{i:0;i:1743242576;}s:12:"5.183.130.98";a:1:{i:0;i:1743435331;}s:12:"115.231.78.2";a:1:{i:3;i:1743448958;}s:13:"43.156.69.138";a:1:{i:0;i:1743541037;}s:12:"159.89.173.8";a:1:{i:0;i:1743562101;}s:14:"20.171.207.145";a:2:{i:0;i:1743689809;i:1;i:1743689810;}s:12:"40.77.167.52";a:1:{i:0;i:1743762481;}s:14:"149.56.150.245";a:3:{i:1;i:1743888431;i:2;i:1743888433;i:3;i:1743888435;}s:14:"52.167.144.191";a:1:{i:0;i:1743894117;}s:13:"34.31.144.171";a:1:{i:0;i:1744045353;}s:14:"43.134.168.254";a:1:{i:0;i:1744067368;}s:13:"43.204.38.204";a:1:{i:0;i:1744072720;}s:13:"35.206.115.46";a:1:{i:0;i:1744345572;}s:14:"34.150.189.116";a:1:{i:0;i:1744378289;}s:14:"52.167.144.212";a:1:{i:0;i:1744424311;}s:12:"35.188.1.236";a:1:{i:0;i:1744442865;}s:13:"165.227.75.18";a:1:{i:0;i:1744443012;}s:11:"34.105.2.13";a:1:{i:0;i:1744558918;}s:14:"52.167.144.159";a:1:{i:0;i:1744572362;}s:14:"119.28.122.157";a:2:{i:0;i:1744573021;i:1;i:1744573022;}s:14:"163.223.210.21";a:3:{i:0;i:1744692970;i:1;i:1744692971;i:2;i:1744692973;}s:14:"43.156.116.252";a:2:{i:0;i:1744712749;i:1;i:1744712750;}s:12:"34.138.54.77";a:1:{i:0;i:1744729849;}s:13:"43.156.100.82";a:2:{i:0;i:1744754079;i:1;i:1744754080;}s:12:"34.21.34.220";a:1:{i:0;i:1744777871;}s:13:"64.227.144.76";a:1:{i:0;i:1744795893;}s:13:"43.134.86.113";a:2:{i:2;i:1744880724;i:3;i:1744880724;}s:13:"40.77.167.116";a:1:{i:1;i:1745683339;}s:11:"34.75.39.63";a:1:{i:0;i:1744970375;}s:9:"127.0.0.1";a:1:{i:0;i:1744988298;}s:13:"204.10.194.42";a:1:{i:2;i:1744988359;}s:12:"40.77.167.22";a:1:{i:0;i:1744992722;}s:14:"43.163.104.130";a:2:{i:0;i:1745067437;i:1;i:1745067438;}s:13:"35.180.139.83";a:1:{i:8;i:1745074048;}s:14:"52.167.144.186";a:1:{i:0;i:1745079314;}s:14:"52.167.144.187";a:1:{i:0;i:1745082990;}s:13:"146.19.215.55";a:1:{i:6;i:1746715700;}s:14:"35.229.105.222";a:1:{i:0;i:1745303559;}s:14:"20.171.207.112";a:2:{i:0;i:1745399854;i:1;i:1745399857;}s:12:"50.6.206.128";a:1:{i:0;i:1745410004;}s:11:"34.53.6.128";a:1:{i:0;i:1745570708;}s:14:"35.196.208.230";a:2:{i:0;i:1745582119;i:1;i:1745582120;}s:12:"83.32.116.52";a:1:{i:1;i:1745608805;}s:15:"143.110.179.248";a:1:{i:0;i:1745648413;}s:14:"52.167.144.197";a:1:{i:1;i:1750436076;}s:13:"154.90.48.114";a:1:{i:1;i:1745738643;}s:14:"31.171.155.215";a:1:{i:1;i:1745757803;}s:12:"82.223.49.57";a:1:{i:1;i:1745759912;}s:14:"52.167.144.233";a:1:{i:0;i:1745769578;}s:14:"52.167.144.185";a:1:{i:0;i:1745773408;}s:12:"34.69.152.10";a:1:{i:0;i:1745835445;}s:13:"34.143.180.23";a:1:{i:0;i:1745847213;}s:13:"52.167.144.22";a:1:{i:0;i:1745856032;}s:14:"194.233.81.136";a:2:{i:0;i:1745866117;i:1;i:1745866118;}s:14:"159.65.150.195";a:1:{i:0;i:1745978330;}s:11:"51.91.75.62";a:1:{i:0;i:1746030675;}s:11:"34.75.59.58";a:2:{i:0;i:1746143881;i:1;i:1746143882;}s:14:"167.99.131.137";a:1:{i:0;i:1746240678;}s:12:"15.236.37.48";a:1:{i:8;i:1746330749;}s:13:"15.237.179.98";a:1:{i:8;i:1746446291;}s:15:"144.217.135.174";a:3:{i:1;i:1746501614;i:2;i:1746501617;i:3;i:1746501618;}s:13:"64.233.173.71";a:1:{i:3;i:1749048027;}s:13:"35.197.26.144";a:1:{i:0;i:1746505620;}s:13:"64.233.173.69";a:1:{i:4;i:1750062149;}s:14:"64.233.173.202";a:1:{i:0;i:1746679542;}s:14:"149.56.150.105";a:3:{i:1;i:1746801366;i:2;i:1746801368;i:3;i:1746801370;}s:11:"69.50.95.89";a:1:{i:0;i:1746940220;}s:13:"34.59.235.217";a:2:{i:0;i:1747019813;i:1;i:1747019815;}s:12:"34.75.140.88";a:1:{i:0;i:1747119143;}s:10:"34.21.55.1";a:1:{i:0;i:1747124788;}s:14:"43.156.118.135";a:2:{i:0;i:1747217849;i:1;i:1747217850;}s:13:"159.89.45.253";a:1:{i:0;i:1747223149;}s:15:"134.199.227.220";a:1:{i:0;i:1747494337;}s:13:"74.208.59.110";a:1:{i:0;i:1747595884;}s:13:"93.114.235.41";a:1:{i:0;i:1747595888;}s:13:"64.233.173.70";a:1:{i:2;i:1750655361;}s:14:"54.174.109.174";a:1:{i:0;i:1747673632;}s:15:"154.213.166.136";a:1:{i:0;i:1747692428;}s:14:"54.164.157.105";a:1:{i:1;i:1747931420;}s:12:"141.95.75.26";a:1:{i:0;i:1747793765;}s:13:"20.171.207.95";a:1:{i:1;i:1747846384;}s:12:"66.249.88.42";a:1:{i:0;i:1747897559;}s:13:"27.115.124.70";a:1:{i:0;i:1747903761;}s:13:"64.233.173.66";a:1:{i:0;i:1747986754;}s:14:"185.191.171.15";a:1:{i:0;i:1747992108;}s:14:"64.226.102.106";a:1:{i:0;i:1748076106;}s:11:"34.9.223.70";a:1:{i:0;i:1748233272;}s:13:"34.59.155.196";a:1:{i:0;i:1748239576;}s:14:"143.110.213.94";a:1:{i:0;i:1748431958;}s:14:"137.184.171.55";a:1:{i:0;i:1748438333;}s:13:"52.169.88.162";a:4:{i:1;i:1748454340;i:2;i:1748454341;i:3;i:1748454343;i:4;i:1748454344;}s:14:"172.245.214.89";a:1:{i:1;i:1748504574;}s:13:"34.134.53.102";a:1:{i:0;i:1748580949;}s:13:"64.233.173.67";a:1:{i:0;i:1748598928;}s:13:"178.62.20.190";a:1:{i:0;i:1748685511;}s:14:"77.111.247.146";a:1:{i:0;i:1748762111;}s:12:"66.249.93.74";a:1:{i:0;i:1748790357;}s:14:"94.232.247.195";a:1:{i:0;i:1748917170;}s:14:"183.207.45.110";a:1:{i:0;i:1748941236;}s:14:"35.222.193.199";a:1:{i:0;i:1749025256;}s:14:"47.149.218.125";a:1:{i:23;i:1749042039;}s:15:"144.217.135.236";a:3:{i:2;i:1749145179;i:3;i:1749145181;i:4;i:1749145182;}s:14:"35.227.188.128";a:1:{i:0;i:1749190814;}s:15:"146.190.164.216";a:1:{i:0;i:1749308425;}s:15:"195.242.102.131";a:1:{i:0;i:1749325822;}s:12:"192.185.4.43";a:1:{i:0;i:1749325827;}s:13:"34.125.63.192";a:1:{i:0;i:1749549195;}s:14:"34.148.210.156";a:1:{i:0;i:1749561406;}s:12:"167.71.14.83";a:1:{i:0;i:1749615612;}s:13:"34.55.118.244";a:1:{i:0;i:1749789963;}s:14:"209.97.181.112";a:1:{i:0;i:1749888580;}s:14:"79.148.181.143";a:1:{i:0;i:1750020062;}s:13:"43.134.83.190";a:2:{i:0;i:1750117773;i:1;i:1750117774;}s:14:"34.125.219.170";a:1:{i:0;i:1750222057;}s:15:"173.239.201.201";a:3:{i:35;i:1750303815;i:36;i:1750303817;i:37;i:1750303819;}s:13:"43.133.63.242";a:2:{i:2;i:1750565228;i:3;i:1750565229;}s:11:"34.138.96.4";a:1:{i:0;i:1750389595;}s:12:"35.204.15.91";a:1:{i:0;i:1750399666;}s:11:"66.249.82.9";a:1:{i:0;i:1750405260;}s:11:"34.42.138.9";a:1:{i:0;i:1750501441;}s:12:"40.77.167.75";a:1:{i:0;i:1750523484;}s:14:"165.232.77.168";a:1:{i:0;i:1750523783;}s:14:"17.241.227.144";a:1:{i:0;i:1750543586;}s:14:"52.167.144.156";a:1:{i:0;i:1750608508;}s:13:"125.166.38.81";a:1:{i:0;i:1750906728;}s:11:"34.74.9.152";a:1:{i:0;i:1751290243;}s:13:"35.238.147.79";a:1:{i:0;i:1751295134;}s:13:"51.159.103.19";a:3:{i:0;i:1751315766;i:1;i:1751315767;i:2;i:1751315768;}s:13:"64.233.173.33";a:1:{i:0;i:1751342513;}s:13:"35.231.159.14";a:1:{i:0;i:1751350583;}s:13:"64.233.173.41";a:1:{i:2;i:1751460019;}s:12:"34.46.25.152";a:1:{i:0;i:1751367754;}s:13:"66.249.82.230";a:1:{i:0;i:1751377223;}s:14:"17.241.219.189";a:1:{i:0;i:1751667286;}s:14:"64.233.173.197";a:1:{i:12;i:1757507742;}s:13:"17.241.75.123";a:1:{i:0;i:1752051300;}s:13:"66.249.81.161";a:1:{i:0;i:1752071234;}s:14:"103.213.116.69";a:1:{i:0;i:1752218539;}s:13:"34.44.209.193";a:1:{i:0;i:1752221731;}s:11:"34.1.25.241";a:1:{i:0;i:1752511402;}s:14:"38.242.155.112";a:1:{i:49;i:1752574578;}s:14:"205.210.31.156";a:1:{i:0;i:1752658174;}s:13:"198.235.24.35";a:1:{i:0;i:1752658824;}s:14:"64.233.173.196";a:1:{i:13;i:1757959622;}s:12:"198.235.24.8";a:1:{i:0;i:1752917703;}s:14:"74.125.212.133";a:1:{i:0;i:1753027980;}s:14:"17.241.219.120";a:1:{i:0;i:1753058271;}s:13:"66.249.82.229";a:1:{i:0;i:1753227424;}s:13:"198.235.24.95";a:1:{i:0;i:1753284209;}s:14:"147.185.132.10";a:1:{i:0;i:1753284332;}s:14:"64.233.173.198";a:1:{i:9;i:1757912942;}s:13:"40.77.167.158";a:1:{i:0;i:1753461610;}s:12:"40.77.167.33";a:1:{i:0;i:1753553635;}s:14:"103.35.191.207";a:1:{i:2;i:1753788578;}s:12:"40.77.167.64";a:1:{i:0;i:1753634511;}s:14:"52.167.144.138";a:1:{i:1;i:1765655728;}s:13:"20.171.207.37";a:2:{i:0;i:1753722560;i:1;i:1753722562;}s:13:"52.187.14.142";a:1:{i:0;i:1753729459;}s:12:"85.215.79.20";a:1:{i:0;i:1753800362;}s:12:"40.77.167.26";a:1:{i:1;i:1754238485;}s:14:"52.167.144.174";a:1:{i:1;i:1760987419;}s:14:"205.210.31.164";a:1:{i:0;i:1754184888;}s:15:"147.185.132.210";a:1:{i:0;i:1754220880;}s:12:"40.77.167.61";a:1:{i:1;i:1766169039;}s:14:"52.167.144.177";a:1:{i:0;i:1754329339;}s:15:"143.198.224.102";a:1:{i:0;i:1754356961;}s:13:"23.109.219.73";a:1:{i:0;i:1754682844;}s:13:"152.42.242.17";a:1:{i:0;i:1755541333;}s:15:"104.214.149.118";a:2:{i:0;i:1755607261;i:1;i:1755607263;}s:14:"52.185.140.106";a:2:{i:0;i:1755626046;i:1;i:1755626048;}s:14:"159.223.80.224";a:2:{i:108;i:1755718281;i:109;i:1755718285;}s:12:"40.86.30.227";a:2:{i:0;i:1755779769;i:1;i:1755779773;}s:11:"13.67.145.9";a:1:{i:0;i:1755809384;}s:14:"167.94.145.104";a:1:{i:0;i:1755879699;}s:14:"183.207.48.165";a:1:{i:0;i:1755916453;}s:11:"92.43.100.3";a:3:{i:1;i:1756081719;i:2;i:1756081720;i:3;i:1756081722;}s:13:"183.81.33.136";a:4:{i:15;i:1756091361;i:16;i:1756091362;i:17;i:1756091364;i:18;i:1756091365;}s:13:"66.249.71.170";a:1:{i:1;i:1764871910;}s:13:"34.145.23.249";a:5:{i:0;i:1756185882;i:1;i:1756185883;i:2;i:1756185885;i:3;i:1756185885;i:4;i:1756185886;}s:13:"35.85.255.240";a:1:{i:0;i:1756286153;}s:12:"37.65.167.67";a:1:{i:0;i:1756306660;}s:11:"83.32.126.2";a:1:{i:0;i:1756306660;}s:12:"20.18.140.51";a:3:{i:7;i:1756376134;i:8;i:1756376137;i:9;i:1756376138;}s:13:"52.187.27.205";a:3:{i:30;i:1756505709;i:31;i:1756505712;i:32;i:1756505713;}s:14:"64.233.173.201";a:1:{i:0;i:1756534299;}s:12:"39.37.176.14";a:1:{i:0;i:1756690715;}s:14:"183.207.45.113";a:1:{i:0;i:1756691216;}s:12:"66.249.88.36";a:1:{i:1;i:1764965544;}s:12:"23.98.92.199";a:6:{i:18;i:1756821937;i:19;i:1756821937;i:20;i:1756821938;i:21;i:1756821939;i:22;i:1756821940;i:23;i:1756821941;}s:14:"52.167.144.150";a:1:{i:0;i:1756974244;}s:13:"20.218.88.214";a:1:{i:0;i:1757113194;}s:12:"52.187.130.8";a:7:{i:2;i:1757282132;i:3;i:1757282132;i:4;i:1757282133;i:5;i:1757282134;i:6;i:1757282134;i:7;i:1757282135;i:8;i:1757282136;}s:14:"192.81.129.161";a:1:{i:0;i:1757285819;}s:14:"139.59.118.211";a:1:{i:0;i:1757354879;}s:12:"185.125.50.5";a:1:{i:0;i:1757828270;}s:13:"205.210.31.97";a:1:{i:0;i:1757832460;}s:14:"34.142.163.137";a:1:{i:0;i:1757855984;}s:14:"34.143.157.117";a:1:{i:0;i:1757908606;}s:13:"52.163.246.95";a:1:{i:0;i:1758141169;}s:14:"64.233.173.149";a:1:{i:5;i:1763368807;}s:14:"34.143.174.189";a:1:{i:0;i:1758233959;}s:14:"136.144.19.110";a:3:{i:2;i:1758294187;i:3;i:1758294189;i:4;i:1758294191;}s:14:"64.233.173.148";a:1:{i:3;i:1763377030;}s:14:"52.167.144.198";a:1:{i:0;i:1758522264;}s:14:"64.233.173.147";a:1:{i:0;i:1758599382;}s:13:"64.188.91.114";a:1:{i:0;i:1758608556;}s:13:"40.77.167.121";a:1:{i:0;i:1758674831;}s:12:"34.28.161.73";a:1:{i:0;i:1758699373;}s:13:"134.149.43.16";a:1:{i:0;i:1758754316;}s:14:"34.142.243.139";a:1:{i:0;i:1758813159;}s:14:"52.167.144.160";a:1:{i:1;i:1760900736;}s:14:"52.167.144.180";a:1:{i:0;i:1759000581;}s:12:"207.46.13.17";a:1:{i:0;i:1759169909;}s:14:"92.204.255.237";a:1:{i:0;i:1759243543;}s:14:"52.167.144.199";a:1:{i:1;i:1766778250;}s:13:"205.210.31.43";a:1:{i:0;i:1759279121;}s:14:"147.185.132.94";a:1:{i:0;i:1759279374;}s:14:"180.242.71.156";a:1:{i:0;i:1759488354;}s:15:"147.185.132.117";a:1:{i:0;i:1759623343;}s:13:"198.235.24.46";a:1:{i:0;i:1759623654;}s:14:"198.235.24.103";a:1:{i:0;i:1759623654;}s:13:"149.56.150.24";a:3:{i:2;i:1759656900;i:3;i:1759656902;i:4;i:1759656903;}s:13:"34.143.202.49";a:1:{i:0;i:1759665162;}s:14:"34.126.152.101";a:1:{i:0;i:1759669825;}s:13:"172.192.54.92";a:1:{i:0;i:1759713558;}s:15:"147.185.132.255";a:1:{i:0;i:1759795975;}s:14:"198.235.24.219";a:1:{i:0;i:1759796043;}s:13:"198.235.24.73";a:1:{i:0;i:1759796165;}s:14:"172.207.123.72";a:1:{i:0;i:1759931845;}s:13:"69.171.231.23";a:1:{i:0;i:1760183385;}s:13:"85.208.96.201";a:1:{i:0;i:1760309763;}s:13:"34.23.168.181";a:1:{i:0;i:1760592198;}s:14:"203.188.183.70";a:1:{i:0;i:1760637192;}s:14:"198.235.24.181";a:1:{i:0;i:1760747727;}s:14:"205.210.31.233";a:1:{i:0;i:1760747892;}s:12:"66.249.93.33";a:1:{i:2;i:1765316403;}s:13:"40.77.167.230";a:1:{i:0;i:1760810618;}s:14:"52.167.144.210";a:1:{i:0;i:1760896899;}s:12:"66.102.9.103";a:1:{i:0;i:1760966632;}s:12:"40.77.167.47";a:1:{i:0;i:1760983396;}s:12:"13.40.27.100";a:1:{i:0;i:1761004215;}s:10:"45.8.25.38";a:1:{i:0;i:1761022123;}s:15:"104.168.126.136";a:1:{i:0;i:1761038707;}s:10:"45.8.25.35";a:1:{i:0;i:1761042592;}s:14:"34.173.194.198";a:1:{i:0;i:1761119435;}s:13:"69.171.231.21";a:1:{i:0;i:1761120741;}s:10:"34.1.22.88";a:2:{i:0;i:1761121142;i:1;i:1761121144;}s:10:"34.1.17.64";a:2:{i:0;i:1761449463;i:1;i:1761449464;}s:10:"34.1.30.81";a:2:{i:0;i:1761457937;i:1;i:1761457938;}s:12:"40.77.167.25";a:1:{i:0;i:1761816299;}s:13:"35.240.232.23";a:1:{i:0;i:1761839796;}s:12:"139.47.9.190";a:1:{i:0;i:1762337631;}s:13:"64.233.172.36";a:1:{i:0;i:1762460336;}s:14:"45.128.199.187";a:1:{i:0;i:1762505078;}s:14:"149.56.150.124";a:4:{i:1;i:1762624887;i:2;i:1762624888;i:3;i:1762624890;i:4;i:1762624891;}s:13:"157.66.54.186";a:2:{i:0;i:1762821135;i:1;i:1762821135;}s:14:"43.173.179.119";a:1:{i:0;i:1762889410;}s:13:"103.1.213.214";a:1:{i:0;i:1762946189;}s:14:"74.125.215.104";a:1:{i:0;i:1763000614;}s:14:"52.178.147.136";a:3:{i:181;i:1763267522;i:182;i:1763267523;i:183;i:1763267525;}s:14:"69.171.231.112";a:1:{i:0;i:1763289203;}s:13:"143.198.85.68";a:2:{i:0;i:1763307726;i:1;i:1763307727;}s:14:"52.167.144.183";a:1:{i:0;i:1763318176;}s:11:"40.77.167.4";a:1:{i:0;i:1763321890;}s:14:"52.169.206.229";a:4:{i:97;i:1763372323;i:98;i:1763372325;i:99;i:1763372326;i:100;i:1763372327;}s:12:"66.249.81.66";a:1:{i:0;i:1763393825;}s:14:"52.167.144.169";a:1:{i:0;i:1763404296;}s:14:"52.167.144.201";a:1:{i:0;i:1763408231;}s:12:"44.223.24.21";a:1:{i:0;i:1763410799;}s:14:"208.89.241.198";a:1:{i:0;i:1763411354;}s:14:"208.89.240.247";a:1:{i:0;i:1763411357;}s:12:"66.249.81.65";a:1:{i:0;i:1763469205;}s:12:"207.46.13.18";a:1:{i:0;i:1763490546;}s:14:"152.42.236.224";a:2:{i:13;i:1763494501;i:14;i:1763494504;}s:12:"66.249.81.67";a:1:{i:0;i:1763550776;}s:14:"152.42.169.114";a:2:{i:4;i:1763604883;i:5;i:1763604884;}s:14:"34.223.110.198";a:1:{i:0;i:1764052098;}s:13:"44.243.79.141";a:1:{i:0;i:1764144027;}s:14:"195.24.236.120";a:1:{i:0;i:1764266341;}s:13:"44.234.85.203";a:1:{i:0;i:1764312669;}s:14:"34.138.127.158";a:1:{i:0;i:1764616385;}s:12:"94.102.55.18";a:1:{i:1;i:1764805293;}s:13:"66.249.71.171";a:1:{i:1;i:1764875581;}s:13:"66.249.66.166";a:1:{i:0;i:1764871806;}s:12:"66.249.66.12";a:1:{i:0;i:1764871901;}s:13:"66.249.71.172";a:1:{i:1;i:1764874644;}s:12:"66.249.66.11";a:1:{i:0;i:1764872306;}s:12:"66.249.66.35";a:1:{i:0;i:1764876026;}s:12:"66.249.66.37";a:1:{i:0;i:1765049015;}s:12:"20.17.96.236";a:4:{i:40;i:1765368145;i:41;i:1765368147;i:42;i:1765368148;i:43;i:1765368149;}s:13:"64.233.173.32";a:1:{i:0;i:1765431608;}s:12:"40.77.167.14";a:1:{i:0;i:1765651792;}s:14:"52.167.144.205";a:1:{i:0;i:1765824913;}s:15:"129.212.229.115";a:3:{i:13;i:1765829383;i:14;i:1765829385;i:15;i:1765829387;}s:13:"44.251.182.89";a:1:{i:0;i:1765896291;}s:14:"52.167.144.142";a:1:{i:0;i:1765911334;}s:12:"35.80.38.201";a:1:{i:0;i:1765987607;}s:12:"13.57.29.224";a:7:{i:0;i:1766067754;i:1;i:1766067755;i:2;i:1766067755;i:3;i:1766067755;i:4;i:1766067756;i:5;i:1766067756;i:6;i:1766067757;}s:14:"216.26.226.213";a:1:{i:0;i:1766075129;}s:12:"13.57.13.184";a:7:{i:0;i:1766080725;i:1;i:1766080726;i:2;i:1766080726;i:3;i:1766080727;i:4;i:1766080727;i:5;i:1766080728;i:6;i:1766080728;}s:11:"40.77.167.5";a:1:{i:0;i:1766089674;}s:13:"44.250.154.45";a:1:{i:0;i:1766164280;}s:14:"216.126.236.55";a:1:{i:0;i:1766261446;}s:11:"66.102.6.39";a:1:{i:0;i:1766513639;}s:12:"40.77.167.54";a:1:{i:0;i:1766688806;}s:12:"40.77.167.48";a:1:{i:0;i:1766692523;}s:15:"104.252.191.126";a:6:{i:0;i:1766770341;i:1;i:1766770341;i:2;i:1766770341;i:3;i:1766770341;i:4;i:1766770342;i:5;i:1766770343;}s:14:"198.235.24.159";a:1:{i:0;i:1766794755;}s:13:"198.235.24.38";a:1:{i:0;i:1766794790;}s:14:"198.235.24.161";a:1:{i:0;i:1766795732;}s:13:"205.210.31.33";a:1:{i:0;i:1766796593;}}','off');
INSERT INTO `wpnc_options` VALUES (356,'rsssl_vulnerability_mail_sent_for','a:7:{i:0;s:36:"f1cee7d5-7dfc-4feb-ac7c-fd83a23c0dcd";i:1;s:36:"7f24db21-576f-4ff0-b1c6-1aa1b0a1b6ec";i:2;s:36:"55b8c7f7-6e31-43d5-85aa-bc13ad932090";i:3;s:36:"efae3451-e8ad-4d88-804b-d2fb1f56d25d";i:4;s:36:"f6d8e0cd-0a9e-42c0-80c9-ed01e034e4ed";i:5;s:36:"4bd043ad-bb4c-40c0-919d-45fd05240cae";i:6;s:36:"04505f67-a9ec-47b6-a1a4-f791de3932b9";}','off');
INSERT INTO `wpnc_options` VALUES (357,'rsssl_l_notification_dismissed_for','a:0:{}','off');
INSERT INTO `wpnc_options` VALUES (358,'rsssl_m_notification_dismissed_for','a:3:{i:0;s:36:"f1cee7d5-7dfc-4feb-ac7c-fd83a23c0dcd";i:1;s:36:"7f24db21-576f-4ff0-b1c6-1aa1b0a1b6ec";i:2;s:36:"55b8c7f7-6e31-43d5-85aa-bc13ad932090";}','off');
INSERT INTO `wpnc_options` VALUES (359,'rsssl_h_notification_dismissed_for','a:0:{}','off');
INSERT INTO `wpnc_options` VALUES (360,'rsssl_c_notification_dismissed_for','a:1:{i:0;s:36:"04505f67-a9ec-47b6-a1a4-f791de3932b9";}','off');
INSERT INTO `wpnc_options` VALUES (395,'elementor_log','a:6:{s:32:"658e0a96ebc132ad35af6980a4cf3c20";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2025-01-08 22:45:09";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:59:"Cannot read properties of null (reading &#039;config&#039;)";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2025-01-08 22:45:09";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1736376309";s:7:"message";s:49:"Cannot read properties of null (reading \'config\')";s:3:"url";s:135:"https://stellaradvisoryservices.com/wp-content/plugins/elementor/assets/js/packages/editor-documents/editor-documents.min.js?ver=3.26.4";s:4:"line";s:1:"1";s:6:"column";s:4:"2102";}s:7:"\0*\0file";s:135:"https://stellaradvisoryservices.com/wp-content/plugins/elementor/assets/js/packages/editor-documents/editor-documents.min.js?ver=3.26.4";s:7:"\0*\0line";s:1:"1";s:9:"\0*\0column";s:4:"2102";}s:32:"76dafb59756afcb7a4025b291b537515";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2025-01-08 23:07:21";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:64:"Cannot read properties of undefined (reading &#039;length&#039;)";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2025-01-08 23:07:21";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1736377641";s:7:"message";s:54:"Cannot read properties of undefined (reading \'length\')";s:3:"url";s:119:"https://stellaradvisoryservices.com/wp-content/plugins/jeg-elementor-kit/assets/js/tiny-slider/tiny-slider.js?ver=2.9.3";s:4:"line";s:1:"1";s:6:"column";s:4:"7205";}s:7:"\0*\0file";s:119:"https://stellaradvisoryservices.com/wp-content/plugins/jeg-elementor-kit/assets/js/tiny-slider/tiny-slider.js?ver=2.9.3";s:7:"\0*\0line";s:1:"1";s:9:"\0*\0column";s:4:"7205";}s:32:"e08dc8801dea680e1228c8c693f257ee";O:31:"Elementor\\Core\\Logger\\Items\\PHP":9:{s:7:"\0*\0date";s:19:"2025-01-09 07:32:17";s:7:"\0*\0type";s:7:"warning";s:10:"\0*\0message";s:38:"Trying to access array offset on false";s:7:"\0*\0meta";a:1:{s:5:"trace";a:1:{i:0;a:3:{s:8:"function";s:8:"shutdown";s:5:"class";s:29:"Elementor\\Core\\Logger\\Manager";s:4:"type";s:2:"->";}}}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2025-01-09 07:32:17";}s:7:"\0*\0args";a:5:{s:4:"type";s:7:"warning";s:7:"message";s:38:"Trying to access array offset on false";s:4:"file";s:99:"/home/hondaja5/stellaradvisoryservices.com/wp-content/plugins/elementor/includes/managers/image.php";s:4:"line";i:113;s:5:"trace";b:1;}s:7:"\0*\0file";s:99:"/home/hondaja5/stellaradvisoryservices.com/wp-content/plugins/elementor/includes/managers/image.php";s:7:"\0*\0line";i:113;}s:32:"1f3f7f521382974dd61eff7a8148ee9e";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2025-01-09 03:17:39";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:38:"elementorFrontendConfig is not defined";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:7;s:14:"\0*\0times_dates";a:7:{i:0;s:19:"2025-01-09 03:17:39";i:1;s:19:"2025-01-09 03:22:31";i:2;s:19:"2025-01-09 03:25:44";i:3;s:19:"2025-01-09 03:26:04";i:4;s:19:"2025-01-09 03:26:35";i:5;s:19:"2025-01-09 03:26:35";i:6;s:19:"2025-01-09 03:29:01";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1736392659";s:7:"message";s:38:"elementorFrontendConfig is not defined";s:3:"url";s:101:"https://stellaradvisoryservices.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.26.4";s:4:"line";s:1:"2";s:6:"column";s:5:"36040";}s:7:"\0*\0file";s:101:"https://stellaradvisoryservices.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.26.4";s:7:"\0*\0line";s:1:"2";s:9:"\0*\0column";s:5:"36040";}s:32:"add341293aaf18712b5a4a4e36376f6d";O:31:"Elementor\\Core\\Logger\\Items\\PHP":9:{s:7:"\0*\0date";s:19:"2025-01-09 10:18:36";s:7:"\0*\0type";s:6:"notice";s:10:"\0*\0message";s:36:"Function utf8_decode() is deprecated";s:7:"\0*\0meta";a:1:{s:5:"trace";a:1:{i:0;a:3:{s:8:"function";s:8:"shutdown";s:5:"class";s:29:"Elementor\\Core\\Logger\\Manager";s:4:"type";s:2:"->";}}}s:8:"\0*\0times";i:2;s:14:"\0*\0times_dates";a:2:{i:0;s:19:"2025-01-09 10:18:36";i:1;s:19:"2025-01-24 09:33:29";}s:7:"\0*\0args";a:5:{s:4:"type";s:6:"notice";s:7:"message";s:36:"Function utf8_decode() is deprecated";s:4:"file";s:106:"/home/hondaja5/stellaradvisoryservices.com/wp-content/plugins/elementor-pro/modules/screenshots/module.php";s:4:"line";i:33;s:5:"trace";b:1;}s:7:"\0*\0file";s:106:"/home/hondaja5/stellaradvisoryservices.com/wp-content/plugins/elementor-pro/modules/screenshots/module.php";s:7:"\0*\0line";i:33;}s:32:"58fb37337126433428b9342b4ff6938d";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2025-01-09 03:29:47";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:63:"Cannot read properties of undefined (reading &#039;value&#039;)";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:2;s:14:"\0*\0times_dates";a:2:{i:0;s:19:"2025-01-09 03:29:47";i:1;s:19:"2025-01-09 03:37:09";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1736393387";s:7:"message";s:53:"Cannot read properties of undefined (reading \'value\')";s:3:"url";s:145:"https://stellaradvisoryservices.com/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.7.1";s:4:"line";s:1:"2";s:6:"column";s:5:"28760";}s:7:"\0*\0file";s:145:"https://stellaradvisoryservices.com/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.7.1";s:7:"\0*\0line";s:1:"2";s:9:"\0*\0column";s:5:"28760";}}','off');
INSERT INTO `wpnc_options` VALUES (458,'current_theme','Hello Elementor','auto');
INSERT INTO `wpnc_options` VALUES (459,'theme_mods_hello-elementor','a:3:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:18:"custom_css_post_id";i:-1;}','on');
INSERT INTO `wpnc_options` VALUES (460,'theme_switched','','auto');
INSERT INTO `wpnc_options` VALUES (461,'hello_theme_version','3.3.0','auto');
INSERT INTO `wpnc_options` VALUES (482,'nav_menu_options','a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (501,'elementor_pro_license_key','activated','auto');
INSERT INTO `wpnc_options` VALUES (502,'_elementor_pro_license_v2_data','a:2:{s:7:"timeout";i:1766883432;s:5:"value";s:71:"{"success":true,"license":"valid","expires":"01.01.2030","features":[]}";}','auto');
INSERT INTO `wpnc_options` VALUES (503,'elementor_pro_version','3.26.3','auto');
INSERT INTO `wpnc_options` VALUES (504,'elementor_pro_install_history','a:1:{s:6:"3.26.3";i:1736392523;}','auto');
INSERT INTO `wpnc_options` VALUES (505,'widget_elementor-library','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpnc_options` VALUES (506,'_elementor_pro_installed_time','1736392523','auto');
INSERT INTO `wpnc_options` VALUES (507,'elementor_submissions_db_version','5','auto');
INSERT INTO `wpnc_options` VALUES (508,'elementor_fonts_manager_font_types','a:0:{}','auto');
INSERT INTO `wpnc_options` VALUES (509,'elementor_fonts_manager_fonts','a:0:{}','auto');
INSERT INTO `wpnc_options` VALUES (510,'elementor_custom_icon_sets_config','a:0:{}','auto');
INSERT INTO `wpnc_options` VALUES (513,'elementor_library_category_children','a:0:{}','auto');
INSERT INTO `wpnc_options` VALUES (517,'elementor_pro_theme_builder_conditions','a:2:{s:6:"footer";a:1:{i:338;a:1:{i:0;s:15:"include/general";}}s:6:"header";a:1:{i:327;a:1:{i:0;s:15:"include/general";}}}','auto');
INSERT INTO `wpnc_options` VALUES (532,'_elementor_pro_api_requests_lock','a:1:{s:11:"get_version";i:1766814851;}','auto');
INSERT INTO `wpnc_options` VALUES (536,'wptwa_settings','{"toggle_text":"Chat with us on WhatsApp","toggle_text_color":"rgba(255, 255, 255, 1)","toggle_background_color":"#0DC152","description":"Hi there! Click one of our representatives below and we will get back to you as soon as possible.","mobile_close_button_text":"Close and go back to page","container_text_color":"rgba(85, 85, 85, 1)","container_background_color":"rgba(255, 255, 255, 1)","account_hover_background_color":"rgba(245, 245, 245, 1)","account_hover_text_color":"rgba(85, 85, 85, 1)","border_color_between_accounts":"#f5f5f5","box_position":"right","consent_alert_background_color":"rgba(255, 0, 0, 1)","button_label":"Need help? Chat via WhatsApp","button_background_color":"#0DC152","button_text_color":"#ffffff","button_background_color_on_hover":"#0DC152","button_text_color_on_hover":"#ffffff","button_background_color_offline":"#a0a0a0","button_text_color_offline":"#ffffff","hide_on_large_screen":"off","hide_on_small_screen":"off","delay_time":"0","inactivity_time":"0","scroll_length":"0","total_accounts_shown":"0","selected_accounts_for_widget":"[349]"}','on');
INSERT INTO `wpnc_options` VALUES (553,'_transient_health-check-site-status-result','{"good":21,"recommended":6,"critical":0}','on');
INSERT INTO `wpnc_options` VALUES (668,'category_children','a:0:{}','auto');
INSERT INTO `wpnc_options` VALUES (1090,'elementor_unfiltered_files_upload','1','auto');
INSERT INTO `wpnc_options` VALUES (1111,'litespeed.conf.__activation','-1','auto');
INSERT INTO `wpnc_options` VALUES (1112,'litespeed.purge.queue','-1','auto');
INSERT INTO `wpnc_options` VALUES (1113,'litespeed.purge.queue2','-1','auto');
INSERT INTO `wpnc_options` VALUES (1115,'litespeed.cloud._summary','{"curr_request.ver_check":0,"last_request.ver_check":1766814880,"news.utime":1766814742,"curr_request.news":0,"last_request.news":1766814742,"token_ts":1736840864,"ips_ts":1738565329,"ips_ts_runner":1738565329,"ips":["102.221.36.98","103.106.229.82","103.106.229.94","103.146.63.42","103.152.118.219","103.152.118.72","103.164.203.163","103.188.22.12","103.28.90.190","103.75.117.169","104.225.142.116","104.244.77.37","108.61.158.223","108.61.200.94","109.248.43.195","135.148.120.32","136.243.106.228","139.84.230.39","141.164.38.65","145.239.252.65","146.88.239.197","147.78.0.165","147.78.3.13","147.78.3.161","149.28.136.245","149.28.47.113","149.28.85.239","152.228.171.66","152.53.36.14","152.53.38.14","155.138.221.81","156.67.218.140","157.90.154.114","158.51.123.249","162.254.117.80","162.254.118.29","163.182.174.161","163.47.21.168","164.52.202.100","167.71.185.204","167.88.61.211","170.249.218.98","178.17.171.177","178.22.124.247","178.22.124.251","178.255.220.12","18.192.146.200","185.116.60.231","185.116.60.232","185.126.237.51","185.212.169.91","185.228.26.40","185.53.57.40","185.53.57.89","188.172.228.182","188.172.229.113","188.64.184.71","190.92.176.5","191.96.101.140","192.248.156.201","192.248.191.135","192.99.38.117","193.203.191.189","194.163.134.104","194.36.144.221","195.231.17.141","198.38.89.73","199.247.28.91","199.59.247.242","201.182.97.70","202.61.226.253","204.10.163.237","209.124.84.191","209.208.26.218","211.23.143.87","213.159.1.75","213.183.48.170","213.184.85.245","216.238.104.48","216.238.71.13","23.95.73.167","27.131.75.41","31.131.4.244","31.22.115.186","31.40.212.152","34.247.229.180","34.249.110.197","38.101.149.196","38.114.121.40","38.54.30.228","38.54.42.235","38.54.79.187","38.60.253.237","41.185.29.210","41.223.52.170","45.124.65.86","45.132.244.92","45.248.77.61","45.32.123.201","45.32.183.112","45.32.210.159","45.32.67.144","45.32.77.223","45.63.67.181","45.76.247.71","45.76.252.131","45.77.148.74","45.77.165.216","45.77.51.171","46.250.220.133","49.12.102.29","5.134.119.103","5.134.119.194","5.188.183.13","5.189.146.228","51.81.186.219","51.81.33.156","54.246.224.74","54.36.103.97","61.219.247.87","61.219.247.90","64.176.163.166","64.176.4.251","64.227.16.93","64.31.63.160","65.108.104.232","65.20.76.133","65.21.81.50","65.21.81.51","66.42.124.101","66.42.75.121","67.219.99.102","69.50.95.216","70.34.205.229","79.172.239.249","81.31.156.245","81.31.156.246","86.105.14.231","86.105.14.232","89.147.110.130","89.58.38.4","91.148.135.53","91.201.67.57","91.228.7.67","92.118.205.75","94.75.232.90","95.179.145.87","95.179.245.162","95.216.116.209"],"is_linked":0,"apikey_ts":1736840905,"main_domain":"stellaradvisoryservices.com","pk_b64":"9vkaPBp7l+YirYGeT5lJFK+EgYjFH5CNDN+CLGI6RKA=","sk_b64":"SRVjVLw6JYEBEOMbW+lHyoIHIEEWNEecguzffNxuEBr2+Ro8GnuX5iKtgZ5PmUkUr4SBiMUfkI0M34IsYjpEoA==","curr_request.d\\/v3upgrade":0,"last_request.d\\/v3upgrade":1766814880,"qc_activated":"anonymous"}','auto');
INSERT INTO `wpnc_options` VALUES (1117,'litespeed.conf.hash','zLS1qBvm2chWXMF2ZTZOl2j7XcSVHuHz','auto');
INSERT INTO `wpnc_options` VALUES (1118,'litespeed.conf.auto_upgrade','','auto');
INSERT INTO `wpnc_options` VALUES (1119,'litespeed.conf.api_key','F5DB8D8BCBB3AFC9B6046AE487C76945','auto');
INSERT INTO `wpnc_options` VALUES (1120,'litespeed.conf.server_ip','','auto');
INSERT INTO `wpnc_options` VALUES (1121,'litespeed.conf.guest','','auto');
INSERT INTO `wpnc_options` VALUES (1122,'litespeed.conf.guest_optm','','auto');
INSERT INTO `wpnc_options` VALUES (1123,'litespeed.conf.news','1','auto');
INSERT INTO `wpnc_options` VALUES (1124,'litespeed.conf.guest_uas','["Lighthouse","GTmetrix","Google","Pingdom","bot","spider","PTST","HeadlessChrome"]','auto');
INSERT INTO `wpnc_options` VALUES (1125,'litespeed.conf.guest_ips','["208.70.247.157","172.255.48.130","172.255.48.131","172.255.48.132","172.255.48.133","172.255.48.134","172.255.48.135","172.255.48.136","172.255.48.137","172.255.48.138","172.255.48.139","172.255.48.140","172.255.48.141","172.255.48.142","172.255.48.143","172.255.48.144","172.255.48.145","172.255.48.146","172.255.48.147","52.229.122.240","104.214.72.101","13.66.7.11","13.85.24.83","13.85.24.90","13.85.82.26","40.74.242.253","40.74.243.13","40.74.243.176","104.214.48.247","157.55.189.189","104.214.110.135","70.37.83.240","65.52.36.250","13.78.216.56","52.162.212.163","23.96.34.105","65.52.113.236","172.255.61.34","172.255.61.35","172.255.61.36","172.255.61.37","172.255.61.38","172.255.61.39","172.255.61.40","104.41.2.19","191.235.98.164","191.235.99.221","191.232.194.51","52.237.235.185","52.237.250.73","52.237.236.145","104.211.143.8","104.211.165.53","52.172.14.87","40.83.89.214","52.175.57.81","20.188.63.151","20.52.36.49","52.246.165.153","51.144.102.233","13.76.97.224","102.133.169.66","52.231.199.170","13.53.162.7","40.123.218.94"]','auto');
INSERT INTO `wpnc_options` VALUES (1126,'litespeed.conf.cache','1','auto');
INSERT INTO `wpnc_options` VALUES (1127,'litespeed.conf.cache-priv','1','auto');
INSERT INTO `wpnc_options` VALUES (1128,'litespeed.conf.cache-commenter','1','auto');
INSERT INTO `wpnc_options` VALUES (1129,'litespeed.conf.cache-rest','1','auto');
INSERT INTO `wpnc_options` VALUES (1130,'litespeed.conf.cache-page_login','1','auto');
INSERT INTO `wpnc_options` VALUES (1131,'litespeed.conf.cache-resources','1','auto');
INSERT INTO `wpnc_options` VALUES (1132,'litespeed.conf.cache-mobile','','auto');
INSERT INTO `wpnc_options` VALUES (1133,'litespeed.conf.cache-mobile_rules','["Mobile","Android","Silk\\/","Kindle","BlackBerry","Opera Mini","Opera Mobi"]','auto');
INSERT INTO `wpnc_options` VALUES (1134,'litespeed.conf.cache-browser','','auto');
INSERT INTO `wpnc_options` VALUES (1135,'litespeed.conf.cache-exc_useragents','[]','auto');
INSERT INTO `wpnc_options` VALUES (1136,'litespeed.conf.cache-exc_cookies','[]','auto');
INSERT INTO `wpnc_options` VALUES (1137,'litespeed.conf.cache-exc_qs','[]','auto');
INSERT INTO `wpnc_options` VALUES (1138,'litespeed.conf.cache-exc_cat','[]','auto');
INSERT INTO `wpnc_options` VALUES (1139,'litespeed.conf.cache-exc_tag','[]','auto');
INSERT INTO `wpnc_options` VALUES (1140,'litespeed.conf.cache-force_uri','[]','auto');
INSERT INTO `wpnc_options` VALUES (1141,'litespeed.conf.cache-force_pub_uri','[]','auto');
INSERT INTO `wpnc_options` VALUES (1142,'litespeed.conf.cache-priv_uri','[]','auto');
INSERT INTO `wpnc_options` VALUES (1143,'litespeed.conf.cache-exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1144,'litespeed.conf.cache-exc_roles','[]','auto');
INSERT INTO `wpnc_options` VALUES (1145,'litespeed.conf.cache-drop_qs','["fbclid","gclid","utm*","_ga"]','auto');
INSERT INTO `wpnc_options` VALUES (1146,'litespeed.conf.cache-ttl_pub','604800','auto');
INSERT INTO `wpnc_options` VALUES (1147,'litespeed.conf.cache-ttl_priv','1800','auto');
INSERT INTO `wpnc_options` VALUES (1148,'litespeed.conf.cache-ttl_frontpage','604800','auto');
INSERT INTO `wpnc_options` VALUES (1149,'litespeed.conf.cache-ttl_feed','604800','auto');
INSERT INTO `wpnc_options` VALUES (1150,'litespeed.conf.cache-ttl_rest','604800','auto');
INSERT INTO `wpnc_options` VALUES (1151,'litespeed.conf.cache-ttl_browser','31557600','auto');
INSERT INTO `wpnc_options` VALUES (1152,'litespeed.conf.cache-ttl_status','["404 3600","500 600"]','auto');
INSERT INTO `wpnc_options` VALUES (1153,'litespeed.conf.cache-login_cookie','','auto');
INSERT INTO `wpnc_options` VALUES (1154,'litespeed.conf.cache-ajax_ttl','[]','auto');
INSERT INTO `wpnc_options` VALUES (1155,'litespeed.conf.cache-vary_cookies','[]','auto');
INSERT INTO `wpnc_options` VALUES (1156,'litespeed.conf.cache-vary_group','[]','auto');
INSERT INTO `wpnc_options` VALUES (1157,'litespeed.conf.purge-upgrade','1','auto');
INSERT INTO `wpnc_options` VALUES (1158,'litespeed.conf.purge-stale','','auto');
INSERT INTO `wpnc_options` VALUES (1159,'litespeed.conf.purge-post_all','','auto');
INSERT INTO `wpnc_options` VALUES (1160,'litespeed.conf.purge-post_f','1','auto');
INSERT INTO `wpnc_options` VALUES (1161,'litespeed.conf.purge-post_h','1','auto');
INSERT INTO `wpnc_options` VALUES (1162,'litespeed.conf.purge-post_p','1','auto');
INSERT INTO `wpnc_options` VALUES (1163,'litespeed.conf.purge-post_pwrp','1','auto');
INSERT INTO `wpnc_options` VALUES (1164,'litespeed.conf.purge-post_a','1','auto');
INSERT INTO `wpnc_options` VALUES (1165,'litespeed.conf.purge-post_y','','auto');
INSERT INTO `wpnc_options` VALUES (1166,'litespeed.conf.purge-post_m','1','auto');
INSERT INTO `wpnc_options` VALUES (1167,'litespeed.conf.purge-post_d','','auto');
INSERT INTO `wpnc_options` VALUES (1168,'litespeed.conf.purge-post_t','1','auto');
INSERT INTO `wpnc_options` VALUES (1169,'litespeed.conf.purge-post_pt','1','auto');
INSERT INTO `wpnc_options` VALUES (1170,'litespeed.conf.purge-timed_urls','[]','auto');
INSERT INTO `wpnc_options` VALUES (1171,'litespeed.conf.purge-timed_urls_time','','auto');
INSERT INTO `wpnc_options` VALUES (1172,'litespeed.conf.purge-hook_all','["switch_theme","wp_create_nav_menu","wp_update_nav_menu","wp_delete_nav_menu","create_term","edit_terms","delete_term","add_link","edit_link","delete_link"]','auto');
INSERT INTO `wpnc_options` VALUES (1173,'litespeed.conf.esi','','auto');
INSERT INTO `wpnc_options` VALUES (1174,'litespeed.conf.esi-cache_admbar','1','auto');
INSERT INTO `wpnc_options` VALUES (1175,'litespeed.conf.esi-cache_commform','1','auto');
INSERT INTO `wpnc_options` VALUES (1176,'litespeed.conf.esi-nonce','["stats_nonce","subscribe_nonce"]','auto');
INSERT INTO `wpnc_options` VALUES (1177,'litespeed.conf.util-instant_click','','auto');
INSERT INTO `wpnc_options` VALUES (1178,'litespeed.conf.util-no_https_vary','','auto');
INSERT INTO `wpnc_options` VALUES (1179,'litespeed.conf.debug-disable_all','','auto');
INSERT INTO `wpnc_options` VALUES (1180,'litespeed.conf.debug','','auto');
INSERT INTO `wpnc_options` VALUES (1181,'litespeed.conf.debug-ips','["127.0.0.1"]','auto');
INSERT INTO `wpnc_options` VALUES (1182,'litespeed.conf.debug-level','','auto');
INSERT INTO `wpnc_options` VALUES (1183,'litespeed.conf.debug-filesize','3','auto');
INSERT INTO `wpnc_options` VALUES (1184,'litespeed.conf.debug-collapse_qs','','auto');
INSERT INTO `wpnc_options` VALUES (1185,'litespeed.conf.debug-inc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1186,'litespeed.conf.debug-exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1187,'litespeed.conf.debug-exc_strings','[]','auto');
INSERT INTO `wpnc_options` VALUES (1188,'litespeed.conf.db_optm-revisions_max','0','auto');
INSERT INTO `wpnc_options` VALUES (1189,'litespeed.conf.db_optm-revisions_age','0','auto');
INSERT INTO `wpnc_options` VALUES (1190,'litespeed.conf.optm-css_min','','auto');
INSERT INTO `wpnc_options` VALUES (1191,'litespeed.conf.optm-css_comb','','auto');
INSERT INTO `wpnc_options` VALUES (1192,'litespeed.conf.optm-css_comb_ext_inl','1','auto');
INSERT INTO `wpnc_options` VALUES (1193,'litespeed.conf.optm-ucss','','auto');
INSERT INTO `wpnc_options` VALUES (1194,'litespeed.conf.optm-ucss_inline','','auto');
INSERT INTO `wpnc_options` VALUES (1195,'litespeed.conf.optm-ucss_whitelist','[]','auto');
INSERT INTO `wpnc_options` VALUES (1196,'litespeed.conf.optm-ucss_file_exc_inline','[]','auto');
INSERT INTO `wpnc_options` VALUES (1197,'litespeed.conf.optm-ucss_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1198,'litespeed.conf.optm-css_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1199,'litespeed.conf.optm-js_min','','auto');
INSERT INTO `wpnc_options` VALUES (1200,'litespeed.conf.optm-js_comb','','auto');
INSERT INTO `wpnc_options` VALUES (1201,'litespeed.conf.optm-js_comb_ext_inl','1','auto');
INSERT INTO `wpnc_options` VALUES (1202,'litespeed.conf.optm-js_delay_inc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1203,'litespeed.conf.optm-js_exc','["jquery.js","jquery.min.js"]','auto');
INSERT INTO `wpnc_options` VALUES (1204,'litespeed.conf.optm-html_min','','auto');
INSERT INTO `wpnc_options` VALUES (1205,'litespeed.conf.optm-html_lazy','[]','auto');
INSERT INTO `wpnc_options` VALUES (1206,'litespeed.conf.optm-html_skip_comment','[]','auto');
INSERT INTO `wpnc_options` VALUES (1207,'litespeed.conf.optm-qs_rm','','auto');
INSERT INTO `wpnc_options` VALUES (1208,'litespeed.conf.optm-ggfonts_rm','','auto');
INSERT INTO `wpnc_options` VALUES (1209,'litespeed.conf.optm-css_async','','auto');
INSERT INTO `wpnc_options` VALUES (1210,'litespeed.conf.optm-ccss_per_url','','auto');
INSERT INTO `wpnc_options` VALUES (1211,'litespeed.conf.optm-ccss_sep_posttype','["page"]','auto');
INSERT INTO `wpnc_options` VALUES (1212,'litespeed.conf.optm-ccss_sep_uri','[]','auto');
INSERT INTO `wpnc_options` VALUES (1213,'litespeed.conf.optm-css_async_inline','1','auto');
INSERT INTO `wpnc_options` VALUES (1214,'litespeed.conf.optm-css_font_display','','auto');
INSERT INTO `wpnc_options` VALUES (1215,'litespeed.conf.optm-js_defer','','auto');
INSERT INTO `wpnc_options` VALUES (1216,'litespeed.conf.optm-emoji_rm','','auto');
INSERT INTO `wpnc_options` VALUES (1217,'litespeed.conf.optm-noscript_rm','','auto');
INSERT INTO `wpnc_options` VALUES (1218,'litespeed.conf.optm-ggfonts_async','','auto');
INSERT INTO `wpnc_options` VALUES (1219,'litespeed.conf.optm-exc_roles','[]','auto');
INSERT INTO `wpnc_options` VALUES (1220,'litespeed.conf.optm-ccss_con','','auto');
INSERT INTO `wpnc_options` VALUES (1221,'litespeed.conf.optm-js_defer_exc','["jquery.js","jquery.min.js","gtm.js","analytics.js"]','auto');
INSERT INTO `wpnc_options` VALUES (1222,'litespeed.conf.optm-gm_js_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1223,'litespeed.conf.optm-dns_prefetch','[]','auto');
INSERT INTO `wpnc_options` VALUES (1224,'litespeed.conf.optm-dns_prefetch_ctrl','','auto');
INSERT INTO `wpnc_options` VALUES (1225,'litespeed.conf.optm-dns_preconnect','[]','auto');
INSERT INTO `wpnc_options` VALUES (1226,'litespeed.conf.optm-exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1227,'litespeed.conf.optm-guest_only','1','auto');
INSERT INTO `wpnc_options` VALUES (1228,'litespeed.conf.object','','auto');
INSERT INTO `wpnc_options` VALUES (1229,'litespeed.conf.object-kind','','auto');
INSERT INTO `wpnc_options` VALUES (1230,'litespeed.conf.object-host','localhost','auto');
INSERT INTO `wpnc_options` VALUES (1231,'litespeed.conf.object-port','11211','auto');
INSERT INTO `wpnc_options` VALUES (1232,'litespeed.conf.object-life','360','auto');
INSERT INTO `wpnc_options` VALUES (1233,'litespeed.conf.object-persistent','1','auto');
INSERT INTO `wpnc_options` VALUES (1234,'litespeed.conf.object-admin','1','auto');
INSERT INTO `wpnc_options` VALUES (1235,'litespeed.conf.object-transients','1','auto');
INSERT INTO `wpnc_options` VALUES (1236,'litespeed.conf.object-db_id','0','auto');
INSERT INTO `wpnc_options` VALUES (1237,'litespeed.conf.object-user','','auto');
INSERT INTO `wpnc_options` VALUES (1238,'litespeed.conf.object-pswd','','auto');
INSERT INTO `wpnc_options` VALUES (1239,'litespeed.conf.object-global_groups','["users","userlogins","useremail","userslugs","usermeta","user_meta","site-transient","site-options","site-lookup","site-details","blog-lookup","blog-details","blog-id-cache","rss","global-posts","global-cache-test"]','auto');
INSERT INTO `wpnc_options` VALUES (1240,'litespeed.conf.object-non_persistent_groups','["comment","counts","plugins","wc_session_id"]','auto');
INSERT INTO `wpnc_options` VALUES (1241,'litespeed.conf.discuss-avatar_cache','','auto');
INSERT INTO `wpnc_options` VALUES (1242,'litespeed.conf.discuss-avatar_cron','','auto');
INSERT INTO `wpnc_options` VALUES (1243,'litespeed.conf.discuss-avatar_cache_ttl','604800','auto');
INSERT INTO `wpnc_options` VALUES (1244,'litespeed.conf.optm-localize','','auto');
INSERT INTO `wpnc_options` VALUES (1245,'litespeed.conf.optm-localize_domains','["### Popular scripts ###","https:\\/\\/platform.twitter.com\\/widgets.js","https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js"]','auto');
INSERT INTO `wpnc_options` VALUES (1246,'litespeed.conf.media-lazy','','auto');
INSERT INTO `wpnc_options` VALUES (1247,'litespeed.conf.media-lazy_placeholder','','auto');
INSERT INTO `wpnc_options` VALUES (1248,'litespeed.conf.media-placeholder_resp','','auto');
INSERT INTO `wpnc_options` VALUES (1249,'litespeed.conf.media-placeholder_resp_color','#cfd4db','auto');
INSERT INTO `wpnc_options` VALUES (1250,'litespeed.conf.media-placeholder_resp_svg','<svg xmlns="http://www.w3.org/2000/svg" width="{width}" height="{height}" viewBox="0 0 {width} {height}"><rect width="100%" height="100%" style="fill:{color};fill-opacity: 0.1;"/></svg>','auto');
INSERT INTO `wpnc_options` VALUES (1251,'litespeed.conf.media-lqip','','auto');
INSERT INTO `wpnc_options` VALUES (1252,'litespeed.conf.media-lqip_qual','4','auto');
INSERT INTO `wpnc_options` VALUES (1253,'litespeed.conf.media-lqip_min_w','150','auto');
INSERT INTO `wpnc_options` VALUES (1254,'litespeed.conf.media-lqip_min_h','150','auto');
INSERT INTO `wpnc_options` VALUES (1255,'litespeed.conf.media-placeholder_resp_async','1','auto');
INSERT INTO `wpnc_options` VALUES (1256,'litespeed.conf.media-iframe_lazy','','auto');
INSERT INTO `wpnc_options` VALUES (1257,'litespeed.conf.media-add_missing_sizes','','auto');
INSERT INTO `wpnc_options` VALUES (1258,'litespeed.conf.media-lazy_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1259,'litespeed.conf.media-lazy_cls_exc','["wmu-preview-img"]','auto');
INSERT INTO `wpnc_options` VALUES (1260,'litespeed.conf.media-lazy_parent_cls_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1261,'litespeed.conf.media-iframe_lazy_cls_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1262,'litespeed.conf.media-iframe_lazy_parent_cls_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1263,'litespeed.conf.media-lazy_uri_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1264,'litespeed.conf.media-lqip_exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1265,'litespeed.conf.media-vpi','','auto');
INSERT INTO `wpnc_options` VALUES (1266,'litespeed.conf.media-vpi_cron','','auto');
INSERT INTO `wpnc_options` VALUES (1267,'litespeed.conf.img_optm-auto','','auto');
INSERT INTO `wpnc_options` VALUES (1268,'litespeed.conf.img_optm-cron','1','auto');
INSERT INTO `wpnc_options` VALUES (1269,'litespeed.conf.img_optm-ori','1','auto');
INSERT INTO `wpnc_options` VALUES (1270,'litespeed.conf.img_optm-rm_bkup','','auto');
INSERT INTO `wpnc_options` VALUES (1271,'litespeed.conf.img_optm-webp','','auto');
INSERT INTO `wpnc_options` VALUES (1272,'litespeed.conf.img_optm-lossless','','auto');
INSERT INTO `wpnc_options` VALUES (1273,'litespeed.conf.img_optm-exif','1','auto');
INSERT INTO `wpnc_options` VALUES (1274,'litespeed.conf.img_optm-webp_attr','["img.src","div.data-thumb","img.data-src","img.data-lazyload","div.data-large_image","img.retina_logo_url","div.data-parallax-image","div.data-vc-parallax-image","video.poster"]','auto');
INSERT INTO `wpnc_options` VALUES (1275,'litespeed.conf.img_optm-webp_replace_srcset','','auto');
INSERT INTO `wpnc_options` VALUES (1276,'litespeed.conf.img_optm-jpg_quality','82','auto');
INSERT INTO `wpnc_options` VALUES (1277,'litespeed.conf.crawler','','auto');
INSERT INTO `wpnc_options` VALUES (1278,'litespeed.conf.crawler-usleep','500','auto');
INSERT INTO `wpnc_options` VALUES (1279,'litespeed.conf.crawler-run_duration','400','auto');
INSERT INTO `wpnc_options` VALUES (1280,'litespeed.conf.crawler-run_interval','600','auto');
INSERT INTO `wpnc_options` VALUES (1281,'litespeed.conf.crawler-crawl_interval','302400','auto');
INSERT INTO `wpnc_options` VALUES (1282,'litespeed.conf.crawler-threads','3','auto');
INSERT INTO `wpnc_options` VALUES (1283,'litespeed.conf.crawler-timeout','30','auto');
INSERT INTO `wpnc_options` VALUES (1284,'litespeed.conf.crawler-load_limit','1','auto');
INSERT INTO `wpnc_options` VALUES (1285,'litespeed.conf.crawler-sitemap','','auto');
INSERT INTO `wpnc_options` VALUES (1286,'litespeed.conf.crawler-drop_domain','1','auto');
INSERT INTO `wpnc_options` VALUES (1287,'litespeed.conf.crawler-map_timeout','120','auto');
INSERT INTO `wpnc_options` VALUES (1288,'litespeed.conf.crawler-roles','[]','auto');
INSERT INTO `wpnc_options` VALUES (1289,'litespeed.conf.crawler-cookies','[]','auto');
INSERT INTO `wpnc_options` VALUES (1290,'litespeed.conf.misc-heartbeat_front','','auto');
INSERT INTO `wpnc_options` VALUES (1291,'litespeed.conf.misc-heartbeat_front_ttl','60','auto');
INSERT INTO `wpnc_options` VALUES (1292,'litespeed.conf.misc-heartbeat_back','','auto');
INSERT INTO `wpnc_options` VALUES (1293,'litespeed.conf.misc-heartbeat_back_ttl','60','auto');
INSERT INTO `wpnc_options` VALUES (1294,'litespeed.conf.misc-heartbeat_editor','','auto');
INSERT INTO `wpnc_options` VALUES (1295,'litespeed.conf.misc-heartbeat_editor_ttl','15','auto');
INSERT INTO `wpnc_options` VALUES (1296,'litespeed.conf.cdn','','auto');
INSERT INTO `wpnc_options` VALUES (1297,'litespeed.conf.cdn-ori','[]','auto');
INSERT INTO `wpnc_options` VALUES (1298,'litespeed.conf.cdn-ori_dir','["wp-content","wp-includes"]','auto');
INSERT INTO `wpnc_options` VALUES (1299,'litespeed.conf.cdn-exc','[]','auto');
INSERT INTO `wpnc_options` VALUES (1300,'litespeed.conf.cdn-quic','','auto');
INSERT INTO `wpnc_options` VALUES (1301,'litespeed.conf.cdn-cloudflare','','auto');
INSERT INTO `wpnc_options` VALUES (1302,'litespeed.conf.cdn-cloudflare_email','','auto');
INSERT INTO `wpnc_options` VALUES (1303,'litespeed.conf.cdn-cloudflare_key','','auto');
INSERT INTO `wpnc_options` VALUES (1304,'litespeed.conf.cdn-cloudflare_name','','auto');
INSERT INTO `wpnc_options` VALUES (1305,'litespeed.conf.cdn-cloudflare_zone','','auto');
INSERT INTO `wpnc_options` VALUES (1306,'litespeed.conf.cdn-mapping','[{"url":"","inc_img":"1","inc_css":"1","inc_js":"1","filetype":[".aac",".css",".eot",".gif",".jpeg",".jpg",".js",".less",".mp3",".mp4",".ogg",".otf",".pdf",".png",".svg",".ttf",".webp",".woff",".woff2"]}]','auto');
INSERT INTO `wpnc_options` VALUES (1307,'litespeed.conf.cdn-attr','[".src",".data-src",".href",".poster","source.srcset"]','auto');
INSERT INTO `wpnc_options` VALUES (1308,'litespeed.conf.qc-token','','auto');
INSERT INTO `wpnc_options` VALUES (1309,'litespeed.conf.qc-nameservers','','auto');
INSERT INTO `wpnc_options` VALUES (1312,'litespeed.gui.lscwp_whm_install','-1','auto');
INSERT INTO `wpnc_options` VALUES (1313,'litespeed.gui.dismiss','-1','auto');
INSERT INTO `wpnc_options` VALUES (1314,'litespeed.gui._summary','{"new_version":1737445558,"score":1738050358,"new_version.last_check":1766814729,"new_version.v":"7.7"}','auto');
INSERT INTO `wpnc_options` VALUES (1315,'litespeed.data.upgrading','-1','auto');
INSERT INTO `wpnc_options` VALUES (1316,'litespeed.admin_display.messages','["<div class=\\"litespeed_icon notice notice-success is-dismissible\\"><p>Purged all caches successfully.<\\/p><\\/div>"]','auto');
INSERT INTO `wpnc_options` VALUES (2985,'litespeed.optimize.timestamp_purge_css','1766814882','auto');
INSERT INTO `wpnc_options` VALUES (2992,'_hello-elementor_notifications','a:2:{s:7:"timeout";i:1766852872;s:5:"value";s:7987:"[{"id":"hello-theme-3.4.5","title":"3.4.5 - 2025-10-27","description":"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.4.4","title":"3.4.4 - 2025-06-08","description":"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.4.3","title":"3.4.3 - 2025-05-26","description":"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.4.2","title":"3.4.2 - 2025-05-19","description":"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.4.0","title":"3.4.0 - 2025-05-05","description":"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.3.0","title":"3.3.0 - 2025-01-21","description":"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.2.1","title":"3.2.1 - 2024-12-16","description":"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\" target=\\"_blank\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.2.0","title":"3.2.0 - 2024-12-15","description":"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\" target=\\"_blank\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.1.1","title":"3.1.1 - 2024-07-30","description":"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.1.0","title":"3.1.0 - 2024-06-19","description":"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\" target=\\"_blank\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\" target=\\"_blank\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\" target=\\"_blank\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\" target=\\"_blank\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.0.2","title":"3.0.2 - 2024-05-28","description":"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.0.1","title":"3.0.1 - 2024-01-24","description":"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>"},{"id":"hello-theme-3.0.0","title":"3.0.0 - 2023-12-26","description":"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>"}]";}','off');
INSERT INTO `wpnc_options` VALUES (3605,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:25:"venture.publish@gmail.com";s:7:"version";s:3:"6.9";s:9:"timestamp";i:1764805309;}','off');
INSERT INTO `wpnc_options` VALUES (15870,'db_upgraded','','on');
INSERT INTO `wpnc_options` VALUES (22800,'wp_notes_notify','1','on');
INSERT INTO `wpnc_options` VALUES (22801,'_site_transient_update_core','O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:57:"https://downloads.wordpress.org/release/wordpress-6.9.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:57:"https://downloads.wordpress.org/release/wordpress-6.9.zip";s:10:"no_content";s:68:"https://downloads.wordpress.org/release/wordpress-6.9-no-content.zip";s:11:"new_bundled";s:69:"https://downloads.wordpress.org/release/wordpress-6.9-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:3:"6.9";s:7:"version";s:3:"6.9";s:11:"php_version";s:6:"7.2.24";s:13:"mysql_version";s:5:"5.5.5";s:11:"new_bundled";s:3:"6.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1766814851;s:15:"version_checked";s:3:"6.9";s:12:"translations";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (23911,'_site_transient_timeout_php_check_9ab7d1d0aab5d0d9977e61657de2d018','1767273440','off');
INSERT INTO `wpnc_options` VALUES (23912,'_site_transient_php_check_9ab7d1d0aab5d0d9977e61657de2d018','a:5:{s:19:"recommended_version";s:3:"8.3";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}','off');
INSERT INTO `wpnc_options` VALUES (23913,'_transient_timeout_rsssl_can_use_curl_headers_check','1766815049','off');
INSERT INTO `wpnc_options` VALUES (23914,'_transient_rsssl_can_use_curl_headers_check','a:6:{i:0;s:25:"Upgrade Insecure Requests";i:1;s:16:"X-XSS protection";i:2;s:22:"X-Content Type Options";i:3;s:15:"Referrer-Policy";i:4;s:18:"Permissions-Policy";i:5;s:30:"HTTP Strict Transport Security";}','off');
INSERT INTO `wpnc_options` VALUES (24069,'_site_transient_update_themes','O:8:"stdClass":5:{s:12:"last_checked";i:1766814872;s:7:"checked";a:4:{s:15:"hello-elementor";s:5:"3.3.0";s:16:"twentytwentyfive";s:3:"1.0";s:16:"twentytwentyfour";s:3:"1.3";s:17:"twentytwentythree";s:3:"1.6";}s:8:"response";a:3:{s:15:"hello-elementor";a:6:{s:5:"theme";s:15:"hello-elementor";s:11:"new_version";s:5:"3.4.5";s:3:"url";s:45:"https://wordpress.org/themes/hello-elementor/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/hello-elementor.3.4.5.zip";s:8:"requires";s:3:"6.0";s:12:"requires_php";s:3:"7.4";}s:16:"twentytwentyfive";a:6:{s:5:"theme";s:16:"twentytwentyfive";s:11:"new_version";s:3:"1.4";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfive/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfive.1.4.zip";s:8:"requires";s:3:"6.7";s:12:"requires_php";s:3:"7.2";}s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.4";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.4.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}}s:9:"no_update";a:1:{s:17:"twentytwentythree";a:6:{s:5:"theme";s:17:"twentytwentythree";s:11:"new_version";s:3:"1.6";s:3:"url";s:47:"https://wordpress.org/themes/twentytwentythree/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip";s:8:"requires";s:3:"6.1";s:12:"requires_php";s:3:"5.6";}}s:12:"translations";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24106,'_site_transient_timeout_wp_theme_files_patterns-e5eb257843980eb9ec15e63e33013b7d','1766816526','off');
INSERT INTO `wpnc_options` VALUES (24107,'_site_transient_wp_theme_files_patterns-e5eb257843980eb9ec15e63e33013b7d','a:2:{s:7:"version";b:0;s:8:"patterns";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24109,'_site_transient_timeout_wp_theme_files_patterns-1a36b6f6d0ca36525d06c2c0c528fa66','1766816527','off');
INSERT INTO `wpnc_options` VALUES (24110,'_site_transient_wp_theme_files_patterns-1a36b6f6d0ca36525d06c2c0c528fa66','a:2:{s:7:"version";s:5:"3.3.0";s:8:"patterns";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24112,'_transient_timeout_rsssl_testpage','1766901127','off');
INSERT INTO `wpnc_options` VALUES (24113,'_transient_rsssl_testpage','<html>\n<head>\n	<meta charset="UTF-8">\n	<META NAME="ROBOTS" CONTENT="NOINDEX, NOFOLLOW">\n</head>\n<body>\n<h1>#SSL TEST PAGE#</h1>\n<p>This page is used purely to test for SSL availability.</p>\n#SERVER-HTTPS-ON# (on)<br>#SERVERPORT443#<br><br>#SUCCESSFULLY DETECTED SSL#\n</body>\n</html>\n','off');
INSERT INTO `wpnc_options` VALUES (24114,'_transient_timeout_rsssl_code_execution_allowed_status','1766901127','off');
INSERT INTO `wpnc_options` VALUES (24115,'_transient_rsssl_code_execution_allowed_status','not-allowed','off');
INSERT INTO `wpnc_options` VALUES (24116,'_transient_timeout_rsssl_directory_indexing_status','1766901127','off');
INSERT INTO `wpnc_options` VALUES (24117,'_transient_rsssl_directory_indexing_status','forbidden','off');
INSERT INTO `wpnc_options` VALUES (24118,'_transient_timeout_rsssl_admin_users','1766818327','off');
INSERT INTO `wpnc_options` VALUES (24119,'_transient_rsssl_admin_users','a:2:{i:0;O:7:"WP_User":8:{s:4:"data";O:8:"stdClass":10:{s:2:"ID";s:1:"1";s:10:"user_login";s:5:"Excom";s:9:"user_pass";s:34:"$P$BQr28Md5U9LR9BaNCvPRSOgwm9dtRt/";s:13:"user_nicename";s:5:"excom";s:10:"user_email";s:25:"venture.publish@gmail.com";s:8:"user_url";s:35:"https://stellaradvisoryservices.com";s:15:"user_registered";s:19:"2025-01-08 06:58:46";s:19:"user_activation_key";s:0:"";s:11:"user_status";s:1:"0";s:12:"display_name";s:5:"Excom";}s:2:"ID";i:1;s:4:"caps";a:1:{s:13:"administrator";b:1;}s:7:"cap_key";s:17:"wpnc_capabilities";s:5:"roles";a:1:{i:0;s:13:"administrator";}s:7:"allcaps";a:63:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:15:"manage_security";b:1;s:13:"administrator";b:1;}s:6:"filter";N;s:16:"\0WP_User\0site_id";i:1;}i:1;O:7:"WP_User":8:{s:4:"data";O:8:"stdClass":10:{s:2:"ID";s:1:"2";s:10:"user_login";s:5:"owner";s:9:"user_pass";s:34:"$P$BAyMi86W3Wod.Qu2mjol67EdPIUCjO.";s:13:"user_nicename";s:5:"owner";s:10:"user_email";s:37:"stellaradvisoryservices.sas@gmail.com";s:8:"user_url";s:0:"";s:15:"user_registered";s:19:"2025-01-29 06:24:27";s:19:"user_activation_key";s:0:"";s:11:"user_status";s:1:"0";s:12:"display_name";s:16:"Stellar Advisory";}s:2:"ID";i:2;s:4:"caps";a:1:{s:13:"administrator";b:1;}s:7:"cap_key";s:17:"wpnc_capabilities";s:5:"roles";a:1:{i:0;s:13:"administrator";}s:7:"allcaps";a:63:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:15:"manage_security";b:1;s:13:"administrator";b:1;}s:6:"filter";N;s:16:"\0WP_User\0site_id";i:1;}}','off');
INSERT INTO `wpnc_options` VALUES (24120,'_site_transient_timeout_theme_roots','1766816527','off');
INSERT INTO `wpnc_options` VALUES (24121,'_site_transient_theme_roots','a:4:{s:15:"hello-elementor";s:7:"/themes";s:16:"twentytwentyfive";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";}','off');
INSERT INTO `wpnc_options` VALUES (24122,'_transient_timeout_rsssl_certinfo','1766901153','off');
INSERT INTO `wpnc_options` VALUES (24123,'_transient_rsssl_certinfo','a:16:{s:4:"name";s:30:"/CN=*.kmshermanandpartners.com";s:7:"subject";a:1:{s:2:"CN";s:26:"*.kmshermanandpartners.com";}s:4:"hash";s:8:"a87195ac";s:6:"issuer";a:3:{s:1:"C";s:2:"US";s:1:"O";s:13:"Let\'s Encrypt";s:2:"CN";s:3:"R13";}s:7:"version";i:2;s:12:"serialNumber";s:38:"0x05F0C91E0FA088427FF811A74B2D9D443126";s:15:"serialNumberHex";s:36:"05F0C91E0FA088427FF811A74B2D9D443126";s:9:"validFrom";s:13:"251225155842Z";s:7:"validTo";s:13:"260325155841Z";s:16:"validFrom_time_t";i:1766678322;s:14:"validTo_time_t";i:1774454321;s:15:"signatureTypeSN";s:10:"RSA-SHA256";s:15:"signatureTypeLN";s:23:"sha256WithRSAEncryption";s:16:"signatureTypeNID";i:668;s:8:"purposes";a:10:{i:1;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:"sslclient";}i:2;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:"sslserver";}i:3;a:3:{i:0;b:1;i:1;b:0;i:2;s:11:"nssslserver";}i:4;a:3:{i:0;b:0;i:1;b:0;i:2;s:9:"smimesign";}i:5;a:3:{i:0;b:0;i:1;b:0;i:2;s:12:"smimeencrypt";}i:6;a:3:{i:0;b:0;i:1;b:0;i:2;s:7:"crlsign";}i:7;a:3:{i:0;b:1;i:1;b:1;i:2;s:3:"any";}i:8;a:3:{i:0;b:1;i:1;b:0;i:2;s:10:"ocsphelper";}i:9;a:3:{i:0;b:0;i:1;b:0;i:2;s:13:"timestampsign";}i:10;a:3:{i:0;b:0;i:1;b:0;i:2;s:8:"codesign";}}s:10:"extensions";a:10:{s:8:"keyUsage";s:35:"Digital Signature, Key Encipherment";s:16:"extendedKeyUsage";s:60:"TLS Web Server Authentication, TLS Web Client Authentication";s:16:"basicConstraints";s:8:"CA:FALSE";s:20:"subjectKeyIdentifier";s:59:"61:12:A6:F8:81:12:C0:BF:DB:07:F3:44:79:FF:D4:D5:E1:46:81:CA";s:22:"authorityKeyIdentifier";s:59:"E7:AB:9F:0F:2C:33:A0:53:D3:5E:4F:78:C8:B2:84:0E:3B:D6:92:33";s:19:"authorityInfoAccess";s:40:"CA Issuers - URI:http://r13.i.lencr.org/";s:14:"subjectAltName";s:854:"DNS:*.kantorawp.com, DNS:*.kantorpengacaramagetan.com, DNS:*.kmshermanandpartners.com, DNS:*.pengacarazaid.com, DNS:*.promo-myrepublic.com, DNS:*.stellaradvisoryservices.com, DNS:kantorawp.com, DNS:kantorawp.com.aalflegal.com, DNS:kantorpengacaramagetan.com, DNS:kantorpengacaramagetan.com.aalflegal.com, DNS:kmshermanandpartners.com, DNS:kmshermanandpartners.com.aalflegal.com, DNS:pengacarazaid.com, DNS:pengacarazaid.com.aalflegal.com, DNS:promo-myrepublic.com, DNS:promo-myrepublic.com.aalflegal.com, DNS:stellaradvisoryservices.com, DNS:stellaradvisoryservices.com.aalflegal.com, DNS:www.kantorawp.com.aalflegal.com, DNS:www.kantorpengacaramagetan.com.aalflegal.com, DNS:www.kmshermanandpartners.com.aalflegal.com, DNS:www.pengacarazaid.com.aalflegal.com, DNS:www.promo-myrepublic.com.aalflegal.com, DNS:www.stellaradvisoryservices.com.aalflegal.com";s:19:"certificatePolicies";s:22:"Policy: 2.23.140.1.2.1";s:21:"crlDistributionPoints";s:47:"Full Name:\n  URI:http://r13.c.lencr.org/39.crl\n";s:15:"ct_precert_scts";s:1183:"Signed Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : 0E:57:94:BC:F3:AE:A9:3E:33:1B:2C:99:07:B3:F7:90:\n                DF:9B:C2:3D:71:32:25:DD:21:A9:25:AC:61:C5:4E:21\n    Timestamp : Dec 25 16:57:12.069 2025 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:46:02:21:00:E5:6A:2F:0F:98:39:EC:86:DD:94:83:\n                0D:87:BA:F4:85:97:D0:AB:0A:9C:AC:1C:75:51:2A:C3:\n                15:FE:B0:8F:54:02:21:00:80:E3:FD:D5:85:6D:59:68:\n                85:28:30:A2:4F:DA:95:DB:F0:F2:9E:89:F8:79:C4:1B:\n                81:CE:94:91:86:5C:3E:03\nSigned Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : E3:23:8D:F2:8D:A2:88:E0:AA:E0:AC:F0:FA:90:C9:85:\n                F0:B6:BF:F5:D2:A5:27:B0:01:FC:1C:44:58:C4:B6:E8\n    Timestamp : Dec 25 16:57:12.524 2025 GMT\n    Extensions: 00:00:05:00:2D:3C:D9:34\n    Signature : ecdsa-with-SHA256\n                30:45:02:20:5C:7F:90:CC:D3:0E:3A:F8:7D:84:C9:25:\n                38:47:43:35:38:18:C2:2A:AF:10:68:30:E3:F8:3D:C4:\n                E0:77:5D:1A:02:21:00:B7:2F:CE:4B:68:EB:CF:4F:A6:\n                BB:07:07:E7:E5:E4:B4:24:43:CB:8D:85:5B:B2:C9:C7:\n                4B:11:CD:5D:7F:4C:11";}}','off');
INSERT INTO `wpnc_options` VALUES (24124,'_transient_timeout_rsssl_mixed_content_fixer_detected','1766815327','off');
INSERT INTO `wpnc_options` VALUES (24125,'_transient_rsssl_mixed_content_fixer_detected','found','off');
INSERT INTO `wpnc_options` VALUES (24126,'_transient_timeout_rsssl_admin_user_count','1766818353','off');
INSERT INTO `wpnc_options` VALUES (24127,'_transient_rsssl_admin_user_count','0','off');
INSERT INTO `wpnc_options` VALUES (24132,'_site_transient_timeout_browser_89db729cfcdc129111f017b0e7ac324a','1767419528','off');
INSERT INTO `wpnc_options` VALUES (24133,'_site_transient_browser_89db729cfcdc129111f017b0e7ac324a','a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:9:"143.0.0.0";s:8:"platform";s:7:"Windows";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}','off');
INSERT INTO `wpnc_options` VALUES (24135,'_transient_timeout_elementor_remote_info_api_data_3.25.3','1766857933','off');
INSERT INTO `wpnc_options` VALUES (24136,'_transient_elementor_remote_info_api_data_3.25.3','a:4:{s:9:"timestamp";s:10:"1766813767";s:14:"upgrade_notice";a:3:{s:7:"version";s:5:"2.0.0";s:7:"message";s:0:"";s:11:"update_link";s:0:"";}s:11:"pro_widgets";a:82:{i:0;a:4:{s:4:"name";s:6:"search";s:5:"title";s:6:"Search";s:4:"icon";s:17:"eicon-site-search";s:10:"categories";s:16:"["pro-elements"]";}i:1;a:4:{s:4:"name";s:5:"posts";s:5:"title";s:5:"Posts";s:4:"icon";s:15:"eicon-post-list";s:10:"categories";s:16:"["pro-elements"]";}i:2;a:4:{s:4:"name";s:9:"portfolio";s:5:"title";s:9:"Portfolio";s:4:"icon";s:18:"eicon-gallery-grid";s:10:"categories";s:16:"["pro-elements"]";}i:3;a:4:{s:4:"name";s:17:"link-in-bio-var-2";s:5:"title";s:7:"Classic";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:4;a:4:{s:4:"name";s:9:"mega-menu";s:5:"title";s:4:"Menu";s:4:"icon";s:15:"eicon-mega-menu";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:5;a:4:{s:4:"name";s:17:"link-in-bio-var-3";s:5:"title";s:8:"Showcase";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:6;a:4:{s:4:"name";s:4:"form";s:5:"title";s:4:"Form";s:4:"icon";s:21:"eicon-form-horizontal";s:10:"categories";s:16:"["pro-elements"]";}i:7;a:4:{s:4:"name";s:17:"link-in-bio-var-4";s:5:"title";s:5:"Links";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:8;a:4:{s:4:"name";s:9:"loop-grid";s:5:"title";s:9:"Loop Grid";s:4:"icon";s:18:"eicon-loop-builder";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:9;a:4:{s:4:"name";s:17:"link-in-bio-var-5";s:5:"title";s:8:"Services";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:10;a:4:{s:4:"name";s:13:"loop-carousel";s:5:"title";s:13:"Loop Carousel";s:4:"icon";s:19:"eicon-carousel-loop";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:11;a:4:{s:4:"name";s:17:"link-in-bio-var-6";s:5:"title";s:9:"Portfolio";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:12;a:4:{s:4:"name";s:7:"gallery";s:5:"title";s:7:"Gallery";s:4:"icon";s:23:"eicon-gallery-justified";s:10:"categories";s:16:"["pro-elements"]";}i:13;a:4:{s:4:"name";s:17:"link-in-bio-var-7";s:5:"title";s:13:"Business Card";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:14;a:4:{s:4:"name";s:17:"animated-headline";s:5:"title";s:17:"Animated Headline";s:4:"icon";s:23:"eicon-animated-headline";s:10:"categories";s:16:"["pro-elements"]";}i:15;a:4:{s:4:"name";s:10:"price-list";s:5:"title";s:10:"Price List";s:4:"icon";s:16:"eicon-price-list";s:10:"categories";s:16:"["pro-elements"]";}i:16;a:4:{s:4:"name";s:11:"price-table";s:5:"title";s:11:"Price Table";s:4:"icon";s:17:"eicon-price-table";s:10:"categories";s:16:"["pro-elements"]";}i:17;a:4:{s:4:"name";s:8:"flip-box";s:5:"title";s:8:"Flip Box";s:4:"icon";s:14:"eicon-flip-box";s:10:"categories";s:16:"["pro-elements"]";}i:18;a:4:{s:4:"name";s:14:"call-to-action";s:5:"title";s:14:"Call to Action";s:4:"icon";s:20:"eicon-image-rollover";s:10:"categories";s:16:"["pro-elements"]";}i:19;a:4:{s:4:"name";s:14:"media-carousel";s:5:"title";s:14:"Media Carousel";s:4:"icon";s:20:"eicon-media-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:20;a:4:{s:4:"name";s:15:"nested-carousel";s:5:"title";s:8:"Carousel";s:4:"icon";s:21:"eicon-nested-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:21;a:4:{s:4:"name";s:10:"off-canvas";s:5:"title";s:10:"Off-Canvas";s:4:"icon";s:16:"eicon-off-canvas";s:10:"categories";s:16:"["pro-elements"]";}i:22;a:4:{s:4:"name";s:9:"countdown";s:5:"title";s:9:"Countdown";s:4:"icon";s:15:"eicon-countdown";s:10:"categories";s:16:"["pro-elements"]";}i:23;a:4:{s:4:"name";s:13:"share-buttons";s:5:"title";s:13:"Share Buttons";s:4:"icon";s:11:"eicon-share";s:10:"categories";s:16:"["pro-elements"]";}i:24;a:4:{s:4:"name";s:10:"blockquote";s:5:"title";s:10:"Blockquote";s:4:"icon";s:16:"eicon-blockquote";s:10:"categories";s:16:"["pro-elements"]";}i:25;a:4:{s:4:"name";s:6:"lottie";s:5:"title";s:6:"Lottie";s:4:"icon";s:12:"eicon-lottie";s:10:"categories";s:16:"["pro-elements"]";}i:26;a:4:{s:4:"name";s:7:"hotspot";s:5:"title";s:7:"Hotspot";s:4:"icon";s:19:"eicon-image-hotspot";s:10:"categories";s:16:"["pro-elements"]";}i:27;a:4:{s:4:"name";s:13:"paypal-button";s:5:"title";s:13:"PayPal Button";s:4:"icon";s:19:"eicon-paypal-button";s:10:"categories";s:16:"["pro-elements"]";}i:28;a:4:{s:4:"name";s:14:"code-highlight";s:5:"title";s:14:"Code Highlight";s:4:"icon";s:20:"eicon-code-highlight";s:10:"categories";s:16:"["pro-elements"]";}i:29;a:4:{s:4:"name";s:14:"video-playlist";s:5:"title";s:14:"Video Playlist";s:4:"icon";s:20:"eicon-video-playlist";s:10:"categories";s:16:"["pro-elements"]";}i:30;a:4:{s:4:"name";s:8:"template";s:5:"title";s:8:"Template";s:4:"icon";s:19:"eicon-document-file";s:10:"categories";s:16:"["pro-elements"]";}i:31;a:4:{s:4:"name";s:13:"stripe-button";s:5:"title";s:13:"Stripe Button";s:4:"icon";s:19:"eicon-stripe-button";s:10:"categories";s:16:"["pro-elements"]";}i:32;a:4:{s:4:"name";s:16:"progress-tracker";s:5:"title";s:16:"Progress Tracker";s:4:"icon";s:22:"eicon-progress-tracker";s:10:"categories";s:40:"["pro-elements","theme-elements-single"]";}i:33;a:4:{s:4:"name";s:8:"nav-menu";s:5:"title";s:8:"Nav Menu";s:4:"icon";s:14:"eicon-nav-menu";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:34;a:4:{s:4:"name";s:17:"table-of-contents";s:5:"title";s:17:"Table of Contents";s:4:"icon";s:23:"eicon-table-of-contents";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:35;a:4:{s:4:"name";s:5:"login";s:5:"title";s:5:"Login";s:4:"icon";s:15:"eicon-lock-user";s:10:"categories";s:16:"["pro-elements"]";}i:36;a:4:{s:4:"name";s:6:"slides";s:5:"title";s:6:"Slides";s:4:"icon";s:12:"eicon-slides";s:10:"categories";s:16:"["pro-elements"]";}i:37;a:4:{s:4:"name";s:20:"testimonial-carousel";s:5:"title";s:20:"Testimonial Carousel";s:4:"icon";s:26:"eicon-testimonial-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:38;a:4:{s:4:"name";s:7:"reviews";s:5:"title";s:7:"Reviews";s:4:"icon";s:12:"eicon-review";s:10:"categories";s:16:"["pro-elements"]";}i:39;a:4:{s:4:"name";s:15:"facebook-button";s:5:"title";s:15:"Facebook Button";s:4:"icon";s:23:"eicon-facebook-like-box";s:10:"categories";s:16:"["pro-elements"]";}i:40;a:4:{s:4:"name";s:17:"facebook-comments";s:5:"title";s:17:"Facebook Comments";s:4:"icon";s:23:"eicon-facebook-comments";s:10:"categories";s:16:"["pro-elements"]";}i:41;a:4:{s:4:"name";s:14:"facebook-embed";s:5:"title";s:14:"Facebook Embed";s:4:"icon";s:14:"eicon-fb-embed";s:10:"categories";s:16:"["pro-elements"]";}i:42;a:4:{s:4:"name";s:13:"facebook-page";s:5:"title";s:13:"Facebook Page";s:4:"icon";s:13:"eicon-fb-feed";s:10:"categories";s:16:"["pro-elements"]";}i:43;a:4:{s:4:"name";s:15:"theme-site-logo";s:5:"title";s:9:"Site Logo";s:4:"icon";s:15:"eicon-site-logo";s:10:"categories";s:18:"["theme-elements"]";}i:44;a:4:{s:4:"name";s:16:"theme-site-title";s:5:"title";s:10:"Site Title";s:4:"icon";s:16:"eicon-site-title";s:10:"categories";s:18:"["theme-elements"]";}i:45;a:4:{s:4:"name";s:16:"theme-page-title";s:5:"title";s:10:"Page Title";s:4:"icon";s:19:"eicon-archive-title";s:10:"categories";s:18:"["theme-elements"]";}i:46;a:4:{s:4:"name";s:16:"theme-post-title";s:5:"title";s:10:"Post Title";s:4:"icon";s:16:"eicon-post-title";s:10:"categories";s:18:"["theme-elements"]";}i:47;a:4:{s:4:"name";s:18:"theme-post-excerpt";s:5:"title";s:12:"Post Excerpt";s:4:"icon";s:18:"eicon-post-excerpt";s:10:"categories";s:18:"["theme-elements"]";}i:48;a:4:{s:4:"name";s:25:"theme-post-featured-image";s:5:"title";s:14:"Featured Image";s:4:"icon";s:20:"eicon-featured-image";s:10:"categories";s:18:"["theme-elements"]";}i:49;a:4:{s:4:"name";s:19:"theme-archive-title";s:5:"title";s:13:"Archive Title";s:4:"icon";s:19:"eicon-archive-title";s:10:"categories";s:18:"["theme-elements"]";}i:50;a:4:{s:4:"name";s:13:"archive-posts";s:5:"title";s:13:"Archive Posts";s:4:"icon";s:19:"eicon-archive-posts";s:10:"categories";s:18:"["theme-elements"]";}i:51;a:4:{s:4:"name";s:10:"author-box";s:5:"title";s:10:"Author Box";s:4:"icon";s:12:"eicon-person";s:10:"categories";s:18:"["theme-elements"]";}i:52;a:4:{s:4:"name";s:13:"post-comments";s:5:"title";s:13:"Post Comments";s:4:"icon";s:14:"eicon-comments";s:10:"categories";s:18:"["theme-elements"]";}i:53;a:4:{s:4:"name";s:15:"post-navigation";s:5:"title";s:15:"Post Navigation";s:4:"icon";s:21:"eicon-post-navigation";s:10:"categories";s:18:"["theme-elements"]";}i:54;a:4:{s:4:"name";s:9:"post-info";s:5:"title";s:9:"Post Info";s:4:"icon";s:15:"eicon-post-info";s:10:"categories";s:18:"["theme-elements"]";}i:55;a:4:{s:4:"name";s:7:"sitemap";s:5:"title";s:7:"Sitemap";s:4:"icon";s:13:"eicon-sitemap";s:10:"categories";s:18:"["theme-elements"]";}i:56;a:4:{s:4:"name";s:11:"breadcrumbs";s:5:"title";s:11:"Breadcrumbs";s:4:"icon";s:11:"eicon-yoast";s:10:"categories";s:18:"["theme-elements"]";}i:57;a:4:{s:4:"name";s:21:"woocommerce-menu-cart";s:5:"title";s:9:"Menu Cart";s:4:"icon";s:10:"eicon-cart";s:10:"categories";s:41:"["theme-elements","woocommerce-elements"]";}i:58;a:4:{s:4:"name";s:19:"wc-archive-products";s:5:"title";s:16:"Archive Products";s:4:"icon";s:14:"eicon-products";s:10:"categories";s:24:"["woocommerce-elements"]";}i:59;a:4:{s:4:"name";s:31:"woocommerce-archive-description";s:5:"title";s:19:"Archive Description";s:4:"icon";s:25:"eicon-product-description";s:10:"categories";s:24:"["woocommerce-elements"]";}i:60;a:4:{s:4:"name";s:20:"woocommerce-products";s:5:"title";s:8:"Products";s:4:"icon";s:14:"eicon-products";s:10:"categories";s:24:"["woocommerce-elements"]";}i:61;a:4:{s:4:"name";s:22:"woocommerce-breadcrumb";s:5:"title";s:23:"WooCommerce Breadcrumbs";s:4:"icon";s:25:"eicon-product-breadcrumbs";s:10:"categories";s:24:"["woocommerce-elements"]";}i:62;a:4:{s:4:"name";s:14:"wc-add-to-cart";s:5:"title";s:18:"Custom Add To Cart";s:4:"icon";s:17:"eicon-woocommerce";s:10:"categories";s:24:"["woocommerce-elements"]";}i:63;a:4:{s:4:"name";s:11:"wc-elements";s:5:"title";s:17:"WooCommerce Pages";s:4:"icon";s:19:"eicon-product-pages";s:10:"categories";s:24:"["woocommerce-elements"]";}i:64;a:4:{s:4:"name";s:13:"wc-categories";s:5:"title";s:18:"Product Categories";s:4:"icon";s:24:"eicon-product-categories";s:10:"categories";s:24:"["woocommerce-elements"]";}i:65;a:4:{s:4:"name";s:25:"woocommerce-product-title";s:5:"title";s:13:"Product Title";s:4:"icon";s:19:"eicon-product-title";s:10:"categories";s:24:"["woocommerce-elements"]";}i:66;a:4:{s:4:"name";s:26:"woocommerce-product-images";s:5:"title";s:14:"Product Images";s:4:"icon";s:20:"eicon-product-images";s:10:"categories";s:24:"["woocommerce-elements"]";}i:67;a:4:{s:4:"name";s:25:"woocommerce-product-price";s:5:"title";s:13:"Product Price";s:4:"icon";s:19:"eicon-product-price";s:10:"categories";s:24:"["woocommerce-elements"]";}i:68;a:4:{s:4:"name";s:31:"woocommerce-product-add-to-cart";s:5:"title";s:11:"Add To Cart";s:4:"icon";s:25:"eicon-product-add-to-cart";s:10:"categories";s:24:"["woocommerce-elements"]";}i:69;a:4:{s:4:"name";s:26:"woocommerce-product-rating";s:5:"title";s:14:"Product Rating";s:4:"icon";s:20:"eicon-product-rating";s:10:"categories";s:24:"["woocommerce-elements"]";}i:70;a:4:{s:4:"name";s:25:"woocommerce-product-stock";s:5:"title";s:13:"Product Stock";s:4:"icon";s:19:"eicon-product-stock";s:10:"categories";s:24:"["woocommerce-elements"]";}i:71;a:4:{s:4:"name";s:24:"woocommerce-product-meta";s:5:"title";s:12:"Product Meta";s:4:"icon";s:18:"eicon-product-meta";s:10:"categories";s:24:"["woocommerce-elements"]";}i:72;a:4:{s:4:"name";s:37:"woocommerce-product-short-description";s:5:"title";s:17:"Short Description";s:4:"icon";s:25:"eicon-product-description";s:10:"categories";s:24:"["woocommerce-elements"]";}i:73;a:4:{s:4:"name";s:29:"woocommerce-product-data-tabs";s:5:"title";s:17:"Product Data Tabs";s:4:"icon";s:18:"eicon-product-tabs";s:10:"categories";s:24:"["woocommerce-elements"]";}i:74;a:4:{s:4:"name";s:42:"woocommerce-product-additional-information";s:5:"title";s:22:"Additional Information";s:4:"icon";s:19:" eicon-product-info";s:10:"categories";s:24:"["woocommerce-elements"]";}i:75;a:4:{s:4:"name";s:27:"woocommerce-product-related";s:5:"title";s:15:"Product Related";s:4:"icon";s:21:"eicon-product-related";s:10:"categories";s:24:"["woocommerce-elements"]";}i:76;a:4:{s:4:"name";s:26:"woocommerce-product-upsell";s:5:"title";s:7:"Upsells";s:4:"icon";s:20:"eicon-product-upsell";s:10:"categories";s:24:"["woocommerce-elements"]";}i:77;a:4:{s:4:"name";s:25:"woocommerce-checkout-page";s:5:"title";s:8:"Checkout";s:4:"icon";s:14:"eicon-checkout";s:10:"categories";s:24:"["woocommerce-elements"]";}i:78;a:4:{s:4:"name";s:16:"woocommerce-cart";s:5:"title";s:4:"Cart";s:4:"icon";s:14:"eicon-woo-cart";s:10:"categories";s:24:"["woocommerce-elements"]";}i:79;a:4:{s:4:"name";s:22:"woocommerce-my-account";s:5:"title";s:10:"My Account";s:4:"icon";s:16:"eicon-my-account";s:10:"categories";s:24:"["woocommerce-elements"]";}i:80;a:4:{s:4:"name";s:28:"woocommerce-purchase-summary";s:5:"title";s:16:"Purchase Summary";s:4:"icon";s:22:"eicon-purchase-summary";s:10:"categories";s:24:"["woocommerce-elements"]";}i:81;a:4:{s:4:"name";s:19:"woocommerce-notices";s:5:"title";s:19:"WooCommerce Notices";s:4:"icon";s:25:"eicon-woocommerce-notices";s:10:"categories";s:24:"["woocommerce-elements"]";}}s:17:"canary_deployment";a:2:{s:11:"plugin_info";a:11:{s:2:"id";s:23:"w.org/plugins/elementor";s:4:"slug";s:9:"elementor";s:6:"plugin";s:23:"elementor/elementor.php";s:11:"new_version";s:5:"3.6.0";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip";s:3:"url";s:40:"https://wordpress.org/plugins/elementor/";s:5:"icons";a:3:{s:2:"2x";s:62:"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768";s:2:"1x";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";s:3:"svg";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";}s:7:"banners";a:2:{s:2:"2x";s:65:"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479";s:2:"1x";s:64:"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:3:"6.9";s:12:"requires_php";s:3:"5.6";}s:10:"conditions";a:0:{}}}','off');
INSERT INTO `wpnc_options` VALUES (24137,'_site_transient_timeout_wp_plugin_dependencies_plugin_timeout_elementor','1766857941','off');
INSERT INTO `wpnc_options` VALUES (24138,'_site_transient_wp_plugin_dependencies_plugin_timeout_elementor','1','off');
INSERT INTO `wpnc_options` VALUES (24139,'can_compress_scripts','1','on');
INSERT INTO `wpnc_options` VALUES (24140,'_transient_timeout_rsssl_htaccess_test_success','1766815349','off');
INSERT INTO `wpnc_options` VALUES (24141,'_transient_rsssl_htaccess_test_success','success','off');
INSERT INTO `wpnc_options` VALUES (24146,'_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a','1766825569','off');
INSERT INTO `wpnc_options` VALUES (24147,'_site_transient_poptags_40cd750bba9870f18aada2478b24840a','O:8:"stdClass":100:{s:11:"woocommerce";a:3:{s:4:"name";s:11:"woocommerce";s:4:"slug";s:11:"woocommerce";s:5:"count";i:7878;}s:6:"widget";a:3:{s:4:"name";s:6:"widget";s:4:"slug";s:6:"widget";s:5:"count";i:4950;}s:4:"post";a:3:{s:4:"name";s:4:"post";s:4:"slug";s:4:"post";s:5:"count";i:2799;}s:5:"admin";a:3:{s:4:"name";s:5:"admin";s:4:"slug";s:5:"admin";s:5:"count";i:2789;}s:3:"seo";a:3:{s:4:"name";s:3:"seo";s:4:"slug";s:3:"seo";s:5:"count";i:2174;}s:5:"posts";a:3:{s:4:"name";s:5:"posts";s:4:"slug";s:5:"posts";s:5:"count";i:2157;}s:9:"shortcode";a:3:{s:4:"name";s:9:"shortcode";s:4:"slug";s:9:"shortcode";s:5:"count";i:2145;}s:8:"comments";a:3:{s:4:"name";s:8:"comments";s:4:"slug";s:8:"comments";s:5:"count";i:1974;}s:9:"ecommerce";a:3:{s:4:"name";s:9:"ecommerce";s:4:"slug";s:9:"ecommerce";s:5:"count";i:1713;}s:6:"images";a:3:{s:4:"name";s:6:"images";s:4:"slug";s:6:"images";s:5:"count";i:1666;}s:5:"image";a:3:{s:4:"name";s:5:"image";s:4:"slug";s:5:"image";s:5:"count";i:1627;}s:6:"google";a:3:{s:4:"name";s:6:"google";s:4:"slug";s:6:"google";s:5:"count";i:1562;}s:8:"facebook";a:3:{s:4:"name";s:8:"facebook";s:4:"slug";s:8:"facebook";s:5:"count";i:1518;}s:7:"twitter";a:3:{s:4:"name";s:7:"twitter";s:4:"slug";s:7:"twitter";s:5:"count";i:1516;}s:5:"email";a:3:{s:4:"name";s:5:"email";s:4:"slug";s:5:"email";s:5:"count";i:1514;}s:8:"security";a:3:{s:4:"name";s:8:"security";s:4:"slug";s:8:"security";s:5:"count";i:1417;}s:7:"gallery";a:3:{s:4:"name";s:7:"gallery";s:4:"slug";s:7:"gallery";s:5:"count";i:1376;}s:7:"sidebar";a:3:{s:4:"name";s:7:"sidebar";s:4:"slug";s:7:"sidebar";s:5:"count";i:1318;}s:5:"login";a:3:{s:4:"name";s:5:"login";s:4:"slug";s:5:"login";s:5:"count";i:1288;}s:6:"social";a:3:{s:4:"name";s:6:"social";s:4:"slug";s:6:"social";s:5:"count";i:1185;}s:4:"page";a:3:{s:4:"name";s:4:"page";s:4:"slug";s:4:"page";s:5:"count";i:1161;}s:9:"analytics";a:3:{s:4:"name";s:9:"analytics";s:4:"slug";s:9:"analytics";s:5:"count";i:1098;}s:7:"payment";a:3:{s:4:"name";s:7:"payment";s:4:"slug";s:7:"payment";s:5:"count";i:1092;}s:5:"block";a:3:{s:4:"name";s:5:"block";s:4:"slug";s:5:"block";s:5:"count";i:1092;}s:9:"gutenberg";a:3:{s:4:"name";s:9:"gutenberg";s:4:"slug";s:9:"gutenberg";s:5:"count";i:1085;}s:5:"video";a:3:{s:4:"name";s:5:"video";s:4:"slug";s:5:"video";s:5:"count";i:1074;}s:10:"e-commerce";a:3:{s:4:"name";s:10:"e-commerce";s:4:"slug";s:10:"e-commerce";s:5:"count";i:1052;}s:9:"elementor";a:3:{s:4:"name";s:9:"elementor";s:4:"slug";s:9:"elementor";s:5:"count";i:1051;}s:7:"widgets";a:3:{s:4:"name";s:7:"widgets";s:4:"slug";s:7:"widgets";s:5:"count";i:1013;}s:7:"content";a:3:{s:4:"name";s:7:"content";s:4:"slug";s:7:"content";s:5:"count";i:993;}s:15:"payment-gateway";a:3:{s:4:"name";s:15:"payment gateway";s:4:"slug";s:15:"payment-gateway";s:5:"count";i:964;}s:6:"slider";a:3:{s:4:"name";s:6:"slider";s:4:"slug";s:6:"slider";s:5:"count";i:958;}s:5:"links";a:3:{s:4:"name";s:5:"links";s:4:"slug";s:5:"links";s:5:"count";i:940;}s:4:"spam";a:3:{s:4:"name";s:4:"spam";s:4:"slug";s:4:"spam";s:5:"count";i:936;}s:4:"form";a:3:{s:4:"name";s:4:"form";s:4:"slug";s:4:"form";s:5:"count";i:916;}s:5:"media";a:3:{s:4:"name";s:5:"media";s:4:"slug";s:5:"media";s:5:"count";i:911;}s:6:"search";a:3:{s:4:"name";s:6:"search";s:4:"slug";s:6:"search";s:5:"count";i:870;}s:2:"ai";a:3:{s:4:"name";s:2:"AI";s:4:"slug";s:2:"ai";s:5:"count";i:837;}s:6:"editor";a:3:{s:4:"name";s:6:"editor";s:4:"slug";s:6:"editor";s:5:"count";i:826;}s:12:"contact-form";a:3:{s:4:"name";s:12:"contact form";s:4:"slug";s:12:"contact-form";s:5:"count";i:796;}s:10:"buddypress";a:3:{s:4:"name";s:10:"buddypress";s:4:"slug";s:10:"buddypress";s:5:"count";i:786;}s:4:"menu";a:3:{s:4:"name";s:4:"menu";s:4:"slug";s:4:"menu";s:5:"count";i:778;}s:3:"rss";a:3:{s:4:"name";s:3:"rss";s:4:"slug";s:3:"rss";s:5:"count";i:773;}s:5:"embed";a:3:{s:4:"name";s:5:"embed";s:4:"slug";s:5:"embed";s:5:"count";i:767;}s:5:"pages";a:3:{s:4:"name";s:5:"pages";s:4:"slug";s:5:"pages";s:5:"count";i:758;}s:11:"performance";a:3:{s:4:"name";s:11:"performance";s:4:"slug";s:11:"performance";s:5:"count";i:733;}s:4:"feed";a:3:{s:4:"name";s:4:"feed";s:4:"slug";s:4:"feed";s:5:"count";i:724;}s:4:"chat";a:3:{s:4:"name";s:4:"chat";s:4:"slug";s:4:"chat";s:5:"count";i:711;}s:8:"category";a:3:{s:4:"name";s:8:"category";s:4:"slug";s:8:"category";s:5:"count";i:710;}s:4:"ajax";a:3:{s:4:"name";s:4:"ajax";s:4:"slug";s:4:"ajax";s:5:"count";i:706;}s:3:"api";a:3:{s:4:"name";s:3:"api";s:4:"slug";s:3:"api";s:5:"count";i:704;}s:8:"shipping";a:3:{s:4:"name";s:8:"shipping";s:4:"slug";s:8:"shipping";s:5:"count";i:702;}s:7:"youtube";a:3:{s:4:"name";s:7:"youtube";s:4:"slug";s:7:"youtube";s:5:"count";i:680;}s:9:"marketing";a:3:{s:4:"name";s:9:"marketing";s:4:"slug";s:9:"marketing";s:5:"count";i:666;}s:6:"jquery";a:3:{s:4:"name";s:6:"jquery";s:4:"slug";s:6:"jquery";s:5:"count";i:665;}s:9:"dashboard";a:3:{s:4:"name";s:9:"dashboard";s:4:"slug";s:9:"dashboard";s:5:"count";i:659;}s:14:"contact-form-7";a:3:{s:4:"name";s:14:"contact form 7";s:4:"slug";s:14:"contact-form-7";s:5:"count";i:659;}s:9:"affiliate";a:3:{s:4:"name";s:9:"affiliate";s:4:"slug";s:9:"affiliate";s:5:"count";i:655;}s:10:"responsive";a:3:{s:4:"name";s:10:"responsive";s:4:"slug";s:10:"responsive";s:5:"count";i:652;}s:3:"css";a:3:{s:4:"name";s:3:"css";s:4:"slug";s:3:"css";s:5:"count";i:640;}s:5:"forms";a:3:{s:4:"name";s:5:"forms";s:4:"slug";s:5:"forms";s:5:"count";i:630;}s:4:"link";a:3:{s:4:"name";s:4:"link";s:4:"slug";s:4:"link";s:5:"count";i:626;}s:6:"events";a:3:{s:4:"name";s:6:"events";s:4:"slug";s:6:"events";s:5:"count";i:623;}s:7:"contact";a:3:{s:4:"name";s:7:"contact";s:4:"slug";s:7:"contact";s:5:"count";i:618;}s:10:"javascript";a:3:{s:4:"name";s:10:"javascript";s:4:"slug";s:10:"javascript";s:5:"count";i:616;}s:6:"blocks";a:3:{s:4:"name";s:6:"blocks";s:4:"slug";s:6:"blocks";s:5:"count";i:615;}s:5:"share";a:3:{s:4:"name";s:5:"share";s:4:"slug";s:5:"share";s:5:"count";i:612;}s:3:"ads";a:3:{s:4:"name";s:3:"ads";s:4:"slug";s:3:"ads";s:5:"count";i:600;}s:5:"popup";a:3:{s:4:"name";s:5:"popup";s:4:"slug";s:5:"popup";s:5:"count";i:591;}s:8:"payments";a:3:{s:4:"name";s:8:"payments";s:4:"slug";s:8:"payments";s:5:"count";i:590;}s:8:"calendar";a:3:{s:4:"name";s:8:"calendar";s:4:"slug";s:8:"calendar";s:5:"count";i:589;}s:6:"custom";a:3:{s:4:"name";s:6:"custom";s:4:"slug";s:6:"custom";s:5:"count";i:581;}s:5:"theme";a:3:{s:4:"name";s:5:"theme";s:4:"slug";s:5:"theme";s:5:"count";i:581;}s:7:"comment";a:3:{s:4:"name";s:7:"comment";s:4:"slug";s:7:"comment";s:5:"count";i:577;}s:10:"categories";a:3:{s:4:"name";s:10:"categories";s:4:"slug";s:10:"categories";s:5:"count";i:571;}s:6:"button";a:3:{s:4:"name";s:6:"button";s:4:"slug";s:6:"button";s:5:"count";i:564;}s:8:"checkout";a:3:{s:4:"name";s:8:"checkout";s:4:"slug";s:8:"checkout";s:5:"count";i:546;}s:4:"user";a:3:{s:4:"name";s:4:"user";s:4:"slug";s:4:"user";s:5:"count";i:539;}s:5:"users";a:3:{s:4:"name";s:5:"users";s:4:"slug";s:5:"users";s:5:"count";i:534;}s:4:"tags";a:3:{s:4:"name";s:4:"tags";s:4:"slug";s:4:"tags";s:5:"count";i:533;}s:10:"newsletter";a:3:{s:4:"name";s:10:"newsletter";s:4:"slug";s:10:"newsletter";s:5:"count";i:531;}s:10:"navigation";a:3:{s:4:"name";s:10:"navigation";s:4:"slug";s:10:"navigation";s:5:"count";i:530;}s:8:"tracking";a:3:{s:4:"name";s:8:"tracking";s:4:"slug";s:8:"tracking";s:5:"count";i:529;}s:12:"social-media";a:3:{s:4:"name";s:12:"social media";s:4:"slug";s:12:"social-media";s:5:"count";i:513;}s:6:"mobile";a:3:{s:4:"name";s:6:"mobile";s:4:"slug";s:6:"mobile";s:5:"count";i:510;}s:7:"gateway";a:3:{s:4:"name";s:7:"gateway";s:4:"slug";s:7:"gateway";s:5:"count";i:491;}s:8:"redirect";a:3:{s:4:"name";s:8:"redirect";s:4:"slug";s:8:"redirect";s:5:"count";i:488;}s:6:"import";a:3:{s:4:"name";s:6:"import";s:4:"slug";s:6:"import";s:5:"count";i:487;}s:12:"notification";a:3:{s:4:"name";s:12:"notification";s:4:"slug";s:12:"notification";s:5:"count";i:483;}s:5:"stats";a:3:{s:4:"name";s:5:"stats";s:4:"slug";s:5:"stats";s:5:"count";i:472;}s:10:"statistics";a:3:{s:4:"name";s:10:"statistics";s:4:"slug";s:10:"statistics";s:5:"count";i:470;}s:7:"chatbot";a:3:{s:4:"name";s:7:"chatbot";s:4:"slug";s:7:"chatbot";s:5:"count";i:462;}s:9:"slideshow";a:3:{s:4:"name";s:9:"slideshow";s:4:"slug";s:9:"slideshow";s:5:"count";i:461;}s:5:"photo";a:3:{s:4:"name";s:5:"photo";s:4:"slug";s:5:"photo";s:5:"count";i:457;}s:5:"cache";a:3:{s:4:"name";s:5:"cache";s:4:"slug";s:5:"cache";s:5:"count";i:456;}s:4:"news";a:3:{s:4:"name";s:4:"news";s:4:"slug";s:4:"news";s:5:"count";i:444;}s:8:"products";a:3:{s:4:"name";s:8:"products";s:4:"slug";s:8:"products";s:5:"count";i:436;}s:6:"photos";a:3:{s:4:"name";s:6:"photos";s:4:"slug";s:6:"photos";s:5:"count";i:432;}s:4:"code";a:3:{s:4:"name";s:4:"code";s:4:"slug";s:4:"code";s:5:"count";i:429;}s:10:"shortcodes";a:3:{s:4:"name";s:10:"shortcodes";s:4:"slug";s:10:"shortcodes";s:5:"count";i:427;}}','off');
INSERT INTO `wpnc_options` VALUES (24153,'wpvivid_email_setting','a:3:{s:7:"send_to";a:0:{}s:6:"always";b:1;s:12:"email_enable";b:0;}','off');
INSERT INTO `wpnc_options` VALUES (24154,'wpvivid_compress_setting','a:7:{s:13:"compress_type";s:3:"zip";s:13:"max_file_size";i:200;s:11:"no_compress";b:1;s:13:"use_temp_file";i:1;s:13:"use_temp_size";i:16;s:17:"exclude_file_size";i:0;s:24:"subpackage_plugin_upload";b:0;}','off');
INSERT INTO `wpnc_options` VALUES (24155,'wpvivid_local_setting','a:2:{s:4:"path";s:14:"wpvividbackups";s:10:"save_local";i:1;}','off');
INSERT INTO `wpnc_options` VALUES (24156,'wpvivid_upload_setting','a:1:{s:15:"remote_selected";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24157,'wpvivid_common_setting','a:10:{s:18:"max_execution_time";i:300;s:17:"log_save_location";s:26:"wpvividbackups/wpvivid_log";s:16:"max_backup_count";i:3;s:14:"show_admin_bar";b:1;s:14:"domain_include";b:1;s:15:"estimate_backup";b:1;s:16:"max_resume_count";i:6;s:12:"memory_limit";s:4:"512M";s:20:"restore_memory_limit";s:4:"512M";s:12:"migrate_size";s:4:"2048";}','off');
INSERT INTO `wpnc_options` VALUES (24158,'wpvivid_init','init','off');
INSERT INTO `wpnc_options` VALUES (24159,'wpvivid_backup_list','a:0:{}','off');
INSERT INTO `wpnc_options` VALUES (24160,'wpvivid_remote_init','init','off');
INSERT INTO `wpnc_options` VALUES (24162,'rsssl_plusone_count','3','auto');
INSERT INTO `wpnc_options` VALUES (24163,'wpvivid_check_htaccess_rule_free','1','off');
INSERT INTO `wpnc_options` VALUES (24164,'rsssl_admin_notices','a:1:{s:12:"risk_level_c";a:5:{s:9:"condition";a:0:{}s:8:"callback";s:6:"_true_";s:5:"score";i:1;s:17:"show_with_options";a:1:{i:0;s:28:"enable_vulnerability_scanner";}s:6:"output";a:10:{s:5:"title";s:33:"You have 1 critical vulnerability";s:3:"msg";s:65:"You have 1 critical vulnerability Please take appropriate action.";s:4:"icon";s:7:"warning";s:4:"type";s:7:"warning";s:11:"dismissible";b:1;s:12:"admin_notice";b:1;s:7:"plusone";b:1;s:18:"highlight_field_id";s:24:"vulnerabilities-overview";s:6:"status";s:7:"warning";s:5:"label";s:7:"Warning";}}}','auto');
INSERT INTO `wpnc_options` VALUES (24165,'wpvivid_need_review','not','off');
INSERT INTO `wpnc_options` VALUES (24170,'rsssl_mixed_content_scan_dismissed','1','off');
INSERT INTO `wpnc_options` VALUES (24171,'rsssl_previous_version','9.1.4','off');
INSERT INTO `wpnc_options` VALUES (24173,'rsssl_htaccess_should_wrap','1','off');
INSERT INTO `wpnc_options` VALUES (24174,'_transient_jetpack_autoloader_plugin_paths','a:1:{i:0;s:40:"{{WP_PLUGIN_DIR}}/really-simple-ssl/core";}','on');
INSERT INTO `wpnc_options` VALUES (24178,'_site_transient_update_plugins','O:8:"stdClass":5:{s:12:"last_checked";i:1766814871;s:8:"response";a:2:{s:23:"elementor/elementor.php";O:8:"stdClass":13:{s:2:"id";s:23:"w.org/plugins/elementor";s:4:"slug";s:9:"elementor";s:6:"plugin";s:23:"elementor/elementor.php";s:11:"new_version";s:6:"3.34.0";s:3:"url";s:40:"https://wordpress.org/plugins/elementor/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip";s:5:"icons";a:2:{s:2:"2x";s:62:"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597";s:2:"1x";s:62:"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597";}s:7:"banners";a:2:{s:2:"2x";s:65:"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133";s:2:"1x";s:64:"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"6.6";s:6:"tested";s:3:"6.9";s:12:"requires_php";s:3:"7.4";s:16:"requires_plugins";a:0:{}}s:39:"jeg-elementor-kit/jeg-elementor-kit.php";O:8:"stdClass":13:{s:2:"id";s:31:"w.org/plugins/jeg-elementor-kit";s:4:"slug";s:17:"jeg-elementor-kit";s:6:"plugin";s:39:"jeg-elementor-kit/jeg-elementor-kit.php";s:11:"new_version";s:5:"3.0.1";s:3:"url";s:48:"https://wordpress.org/plugins/jeg-elementor-kit/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/jeg-elementor-kit.3.0.1.zip";s:5:"icons";a:2:{s:2:"1x";s:62:"https://ps.w.org/jeg-elementor-kit/assets/icon.svg?rev=3378738";s:3:"svg";s:62:"https://ps.w.org/jeg-elementor-kit/assets/icon.svg?rev=3378738";}s:7:"banners";a:2:{s:2:"2x";s:73:"https://ps.w.org/jeg-elementor-kit/assets/banner-1544x500.jpg?rev=3378738";s:2:"1x";s:72:"https://ps.w.org/jeg-elementor-kit/assets/banner-772x250.jpg?rev=3378738";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.0";s:6:"tested";s:5:"6.8.3";s:12:"requires_php";s:3:"7.4";s:16:"requires_plugins";a:1:{i:0;s:9:"elementor";}}}s:12:"translations";a:0:{}s:9:"no_update";a:4:{s:35:"litespeed-cache/litespeed-cache.php";O:8:"stdClass":10:{s:2:"id";s:29:"w.org/plugins/litespeed-cache";s:4:"slug";s:15:"litespeed-cache";s:6:"plugin";s:35:"litespeed-cache/litespeed-cache.php";s:11:"new_version";s:3:"7.7";s:3:"url";s:46:"https://wordpress.org/plugins/litespeed-cache/";s:7:"package";s:62:"https://downloads.wordpress.org/plugin/litespeed-cache.7.7.zip";s:5:"icons";a:2:{s:2:"2x";s:68:"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181";s:2:"1x";s:68:"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181";}s:7:"banners";a:2:{s:2:"2x";s:71:"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181";s:2:"1x";s:70:"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.3";}s:19:"metform/metform.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/metform";s:4:"slug";s:7:"metform";s:6:"plugin";s:19:"metform/metform.php";s:11:"new_version";s:5:"4.1.0";s:3:"url";s:38:"https://wordpress.org/plugins/metform/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/metform.4.1.0.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/metform/assets/icon-256x256.png?rev=3260686";s:2:"1x";s:60:"https://ps.w.org/metform/assets/icon-128x128.png?rev=3260686";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/metform/assets/banner-1544x500.jpg?rev=3260686";s:2:"1x";s:62:"https://ps.w.org/metform/assets/banner-772x250.jpg?rev=3260686";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.0";}s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";O:8:"stdClass":10:{s:2:"id";s:31:"w.org/plugins/really-simple-ssl";s:4:"slug";s:17:"really-simple-ssl";s:6:"plugin";s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";s:11:"new_version";s:5:"9.5.5";s:3:"url";s:48:"https://wordpress.org/plugins/really-simple-ssl/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/really-simple-ssl.9.5.5.zip";s:5:"icons";a:2:{s:2:"2x";s:70:"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720";s:2:"1x";s:70:"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720";}s:7:"banners";a:2:{s:2:"2x";s:73:"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992";s:2:"1x";s:72:"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"6.6";}s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/wpvivid-backuprestore";s:4:"slug";s:21:"wpvivid-backuprestore";s:6:"plugin";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:11:"new_version";s:7:"0.9.122";s:3:"url";s:52:"https://wordpress.org/plugins/wpvivid-backuprestore/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/wpvivid-backuprestore.0.9.122.zip";s:5:"icons";a:2:{s:2:"2x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-256x256.png?rev=2899202";s:2:"1x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-128x128.png?rev=2899202";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/wpvivid-backuprestore/assets/banner-1544x500.png?rev=2899202";s:2:"1x";s:76:"https://ps.w.org/wpvivid-backuprestore/assets/banner-772x250.png?rev=2899202";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.5";}}s:7:"checked";a:8:{s:23:"elementor/elementor.php";s:6:"3.25.3";s:31:"elementor-pro/elementor-pro.php";s:6:"3.26.3";s:39:"jeg-elementor-kit/jeg-elementor-kit.php";s:6:"2.6.11";s:35:"litespeed-cache/litespeed-cache.php";s:3:"7.7";s:19:"metform/metform.php";s:5:"4.1.0";s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";s:5:"9.5.5";s:29:"wpt-whatsapp/wpt-whatsapp.php";s:5:"2.2.5";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:7:"0.9.122";}}','off');
INSERT INTO `wpnc_options` VALUES (24179,'litespeed.conf._version','7.7','auto');
INSERT INTO `wpnc_options` VALUES (24180,'litespeed.conf.optm-ccss_whitelist','[]','auto');
INSERT INTO `wpnc_options` VALUES (24181,'litespeed.conf.media-auto_rescale_ori','','auto');
INSERT INTO `wpnc_options` VALUES (24182,'litespeed.conf.img_optm-sizes_skipped','[]','auto');
INSERT INTO `wpnc_options` VALUES (24183,'litespeed.conf.cdn-cloudflare_clear','','auto');
INSERT INTO `wpnc_options` VALUES (24184,'litespeed.conf.qc-cname','','auto');
INSERT INTO `wpnc_options` VALUES (24185,'litespeed.conf.debug-disable_tmp','0','auto');
INSERT INTO `wpnc_options` VALUES (24186,'_site_transient_timeout_wp_theme_files_patterns-99cc4ad29a19e0f4c0b64aa33bef71f2','1766816780','off');
INSERT INTO `wpnc_options` VALUES (24187,'_site_transient_wp_theme_files_patterns-99cc4ad29a19e0f4c0b64aa33bef71f2','a:2:{s:7:"version";b:0;s:8:"patterns";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24188,'_site_transient_timeout_community-events-b0d00d51dda687a389c7074d0a75ad8f','1766858184','off');
INSERT INTO `wpnc_options` VALUES (24189,'_site_transient_community-events-b0d00d51dda687a389c7074d0a75ad8f','a:4:{s:9:"sandboxed";b:0;s:5:"error";N;s:8:"location";a:1:{s:2:"ip";s:11:"103.52.69.0";}s:6:"events";a:0:{}}','off');
INSERT INTO `wpnc_options` VALUES (24190,'_site_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3','1766858185','off');
INSERT INTO `wpnc_options` VALUES (24191,'_site_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:59:"The latest news about WordPress and the WordPress community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 17:16:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/?v=7.0-alpha-61390";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:29:"https://s.w.org/favicon.ico?2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:40:"2026 Global Partner Program Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/12/2026-global-partner-program/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 17:16:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19534";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:412:"Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community. Why Choose [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Harmony Romo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:11388:"\n<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" fetchpriority="high" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19617" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?w=1600&amp;ssl=1 1600w" sizes="(max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class="wp-block-heading">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class="wp-block-heading">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class="wp-block-heading">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class="wp-block-heading">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class="wp-block-heading">Program Benefits</h3>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td class="has-text-align-left" data-align="left"></td><td class="has-text-align-center" data-align="center"><strong>Global&nbsp;Leader</strong></td><td class="has-text-align-center" data-align="center"><strong>Regional Powerhouse</strong></td><td class="has-text-align-center" data-align="center"><strong>Community Builder</strong></td></tr><tr><td class="has-text-align-left" data-align="left"><br><br><br><br><strong>Best for:<br></strong></td><td class="has-text-align-center" data-align="center">Established brands seeking global reach and year-round visibility.</td><td class="has-text-align-center" data-align="center">Companies aiming for regional dominance and strong brand recognition.</td><td class="has-text-align-center" data-align="center">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class="has-text-align-left" data-align="left">Sponsorship payable in full or through quarterly installments</td><td class="has-text-align-center" data-align="center">$180,000</td><td class="has-text-align-center" data-align="center">$110,000</td><td class="has-text-align-center" data-align="center">$60,000</td></tr><tr><td class="has-text-align-left" data-align="left">Top tier sponsorship benefits at all local <a href="https://central.wordcamp.org/">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Option to feature multiple brands across events</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Dedicated sponsor landing page</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Complimentary WordPress event tickets for your team</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Recognition across all <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href="https://central.wordcamp.org/">WordCamps</a></td><td class="has-text-align-center" data-align="center">Quarterly</td><td class="has-text-align-center" data-align="center">Annually</td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Inclusion of your company logo in signage and materials for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> events</td><td class="has-text-align-center" data-align="center">All signage &amp; materials for the year (digital and printed)</td><td class="has-text-align-center" data-align="center">Signage &amp; materials for 5 events per year (printed only)</td><td class="has-text-align-center" data-align="center">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class="has-text-align-left" data-align="left">Opportunity to be featured in an exclusive digital binder for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> event organizers</td><td class="has-text-align-center" data-align="center">Priority placement (logos &amp; text)</td><td class="has-text-align-center" data-align="center">Feature listing (text only)</td><td class="has-text-align-center" data-align="center">Feature listing (text only)</td></tr><tr><td class="has-text-align-left" data-align="left">Regular recognition in <a href="https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/">monthly education buzz report</a></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class="wp-block-heading">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class="wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained" style="padding-top:var(--wp--preset--spacing--edge-space);padding-right:var(--wp--preset--spacing--edge-space);padding-bottom:var(--wp--preset--spacing--edge-space);padding-left:var(--wp--preset--spacing--edge-space)">\n<p class="has-text-align-center"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="mailto:support@wordcamp.org">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div style="height:25px" aria-hidden="true" class="wp-block-spacer"></div>\n\n\n\n<p><em>Please see&nbsp;<a href="https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials">Rules for Sponsor Materials</a>&nbsp;for more details about terms of sponsorship. Please also see our&nbsp;<a href="https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf" target="_blank" rel="noreferrer noopener">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href="https://wordpressfoundation.org/donate/">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19534";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:65:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"State of the Word 2025: Innovation Shaped by Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://wordpress.org/news/2025/12/sotw-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 18:26:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:17:"state of the word";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19447";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:354:"State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"enclosure";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"url";s:59:"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4";s:6:"length";s:8:"29136831";s:4:"type";s:9:"video/mp4";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"url";s:53:"https://wordpress.org/news/files/2025/12/wapu-513.mp4";s:6:"length";s:9:"102323371";s:4:"type";s:9:"video/mp4";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"Nicholas Garofalo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:36376:"\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe title="State of the Word 2025" width="500" height="281" src="https://www.youtube.com/embed/U_DF4-23C8Q?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href="https://wordpress.org/book/2015/11/wordcamp-2006/"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1" alt="Globe graphic noting 43% of websites and 60.5% CMS market share" class="wp-image-19500" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="(max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class="wp-block-heading">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href="https://wordpress.org/download/releases/6-9/">WordPress 6.9</a>.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1" alt="WordPress 6.9 Gene album cover art" class="wp-image-19511" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation.&nbsp;</p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1" alt="Photo of WordPress release leads pressing the button to release 6.9" class="wp-image-19457" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href="https://en.wikipedia.org/wiki/WordPress#History">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1" alt="Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere" class="wp-image-19510" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href="https://telex.automattic.ai/">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class="wp-block-video"><video height="2160" style="aspect-ratio: 3840 / 2160;" width="3840" controls src="https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19503" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href="https://wordpress.org/education/campus-connect/">Campus Connect</a> and <a href="https://wordpress.org/education/credits/">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href="https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19505" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><figcaption class="wp-element-caption">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1" alt="Various Wapuu artwork examples" class="wp-image-19506" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href="https://events.wordpress.org/managua/2025/wordpress-youth-day/">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class="wp-block-video"><video height="2160" style="aspect-ratio: 3840 / 2160;" width="3840" controls src="https://wordpress.org/news/files/2025/12/wapu-513.mp4"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class="wp-block-heading">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href="https://profiles.wordpress.org/matveb/">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordPress 6.9 Feature Demo" width="500" height="281" src="https://www.youtube.com/embed/vkYulcN0lbc?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class="wp-block-list">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href="https://wordpress.org/plugins/plugin-check/">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href="https://wordpress.org/data-liberation/">Data Liberation</a>, noting improvements to the <a href="https://wordpress.org/plugins/wordpress-importer/">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href="https://playground.wordpress.net/">Playground</a> ecosystem, including <a href="https://developer.wordpress.com/studio/">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> (Automattic), <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> (Google), and <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="572" src="https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1" alt="" class="wp-image-19462" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1024%2C572&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=300%2C168&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=768%2C429&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1536%2C858&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=2048%2C1144&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><figcaption class="wp-element-caption">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class="wp-block-heading">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1" alt="Q&amp;A" class="wp-image-19512" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href="https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class="wp-block-heading">TBPN Podcast Appearance</h2>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="&#x1f534; CODE RED &#x1f534;, Dell Donates Size, Bun Acquired, AWS CEO Joins, Tae Kim Tells All" width="500" height="281" src="https://www.youtube.com/embed/eBQh57HuJzk?start=10036&#038;feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href="https://www.beeper.com/">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class="wp-block-heading">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class="wp-block-heading">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href="https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia</a> in Mumbai, India,<a href="https://europe.wordcamp.org/2026/">WordCamp Europe</a> in Kraków, Poland, and <a href="https://us.wordcamp.org/2026/">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19447";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:66:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"WordPress 6.9 “Gene”";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/news/2025/12/gene/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 02 Dec 2025 20:12:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19398";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:495:"WordPress 6.9, code-named "Gene," brings major upgrades to how teams collaborate and create. The Notes feature introduces block-level commenting to streamline reviewing and polishing content, navigating across the entire dashboard with the Command Palette is now faster for power users, and the new Abilities API provides a standardized way to open the door for AI-powered and automated workflows. Combined with all the performance and accessibility improvements, 6.9 is one to write home about.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:79691:"\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="535" src="https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1" alt="WordPress 6.9 Release Edition Featured Image" class="wp-image-19404" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=2048%2C1070&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris.&nbsp;</p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class="wp-block-heading">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href="https://wordpress.org/wordpress-6.9.zip">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class="wp-block-heading">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1" alt="View of people interacting with notes in a post." class="wp-image-19428" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1" alt="Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts." class="wp-image-19430" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1" alt="&quot;Novem&quot; text selected and stretching across the interface." class="wp-image-19431" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="632" src="https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1" alt="Abstract view of circles around a plugin icon with sparkles, indicating AI functionality." class="wp-image-19432" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=768%2C474&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?w=1360&amp;ssl=1 1360w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class="wp-block-heading">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class="wp-block-heading">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href="https://wordpress.org/download/releases/6-9">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class="wp-block-heading">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href="https://learn.wordpress.org/">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href="https://learn.wordpress.org/social-learning/">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href="https://wordpress.org/documentation/wordpress-version/version-6.9">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href="https://make.wordpress.org/core/wordpress-6-9-field-guide/">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class="wp-block-heading">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class="wp-block-list">\n<li>Release Lead: <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a>, <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a>, <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a>, <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a>, <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href="https://wordpress.org/about/">democratize publishing</a> and embody the <a href="https://opensource.org/osd-annotated">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class="has-small-font-size"><a href="https://profiles.wordpress.org/o-o/">2046</a> · <a href="https://profiles.wordpress.org/aakashverma1/">Aakash Verma</a> · <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a> · <a href="https://profiles.wordpress.org/aaronrobertshaw/">Aaron Robertshaw</a> · <a href="https://profiles.wordpress.org/aarti1318/">Aarti Chauhan</a> · <a href="https://profiles.wordpress.org/thehercules/">Aashish Sharma</a> · <a href="https://profiles.wordpress.org/aatospaja/">aatospaja</a> · <a href="https://profiles.wordpress.org/abduremon/">Abdur Rahman Emon</a> · <a href="https://profiles.wordpress.org/hurayraiit/">Abu Hurayra</a> · <a href="https://profiles.wordpress.org/kawauso/">Adam Harley (Kawauso)</a> · <a href="https://profiles.wordpress.org/adamsilverstein/">Adam Silverstein</a> · <a href="https://profiles.wordpress.org/zieladam/">Adam Zieliński</a> · <a href="https://profiles.wordpress.org/adityab98/">Aditya Bansode</a> · <a href="https://profiles.wordpress.org/b1ink0/">Aditya Dhade</a> · <a href="https://profiles.wordpress.org/adityashah2411/">aditya shah</a> · <a href="https://profiles.wordpress.org/iamadisingh/">Aditya Singh</a> · <a href="https://profiles.wordpress.org/aduth/">aduth</a> · <a href="https://profiles.wordpress.org/agulbra/">agulbra</a> · <a href="https://profiles.wordpress.org/elazzabi/">Ahmed</a> · <a href="https://profiles.wordpress.org/chaion07/">Ahmed Kabir Chaion</a> · <a href="https://profiles.wordpress.org/ajaxstardust/">ajaxStardust</a> · <a href="https://profiles.wordpress.org/ajitbohra/">Ajit Bohra</a> · <a href="https://profiles.wordpress.org/akanshusingh/">Akanshu Singh</a> · <a href="https://profiles.wordpress.org/akeda/">Akeda Bagus</a> · <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a> · <a href="https://profiles.wordpress.org/atachibana/">Akira Tachibana</a> · <a href="https://profiles.wordpress.org/wpfy/">Akramul Hasan</a> · <a href="https://profiles.wordpress.org/akshat2802/">Akshat Kakkad</a> · <a href="https://profiles.wordpress.org/akshaydhere/">Akshay Dhere</a> · <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a> · <a href="https://profiles.wordpress.org/aljullu/">Albert Juh&#233; Lluveras</a> · <a href="https://profiles.wordpress.org/alejandrogonzalvo/">alejandrogonzalvo</a> · <a href="https://profiles.wordpress.org/alexcu21/">Alex Cuadra</a> · <a href="https://profiles.wordpress.org/ajlende/">Alex Lende</a> · <a href="https://profiles.wordpress.org/alexclassroom/">Alex Lion (阿力獅)</a> · <a href="https://profiles.wordpress.org/alexstine/">Alex Stine</a> · <a href="https://profiles.wordpress.org/alexandrebuffet/">Alexandre Buffet</a> · <a href="https://profiles.wordpress.org/alexus450/">Alexei Samarschi</a> · <a href="https://profiles.wordpress.org/alexius08/">Alexis Pandaan</a> · <a href="https://profiles.wordpress.org/alordiel/">alordiel</a> · <a href="https://profiles.wordpress.org/mrfoxtalbot/">Alvaro G&#243;mez</a> · <a href="https://profiles.wordpress.org/alh0319/">Amber Hinds</a> · <a href="https://profiles.wordpress.org/amin7/">Amin</a> · <a href="https://profiles.wordpress.org/theaminuldev/">Aminul Islam</a> · <a href="https://profiles.wordpress.org/aialvi/">Aminul Islam Alvi</a> · <a href="https://profiles.wordpress.org/amitbhosale/">Amit Bhosale</a> · <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a> · <a href="https://profiles.wordpress.org/anatolbroder/">Anatol Broder</a> · <a href="https://profiles.wordpress.org/anlino/">Anders Nor&#233;n</a> · <a href="https://profiles.wordpress.org/afercia/">Andrea Fercia</a> · <a href="https://profiles.wordpress.org/awetz583/">Andrea Roenning</a> · <a href="https://profiles.wordpress.org/andraganescu/">Andrei Draganescu</a> · <a href="https://profiles.wordpress.org/andrewhoyer/">Andrew Hoyer</a> · <a href="https://profiles.wordpress.org/nacin/">Andrew Nacin</a> · <a href="https://profiles.wordpress.org/azaozz/">Andrew Ozz</a> · <a href="https://profiles.wordpress.org/andrewserong/">Andrew Serong</a> · <a href="https://profiles.wordpress.org/oandregal/">André Maneiro</a> · <a href="https://profiles.wordpress.org/afragen/">Andy Fragen</a> · <a href="https://profiles.wordpress.org/mymothersdaughter/">Anita C</a> · <a href="https://profiles.wordpress.org/ankit-k-gupta/">Ankit K Gupta</a> · <a href="https://profiles.wordpress.org/ankitkumarshah/">Ankit Kumar Shah</a> · <a href="https://profiles.wordpress.org/ankitmaru/">Ankit Panchal</a> · <a href="https://profiles.wordpress.org/annezazu/">Anne McCarthy</a> · <a href="https://profiles.wordpress.org/annebovelett/">Anne-Mieke Bovelett</a> · <a href="https://profiles.wordpress.org/antonvlasenko/">Anton Vlasenko</a> · <a href="https://profiles.wordpress.org/antoniosejas/">Antonio Sejas</a> · <a href="https://profiles.wordpress.org/anujrathore24/">Anuj Singh</a> · <a href="https://profiles.wordpress.org/anveshika/">Anveshika Srivastava</a> · <a href="https://profiles.wordpress.org/apmeyer/">apmeyer</a> · <a href="https://profiles.wordpress.org/aristath/">Ari Stathopoulos</a> · <a href="https://profiles.wordpress.org/fliespl/">Arkadiusz Rzadkowolski</a> · <a href="https://profiles.wordpress.org/armandovias/">Armando</a> · <a href="https://profiles.wordpress.org/artemiosans/">Artemio Morales</a> · <a href="https://profiles.wordpress.org/arthur791004/">Arthur Chu</a> · <a href="https://profiles.wordpress.org/artpi/">Artur Piszek</a> · <a href="https://profiles.wordpress.org/artz91/">ArtZ91</a> · <a href="https://profiles.wordpress.org/asafm7/">asafm7</a> · <a href="https://profiles.wordpress.org/asdofindia/">asdofindia</a> · <a href="https://profiles.wordpress.org/ashfame/">Ashish Kumar (Ashfame)</a> · <a href="https://profiles.wordpress.org/akashdev/">Ashraful Haque Akash</a> · <a href="https://profiles.wordpress.org/askapache/">askapache</a> · <a href="https://profiles.wordpress.org/aslamdoctor/">Aslam Doctor</a> · <a href="https://profiles.wordpress.org/aurooba/">Aurooba Ahmed</a> · <a href="https://profiles.wordpress.org/aut0poietic/">aut0poietic</a> · <a href="https://profiles.wordpress.org/aksl95/">Axel DUCORON</a> · <a href="https://profiles.wordpress.org/ayeshrajans/">Ayesh Karunaratne</a> · <a href="https://profiles.wordpress.org/azharderaiya/">Azhar Deraiya</a> · <a href="https://profiles.wordpress.org/beryldlg/">B&#233;ryl de La Grandi&#232;re</a> · <a href="https://profiles.wordpress.org/bartnv/">bartnv</a> · <a href="https://profiles.wordpress.org/bchecketts/">bchecketts</a> · <a href="https://profiles.wordpress.org/beee/">Beee</a> · <a href="https://profiles.wordpress.org/scruffian/">Ben Dwyer</a> · <a href="https://profiles.wordpress.org/benazeer/">Benazeer</a> · <a href="https://profiles.wordpress.org/rainbowgeek/">Benjamin Denis</a> · <a href="https://profiles.wordpress.org/benjamin_zekavica/">Benjamin Zekavica</a> · <a href="https://profiles.wordpress.org/bvl/">Benny</a> · <a href="https://profiles.wordpress.org/benoitchantre/">Benoit Chantre</a> · <a href="https://profiles.wordpress.org/kau-boy/">Bernhard Kau</a> · <a href="https://profiles.wordpress.org/bernhard reiter/">Bernhard Reiter</a> · <a href="https://profiles.wordpress.org/bernhard-reiter/">Bernie Reiter</a> · <a href="https://profiles.wordpress.org/bgermann/">bgermann</a> · <a href="https://profiles.wordpress.org/bhattaganesh/">bhattaganesh</a> · <a href="https://profiles.wordpress.org/bhaveshdesai/">Bhavesh Desai</a> · <a href="https://profiles.wordpress.org/bidbmak/">BiDbMAK</a> · <a href="https://profiles.wordpress.org/mbigul/">Bigul Malayi</a> · <a href="https://profiles.wordpress.org/birgire/">Birgir Erlendsson (birgire)</a> · <a href="https://profiles.wordpress.org/bph/">Birgit Pauli-Haack</a> · <a href="https://profiles.wordpress.org/rainynewt/">Bishal Shrestha</a> · <a href="https://profiles.wordpress.org/bobbyleenoblestudios/">bobbyleenoblestudios</a> · <a href="https://profiles.wordpress.org/bogdanungureanu/">BogdanUngureanu</a> · <a href="https://profiles.wordpress.org/gitlost/">bonger</a> · <a href="https://profiles.wordpress.org/bor0/">Boro Sitnikovski</a> · <a href="https://profiles.wordpress.org/burlesonbrad/">Brad Griffin</a> · <a href="https://profiles.wordpress.org/bradley2083/">brad hogan</a> · <a href="https://profiles.wordpress.org/bjorsch/">Brad Jorsch</a> · <a href="https://profiles.wordpress.org/bradshawtm/">bradshawtm</a> · <a href="https://profiles.wordpress.org/bhubbard/">Brandon Hubbard</a> · <a href="https://profiles.wordpress.org/kraftbj/">Brandon Kraft</a> · <a href="https://profiles.wordpress.org/heybran/">Brandon Zhang</a> · <a href="https://profiles.wordpress.org/bgoewert/">Brennan Goewert</a> · <a href="https://profiles.wordpress.org/brhodes/">brhodes</a> · <a href="https://profiles.wordpress.org/ironprogrammer/">Brian Alexander</a> · <a href="https://profiles.wordpress.org/bacoords/">Brian Coords</a> · <a href="https://profiles.wordpress.org/bgardner/">Brian Gardner</a> · <a href="https://profiles.wordpress.org/masteradhoc/">Brian Haas</a> · <a href="https://profiles.wordpress.org/brumack/">brumack</a> · <a href="https://profiles.wordpress.org/bschneidewind/">Bryan Schneidewind</a> · <a href="https://profiles.wordpress.org/bshuchter/">bshuchter</a> · <a href="https://profiles.wordpress.org/burnuser/">burnuser</a> · <a href="https://profiles.wordpress.org/byteninjaa0/">byteninjaa0</a> · <a href="https://profiles.wordpress.org/cedche99/">C&#233;dric Chevillard</a> · <a href="https://profiles.wordpress.org/callumbw95/">Callum Bridgford-Whittick</a> · <a href="https://profiles.wordpress.org/snicco/">Calvin Alkan</a> · <a href="https://profiles.wordpress.org/karl94/">Carlo Cannas</a> · <a href="https://profiles.wordpress.org/cbravobernal/">Carlos Bravo</a> · <a href="https://profiles.wordpress.org/carlosgprim/">Carlos G. P.</a> · <a href="https://profiles.wordpress.org/carlsteffen/">CarlSteffen</a> · <a href="https://profiles.wordpress.org/poena/">Carolina Nymark</a> · <a href="https://profiles.wordpress.org/corazondejaguar/">Carolina Romo</a> · <a href="https://profiles.wordpress.org/ciobanucatalin/">Catalin Ciobanu</a> · <a href="https://profiles.wordpress.org/catgofire/">catgofire</a> · <a href="https://profiles.wordpress.org/cbirdsong/">cbirdsong</a> · <a href="https://profiles.wordpress.org/ccharel/">ccharel</a> · <a href="https://profiles.wordpress.org/cbutlerjr/">Chad Butler</a> · <a href="https://profiles.wordpress.org/shireling/">Chad Chadbourne</a> · <a href="https://profiles.wordpress.org/cherrygot/">Chakrapani Gautam</a> · <a href="https://profiles.wordpress.org/chihsuan/">Chi-Hsuan Huang</a> · <a href="https://profiles.wordpress.org/chillifish/">Chillifish</a> · <a href="https://profiles.wordpress.org/chloed/">ChloeD</a> · <a href="https://profiles.wordpress.org/chouby/">Chouby</a> · <a href="https://profiles.wordpress.org/czarate/">Chris Zarate</a> · <a href="https://profiles.wordpress.org/chriscct7/">chriscct7</a> · <a href="https://profiles.wordpress.org/chrisdotdotdot/">chrisdotdotdot</a> · <a href="https://profiles.wordpress.org/chrismattix/">chrismattix</a> · <a href="https://profiles.wordpress.org/christinecooper/">christinecooper</a> · <a href="https://profiles.wordpress.org/apermo/">Christoph Daum</a> · <a href="https://profiles.wordpress.org/nyiriland/">Christy Nyiri</a> · <a href="https://profiles.wordpress.org/cikrimcin/">cikrimcin</a> · <a href="https://profiles.wordpress.org/butterflymedia/">Ciprian Popescu</a> · <a href="https://profiles.wordpress.org/chrisvendiadvertisingcom/">cjhaas</a> · <a href="https://profiles.wordpress.org/ckoerner/">ckoerner</a> · <a href="https://profiles.wordpress.org/claimableperch/">claimableperch</a> · <a href="https://profiles.wordpress.org/codeamp/">Code Amp</a> · <a href="https://profiles.wordpress.org/codebuddy/">codebuddy</a> · <a href="https://profiles.wordpress.org/coleatkinson1/">coleatkinson1</a> · <a href="https://profiles.wordpress.org/costdev/">Colin Stewart</a> · <a href="https://profiles.wordpress.org/colind/">ColinD</a> · <a href="https://profiles.wordpress.org/ogrecooper/">Cooper Dalrymple</a> · <a href="https://profiles.wordpress.org/coralietixeront/">Coralie Tixeront</a> · <a href="https://profiles.wordpress.org/salzano/">Corey Salzano</a> · <a href="https://profiles.wordpress.org/coreyw/">Corey Worrell</a> · <a href="https://profiles.wordpress.org/cornwell/">Cornwell</a> · <a href="https://profiles.wordpress.org/cr0ybot/">Cory Hughart</a> · <a href="https://profiles.wordpress.org/courane01/">Courtney Robertson</a> · <a href="https://profiles.wordpress.org/cucocreative/">cucocreative</a> · <a href="https://profiles.wordpress.org/cwhitmore/">Cullen Whitmore</a> · <a href="https://profiles.wordpress.org/cyrille37/">Cyrille37</a> · <a href="https://profiles.wordpress.org/daanvandenbergh/">Daan van den Bergh</a> · <a href="https://profiles.wordpress.org/acketon/">Dakota Chichester</a> · <a href="https://profiles.wordpress.org/damchtlv/">damchtlv</a> · <a href="https://profiles.wordpress.org/damir-webthemer/">Damir</a> · <a href="https://profiles.wordpress.org/colorful-tones/">Damon Cook</a> · <a href="https://profiles.wordpress.org/dancameron/">Dan Cameron</a> · <a href="https://profiles.wordpress.org/danielpw/">Dan Waldschmidt</a> · <a href="https://profiles.wordpress.org/danielbachhuber/">Daniel Bachhuber</a> · <a href="https://profiles.wordpress.org/danieliser/">Daniel Iser</a> · <a href="https://profiles.wordpress.org/talldanwp/">Daniel Richards</a> · <a href="https://profiles.wordpress.org/mte90/">Daniele Scasciafratte</a> · <a href="https://profiles.wordpress.org/daniellacatus/">daniellacatus</a> · <a href="https://profiles.wordpress.org/danielmorell/">danielmorell</a> · <a href="https://profiles.wordpress.org/dscqbus/">Danny Schmarsel</a> · <a href="https://profiles.wordpress.org/dannyreaktiv/">dannyreaktiv</a> · <a href="https://profiles.wordpress.org/nerrad/">Darren Ethier (nerrad)</a> · <a href="https://profiles.wordpress.org/darshitrajyaguru97/">Darshit Rajyaguru</a> · <a href="https://profiles.wordpress.org/dryanpress/">Dave Ryan</a> · <a href="https://profiles.wordpress.org/daveguitaruno/">daveguitaruno</a> · <a href="https://profiles.wordpress.org/davilera/">David Aguilera</a> · <a href="https://profiles.wordpress.org/darerodz/">David Arenas</a> · <a href="https://profiles.wordpress.org/dartiss/">David Artiss</a> · <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a> · <a href="https://profiles.wordpress.org/dpcalhoun/">David Calhoun</a> · <a href="https://profiles.wordpress.org/dlh/">David Herrera</a> · <a href="https://profiles.wordpress.org/justlevine/">David Levine</a> · <a href="https://profiles.wordpress.org/davidperez/">David Perez</a> · <a href="https://profiles.wordpress.org/djivad/">David Riviera</a> · <a href="https://profiles.wordpress.org/get_dave/">David Smith</a> · <a href="https://profiles.wordpress.org/davidb/">DavidB</a> · <a href="https://profiles.wordpress.org/dawidadach/">dawidadach</a> · <a href="https://profiles.wordpress.org/dsas/">Dean Sas</a> · <a href="https://profiles.wordpress.org/dkarfa/">Debabrata Karfa</a> · <a href="https://profiles.wordpress.org/debarghyabanerjee/">DEBARGHYA BANERJEE</a> · <a href="https://profiles.wordpress.org/denis-de-bernardy/">Denis de Bernardy</a> · <a href="https://profiles.wordpress.org/dingo_d/">Denis Žoljom</a> · <a href="https://profiles.wordpress.org/realloc/">Dennis Ploetner</a> · <a href="https://profiles.wordpress.org/dmsnell/">Dennis Snell</a> · <a href="https://profiles.wordpress.org/dennysdionigi/">Dennys Dionigi</a> · <a href="https://profiles.wordpress.org/densinakum/">Densi Nakum</a> · <a href="https://profiles.wordpress.org/derekherman/">derekherman</a> · <a href="https://profiles.wordpress.org/devasheeshkaul/">Devasheesh Kaul</a> · <a href="https://profiles.wordpress.org/dhananjaykuber/">Dhananjay Kuber</a> · <a href="https://profiles.wordpress.org/dhrumilk/">Dhrumil Kumbhani</a> · <a href="https://profiles.wordpress.org/dhruval04/">Dhruval Shah</a> · <a href="https://profiles.wordpress.org/dhruvang21/">Dhruvang21</a> · <a href="https://profiles.wordpress.org/dhruvik18/">Dhruvik Malaviya</a> · <a href="https://profiles.wordpress.org/diebombe/">diebombe</a> · <a href="https://profiles.wordpress.org/dilipbheda/">Dilip Bheda</a> · <a href="https://profiles.wordpress.org/dilip2615/">Dilip Modhavadiya</a> · <a href="https://profiles.wordpress.org/dd32/">Dion Hulse</a> · <a href="https://profiles.wordpress.org/divinenephron/">divinenephron</a> · <a href="https://profiles.wordpress.org/djcowan/">dj.cowan</a> · <a href="https://profiles.wordpress.org/ocean90/">Dominik Schilling</a> · <a href="https://profiles.wordpress.org/dominiquepijnenburg/">dominiquepijnenburg</a> · <a href="https://profiles.wordpress.org/donalirl/">donalirl</a> · <a href="https://profiles.wordpress.org/doughamlin/">doughamlin</a> · <a href="https://profiles.wordpress.org/dougmelvin/">DougMelvin</a> · <a href="https://profiles.wordpress.org/drawcard/">drawcard</a> · <a href="https://profiles.wordpress.org/dretzlaff/">dretzlaff</a> · <a href="https://profiles.wordpress.org/drewapicture/">Drew Jaynes</a> · <a href="https://profiles.wordpress.org/drivingralle/">Drivingralle</a> · <a href="https://profiles.wordpress.org/dsawyers/">dsawyers</a> · <a href="https://profiles.wordpress.org/dustintechsmith/">dustintechsmith</a> · <a href="https://profiles.wordpress.org/eclev91/">eclev91</a> · <a href="https://profiles.wordpress.org/eduwass/">eduwass</a> · <a href="https://profiles.wordpress.org/ehti/">Ehti</a> · <a href="https://profiles.wordpress.org/elialum/">elialum</a> · <a href="https://profiles.wordpress.org/eliezerspp/">Eliezer Pe&#241;a</a> · <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a> · <a href="https://profiles.wordpress.org/elvismdev/">Elvis Morales</a> · <a href="https://profiles.wordpress.org/emaildano/">emaildano</a> · <a href="https://profiles.wordpress.org/codex-m/">Emerson Maningo</a> · <a href="https://profiles.wordpress.org/emlebrun/">Emilie LEBRUN</a> · <a href="https://profiles.wordpress.org/emranahmed/">Emran Ahmed</a> · <a href="https://profiles.wordpress.org/enaanfarhan/">Enaan Farhan</a> · <a href="https://profiles.wordpress.org/lopo/">Enrico Battocchi</a> · <a href="https://profiles.wordpress.org/nrqsnchz/">Enrique S&#225;nchez</a> · <a href="https://profiles.wordpress.org/epeicher/">epeicher</a> · <a href="https://profiles.wordpress.org/ekazda/">Eric</a> · <a href="https://profiles.wordpress.org/ericlewis/">Eric Andrew Lewis</a> · <a href="https://profiles.wordpress.org/ethitter/">Erick Hitter</a> · <a href="https://profiles.wordpress.org/kebbet/">Erik</a> · <a href="https://profiles.wordpress.org/ejoling/">Erik Joling</a> · <a href="https://profiles.wordpress.org/im3dabasia1/">Eshaan Dabasiya</a> · <a href="https://profiles.wordpress.org/ethanscorey/">ethanscorey</a> · <a href="https://profiles.wordpress.org/circlecube/">Evan Mullins</a> · <a href="https://profiles.wordpress.org/etobiesen/">Even Tobiesen</a> · <a href="https://profiles.wordpress.org/fabiankaegy/">Fabian Kägy</a> · <a href="https://profiles.wordpress.org/gaambo/">Fabian Todt</a> · <a href="https://profiles.wordpress.org/faisalahammad/">Faisal Ahammad</a> · <a href="https://profiles.wordpress.org/faisal03/">Faisal Alvi</a> · <a href="https://profiles.wordpress.org/fakhriaz/">fakhriaz</a> · <a href="https://profiles.wordpress.org/falgunihdesai/">Falguni Desai</a> · <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> · <a href="https://profiles.wordpress.org/ffffelix/">Felix Renicks</a> · <a href="https://profiles.wordpress.org/fellyph/">Fellyph Cintra</a> · <a href="https://profiles.wordpress.org/mista-flo/">Florian TIAR</a> · <a href="https://profiles.wordpress.org/frantorres/">Francisco Torres</a> · <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a> · <a href="https://profiles.wordpress.org/frogdesk/">FrogDesk Strategy</a> · <a href="https://profiles.wordpress.org/takahashi_fumiki/">Fumiki Takahashi</a> · <a href="https://profiles.wordpress.org/gaeldenysiak/">Gael Denysiak</a> · <a href="https://profiles.wordpress.org/gajendrasingh/">Gajendra Singh</a> · <a href="https://profiles.wordpress.org/ecgan/">Gan Eng Chin</a> · <a href="https://profiles.wordpress.org/garrett-eclipse/">Garrett Hyder</a> · <a href="https://profiles.wordpress.org/garyj/">Gary Jones</a> · <a href="https://profiles.wordpress.org/pento/">Gary Pendergast</a> · <a href="https://profiles.wordpress.org/guddu1315/">Gaurang Dabhi</a> · <a href="https://profiles.wordpress.org/gautam23/">Gautam Mehta</a> · <a href="https://profiles.wordpress.org/soulseekah/">Gennady Kovshenin</a> · <a href="https://profiles.wordpress.org/mamaduka/">George Mamadashvili</a> · <a href="https://profiles.wordpress.org/georgestephanis/">George Stephanis</a> · <a href="https://profiles.wordpress.org/stoyanovgs/">Georgi Stoyanov</a> · <a href="https://profiles.wordpress.org/gernberg/">gernberg</a> · <a href="https://profiles.wordpress.org/giuliorubelli/">giuliorubelli</a> · <a href="https://profiles.wordpress.org/glendaviesnz/">Glen Davies</a> · <a href="https://profiles.wordpress.org/ingeniumed/">Gopal Krishnan</a> · <a href="https://profiles.wordpress.org/grantmkin/">Grant M. Kinney</a> · <a href="https://profiles.wordpress.org/gziolo/">Greg Ziółkowski</a> · <a href="https://profiles.wordpress.org/guido07111975/">Guido</a> · <a href="https://profiles.wordpress.org/wido/">Guido Scialfa</a> · <a href="https://profiles.wordpress.org/guillaumeturpin/">Guillaume TURPIN</a> · <a href="https://profiles.wordpress.org/gulamdastgir04/">Gulamdastgir Momin</a> · <a href="https://profiles.wordpress.org/adrock42/">H. Adam Lenz</a> · <a href="https://profiles.wordpress.org/kabir93/">H. Kabir</a> · <a href="https://profiles.wordpress.org/hanimbarek/">hanimbarek</a> · <a href="https://profiles.wordpress.org/hanneslsm/">hanneslsm</a> · <a href="https://profiles.wordpress.org/hage/">Hans-Gerd Gerhards</a> · <a href="https://profiles.wordpress.org/hardik2221/">Hardik Raval</a> · <a href="https://profiles.wordpress.org/hareesh-pillai/">Hareesh S</a> · <a href="https://profiles.wordpress.org/harshgajipara/">Harsh Gajipara</a> · <a href="https://profiles.wordpress.org/harshalkadu/">Harshal Kadu</a> · <a href="https://profiles.wordpress.org/harshbhonsle08/">harshbhonsle08</a> · <a href="https://profiles.wordpress.org/harshdeepgill/">harshdeepgill</a> · <a href="https://profiles.wordpress.org/haruncpi/">Harun</a> · <a href="https://profiles.wordpress.org/helen/">Helen Hou-Sandi</a> · <a href="https://profiles.wordpress.org/helgatheviking/">HelgaTheViking</a> · <a href="https://profiles.wordpress.org/hideishi/">Hidenori ISHIKAWA</a> · <a href="https://profiles.wordpress.org/hilayt24/">Hilay Trivedi</a> · <a href="https://profiles.wordpress.org/panchalhimani711/">Himani Panchal</a> · <a href="https://profiles.wordpress.org/abcd95/">Himanshu Pathak</a> · <a href="https://profiles.wordpress.org/hiroshisato/">Hiroshi Sato</a> · <a href="https://profiles.wordpress.org/hbhalodia/">Hit Bhalodia</a> · <a href="https://profiles.wordpress.org/hitendra-chopda/">Hitendra Chopda</a> · <a href="https://profiles.wordpress.org/hiteshtalpada/">Hitesh Talpada</a> · <a href="https://profiles.wordpress.org/hozefasmile/">Hozefa Saleh</a> · <a href="https://profiles.wordpress.org/hrohh/">Hrohh</a> · <a href="https://profiles.wordpress.org/hugod/">hugod</a> · <a href="https://profiles.wordpress.org/hugosolar/">hugosolar</a> · <a href="https://profiles.wordpress.org/humanify/">humanify</a> · <a href="https://profiles.wordpress.org/huubl/">huubl</a> · <a href="https://profiles.wordpress.org/huzaifaalmesbah/">Huzaifa Al Mesbah</a> · <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a> · <a href="https://profiles.wordpress.org/iandunn/">Ian Dunn</a> · <a href="https://profiles.wordpress.org/ignatiusjeroe/">ignatiusjeroe</a> · <a href="https://profiles.wordpress.org/igorradovanov/">Igor Radovanov</a> · <a href="https://profiles.wordpress.org/ikriv/">ikriv</a> · <a href="https://profiles.wordpress.org/imokweb/">imokweb</a> · <a href="https://profiles.wordpress.org/imranhasanraaz/">Imran</a> · <a href="https://profiles.wordpress.org/indirabiswas27/">Indira Biswas</a> · <a href="https://profiles.wordpress.org/ipstenu/">Ipstenu (Mika Epstein)</a> · <a href="https://profiles.wordpress.org/iqbal1hossain/">Iqbal Hossain</a> · <a href="https://profiles.wordpress.org/isabel_brison/">Isabel Brison</a> · <a href="https://profiles.wordpress.org/ishikaatxecurify/">Ishika Bansal</a> · <a href="https://profiles.wordpress.org/ivanottinger/">Ivan Ottinger</a> · <a href="https://profiles.wordpress.org/jabe/">Jabe</a> · <a href="https://profiles.wordpress.org/jacobcassidy/">Jacob Cassidy</a> · <a href="https://profiles.wordpress.org/jagirbahesh/">Jagir Bahesh</a> · <a href="https://profiles.wordpress.org/jaiminp/">Jaimin Prajapati</a> · <a href="https://profiles.wordpress.org/jakariaistauk/">Jakaria Istauk</a> · <a href="https://profiles.wordpress.org/whyisjake/">Jake Spurlock</a> · <a href="https://profiles.wordpress.org/jakeparis/">jakeparis</a> · <a href="https://profiles.wordpress.org/jameskoster/">James Koster</a> · <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> · <a href="https://profiles.wordpress.org/jhmonroe/">James Monroe</a> · <a href="https://profiles.wordpress.org/q0rban/">James Sansbury</a> · <a href="https://profiles.wordpress.org/jamestitus299/">James Titus</a> · <a href="https://profiles.wordpress.org/codente/">Jamie</a> · <a href="https://profiles.wordpress.org/jamieburchell/">Jamie Burchell</a> · <a href="https://profiles.wordpress.org/jamesmarsland/">Jamie Marsland</a> · <a href="https://profiles.wordpress.org/janthiel/">janthiel</a> · <a href="https://profiles.wordpress.org/jsnajdr/">Jarda Snajdr</a> · <a href="https://profiles.wordpress.org/jarekmorawski/">jarekmorawski</a> · <a href="https://profiles.wordpress.org/jasalt/">Jarkko Saltiola</a> · <a href="https://profiles.wordpress.org/jason_the_adams/">Jason Adams</a> · <a href="https://profiles.wordpress.org/madtownlems/">Jason LeMahieu (MadtownLems)</a> · <a href="https://profiles.wordpress.org/jasonsa19/">Jason Sauerwald</a> · <a href="https://profiles.wordpress.org/javiercasares/">Javier Casares</a> · <a href="https://profiles.wordpress.org/jonmcpartland/">Jay McPartland</a> · <a href="https://profiles.wordpress.org/shovan_jaya/">Jayaram</a> · <a href="https://profiles.wordpress.org/jdahir0789/">Jaydip</a> · <a href="https://profiles.wordpress.org/audrasjb/">Jean-Baptiste Audras</a> · <a href="https://profiles.wordpress.org/krokodok/">Jeff Chi</a> · <a href="https://profiles.wordpress.org/jeffmatson/">Jeff Matson</a> · <a href="https://profiles.wordpress.org/jffng/">Jeff Ong</a> · <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> · <a href="https://profiles.wordpress.org/cheffheid/">Jeffrey de Wit</a> · <a href="https://profiles.wordpress.org/jeffr0/">Jeffro</a> · <a href="https://profiles.wordpress.org/jeflopodev/">jeflopo</a> · <a href="https://profiles.wordpress.org/jdy68/">Jenny Dupuy</a> · <a href="https://profiles.wordpress.org/jeremiahbratton/">Jeremiah Bratton</a> · <a href="https://profiles.wordpress.org/jeremyfelt/">Jeremy Felt</a> · <a href="https://profiles.wordpress.org/jkmassel/">Jeremy Massel</a> · <a href="https://profiles.wordpress.org/slimndap/">Jeroen Schmit</a> · <a href="https://profiles.wordpress.org/jeryj/">jeryj</a> · <a href="https://profiles.wordpress.org/jesin/">Jesin A</a> · <a href="https://profiles.wordpress.org/jessedyck/">jessedyck</a> · <a href="https://profiles.wordpress.org/luminuu/">Jessica Lyschik</a> · <a href="https://profiles.wordpress.org/jigar-bhanushali/">Jigar Bhanushali</a> · <a href="https://profiles.wordpress.org/jigar9998/">Jigar Panchal</a> · <a href="https://profiles.wordpress.org/jikamens/">jikamens</a> · <a href="https://profiles.wordpress.org/jnweaver/">jnweaver</a> · <a href="https://profiles.wordpress.org/jojo256/">Joan Namunina</a> · <a href="https://profiles.wordpress.org/jobata/">JoAnne Obata</a> · <a href="https://profiles.wordpress.org/jochent/">JochenT</a> · <a href="https://profiles.wordpress.org/jodamo5/">jodamo5</a> · <a href="https://profiles.wordpress.org/joedolson/">Joe Dolson</a> · <a href="https://profiles.wordpress.org/joehoyle/">Joe Hoyle</a> · <a href="https://profiles.wordpress.org/joemcgill/">Joe McGill</a> · <a href="https://profiles.wordpress.org/joen/">Joen Asmussen</a> · <a href="https://profiles.wordpress.org/timse201/">Johannes J&#252;lg</a> · <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a> · <a href="https://profiles.wordpress.org/brandbrilliance/">John Brand</a> · <a href="https://profiles.wordpress.org/johnny5/">John Godley</a> · <a href="https://profiles.wordpress.org/johnjamesjacoby/">John James Jacoby</a> · <a href="https://profiles.wordpress.org/mindctrl/">John Parris</a> · <a href="https://profiles.wordpress.org/johnregan3/">John Regan</a> · <a href="https://profiles.wordpress.org/johnvieth/">JohnVieth</a> · <a href="https://profiles.wordpress.org/jonsurrell/">Jon Surrell</a> · <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a> · <a href="https://profiles.wordpress.org/jrchamp/">Jonathan Champ</a> · <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a> · <a href="https://profiles.wordpress.org/n2erjo00/">Joni Erkkil&#228;</a> · <a href="https://profiles.wordpress.org/spacedmonkey/">Jonny Harris</a> · <a href="https://profiles.wordpress.org/jonoaldersonwp/">Jono Alderson</a> · <a href="https://profiles.wordpress.org/jordesign/">jordesign</a> · <a href="https://profiles.wordpress.org/jorgefilipecosta/">Jorge Costa</a> · <a href="https://profiles.wordpress.org/josvelasco/">Jos Velasco</a> · <a href="https://profiles.wordpress.org/josephscott/">Joseph Scott</a> · <a href="https://profiles.wordpress.org/jhabdas/">Josh Habdas</a> · <a href="https://profiles.wordpress.org/verygoode/">Joshua Goode</a> · <a href="https://profiles.wordpress.org/jrmd/">jrmd</a> · <a href="https://profiles.wordpress.org/juanfra/">Juan Aldasoro</a> · <a href="https://profiles.wordpress.org/juampick/">Juan Cook</a> · <a href="https://profiles.wordpress.org/juanmaguitar/">JuanMa Garrido</a> · <a href="https://profiles.wordpress.org/juliengardair/">juliengardair</a> · <a href="https://profiles.wordpress.org/jrf/">Juliette Reinders Folmer</a> · <a href="https://profiles.wordpress.org/justinahinon/">Justin Ahinon</a> · <a href="https://profiles.wordpress.org/greenshady/">Justin Tadlock</a> · <a href="https://profiles.wordpress.org/itsroy69/">Jyotirmoy Roy</a> · <a href="https://profiles.wordpress.org/kadamwhite/">K. Adam White</a> · <a href="https://profiles.wordpress.org/kevin940726/">Kai Hao</a> · <a href="https://profiles.wordpress.org/trepmal/">Kailey (trepmal)</a> · <a href="https://profiles.wordpress.org/kaitohm/">Kaito Hanamori</a> · <a href="https://profiles.wordpress.org/kakomap/">Kakoma</a> · <a href="https://profiles.wordpress.org/kalpeshh/">Kalpesh</a> · <a href="https://profiles.wordpress.org/karinchristen/">Karin Christen</a> · <a href="https://profiles.wordpress.org/karolmanijak/">Karol Manijak</a> · <a href="https://profiles.wordpress.org/karthickmurugan/">Karthick Murugan</a> · <a href="https://profiles.wordpress.org/karthikeya01/">Karthikeya Bethu</a> · <a href="https://profiles.wordpress.org/kasparsd/">Kaspars</a> · <a href="https://profiles.wordpress.org/codebykat/">Kat Hagan</a> · <a href="https://profiles.wordpress.org/katinthehatsite/">Kateryna K. a11n</a> · <a href="https://profiles.wordpress.org/zoonini/">Kathryn Presner</a> · <a href="https://profiles.wordpress.org/katrinadtl/">Katrina Massey</a> · <a href="https://profiles.wordpress.org/kausaralm/">Kausar Alam</a> · <a href="https://profiles.wordpress.org/khushdoms/">Kaushik Domadiya</a> · <a href="https://profiles.wordpress.org/onlykawshar/">Kawshar Ahmed</a> · <a href="https://profiles.wordpress.org/kaygee79/">kaygee79</a> · <a href="https://profiles.wordpress.org/mt8biz/">Kazuto Takeshita</a> · <a href="https://profiles.wordpress.org/ryelle/">Kelly Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/kellychoffman/">Kelly Hoffman</a> · <a href="https://profiles.wordpress.org/tinypixel/">Kelly Mears</a> · <a href="https://profiles.wordpress.org/kgagne/">Ken Gagne</a> · <a href="https://profiles.wordpress.org/kerfred/">Kerfred</a> · <a href="https://profiles.wordpress.org/gwwar/">Kerry Liu</a> · <a href="https://profiles.wordpress.org/kesselb/">kesselb</a> · <a href="https://profiles.wordpress.org/kevinlearynet/">Kevin Leary</a> · <a href="https://profiles.wordpress.org/khoipro/">Khoi Pro</a> · <a href="https://profiles.wordpress.org/khushipatel15/">Khushi Patel</a> · <a href="https://profiles.wordpress.org/killerbishop/">killerbishop</a> · <a href="https://profiles.wordpress.org/iamkingsleyf/">Kingsley Felix</a> · <a href="https://profiles.wordpress.org/kirasong/">Kira Schroder</a> · <a href="https://profiles.wordpress.org/kishanjasani/">Kishan Jasani</a> · <a href="https://profiles.wordpress.org/kitchin/">kitchin</a> · <a href="https://profiles.wordpress.org/kjellr/">Kjell Reigstad</a> · <a href="https://profiles.wordpress.org/kkmuffme/">kkmuffme</a> · <a href="https://profiles.wordpress.org/kleor/">Kleor</a> · <a href="https://profiles.wordpress.org/knutsp/">Knut Sparhell</a> · <a href="https://profiles.wordpress.org/obenland/">Konstantin Obenland</a> · <a href="https://profiles.wordpress.org/xkon/">Konstantinos Xenos</a> · <a href="https://profiles.wordpress.org/kpapazov/">kpapazov</a> · <a href="https://profiles.wordpress.org/kprocyszyn/">kprocyszyn</a> · <a href="https://profiles.wordpress.org/krishaamer/">krishaamer</a> · <a href="https://profiles.wordpress.org/krunal265/">Krunal Bhimajiyani</a> · <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a> · <a href="https://profiles.wordpress.org/kshaner/">kshaner</a> · <a href="https://profiles.wordpress.org/kub1x/">kub1x</a> · <a href="https://profiles.wordpress.org/kubiq/">kubiq</a> · <a href="https://profiles.wordpress.org/kunalpuri123/">kunalpuri123</a> · <a href="https://profiles.wordpress.org/kushsharma/">Kush Sharma</a> · <a href="https://profiles.wordpress.org/kush123/">Kushagra Goyal</a> · <a href="https://profiles.wordpress.org/lgadzhev/">Lachezar Gadzhev</a> · <a href="https://profiles.wordpress.org/lakrisgubben/">lakrisgubben</a> · <a href="https://profiles.wordpress.org/lakshyajeet/">Lakshyajeet Singh Goyal</a> · <a href="https://profiles.wordpress.org/lalitkumawat/">Lalit Kumawat</a> · <a href="https://profiles.wordpress.org/lancewillett/">Lance Willett</a> · <a href="https://profiles.wordpress.org/newyorkerlaura/">Laura Byrne</a> · <a href="https://profiles.wordpress.org/laurisaarni/">Lauri Saarni</a> · <a href="https://profiles.wordpress.org/ldanielgiuliani/">ldanielgiuliani</a> · <a href="https://profiles.wordpress.org/leewillis77/">Lee Willis</a> · <a href="https://profiles.wordpress.org/leedxw/">leedxw</a> · <a href="https://profiles.wordpress.org/leemon/">leemon</a> · <a href="https://profiles.wordpress.org/0mirka00/">Lena Morita</a> · <a href="https://profiles.wordpress.org/leonidasmilossis/">Leonidas Milosis</a> · <a href="https://profiles.wordpress.org/levinbaria/">Levin Baria</a> · <a href="https://profiles.wordpress.org/lgseo/">lgseo</a> · <a href="https://profiles.wordpress.org/lilgames/">LilGames</a> · <a href="https://profiles.wordpress.org/liviopv/">liviopv</a> · <a href="https://profiles.wordpress.org/logiclink/">logiclink</a> · <a href="https://profiles.wordpress.org/logicrays/">LogicRays Technologies</a> · <a href="https://profiles.wordpress.org/lordandy1984/">lordandy1984</a> · <a href="https://profiles.wordpress.org/lovor/">Lovro Hrust</a> · <a href="https://profiles.wordpress.org/lucasms/">Lucas Martins</a> · <a href="https://profiles.wordpress.org/gigitux/">Luigi Teschio</a> · <a href="https://profiles.wordpress.org/luisherranz/">luisherranz</a> · <a href="https://profiles.wordpress.org/lukasfritzedev/">LukasFritzeDev</a> · <a href="https://profiles.wordpress.org/wpfed/">Lukasz</a> · <a href="https://profiles.wordpress.org/lukecavanagh/">Luke Cavanagh</a> · <a href="https://profiles.wordpress.org/maccyd/">maccyd</a> · <a href="https://profiles.wordpress.org/madhavishah01/">Madhavi Shah</a> · <a href="https://profiles.wordpress.org/madhudollu/">Madhu Dollu</a> · <a href="https://profiles.wordpress.org/onemaggie/">Maggie Cabrera</a> · <a href="https://profiles.wordpress.org/maikuolan/">Maikuolan</a> · <a href="https://profiles.wordpress.org/manfcarlo/">manfcarlo</a> · <a href="https://profiles.wordpress.org/manhatthien98/">manhatthien98</a> · <a href="https://profiles.wordpress.org/sirlouen/">Manuel Camargo</a> · <a href="https://profiles.wordpress.org/manzoorwanijk/">Manzoor Wani</a> · <a href="https://profiles.wordpress.org/maorb/">maorb</a> · <a href="https://profiles.wordpress.org/mdxfr/">Marc</a> · <a href="https://profiles.wordpress.org/marc4/">Marc Armengou</a> · <a href="https://profiles.wordpress.org/pagelab/">Marcio Duarte</a> · <a href="https://profiles.wordpress.org/mciampini/">Marco Ciampini</a> · <a href="https://profiles.wordpress.org/leadclown/">Marcus</a> · <a href="https://profiles.wordpress.org/mkaz/">Marcus Kazmierczak</a> · <a href="https://profiles.wordpress.org/marian1/">marian1</a> · <a href="https://profiles.wordpress.org/plari/">Marie</a> · <a href="https://profiles.wordpress.org/tyxla/">Marin Atanasov</a> · <a href="https://profiles.wordpress.org/santosguillamot/">Mario Santos</a> · <a href="https://profiles.wordpress.org/mariohamann/">mariohamann</a> · <a href="https://profiles.wordpress.org/marius84/">mariushosting</a> · <a href="https://profiles.wordpress.org/bozzmedia/">Marty</a> · <a href="https://profiles.wordpress.org/martythornley/">MartyThornley</a> · <a href="https://profiles.wordpress.org/marybaum/">Mary Baum</a> · <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a> · <a href="https://profiles.wordpress.org/mat-lipe/">Mat Lipe</a> · <a href="https://profiles.wordpress.org/mathiscode/">mathiscode</a> · <a href="https://profiles.wordpress.org/mmaattiiaass/">Matias Benedetto</a> · <a href="https://profiles.wordpress.org/matveb/">Matias Ventura</a> · <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> · <a href="https://profiles.wordpress.org/mattyrob/">Matt Robinson</a> · <a href="https://profiles.wordpress.org/mattwest/">Matt West</a> · <a href="https://profiles.wordpress.org/matteoenna/">Matteo Enna</a> · <a href="https://profiles.wordpress.org/pfefferle/">Matthias Pfefferle</a> · <a href="https://profiles.wordpress.org/mattryanwalker/">mattryanwalker</a> · <a href="https://profiles.wordpress.org/maxschmeling/">Max Schmeling</a> · <a href="https://profiles.wordpress.org/maxpertici/">Maxime Pertici</a> · <a href="https://profiles.wordpress.org/mayanktripathi32/">Mayank Tripathi</a> · <a href="https://profiles.wordpress.org/mayur8991/">Mayur Prajapati</a> · <a href="https://profiles.wordpress.org/faithcoder/">Md Abdullah Al Arif</a> · <a href="https://profiles.wordpress.org/mabfahad/">Md Abdullah Al Fahad</a> · <a href="https://profiles.wordpress.org/hmbashar/">Md Abul Bashar</a> · <a href="https://profiles.wordpress.org/ismail0071/">MD ISMAIL</a> · <a href="https://profiles.wordpress.org/kawsar007/">MD Kawsar Chowdhury</a> · <a href="https://profiles.wordpress.org/masummollaalhaz/">Md Masum Molla Alhaz</a> · <a href="https://profiles.wordpress.org/obiplabon/">Md Obidullah (obiPlabon)</a> · <a href="https://profiles.wordpress.org/wprashed/">Md Rashed Hossain</a> · <a href="https://profiles.wordpress.org/sabbir20/">Md Sabbir Hossain</a> · <a href="https://profiles.wordpress.org/najmulsaju/">Md. Najmul Islam</a> · <a href="https://profiles.wordpress.org/mehedi_csit/">Md.Mehedi Hasan</a> · <a href="https://profiles.wordpress.org/mdmoreau/">mdmoreau</a> · <a href="https://profiles.wordpress.org/mdviralsampat/">mdviralsampat</a> · <a href="https://profiles.wordpress.org/immeet94/">Meet Makadia</a> · <a href="https://profiles.wordpress.org/megane9988/">megane9988</a> · <a href="https://profiles.wordpress.org/meher/">Meher Bala</a> · <a href="https://profiles.wordpress.org/melchoyce/">Mel Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/mfgmicha/">Micha Krapp</a> · <a href="https://profiles.wordpress.org/mburridge/">Michael Burridge</a> · <a href="https://profiles.wordpress.org/michaelkeck/">Michael Keck</a> · <a href="https://profiles.wordpress.org/mnelson4/">Michael Nelson</a> · <a href="https://profiles.wordpress.org/xmic/">Michael Sumner</a> · <a href="https://profiles.wordpress.org/michaelreetz/">michaelreetz</a> · <a href="https://profiles.wordpress.org/czapla/">Michal Czaplinski</a> · <a href="https://profiles.wordpress.org/marktimemedia/">Michelle Schulp Hunt</a> · <a href="https://profiles.wordpress.org/mcsf/">Miguel Fonseca</a> · <a href="https://profiles.wordpress.org/migueluy/">Miguel Lezama</a> · <a href="https://profiles.wordpress.org/simison/">Mikael Korpela</a> · <a href="https://profiles.wordpress.org/mobius5150/">Mike</a> · <a href="https://profiles.wordpress.org/mikefitzman/">Mike Fitzpatrick</a> · <a href="https://profiles.wordpress.org/mikehansenme/">Mike Hansen</a> · <a href="https://profiles.wordpress.org/mikejolley/">Mike Jolley</a> · <a href="https://profiles.wordpress.org/mmcalister/">Mike McAlister</a> · <a href="https://profiles.wordpress.org/ritterml/">Mike Ritter</a> · <a href="https://profiles.wordpress.org/mikinc860/">Mikin Chauhan</a> · <a href="https://profiles.wordpress.org/firestar300/">Milan Ricoul</a> · <a href="https://profiles.wordpress.org/multidots1896/">Minal Diwan</a> · <a href="https://profiles.wordpress.org/369work/">Miroku</a> · <a href="https://profiles.wordpress.org/missveronicatv/">missveronica</a> · <a href="https://profiles.wordpress.org/presstoke/">Mitchell Austin</a> · <a href="https://profiles.wordpress.org/mkeck/">mkeck</a> · <a href="https://profiles.wordpress.org/mlaetitia1986/">mlaetitia1986</a> · <a href="https://profiles.wordpress.org/mleray/">mleray</a> · <a href="https://profiles.wordpress.org/mleraygp/">mleraygp</a> · <a href="https://profiles.wordpress.org/mobarak/">Mobarak Ali</a> · <a href="https://profiles.wordpress.org/opurockey/">Mohammad Rockeybul Alam</a> · <a href="https://profiles.wordpress.org/mohkatz/">Mohammed Kateregga</a> · <a href="https://profiles.wordpress.org/mosescursor/">Moses Cursor Ssebunya</a> · <a href="https://profiles.wordpress.org/mrwweb/">mrwweb</a> · <a href="https://profiles.wordpress.org/mtg169/">mtg169</a> · <a href="https://profiles.wordpress.org/mujuonly/">mujuonly</a> · <a href="https://profiles.wordpress.org/mukesh27/">Mukesh Panchal</a> · <a href="https://profiles.wordpress.org/mukulsingh27/">Mukul Singh</a> · <a href="https://profiles.wordpress.org/faguni22/">Mumtahina Faguni</a> · <a href="https://profiles.wordpress.org/sedmikrasky/">N&#250;ria Nadal i Rovira</a> · <a href="https://profiles.wordpress.org/vyasnaman/">Naman Vyas</a> · <a href="https://profiles.wordpress.org/nanisamireddy/">NANI SAMIREDDY</a> · <a href="https://profiles.wordpress.org/narenin/">Narendra Sishodiya</a> · <a href="https://profiles.wordpress.org/nareshbheda/">Naresh Bheda</a> · <a href="https://profiles.wordpress.org/muddassirnasim/">Nasim Miah</a> · <a href="https://profiles.wordpress.org/n8finch/">Nate Finch</a> · <a href="https://profiles.wordpress.org/naveendwivedi/">Naveen Dwivedi</a> · <a href="https://profiles.wordpress.org/navi161/">Navneet Kaur</a> · <a href="https://profiles.wordpress.org/bugnumber9/">Nazar Hotsa</a> · <a href="https://profiles.wordpress.org/nazmul111/">Nazmul Hosen</a> · <a href="https://profiles.wordpress.org/greatislander/">Ned Zimmerman</a> · <a href="https://profiles.wordpress.org/nexbridge/">nexbridge</a> · <a href="https://profiles.wordpress.org/nextendweb/">Nextendweb</a> · <a href="https://profiles.wordpress.org/neychok/">Neycho Kalaydzhiev</a> · <a href="https://profiles.wordpress.org/nickchomey/">Nick</a> · <a href="https://profiles.wordpress.org/nickstarkloff/">Nick</a> · <a href="https://profiles.wordpress.org/ndiego/">Nick Diego</a> · <a href="https://profiles.wordpress.org/celloexpressions/">Nick Halsey</a> · <a href="https://profiles.wordpress.org/nickbrazilian/">nickbrazilian</a> · <a href="https://profiles.wordpress.org/nickjbedford/">nickjbedford</a> · <a href="https://profiles.wordpress.org/nickpagz/">nickpagz</a> · <a href="https://profiles.wordpress.org/nickwilmot/">nickwilmot</a> · <a href="https://profiles.wordpress.org/nico23/">Nico</a> · <a href="https://profiles.wordpress.org/nidhidhandhukiya/">nidhidhandhukiya</a> · <a href="https://profiles.wordpress.org/nielslange/">Niels Lange</a> · <a href="https://profiles.wordpress.org/nigelnelles/">nigelnelles</a> · <a href="https://profiles.wordpress.org/ntsekouras/">Nik Tsekouras</a> · <a href="https://profiles.wordpress.org/smushytaco/">Nikan Radan</a> · <a href="https://profiles.wordpress.org/nikunj8866/">Nikunj Hatkar</a> · <a href="https://profiles.wordpress.org/nimeshatxecurify/">Nimesh</a> · <a href="https://profiles.wordpress.org/ninomiho/">Nino Mihovilic</a> · <a href="https://profiles.wordpress.org/ninos-ego/">Ninos</a> · <a href="https://profiles.wordpress.org/noahtallen/">Noah Allen</a> · <a href="https://profiles.wordpress.org/othernoel/">Noel Santos</a> · <a href="https://profiles.wordpress.org/noruzzaman/">Noruzzaman</a> · <a href="https://profiles.wordpress.org/nosilver4u/">nosilver4u</a> · <a href="https://profiles.wordpress.org/oceantober/">oceantober</a> · <a href="https://profiles.wordpress.org/oferlaor/">oferlaor</a> · <a href="https://profiles.wordpress.org/okat/">okat</a> · <a href="https://profiles.wordpress.org/yasunocco/">Okawa Yasuno</a> · <a href="https://profiles.wordpress.org/oglekler/">Olga Gleckler</a> · <a href="https://profiles.wordpress.org/domainsupport/">Oliver Campion</a> · <a href="https://profiles.wordpress.org/alshakero/">Omar Alshaker</a> · <a href="https://profiles.wordpress.org/gabertronic/">Ophelia Rose</a> · <a href="https://profiles.wordpress.org/optimizingmatters/">Optimizing Matters</a> · <a href="https://profiles.wordpress.org/owi/">owi</a> · <a href="https://profiles.wordpress.org/paaljoachim/">Paal Joachim Romdahl</a> · <a href="https://profiles.wordpress.org/pablohoneyhoney/">Pablo Honey</a> · <a href="https://profiles.wordpress.org/palak678/">Palak Patel</a> · <a href="https://profiles.wordpress.org/paragoninitiativeenterprises/">Paragon Initiative Enterprises</a> · <a href="https://profiles.wordpress.org/parinpanjari/">Parin Panjari</a> · <a href="https://profiles.wordpress.org/parthvataliya/">Parth vataliya</a> · <a href="https://profiles.wordpress.org/techpartho/">Partho Hore</a> · <a href="https://profiles.wordpress.org/swissspidy/">Pascal Birchler</a> · <a href="https://profiles.wordpress.org/pateljaymin/">Patel Jaymin</a> · <a href="https://profiles.wordpress.org/patricia70/">Patricia BT</a> · <a href="https://profiles.wordpress.org/lumiblog/">Patrick Lumumba</a> · <a href="https://profiles.wordpress.org/patpiwo/">Patrick Piwowarczyk</a> · <a href="https://profiles.wordpress.org/pryley/">Paul</a> · <a href="https://profiles.wordpress.org/pbearne/">Paul Bearne</a> · <a href="https://profiles.wordpress.org/pbiron/">Paul Biron</a> · <a href="https://profiles.wordpress.org/paulbonneau/">Paul Bonneau</a> · <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a> · <a href="https://profiles.wordpress.org/paulopmt1/">Paulo Trentin</a> · <a href="https://profiles.wordpress.org/paulstanos/">paulstanos</a> · <a href="https://profiles.wordpress.org/pcarvalho/">pcarvalho</a> · <a href="https://profiles.wordpress.org/pedrofigueroa1989/">Pedro Figueroa</a> · <a href="https://profiles.wordpress.org/peroks/">Per Egil Roksvaag</a> · <a href="https://profiles.wordpress.org/peteringersoll/">Peter Ingersoll</a> · <a href="https://profiles.wordpress.org/westi/">Peter Westwood</a> · <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a> · <a href="https://profiles.wordpress.org/petitphp/">petitphp</a> · <a href="https://profiles.wordpress.org/philipjohn/">Philip John</a> · <a href="https://profiles.wordpress.org/philsola/">Philip Sola</a> · <a href="https://profiles.wordpress.org/tyrannous/">Philipp Bammes</a> · <a href="https://profiles.wordpress.org/phillsav/">Phill</a> · <a href="https://profiles.wordpress.org/piskvorky/">piskvorky</a> · <a href="https://profiles.wordpress.org/poojabhimani/">Pooja Bhimani</a> · <a href="https://profiles.wordpress.org/poojapadamad/">poojapadamad</a> · <a href="https://profiles.wordpress.org/porg/">porg</a> · <a href="https://profiles.wordpress.org/prab18hat/">Prabhat Mishra</a> · <a href="https://profiles.wordpress.org/praful2111/">Praful Patel</a> · <a href="https://profiles.wordpress.org/pranjalpratapsingh/">Pranjal Pratap Singh</a> · <a href="https://profiles.wordpress.org/prasadkarmalkar/">Prasad Karmalkar</a> · <a href="https://profiles.wordpress.org/prasadgupte/">prasadgupte</a> · <a href="https://profiles.wordpress.org/pmbaldha/">Prashant Baldha</a> · <a href="https://profiles.wordpress.org/pratiklondhe/">Pratik Londhe</a> · <a href="https://profiles.wordpress.org/presskopp/">Presskopp</a> · <a href="https://profiles.wordpress.org/prettyboymp/">prettyboymp</a> · <a href="https://profiles.wordpress.org/puggan/">puggan</a> · <a href="https://profiles.wordpress.org/quentinr64600/">quentinr64600</a> · <a href="https://profiles.wordpress.org/rachelbaker/">Rachel Baker</a> · <a href="https://profiles.wordpress.org/rafiq91/">Rafiqul Islam</a> · <a href="https://profiles.wordpress.org/ralucastn/">Raluca</a> · <a href="https://profiles.wordpress.org/superpoincare/">Ramanan</a> · <a href="https://profiles.wordpress.org/ramiy/">Rami Yushuvaev</a> · <a href="https://profiles.wordpress.org/rahmohn/">Ramon Ahnert</a> · <a href="https://profiles.wordpress.org/rcorrales/">Ramon Corrales</a> · <a href="https://profiles.wordpress.org/ramonopoly/">Ramon James</a> · <a href="https://profiles.wordpress.org/ravichudasama01/">Ravi Chudasama</a> · <a href="https://profiles.wordpress.org/ravigadhiyawp/">Ravi Gadhiya</a> · <a href="https://profiles.wordpress.org/rcrdortiz/">rcrdortiz</a> · <a href="https://profiles.wordpress.org/rehanali/">Rehan Ali</a> · <a href="https://profiles.wordpress.org/rejaulalomkhan/">Rejaul Alom Khan</a> · <a href="https://profiles.wordpress.org/tabrisrp/">Remy Perona</a> · <a href="https://profiles.wordpress.org/espellcaste/">Renato Alves</a> · <a href="https://profiles.wordpress.org/renishsurani/">renishsurani</a> · <a href="https://profiles.wordpress.org/retrofox/">retrofox</a> · <a href="https://profiles.wordpress.org/rezwanshiblu1952/">Rezwan Shiblu</a> · <a href="https://profiles.wordpress.org/youknowriad/">Riad Benguella</a> · <a href="https://profiles.wordpress.org/riadev/">riadev</a> · <a href="https://profiles.wordpress.org/richtabor/">Rich Tabor</a> · <a href="https://profiles.wordpress.org/rockfire/">Richard Korthuis</a> · <a href="https://profiles.wordpress.org/riddhidave/">Riddhi Dave</a> · <a href="https://profiles.wordpress.org/rinatkhaziev/">Rinat</a> · <a href="https://profiles.wordpress.org/rinkalpagdar/">Rinkal Pagdar</a> · <a href="https://profiles.wordpress.org/rishabhwp/">Rishabh Gupta</a> · <a href="https://profiles.wordpress.org/rishavdutta/">Rishav Dutta</a> · <a href="https://profiles.wordpress.org/rishit30g/">Rishit Gupta</a> · <a href="https://profiles.wordpress.org/ristojovanovic/">Risto Jovanovic</a> · <a href="https://profiles.wordpress.org/devrito/">Ritoban</a> · <a href="https://profiles.wordpress.org/noisysocks/">Robert Anderson</a> · <a href="https://profiles.wordpress.org/miqrogroove/">Robert Chapin</a> · <a href="https://profiles.wordpress.org/robertghetau/">Robert Ghetau</a> · <a href="https://profiles.wordpress.org/sanchothefat/">Robert O\'Rourke</a> · <a href="https://profiles.wordpress.org/robmcclel/">Robmcclel</a> · <a href="https://profiles.wordpress.org/rodrigosprimo/">Rodrigo Primo</a> · <a href="https://profiles.wordpress.org/roelof/">roelof</a> · <a href="https://profiles.wordpress.org/rollybueno/">Rolly Bueno</a> · <a href="https://profiles.wordpress.org/ronak44/">Ronak prajapati</a> · <a href="https://profiles.wordpress.org/room34/">Room 34 Creative Services, LLC</a> · <a href="https://profiles.wordpress.org/costasovo/">Rostislav Woln&#253;</a> · <a href="https://profiles.wordpress.org/rotemg/">Rotem Gelbart</a> · <a href="https://profiles.wordpress.org/rayhatron/">Rufaro Madamombe</a> · <a href="https://profiles.wordpress.org/rutvikbhambhi2004/">Rutvik Bhambhi</a> · <a href="https://profiles.wordpress.org/rmccue/">Ryan McCue</a> · <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a> · <a href="https://profiles.wordpress.org/skierpage/">S Page</a> · <a href="https://profiles.wordpress.org/soean/">S&#246;ren W&#252;nsch</a> · <a href="https://profiles.wordpress.org/sabbir1991/">Sabbir Ahmed</a> · <a href="https://profiles.wordpress.org/devsabbirahmed/">Sabbir Sam</a> · <a href="https://profiles.wordpress.org/sachinrajcp123/">SACHINRAJ CP</a> · <a href="https://profiles.wordpress.org/sahiljadhav1617/">Sahil Jadhav</a> · <a href="https://profiles.wordpress.org/sainathpoojary/">Sainath Poojary</a> · <a href="https://profiles.wordpress.org/sajjad67/">Sajjad Hossain Sagor</a> · <a href="https://profiles.wordpress.org/sakibmoon/">sakibmoon</a> · <a href="https://profiles.wordpress.org/samueljseay/">Sam</a> · <a href="https://profiles.wordpress.org/sam_a/">sam_a</a> · <a href="https://profiles.wordpress.org/samirmalpande/">Samir Malpande</a> · <a href="https://profiles.wordpress.org/viralsampat/">Sampat Viral</a> · <a href="https://profiles.wordpress.org/sjapaget/">Samuel Paget</a> · <a href="https://profiles.wordpress.org/otto42/">Samuel Wood (Otto)</a> · <a href="https://profiles.wordpress.org/sandeepdahiya/">Sandeep Dahiya</a> · <a href="https://profiles.wordpress.org/sandipsinh007/">Sandip Sinh</a> · <a href="https://profiles.wordpress.org/ourvalley/">Sandy McFadden</a> · <a href="https://profiles.wordpress.org/mikachan/">Sarah Norris</a> · <a href="https://profiles.wordpress.org/tinkerbelly/">sarah semark</a> · <a href="https://profiles.wordpress.org/sarthaknagoshe2002/">Sarthak Nagoshe</a> · <a href="https://profiles.wordpress.org/satishprajapati/">Satish Prajapati</a> · <a href="https://profiles.wordpress.org/saurabhdhariwal/">saurabh.dhariwal</a> · <a href="https://profiles.wordpress.org/saxonafletcher/">Saxon Fletcher</a> · <a href="https://profiles.wordpress.org/scholdstrom/">scholdstrom</a> · <a href="https://profiles.wordpress.org/swb1192/">Scott Buscemi</a> · <a href="https://profiles.wordpress.org/sc0ttkclark/">Scott Kingsley Clark</a> · <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a> · <a href="https://profiles.wordpress.org/wonderboymusic/">Scott Taylor</a> · <a href="https://profiles.wordpress.org/scribu/">scribu</a> · <a href="https://profiles.wordpress.org/sebastianpisula/">Sebastian Pisula</a> · <a href="https://profiles.wordpress.org/seifradwane/">Seif Radwane</a> · <a href="https://profiles.wordpress.org/sergeybiryukov/">Sergey Biryukov</a> · <a href="https://profiles.wordpress.org/smrubenstein/">Seth Rubenstein</a> · <a href="https://profiles.wordpress.org/shsajalchowdhury/">SH Sajal Chowdhury</a> · <a href="https://profiles.wordpress.org/shadialaghbari/">Shadi G شادي جـ</a> · <a href="https://profiles.wordpress.org/shailu25/">Shail Mehta</a> · <a href="https://profiles.wordpress.org/sh4lin/">Shalin Shah</a> · <a href="https://profiles.wordpress.org/shanemuir/">Shane Muirhead</a> · <a href="https://profiles.wordpress.org/iamshashank/">Shashank Jain</a> · <a href="https://profiles.wordpress.org/shekh0109/">Shashank Shekhar</a> · <a href="https://profiles.wordpress.org/sajib1223/">Shazzad Hossain Khan</a> · <a href="https://profiles.wordpress.org/designsimply/">Sheri Grey</a> · <a href="https://profiles.wordpress.org/shiponkarmakar/">Shipon Karmakar</a> · <a href="https://profiles.wordpress.org/shreya0shrivastava/">Shreya Shrivastava</a> · <a href="https://profiles.wordpress.org/iamshubhamsp/">Shubham Patil</a> · <a href="https://profiles.wordpress.org/shyamgadde/">Shyamsundar Gadde</a> · <a href="https://profiles.wordpress.org/sidharthpandita/">sidharthpandita</a> · <a href="https://profiles.wordpress.org/siliconforks/">siliconforks</a> · <a href="https://profiles.wordpress.org/shilpaashokan94/">Silpa TA</a> · <a href="https://profiles.wordpress.org/simonefontana/">simonefontana</a> · <a href="https://profiles.wordpress.org/slaffik/">Slava Abakumov</a> · <a href="https://profiles.wordpress.org/smerriman/">smerriman</a> · <a href="https://profiles.wordpress.org/snehapatil02/">Sneha Patil</a> · <a href="https://profiles.wordpress.org/maia12345/">Sophie Dimitrov</a> · <a href="https://profiles.wordpress.org/sourabhjain/">Sourabh Jain</a> · <a href="https://profiles.wordpress.org/sourav08/">Sourav Pahwa</a> · <a href="https://profiles.wordpress.org/soyebsalar01/">Soyeb Salar</a> · <a href="https://profiles.wordpress.org/spenserhale/">Spenser Hale</a> · <a href="https://profiles.wordpress.org/spstrap/">spstrap</a> · <a href="https://profiles.wordpress.org/srikat/">Sridhar Katakam</a> · <a href="https://profiles.wordpress.org/stankea/">stankea</a> · <a href="https://profiles.wordpress.org/metodiew/">Stanko Metodiev</a> · <a href="https://profiles.wordpress.org/staurand/">staurand</a> · <a href="https://profiles.wordpress.org/hubersen/">Stefan Pasch</a> · <a href="https://profiles.wordpress.org/stefanvelthuys/">Stefan Velthuys</a> · <a href="https://profiles.wordpress.org/sabernhardt/">Stephen Bernhardt</a> · <a href="https://profiles.wordpress.org/stephenharris/">Stephen Harris</a> · <a href="https://profiles.wordpress.org/dufresnesteven/">Steve Dufresne</a> · <a href="https://profiles.wordpress.org/strarsis/">strarsis</a> · <a href="https://profiles.wordpress.org/subrataemfluence/">Subrata Sarkar</a> · <a href="https://profiles.wordpress.org/sudipatel007/">Sudip Dadhaniya</a> · <a href="https://profiles.wordpress.org/sujansarkar/">Sujan Sarkar</a> · <a href="https://profiles.wordpress.org/sukhendu2002/">Sukhendu Sekhar Guria</a> · <a href="https://profiles.wordpress.org/sumitbagthariya16/">Sumit Bagthariya</a> · <a href="https://profiles.wordpress.org/sunil25393/">SunilPrajapati</a> · <a href="https://profiles.wordpress.org/sunnykasera/">sunnykasera</a> · <a href="https://profiles.wordpress.org/sunyatasattva/">sunyatasattva (a11n)</a> · <a href="https://profiles.wordpress.org/supernovia/">supernovia</a> · <a href="https://profiles.wordpress.org/suzukube/">SuzuKube</a> · <a href="https://profiles.wordpress.org/svedish/">svedish</a> · <a href="https://profiles.wordpress.org/lordspace/">Svetoslav Marinov</a> · <a href="https://profiles.wordpress.org/cybr/">Sybre Waaijer</a> · <a href="https://profiles.wordpress.org/syhussaini/">syhussaini</a> · <a href="https://profiles.wordpress.org/schwipps/">T4ng</a> · <a href="https://profiles.wordpress.org/tacoverdo/">Taco Verdonschot</a> · <a href="https://profiles.wordpress.org/iamtakashi/">Takashi Irie</a> · <a href="https://profiles.wordpress.org/takuword/">Takuro</a> · <a href="https://profiles.wordpress.org/karmatosed/">Tammie Lister</a> · <a href="https://profiles.wordpress.org/tatof/">tatof</a> · <a href="https://profiles.wordpress.org/tecnogaming/">tecnogaming</a> · <a href="https://profiles.wordpress.org/mecaota/">Tetsuro Higuchi</a> · <a href="https://profiles.wordpress.org/tharsheblows/">tharsheblows</a> · <a href="https://profiles.wordpress.org/thelmachido/">thelmachido a11n</a> · <a href="https://profiles.wordpress.org/tsquez/">ThemeAWESOME</a> · <a href="https://profiles.wordpress.org/themiked/">theMikeD</a> · <a href="https://profiles.wordpress.org/kraftner/">Thomas Kr&#228;ftner</a> · <a href="https://profiles.wordpress.org/tfrommen/">Thorsten Frommen</a> · <a href="https://profiles.wordpress.org/tillkruess/">Till Kr&#252;ss</a> · <a href="https://profiles.wordpress.org/timhavinga/">Tim Havinga</a> · <a href="https://profiles.wordpress.org/dontfeedthecode/">Tim Sheehan</a> · <a href="https://profiles.wordpress.org/timotijhof/">Timo Tijhof</a> · <a href="https://profiles.wordpress.org/spaceshipone/">Timoth&#233;e Brosille</a> · <a href="https://profiles.wordpress.org/timotheemoulin/">Timoth&#233;e Moulin</a> · <a href="https://profiles.wordpress.org/timothyblynjacobs/">Timothy Jacobs</a> · <a href="https://profiles.wordpress.org/tjarrett/">TJarrett</a> · <a href="https://profiles.wordpress.org/tobiasbg/">Tobias B&#228;thge</a> · <a href="https://profiles.wordpress.org/tz-media/">Tobias Zimpel</a> · <a href="https://profiles.wordpress.org/tobifjellner/">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href="https://profiles.wordpress.org/tomdevisser/">Tom de Visser</a> · <a href="https://profiles.wordpress.org/tjnowell/">Tom J Nowell</a> · <a href="https://profiles.wordpress.org/shimotomoki/">Tomoki Shimomura</a> · <a href="https://profiles.wordpress.org/skithund/">Toni Viemer&#246;</a> · <a href="https://profiles.wordpress.org/hellofromtonya/">Tonya Mork</a> · <a href="https://profiles.wordpress.org/toro_unit/">Toro_Unit (Hiroshi Urabe)</a> · <a href="https://profiles.wordpress.org/zodiac1978/">Torsten Landsiedel</a> · <a href="https://profiles.wordpress.org/wpsmith/">Travis Smith</a> · <a href="https://profiles.wordpress.org/traxus/">traxus</a> · <a href="https://profiles.wordpress.org/sllimrovert/">Trevor Mills</a> · <a href="https://profiles.wordpress.org/tristanleboss/">tristanleboss</a> · <a href="https://profiles.wordpress.org/areziaal/">Troy Chaplin</a> · <a href="https://profiles.wordpress.org/truptikanzariya/">Trupti Kanzariya</a> · <a href="https://profiles.wordpress.org/tsteel/">tsteel</a> · <a href="https://profiles.wordpress.org/dinhtungdu/">Tung Du</a> · <a href="https://profiles.wordpress.org/tusharbharti/">Tushar Bharti</a> · <a href="https://profiles.wordpress.org/tusharaddweb/">Tushar Patel</a> · <a href="https://profiles.wordpress.org/tussendoor/">Tussendoor B.V.</a> · <a href="https://profiles.wordpress.org/ugyensupport/">Ugyen Dorji</a> · <a href="https://profiles.wordpress.org/umeshnevase/">Umesh Nevase</a> · <a href="https://profiles.wordpress.org/umeshsinghin/">Umesh Singh</a> · <a href="https://profiles.wordpress.org/unsalkorkmaz/">Unsal Korkmaz</a> · <a href="https://profiles.wordpress.org/upadalavipul/">upadalavipul</a> · <a href="https://profiles.wordpress.org/utsavladani/">Utsav Ladani</a> · <a href="https://profiles.wordpress.org/utsav72640/">Utsav tilava</a> · <a href="https://profiles.wordpress.org/valentingrenier/">Valentin Grenier</a> · <a href="https://profiles.wordpress.org/tsimshatsui/">Vape tsimshatsui</a> · <a href="https://profiles.wordpress.org/vbbp/">vbbp</a> · <a href="https://profiles.wordpress.org/sheldorofazeroth/">Vedansh Mishra</a> · <a href="https://profiles.wordpress.org/vevas/">Vegard S.</a> · <a href="https://profiles.wordpress.org/vgnavada/">vgnavada</a> · <a href="https://profiles.wordpress.org/vcanales/">Vicente Canales</a> · <a href="https://profiles.wordpress.org/vidugupta/">vidugupta</a> · <a href="https://profiles.wordpress.org/vijendrajat/">Vijendra Jat</a> · <a href="https://profiles.wordpress.org/szepeviktor/">Viktor Sz&#233;pe</a> · <a href="https://profiles.wordpress.org/vineet2003/">Vinit</a> · <a href="https://profiles.wordpress.org/ghorivipul97/">Vipul Ghori</a> · <a href="https://profiles.wordpress.org/vipulgupta003/">Vipul Gupta</a> · <a href="https://profiles.wordpress.org/vipulpatil/">Vipul Patil</a> · <a href="https://profiles.wordpress.org/vishitshah/">Vishit Shah</a> · <a href="https://profiles.wordpress.org/vladimiraus/">vladimiraus</a> · <a href="https://profiles.wordpress.org/vortfu/">vortfu</a> · <a href="https://profiles.wordpress.org/vrishabhsk/">Vrishabh Jasani</a> · <a href="https://profiles.wordpress.org/walterebert/">Walter Ebert</a> · <a href="https://profiles.wordpress.org/webmandesign/">WebMan Design &#124; Oliver Juhas</a> · <a href="https://profiles.wordpress.org/websupporter/">websupporter</a> · <a href="https://profiles.wordpress.org/webwrotter/">webwrotter</a> · <a href="https://profiles.wordpress.org/westonruter/">Weston Ruter</a> · <a href="https://profiles.wordpress.org/whaze/">whaze</a> · <a href="https://profiles.wordpress.org/widhy980/">widhy980</a> · <a href="https://profiles.wordpress.org/skorasaurus/">Will Skora</a> · <a href="https://profiles.wordpress.org/wplmillet/">wplmillet</a> · <a href="https://profiles.wordpress.org/xate/">xate</a> · <a href="https://profiles.wordpress.org/xavilc/">xavilc</a> · <a href="https://profiles.wordpress.org/xerpa43/">xerpa43</a> · <a href="https://profiles.wordpress.org/xipasduarte/">xipasduarte</a> · <a href="https://profiles.wordpress.org/yagniksangani/">Yagnik Sangani</a> · <a href="https://profiles.wordpress.org/yashyadav247/">Yash</a> · <a href="https://profiles.wordpress.org/getsyash/">Yash B</a> · <a href="https://profiles.wordpress.org/yashjawale/">Yash Jawale</a> · <a href="https://profiles.wordpress.org/yogeshbhutkar/">Yogesh Bhutkar</a> · <a href="https://profiles.wordpress.org/yogieanamcara/">YogieAnamCara</a> · <a href="https://profiles.wordpress.org/fierevere/">Yui</a> · <a href="https://profiles.wordpress.org/zebulan/">Zebulan Stanphill</a> · <a href="https://profiles.wordpress.org/zeelthakkar/">Zeel Thakkar</a> · <a href="https://profiles.wordpress.org/zunaid321/">Zunaid Amin</a> · <a href="https://profiles.wordpress.org/lstraczynski/">Łukasz Strączyński</a> · <a href="https://profiles.wordpress.org/haozi/">耗子</a></p>\n\n\n\n<p>More than <a href="https://translate.wordpress.org/stats/">71 locales have fully translated</a> WordPress 6.9 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200+ languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href="https://wordpress.org/support/forums/">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class="wp-block-heading"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href="https://make.wordpress.org/">Make WordPress</a> and use <a href="https://make.wordpress.org/contribute/">this interactive tool</a> to help you decide which is right for you.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19398";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 25 Nov 2025 15:33:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:18:"release candidates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19373";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:366:"The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC3 on a test server and site. Reaching this phase [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:8039:"\n<p>The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. <strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the highest quality possible.</p>\n\n\n\n<p>You can test WordPress 6.9 RC3 in four ways:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/"></a><a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta2.zip"></a><a href="https://wordpress.org/wordpress-6.9-RC3.zip">RC3 version (zip)</a>. and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn">6.9 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC3?</h2>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? Take a look at the <a href="https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide">WordPress 6.9 Field Guide</a>. For technical information related to issues addressed since <a href="https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-18&amp;until=2025-11-25">Gutenberg commits for 6.9</a> since November 18</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F18%2F2025..11%2F24%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed WordPress Core Trac tickets</a> since November 18</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can get involved with the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC3 prerelease is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href="https://make.wordpress.org/test/handbook/get-setup-for-testing/">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta/RC area</a> of the support forums or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/"></a><a href="https://make.wordpress.org/chat/">Making WordPress Slack</a>..</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 prereleases. If you haven’t yet, please conclude your testing and update the <em>“Tested up to”</em> version in your theme and plugin <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">readme files</a> to <code>6.9</code>.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information in the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>.&nbsp;</p>\n\n\n\n<h3 class="wp-block-heading">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp;You can <a href="https://translate.wordpress.org/projects/wp/dev/">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC3 haiku</h2>\n\n\n\n<p><em>Some folks make money,</em></p>\n\n\n\n<p><em>some folks make time to travel,</em></p>\n\n\n\n<p><em>and we Make WordPress.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/mobarak/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mobarak</a> <em>and</em> <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19373";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 18 Nov 2025 15:26:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19350";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:367:"The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Akshaya Rane";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:10595:"\n<p>The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.9 RC2 in four ways:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC2.zip">RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href="https://make.wordpress.org/cli/">WP-CLI</a> command:<br><code>wp core update --version=6.9-RC2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn">6.9 RC2 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.9’s highlighted features in the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-11&amp;until=2025-11-18">GitHub commits for 6.9</a> since November 11</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F11%2F2025..11%2F18%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 11</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Notes Feature in 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Abilities API in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/">WordPress 6.9 Frontend Performance Field Guide</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/interactivity-apis-client-navigation-improvements-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Interactivity API’s client navigation improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Block Bindings improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Changes to the Interactivity API in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/">Consistent Cache Keys for Query Groups in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">DataViews, DataForm, et al. in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/" target="_blank" rel="noreferrer noopener">Preparing the Post Editor for Full iframe Integration</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/theme-json-border-radius-presets-support-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Theme.json Border Radius Presets Support in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Heading Block CSS Specificity Fix in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/">Miscellaneous Developer-focused Changes in 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/" data-type="link" data-id="https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/">Modernizing UTF-8 support in WordPress 6.9</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h2 class="wp-block-heading">Get involved in testing</h2>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC2 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href="https://make.wordpress.org/test/handbook/get-setup-for-testing/">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.&nbsp;</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Update your theme or plugin</h2>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. If you haven’t yet, make sure to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Test on your hosting platforms</h2>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp; You can<a href="https://translate.wordpress.org/projects/wp/dev/"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href="https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze"> hard string freeze</a> point of the <a href="https://make.wordpress.org/core/2025/11/11/wordpress-6-9-release-candidate-phase/">6.9 release cycle</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC2 haiku</h2>\n\n\n\n<p>A calm hillside sighs,<br>Work of many now complete —<br>RC2 stays true.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to <a href=\'https://profiles.wordpress.org/amykamala/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>amykamala</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> and <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a> for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19350";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 15:34:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:18:"release candidates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19317";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is still under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site. WordPress 6.9 RC1 [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:9479:"\n<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC1.zip">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn" data-type="link" data-id="https://playground.wordpress.net/?php=8.3&amp;wp=rc&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/log/?revs=61183-61203">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Site Editor improvements and Refined content creation\n<ul class="wp-block-list">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class="wp-block-list">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class="wp-block-list">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class="wp-block-heading">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/">Accordion Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64099">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64204">Modified notes notifications</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href="https://make.wordpress.org/hosting/test-results/">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a><em>, </em><a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <em>and</em> <a href=\'https://profiles.wordpress.org/cbravobernal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbravobernal</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19317";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/11/wordpress-6-9-beta-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 04 Nov 2025 15:34:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:347:"WordPress 6.9 Beta 3 is available for download and testing! This beta version of the WordPress software is still under development. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site. WordPress 6.9 Beta 3 can be tested [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5454:"\n<p>WordPress 6.9 Beta 3 is available for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is still under development</strong>. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 Beta 3 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta3.zip">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 3 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p></p>\n\n\n\n<p>The final release of WordPress 6.9 is scheduled for <strong>December 2, 2025</strong>, and the <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Thank you to everyone who helps with testing!</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Find out what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 3 version is key to ensuring that everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally as important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> provides a walk through on testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 3 contains more than 80 updates and fixes since the Beta 2 release.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes, and more are on the way with your testing! You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-28&amp;until=2025-11-04">Gutenberg commits for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2025..11%2F04%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Core Trac tickets for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://github.com/WordPress/wordpress-develop/compare/7dcb09c26a1d97c20dcceb866abbd0f3c128388b...81f755846c2d66ce7d21b01623f8163a9f7c6ef6">Comparing commit changes in Core for 6.9</a> since October 28, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 3 haiku</h2>\n\n\n\n<p><em>Code is poetry,</em></p>\n\n\n\n<p><em>and poetry is magic.</em></p>\n\n\n\n<p><em>So code is magic.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a> <em>, </em><a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a>,  <em>and</em> <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19263";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 28 Oct 2025 15:23:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:3:"6-9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19253";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:334:"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Akshaya Rane";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5125:"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta2.zip">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href="https://make.wordpress.org/core/"> Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href="https://wordpress.org/support/forum/alphabeta/"> Alpha/Beta area</a> of the support forums or directly to<a href="https://core.trac.wordpress.org/newticket"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href="https://core.trac.wordpress.org/tickets/major"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href="https://make.wordpress.org/test/"> testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19253";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"WordPress 6.8.3 Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Sep 2025 19:31:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"minor-releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19204";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:372:"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"John Blackbourn";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4937:"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href="https://wordpress.org/wordpress-6.8.3.zip">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href="https://make.wordpress.org/core/6-9/">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href="https://wordpress.org/documentation/wordpress-version/version-6-8-3/">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href="https://hackerone.com/wordpress?type=team">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href="https://hackerone.com/mnelson4">Mike Nelson</a>, <a href="https://hackerone.com/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs/">Timothy Jacobs</a>, and <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href="https://x.com/Savphill">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class="wp-block-heading">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href="https://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/zieladam">Adam Zieliński</a>, <a href="https://profiles.wordpress.org/xknown">Alex Concha</a>, <a href="https://profiles.wordpress.org/andraganescu%20">Andrei Draganescu</a>, <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ehtis">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/iandunn">Ian Dunn</a>, <a href="https://profiles.wordpress.org/whyisjake">Jake Spurlock</a>, <a href="https://profiles.wordpress.org/audrasjb">Jb Audras</a>, <a href="https://profiles.wordpress.org/joehoyle">Joe Hoyle</a>, <a href="https://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="https://profiles.wordpress.org/jonsurrell">Jon Surrell</a>, <a href="https://profiles.wordpress.org/desrosj">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/mnelson4">Michael Nelson</a>, <a href="https://profiles.wordpress.org/peterwilsoncc">Peter Wilson</a>, <a href="https://profiles.wordpress.org/phillsav">Phill</a>, <a href="https://profiles.wordpress.org/noisysocks">Robert Anderson</a>, <a href="https://profiles.wordpress.org/rmccue">Ryan McCue</a>, <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs">Timothy Jacobs</a>, <a href="https://profiles.wordpress.org/vortfu">vortfu</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a></p>\n\n\n\n<h2 class="wp-block-heading">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href="https://core.trac.wordpress.org/report/6">pick a ticket</a>, and join the conversation in the <a href="https://app.slack.com/client/T024MFP4J/C02RQBWTW">#core</a> Slack channel. Need help? Check out the <a href="https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href="https://profiles.wordpress.org/ehtis/">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>, <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a>, <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a> for reviewing.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19204";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"Portland Welcomes WordCamp US 2025: A Community Gathering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 30 Aug 2025 03:03:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"WordCamp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19074";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:405:"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brett McSherry";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:65530:"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class="wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex">\n<figure class="wp-block-pullquote"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class="wp-block-heading">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px;border-radius:2px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857c28e&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857c28e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19080" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19080" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857c5a8&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857c5a8" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19081" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19081" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857c890&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857c890" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="1707" height="2560" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19087" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1" alt="" class="wp-image-19087" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857cb67&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857cb67" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19084" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19084" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857ce3a&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857ce3a" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19082" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19082" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857d109&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857d109" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19085" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19085" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857d3be&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857d3be" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19086" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19086" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857d673&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857d673" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19090" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19090" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857d956&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857d956" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19089" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19089" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857dc12&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857dc12" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19092" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19092" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857ded6&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857ded6" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19088" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19088" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857e1c6&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857e1c6" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19091" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19091" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857e491&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857e491" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19083" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19083" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class="wp-block-heading">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;" width="500" height="281" src="https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href="https://youtu.be/PGvh7fCOUk0">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href="https://youtu.be/F4NEPcwGRCI">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a>. Panelists <a href="https://youtu.be/ARqM9U0ESvo">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href="https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;" width="500" height="281" src="https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href="https://youtu.be/v_0O6dQ4Q4E">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19103" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href="https://youtu.be/vBjNqdacbh4">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href="https://youtu.be/O7FPiFpRI3o">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href="https://youtu.be/ORnJTpjA-4w">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class="wp-block-heading">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;" width="500" height="281" src="https://www.youtube.com/embed/45HRzzc0waU?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class="wp-block-heading">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href="https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857f113&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857f113" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19112" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19112" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857f412&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857f412" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19124" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19124" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857f6e5&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857f6e5" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19122" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19122" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857f9b8&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857f9b8" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19107" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19107" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857fc9e&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857fc9e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="675" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19108" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1" alt="" class="wp-image-19108" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72857ff79&quot;}" data-wp-interactive="core/image" data-wp-key="694f72857ff79" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19113" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19113" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f728580268&quot;}" data-wp-interactive="core/image" data-wp-key="694f728580268" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="433" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19106" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1" alt="" class="wp-image-19106" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f72858054a&quot;}" data-wp-interactive="core/image" data-wp-key="694f72858054a" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19110" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19110" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f728580861&quot;}" data-wp-interactive="core/image" data-wp-key="694f728580861" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19119" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19119" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;694f728580b35&quot;}" data-wp-interactive="core/image" data-wp-key="694f728580b35" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19133" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19133" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href="https://europe.wordcamp.org/2026/">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19074";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:32:"https://wordpress.org/news/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:9:"\n	hourly	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:4:"\n	1	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:4:"site";a:1:{i:0;a:5:{s:4:"data";s:8:"14607090";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Sat, 27 Dec 2025 05:56:25 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:4:"vary";s:37:"Accept-Encoding, accept, content-type";s:25:"strict-transport-security";s:12:"max-age=3600";s:6:"x-olaf";s:3:"⛄";s:13:"last-modified";s:29:"Wed, 10 Dec 2025 17:16:49 GMT";s:4:"link";s:63:"<https://wordpress.org/news/wp-json/>; rel="https://api.w.org/"";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:16:"content-encoding";s:4:"gzip";s:7:"alt-svc";s:19:"h3=":443"; ma=86400";s:4:"x-nc";s:9:"HIT ord 2";}s:5:"build";i:1764805302;s:21:"cache_expiration_time";i:1766858185;s:23:"__cache_expiration_time";i:1766858185;}','off');
INSERT INTO `wpnc_options` VALUES (24192,'_site_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1766858185','off');
INSERT INTO `wpnc_options` VALUES (24193,'_site_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1766814985','off');
INSERT INTO `wpnc_options` VALUES (24194,'_site_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9','1766858186','off');
INSERT INTO `wpnc_options` VALUES (24195,'_site_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:112:"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"WordPress Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:28:"http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:2:"en";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:47:"WordPress Planet - http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:50:{i:0;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Matt: Riley Walz";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150936";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:33:"https://ma.tt/2025/12/riley-watz/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:676:"<p>The writer Aadil Pickle has a <a href="https://sfalexandria.com/posts/rileys-ideas/">great profile of one of my favorite hackers, &#8220;Training the Idea Muscle&#8221; on Riley Walz</a>. Riley epitomizes the term &#8220;high agency,&#8221; and I&#8217;ve been continually impressed with his ability to rapidly code novel ideas and interfaces on top of public or reverse-engineered data. He&#8217;s a hacker, artist, and provocateur.</p>\n\n\n\n<p>I&#8217;m enjoying this slower time of the year, and it looks like this will be the warmest Christmas I can remember in Houston; it was 80° F today! Makes me appreciate what Christmas in the southern hemisphere must be like.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 24 Dec 2025 00:32:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:139:"Gutenberg Times: Roadmap for WordPress 7.0 and schedule, commands for the Command Palette, Gutenberg 22.3, and more — Weekend Edition 353";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://gutenbergtimes.com/?p=43471";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:143:"https://gutenbergtimes.com/roadmap-for-wordpress-7-0-and-schedule-commands-for-the-command-palette-gutenberg-22-3-and-more-weekend-edition-353/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:26120:"<p>Hi there, </p>\n\n\n\n<p>Welcome to our last edition for the year 2025. I am not ready to reflect on the whole year, however, I am excited for 2026. There will be many new features coming to WordPress with the three major releases and also plenty of bug fixes and quality-of-life enhancement towards consistency. </p>\n\n\n\n<p>The first edition for 2026 will have to wait a bit and it is scheduled for January 24, 2026, roughly a month from now, due to my vacation and training schedule.</p>\n\n\n\n<p>I wish you and yours wonderful Holidays and a happy, prosperous and healthy New Year! <img alt="🤶" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f936.png" style="height: 1em;" /><img alt="🎄" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f384.png" style="height: 1em;" /><img alt="🎁" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f381.png" style="height: 1em;" /><img alt="🎆" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f386.png" style="height: 1em;" /><img alt="🎇" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f387.png" style="height: 1em;" /></p>\n\n\n\n<p>Yours, <img alt="💕" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f495.png" style="height: 1em;" /><br /><em>Birgit</em></p>\n\n\n\n\n\n<p><strong>Steve Burge</strong> and <strong>Dan Knaus</strong>s interviewed me for the PublishPress podcast. We covered WordPress 6.9&#8217;s six new blocks (accordion, term query, time to read, math, comment count, and comment link) plus editorial notes for team collaboration. The release marks a restart after Automattic&#8217;s contribution pause.</p>\n\n\n\n<p>WordPress 7.0 ( April 9, 2025) will bring template management improvements and a tabs block. The AI team is building foundational infrastructure—Abilities API, MCP Adapter, PHP AI SDK, and experiments plugin—enabling plugins to integrate with AI assistants. Real-time collaborative editing remains in development, facing technical hosting challenges. <a href="https://www.youtube.com/watch?v=_9doWARTmWc">The recording is available on YouTube.</a></p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<h2 class="wp-block-heading" id="0-word-press-release-information">Roadmap WordPress 7.0 and two more releases in 2026</h2>\n\n\n\n<p>In his lates post, <strong>Matias Ventura</strong>, lead architect of Gutenberg, laid out <a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/"><strong>the plan for WordPress 7.0.</strong></a>  It&#8217;s aspirational and not all the items will make it into the next major version of WordPress. The very detailed plan covers the project’s shift into Phase 3: Collaboration, a vision for real-time co-editing, and enhanced communication through site notes. Ventura underscores the modernization of the administrative experience via a unified design system and expanded DataViews. By integrating a standardized AI API and advancing responsive editing tools, WordPress 7.0 aims to unify the design and development process. Ultimately, the release promises to deliver a more cohesive and performant platform through refined navigation and versatile new core blocks. Here are the broad topics of the plan. </p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#collaboration">Collaboration </a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#admin">Admin</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#apis">APIs</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#navigation-block">Navigation Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#customization">Customization</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#blocks">Blocks</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#media">Media</a></li>\n</ul>\n\n\n\n<p><strong>Jonathan Desrosiers</strong> also published the <a href="https://make.wordpress.org/project/2025/12/18/proposal-2026-major-release-schedule/"><strong>proposed schedule of the 2026 </strong></a>releases. Following the schedule, we have two more dates to put on our calendars: Beta 1 for WordPress 7.0 will be on February 19, and RC 1 is scheduled for March 19, 2026. </p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Table of WordPress release dates for 2026" class="wp-image-43753" height="479" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-20-at-19.32.47.png?resize=652%2C479&#038;ssl=1" width="652" /></figure>\n\n\n\n<p>Provided the Release squad approves this schedule. I also can offer a timeline for the <strong>WordPress 7.0 Source of Truth:</strong> First draft will be available for public preview on February 26, 2026, and the post will be published on March 26, 2026.</p>\n\n\n\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">\n<p><img alt="🎙" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f399.png" style="height: 1em;" /> The latest episode is <a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/">Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2</a> with <strong>JC Palmes</strong>, WebDev Studios</p>\n\n\n\n<figure class="wp-block-image size-full is-style-no-vertical-margin"><img alt="Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack" class="wp-image-43283" height="186" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1" width="652" /></figure>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h2 class="wp-block-heading" id="gutenberg-22-3-and-beyond">Gutenberg 22.3 and beyond</h2>\n\n\n\n<p><strong>Hector Prieto</strong> led the release of <a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/">Gutenberg 22.3 (December 17)</a>. In his release post he highlighted:</p>\n\n\n\n<ol class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#dedicated-fonts-page-for-easier-typography-management">Dedicated Fonts page for easier typography management</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#image-editing-improvements">Image editing improvements</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#responsive-grid-block">Responsive Grid block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#other-highlights">Other highlights</a></li>\n</ol>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Dave Smith,</strong> core conditrbutor on the GGutenbergProject explains in his video <br /><a href="https://www.youtube.com/watch?v=wWR6_DHQoI4"><strong>The changes leveling up Navigation in WordPress 7.0</strong></a>,He wrote in tthedescription: &#8220;Navigation is one of the most important — and most frustrating — parts of building a WordPress site.In this video, I walk you through what’s changing, why it matters, and show the real work already underway — including early prototypes and demos.&#8221; Check it out. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<h2 class="wp-block-heading" id="0-p">Plugins and Tools for #nocode site builders</h2>\n\n\n\n<p><strong>Jamie Marsland</strong> is at it again with short videos and teaching you new skills. In his latest video <a href="https://www.youtube.com/watch?v=qGKVSl7_1EU"><strong>&#8220;How to Create a High-Converting Landing Page With WordPress (Free Blueprint)&#8221;</strong></a> he gives you step -y -tep instructions for an easy way to create high-converting WordPress landing pages using only core blocks. He built a distraction-free landing page based on the <a href="https://storybrand.com/">StoryBrand</a> methodology, so each section has a clear purpose and guides visitors through a simple story as they scroll.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<p><strong><a href="https://x.com/SarahPerezTC">Sarah Perez</a>,</strong> consumer tech editor at TechCrunch, reported that &#8220;<a href="https://techcrunch.com/2025/12/03/wordpresss-vibe-coding-experiment-telex-has-already-been-put-to-real-world-use/"><strong>WordPress’s vibe-coding experiment, Telex, is now being used</strong></a>&#8221; and it features Automattic’s AI tool for natural language web development. Introduced at the &#8220;State of the Word&#8221; event, <a href="https://telex.automattic.com">Telex</a> allows users to create complex Gutenberg blocks, like pricing calculators and logo carousels, without coding. Perez highlights how &#8220;vibe coding&#8221; makes site building accessible for non-tech users, enabling them to create professional results. With the new Abilities API, Telex marks WordPress’s move toward AI-driven workflows that streamline the design process.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong><a href="https://x.com/courtneyr_dev">Courtney Robertson</a></strong> Developer advocate at GoDaddy released the plugin <a href="https://wordpress.org/plugins/post-formats-for-block-themes/"><strong>Post Formats for Block Themes</strong></a>, which brings back old-school post formats to modern WordPress block themes. It restores useful features for galleries, quotes, and videos often missing in newer themes. You’ll find smart auto-detection, unique block patterns for each format, and a handy Chat Log block for easy transcripts. By combining these classic tools with today’s full-site editing, this plugin helps creators maintain a great design and add variety in a simple and accessible way.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Valentin Grenier</strong>, a WordPress developer from Toulouse, France, just dropped his first plugin: <strong><a href="https://wordpress.org/plugins/simple-block-animations/">Simple block animations</a></strong>. It’s a cool, lightweight tool for adding some fun scroll-triggered visual effects to your Gutenberg blocks without needing to mess with any custom code. You get five different animation types, like fades and slides,, thatyou can tweak with durations and delays. Built using the <a href="https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API">Intersection Observer API</a> and good old native CSS, it keeps things running smoothly by loading assets only when they&#8217;re needed while also being mindful of motion preferences to make it accessible. </p>\n\n\n\n<h2 class="wp-block-heading" id="2-word-press-6-0-1-and-6-1-scheduled">What&#8217;s new in WordPress Playground</h2>\n\n\n\n<p>Felyph Centra posted a few video on WordPressTV to showcase various features of WordPress Playground </p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/previewing-github-branches-with-wordpress-playground/">Previewing GitHub branches with WordPress Playground</a>. </strong>This video demonstrates a method to streamline development reviews. This technique addresses the common pain point of needing complex local environments or relying on static screenshots to share work in progress.</p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/introduction-to-wordpress-playground-landing-page/">Introduction to WordPress Playground landing page</a></strong>. The new landing page explains the capabilities of the platform and what is possible with WordPress Playground.</p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/using-wordpress-playground-to-work-with-ai-agents/">Using WordPress Playground to work with AI agents</a></strong>. Centra shared how you can use the WordPress Playground to integrate with AI agents. with an example that uses GitHub Copilot agents. Using this flow it executes small tasks for a plugin, such as refactoring code or updating documentation. WordPress Playground can serve as a base to validate the AI agent’s code changes using E2E tests.</p>\n\n\n\n<p>In the post <a href="https://make.wordpress.org/playground/2025/12/19/action-required-github-proxy-com-shutdown/"><strong>Action required: github-proxy.com shutdown</strong></a> Centra lays out the migration to switch over from a third-party proxy server to Playground&#8217;s built -n CORS handling. Your existing blueprints are safe, though. If you worked with Blueprints you can also learn how to reference GitHub repos, folders and files with native Playground resources. </p>\n\n\n<div class="ng-block-33a6410edf0f4b89 wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #fdfcea; border-radius: 12px;"><div class="ng-block-016cde0c67ecc1db wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong> <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/" rel="noreferrer noopener" target="_blank">&#8220;Keeping up with Gutenberg—Index- Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. </p></div></div></div></div>\n\n<div class="ng-block-e4c56c7fd61fe2c8 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>The previous years are also available: <br /><strong><strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/">2020</a> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/">2021</a></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/">2022</a></strong></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023">2023</a></strong> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/"><strong>2024</strong></a></p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<h2 class="wp-block-heading" id="3-building-themes-for-fse-and-word-press">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p>In this week&#8217;s livestream<strong> JuanMa Garrido </strong>explored how to <a href="https://www.youtube.com/watch?v=ETqUp0UXH0k" rel="noreferrer noopener" target="_blank">create commands for the Commands Palette</a>. WordPress 6.9 brought the Command Palette to the whole WordPress space and not just restrict it to the Site Editor. Now all plugin developer can register commands together with their plugin&#8217;s features. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Justin Tadlock</strong> published the monthly roundup on <a href="https://developer.wordpress.org/news/2025/12/whats-new-for-developers-december-2025/">What’s new for developers? (December 2025)</a>, noting WordPress 6.9 “Gene” and pointing to the 6.9 Field Guide and State of the Word. Highlights include the new AI Experiments plugin, Breadcrumbs block improvements heading toward stability, and an experimental Tabs block. Tooling updates cover WPCS 3.3.0, Data Views/Forms and Field API enhancements, <code>@wordpress/boot</code> routing, and a visibility key rename. Themes and Playground also saw notable updates.</p>\n\n\n\n<p><strong>Ryan Welcher</strong> shot a video <a href="https://www.youtube.com/watch?v=ApGnD888tZs" rel="noreferrer noopener" target="_blank">What’s New For WordPress Developers – December 2025</a>, covering the parts of the blog post. </p>\n\n\n\n<figure class="wp-block-image size-full"><a href="https://www.youtube.com/watch?v=ApGnD888tZs"><img alt="" class="wp-image-43627" height="360" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-17-at-15.28.46.png?resize=650%2C360&#038;ssl=1" width="650" /></a></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>As a reader of this newsletter you might already know about <a href="https://developer.wordpress.com/studio/">WordPress Studio</a>, the fast, free, open-source local development tool, that&#8217;s based on WordPress Playground. <strong>Nick Diego </strong>recorded a <a href="https://www.youtube.com/watch?v=wxBXWmo2oV0"><strong>Getting Started with WordPress Studio</strong></a> video and walks you through  creating local sites, configuring your environment, and using the tools that come bundled with the app. You’ll also learn how to unlock advanced features with a free WordPress.com account, including syncing with WordPress.com and Pressable, sharing live preview links, and using the built-in AI Assistant to accelerate development. Whether you build plugins, create themes, or manage client projects, Studio helps you work faster and smarter.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In her post, <strong><a href="https://eventkoi.com/blog/event-query-loop-block-guide/">Build Custom Event Lists &amp; Grids With One Block: Event Query Loop Block Ultimate Guide</a></strong>, <strong>Lesley Sim</strong> shared a comprehensive tutorial for managing EventKoi’s specialized query block within WordPress. The post details how to create custom list and grid layouts using various query parameters, such as date ranges and recurring event instances, without any coding. By explaining the block&#8217;s internal structure and the flexible Event Data block, Sim illustrates how users can achieve precise design control and dynamic content display.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In his latest post for the WordPress Developer Blog, <strong><a href="https://developer.wordpress.org/news/2025/12/word-switcher-extending-core-blocks-with-interactivity/">Word Switcher: Extending Core Blocks with Interactivity</a></strong>, <strong>JuanMa Garrido</strong> provides a practical guide for beginners on enhancing standard WordPress blocks using native tools. Garrido demonstrates how to combine the <strong>Format API</strong> for editor controls, the <strong>HTML API</strong> for server-side processing, and the <strong>Interactivity API</strong> for frontend animations. Developers learn to create a &#8220;word switcher&#8221; effect that cycles through text variations without relying on heavy external libraries. This approach ensures a lightweight, performant, and professional workflow that bridges the gap between simple content entry and modern, reactive web design.</p>\n\n\n<div class="ng-block-528ec927148e518a wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #f8f8f8; border-radius: 8px;"><div class="ng-block-13dccbc29b9082f8 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong><a href="https://gutenbergtimes.com/need-a-zip-from-master/">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p></div></div></div></div>\n\n<div class="ng-block-9e2e20ae3728509d wp-block-newsletterglue-image ng-block size-full is-resized" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px;"><a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json"><img alt="" class="wp-image-42874 ng-image" height="45" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2025-11-15-at-12.06.44.png?resize=196%2C45&#038;ssl=1" style="border-style: none; border-color: transparent;" width="196" /></a></div></div></div></div>\n\n<div class="ng-block-fa7f2ca3bf976542 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>Now also available via <a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href="mailto:pauli@gutenbergtimes.com">Email me </a>with your experience.</p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p class="has-text-align-center has-small-font-size"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href="mailto:pauli@gutenbergtimes.com">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p class="has-text-align-center has-small-font-size">For questions to be answered on the <a href="http://gutenbergtimes.com/podcast">Gutenberg Changelog</a>, <br />send them to <a href="mailto:changelog@gutenbergtimes.com">changelog@gutenbergtimes.com</a></p>\n\n\n<div class="ng-block-ad1f04c54cda68ee wp-block-newsletterglue-separator ng-block" style="color: #666666;" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; color: #666666;"><hr style="background-color: transparent; color: transparent; margin: 0; border: 0; border-top: 1px solid #666666; width: 560px; height: 0;" /></div></div></div></div>\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%"><div class="ng-block-a5c06fb13fd8b8b8 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 14px; font-family: Helvetica; line-height: 0.2; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong>Featured Image: </strong></p></div></div></div></div></div>\n\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 20 Dec 2025 18:35:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Birgit Pauli-Haack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"Matt: Wolfram Automattica";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150898";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:42:"https://ma.tt/2025/12/wolfram-automattica/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2079:"<figure class="wp-block-image size-large"><img alt="" class="wp-image-150900" height="337" src="https://i0.wp.com/ma.tt/files/2025/12/Gemini_Generated_Image_pzhu6zpzhu6zpzhu-1024x572.png?resize=604%2C337&#038;quality=80&#038;ssl=1" width="604" /></figure>\n\n\n\n<p>It&#8217;s exciting to announce that <a href="https://www.wolframalpha.com/input/?i=stephen+wolfram">Stephen Wolfram</a> has joined as a special advisor to <a href="https://automattic.com/">Automattic</a>.</p>\n\n\n\n<p>I promise this is not just because he is such <a href="https://writings.stephenwolfram.com/">an incredible blogger</a>, using WordPress, natch.</p>\n\n\n\n<p>If you don&#8217;t know about Stephen Wolfram, <a href="https://www.stephenwolfram.com/about/">his about page is not a bad place to start</a>, but far more interesting is his <a href="https://writings.stephenwolfram.com/2019/02/seeking-the-productive-life-some-details-of-my-personal-infrastructure/">2019 essay on Seeking the Productive Life</a>, which includes a setup for hiking outdoors while typing on a laptop.</p>\n\n\n\n<p>Stephen was doing the remote CEO thing decades before I imagined Automattic. He spoke at Automattic&#8217;s Grand Meetup in 2019 and one of my favorite memories was seeing him at the silent disco after-party. We also did <a href="https://distributed.blog/2019/10/03/turning-ideas-into-real-things/">an episode of the Distributed podcast together</a>.</p>\n\n\n\n<p>Since he started engaging more deeply earlier this year, I&#8217;ve gotten a lot of joy from seeing him interact with teams across the company, asking questions in an incisive, inquisitive way that helps break down problems. We just finished up several hours of a deep dive into our board topics with several hundred Automatticans participating.</p>\n\n\n\n<p>Automattic has been blessed with amazing directors over the years. Currently, our board is <a href="https://en.wikipedia.org/wiki/Susan_Decker">Susan Decker</a>, <a href="https://en.wikipedia.org/wiki/Ann_E._Dunwoody">General Ann Dunwoody</a>, <a href="https://toni.org/">Toni Schneider</a>, and me.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 19 Dec 2025 02:47:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:88:"Open Channels FM: Delivering Customer Value Through Collaborative Ecosystem Partnerships";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113501";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:95:"https://openchannels.fm/delivering-customer-value-through-collaborative-ecosystem-partnerships/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:199:"In this podcast, Jonathan chats with Sandra from Greyd and Tim from BigScoots about forming strong partnerships in WordPress. They share tips on success, collaboration, and maintaining relationships.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 18 Dec 2025 10:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Matt: The Thinking Game";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150883";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"https://ma.tt/2025/12/the-thinking-game/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:596:"<p>If you haven&#8217;t seen it, The Thinking Game documentary is excellent, and available for free on YouTube.</p>\n\n\n\n<figure class="wp-block-embed alignfull is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p>You have to buy it, but the Kanye documentary <a href="https://www.inwhosenamemovie.com/">In Whose Name</a> is also pretty fascinating. (I first blogged about Kanye in 2007, <a href="https://ma.tt/2007/07/on-php/">discussing PHP&#8217;s botched version 4 to 5 upgrade</a>.)</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 18 Dec 2025 05:29:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:112:"WPTavern: #198 – Muntasir Sakib on Bridging the Gap Between WordPress Plugin Development and Marketing Success";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=201777";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:126:"https://wptavern.com/podcast/198-muntasir-sakib-on-bridging-the-gap-between-wordpress-plugin-development-and-marketing-success";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:49111:"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, build it and they might come, bridging the gap between WordPress plugin development and marketing success.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you or your idea featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Muntasir Sakib. Muntasir, has been active in the WordPress space since 2018, working with well-known plugins and companies such as Tutor, LMS, Droip and more. He&#8217;s played a key role scaling products from their early days helping them achieve wider adoption.</p>\n\n\n\n<p>He&#8217;s also been active in the WordPress community more broadly at events such as WordCamp Asia and Word Camp Sylhet.</p>\n\n\n\n<p>The focus of today&#8217;s episode is a crucial, yet often overlooked topic, especially if you&#8217;re a plugin developer. It&#8217;s a chat about the moment when plugin development ends and the real success can begin. In a WordPress marketplace that&#8217;s more crowded and competitive than ever, simply build it and they will come, does not mean that users will. Muntasir wants to bust the myth by digging into why marketing is essential from day one, and not an afterthought left until launch day.</p>\n\n\n\n<p>We start by learning about Muntasir&#8217;s journey through the WordPress ecosystem, and his approach to balancing development and marketing for plugins. He explains the key differences between marketing in the WordPress ecosystem versus the SaaS world. In WordPress, you don&#8217;t control the full stack and your users expect openness and interoperability, making community focus and support critical.</p>\n\n\n\n<p>The discussion then turns to the practicalities of launching and growing a plugin. Why throwing new features at a product isn&#8217;t enough, and why listening to users and building community relationships is often more valuable than racing to add features no one has asked for.</p>\n\n\n\n<p>We talk about the dos and don&#8217;ts gained from Muntasir&#8217;s experience, including the pitfalls of relying on lifetime deals for early revenue, and why a recurring revenue model is key for long-term sustainability.</p>\n\n\n\n<p>We also talk through the role of community, partnerships, and events like WordCamps, not just as marketing opportunities, but as places to build the relationships and collaborations that can help plugins thrive.</p>\n\n\n\n<p>if you&#8217;re a WordPress plugin developer wondering how to turn a finished product into real success, or you&#8217;re trying to figure out where marketing fits into your roadmap, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Muntasir Sakib.</p>\n\n\n\n<p>I am joined on the podcast by Muntasir Sakib. Hello.</p>\n\n\n\n<p>[00:03:47] <strong>Muntasir Sakib:</strong> Hello, Nathan. How are you doing?</p>\n\n\n\n<p>[00:03:48] <strong>Nathan Wrigley:</strong> Yeah, good. Very nice to connect with you. We&#8217;ve had a long chat prior to hitting the record button. And we really touched on all sorts of things in life. But that&#8217;s not the purpose of the podcast today. We&#8217;re going to keep it firmly on the WordPress side of things, and particularly about marketing, I guess maybe a good way to sum it up, which is a topic that we don&#8217;t often get into.</p>\n\n\n\n<p>Before we get into that, Muntasir, I wonder if you wouldn&#8217;t mind just introducing yourself. Just tell us a little bit about yourself and what you do. How come you&#8217;re connected to the WordPress community? Whatever you think fits the bill.</p>\n\n\n\n<p>[00:04:18] <strong>Muntasir Sakib:</strong> Thank you, Nathan, for giving me the opportunity to talk about myself a bit, and it&#8217;s nice being with you here.</p>\n\n\n\n<p>Well, I&#8217;m Muntasir, I&#8217;m Muntasir Sakib and I have been with WordPress since 2018. So you can say over half a decade. And throughout my career, I worked for some really, really amazing plugins and companies such as Tutor LMS, Droip, EasyCommerce, Core Designer, ThumbPress.</p>\n\n\n\n<p>So when I joined JoomShaper, like premium, back in the days, I was talking about 2019, we had Tutor LMS and Tutor LMS had probably 15,000 or less active installations back in the time. And then within three and a half years, with the help of the amazing team we had back then, we all worked together day and night, and with our beautiful clients and customers all around the globe we achieved 100,000 plus active installations within three and a half years. And that was a phenomenal number to mention in the WordPress industry, in the WordPress ecosystem.</p>\n\n\n\n<p>And then there&#8217;s Droip, the first ever true no-code website builder for WordPress, and that was born. It got a traction that we ever expected it to be that much. So we were overwhelmed about it as well.</p>\n\n\n\n<p>And then during my tenure so far, I, along with my team, represented Tutor LMS and Droip at WordCamp Asia 2023, WordCamp Sylhet 2023 and some other WordPress meetups as well.</p>\n\n\n\n<p>And why did we join WordCamps? That could be a question. It&#8217;s because we sponsored those events to show our gratitude to the WordPress community and the ecosystem. Because there&#8217;s a thing in WordPress, which we say Five for the Future, as per Matt. So every product companies and every business that do business in the WordPress industry should contribute in the WordPress ecosystem, contributes in the open source market so that it get better every day.</p>\n\n\n\n<p>Because we are working in the ecosystem, we bring some real value for our clients. So what if our foundation is not strong enough to get those clients, to get those correct tractions? Because in the SaaS market nowadays, there are lots of, plethora of SaaS products, but we have to bring something together, stronger and better than SaaS, so that people believe in us and they come together to work with us and use our products.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> Yeah, thank you. So you&#8217;ve been working with a variety of different clients in the WordPress space. And when I put out a message saying, I&#8217;d like to chat with a variety of people on this podcast, you reached out and you mentioned that you wanted to talk about essentially the gap where development finishes and success begins. Because I think it&#8217;s fair to say that if you were to rewind the clock, I don&#8217;t know, maybe 15 years or something like that, maybe 10 years, it was much more straightforward to build a product as a developer, put it out into the marketplace, and because you were potentially the prime mover, the first person to have such a thing, you might succeed just off the basis of build it and they will come. That old chestnut.</p>\n\n\n\n<p>Whereas now the marketplace is much more mature, much more saturated. And so the idea of build it and they will come. Oh, really, I mean unless you are incredibly fortunate, or maybe you&#8217;ve already had some success and so have, I don&#8217;t know, your company has notoriety or what have you, that really isn&#8217;t the case anymore. When development finishes there needs to be this whole marketing piece that swings into action to alert the community.</p>\n\n\n\n<p>So how would you differentiate between the plugin marketplace, in terms of marketing, and the SaaS marketplace? What makes those two things different?</p>\n\n\n\n<p>[00:07:59] <strong>Muntasir Sakib:</strong> Well, that&#8217;s a pretty important question that we mostly overlook. Nathan, thank you for bringing that out. We need to be very specific. When it&#8217;s about WordPress product marketing, it&#8217;s more like ecosystem driven than SaaS. When we&#8217;re talking about SaaS, you control the entire environment, your onboarding journey, your analytics, your pricing model, your customer journey. Everything is under the one umbrella.</p>\n\n\n\n<p>But when it&#8217;s about WordPress, then you are selling inside an open ecosystem where users make dozens of plugins together. So you cannot give your customer some boundaries that if you use my product or my plugin, you cannot use others. It doesn&#8217;t make any sense.</p>\n\n\n\n<p>So they&#8217;re going to use as many plugins as they want to, and you have to be compatible with every one of those. So you don&#8217;t control hosting, themes, PHP versions or the user&#8217;s technical setup, all of which impact your product experience, right?</p>\n\n\n\n<p>And in wp.org, wp.org acts as a distribution channel. So you need to think about it. It&#8217;s more of like app store, which influence reviews, support expectations, and growth. In most cases, all the products start from wp.org, which provides a free version of every plugin.</p>\n\n\n\n<p>So the founders and the marketers mostly overlook the thing that free plugin often becomes your biggest acquisition engine. So your marketing depends heavily on the documentation, the on point documentation, and the onboarding journey inside your WordPress dashboard. Your operation, the smoother it is, the better it&#8217;ll be to get the traction of the pro customers and the continuous updates, and your community presence. If you have no community presence in the ecosystem in your WordPress community, then you are just gone.</p>\n\n\n\n<p>[00:09:50] <strong>Nathan Wrigley:</strong> It&#8217;s so curious, when you sort of say it like that, the idea of logging into the WordPress backend, if you&#8217;re a plugin developer or a regular user of WordPress, you&#8217;ll be really familiar with this. If you go into a website, there&#8217;s often dozens of different things. And maybe a lot of them are kind of overlapping, so there might be things which integrate with other things. And as a plugin developer, that kind of overhead is something that you just don&#8217;t really need to worry about with SaaS, because you just build the thing, and you make sure that it works and everybody logs in, and it works because it&#8217;s yours and you control the infrastructure and the hardware that it&#8217;s on and the servers and all of that kind of stuff.</p>\n\n\n\n<p>Whereas the WordPress thing, it&#8217;s just so much more complicated and you&#8217;ve really got to be thinking all the time about sticking to coding standards to make sure that at least you know your thing is doing it right. And if there&#8217;s a conflict and something breaks, well, you can be fairly sure that it wasn&#8217;t your fault, it might be somebody else&#8217;s fault. So it is much, much more complicated.</p>\n\n\n\n<p>And then throw into it all of the other bits and pieces that you&#8217;ve just mentioned, community and all of that kind of stuff. I mean, it really is a very complicated picture, and I think getting more and more complicated year by year.</p>\n\n\n\n<p>So have you, in your previous work, have you kind of identified this moment where the development cycle ends and the marketing cycle begins, if you like, but the plugin developer has basically made no preparation for the marketing piece? They&#8217;ve just built things and then have an expectation that, oh, it&#8217;ll just sell itself. Do you see that? Is that a real thing?</p>\n\n\n\n<p>[00:11:22] <strong>Muntasir Sakib:</strong> Yeah, that&#8217;s definitely a real thing. And the thing is, I don&#8217;t give the blame to the developers actually, because they were supposed to build the product, they were supposed to follow the compliance issues, and they&#8217;re supposed to build fresh code so that the thing cannot break when people are using it massively.</p>\n\n\n\n<p>But it&#8217;s mostly from our and from the marketers end that we need to tell them beforehand, like what to do and how can we get the KPIs? What are the things that we need to sell to our customers that going to help them to solve their problems?</p>\n\n\n\n<p>Because the fun fact is, in most cases, when our founders or a developers is planning to build a product, a plugin, they were thinking from their end like, okay, fine, I want to build a product so that the product going to be that much good that everyone going to use it. But it&#8217;s not the case, because we have almost like 59,000 plugins right now in WordPress directory. So in every category, in every niche, there&#8217;s a plethora of products, plethora of competitors. So there were some big competitors and there are some upcoming competitors who are small.</p>\n\n\n\n<p>So how they compete with someone who has already hundred thousand or a million of active installations, millions of happy users. We cannot compete them with just everything they have. Whether if we come with some specific niche, like some specific problems that they&#8217;re facing from our competitors, and we can add value to them, to our clients, they would be happy enough to try our product.</p>\n\n\n\n<p>So you need to give something to the customers first so that they can rely on you. And if you have a good reputation beforehand, like if you are not new in this industry, you have some other plugins beforehand, and if have a good reputation and you are coming with another solution, they&#8217;re surely going to try it. And there&#8217;s the catch.</p>\n\n\n\n<p>When people start using your product, they give you the feedback, and those feedbacks are gold mines. So you need to talk with your customers. You need to talk with the developers. You need to connect with them on regular basis. And that&#8217;s the job of us. That&#8217;s the real job of us, like the support system, the marketers, content creators. The documentations all need to come along and they need to figure out the problems, what they&#8217;re facing, and what the customers are asking for. What are the bugs they&#8217;re having? It can be a bug based on their environment, like everyone has their different environment, right?</p>\n\n\n\n<p>But the thing is, when we speak to the customers, when we talk to them and when we try to figure out their issues and try to solve their problems, they&#8217;re going to do the best marketing you can ever imagine, the word of mouth. And WordPress is doing the exact same thing. WordPress is depending on word of mouth. Your 10 happy customers is way more important and valuable to you than a hundred thousand dollars.</p>\n\n\n\n<p>[00:14:08] <strong>Nathan Wrigley:</strong> And I think that kind of speaks to what I would imagine, or at least what I would hope to be the case. When I look back at my time in WordPress and I go right back to the beginning of it, it felt like a really good, solid playground for hobbyists. There were an awful lot of people who were doing things for a hobby, and then now it&#8217;s become much more professional. In fact, when I joined the WordPress community, that whole thing was just beginning to open up. There were a few companies who were making a great deal of success for themselves, selling things into the marketplace, you know, they had a free version and a pro version. But it was still, it still felt like the beginning of that, the wild west of that.</p>\n\n\n\n<p>And I think that still there&#8217;s a little bit of that hobbyist mentality still out there where, you know, you attend events, you hang out with like-minded people. You can see that this individual over here, they had success, I could do the same. But there&#8217;s that whole thing that you&#8217;ve got to have prior to building anything, and it sounds to me like you&#8217;re making a real difference between the marketing people and the development people.</p>\n\n\n\n<p>And, okay, maybe you are this unique person that can do both. Maybe you are brilliant at developing and you are going to be an amazing marketer. I think it&#8217;s fair to say that most people are not that. They don&#8217;t have the time, they&#8217;ve got other things to do, their skillset is developing, their skillset is marketing, they&#8217;re kind of different entities.</p>\n\n\n\n<p>But it feels like for many people, that realisation hasn&#8217;t been made yet, that you need to, before launching, so maybe even at the moment you think, I am going to build this thing, maybe that&#8217;s the moment where you think, okay, two thirds of my budget is going to go into development and one third into marketing, or 50 50 or 70 30, or whatever it may be. I think that&#8217;s what you&#8217;re saying is that you need to be thinking about this right from the beginning, not leaving it until the last minute if you want it to be a success.</p>\n\n\n\n<p>[00:15:57] <strong>Muntasir Sakib:</strong> Exactly, exactly. You have to have a plan from day one when you started developing a product. How and where should I go? Who are my primary audiences? Whom to reach out. Which influencers should we work with? And when should I give them the beta version to test? I can give a beta version to like hundreds of peoples, who are willingly giving it a try. Tell us some beautiful insights, some valuable insights so that we can develop the product even more before going to the market. So that&#8217;s the thing.</p>\n\n\n\n<p>In most cases, what developers are thinking, what mostly the founders who are mostly developers, they&#8217;re thinking like, well, I can develop the product like 80% and then for the rest 20%, we can start working with the marketing team. I can think of how to go to the market and how to have some early traction. Early traction is easy, but it&#8217;s not the kicker. Early traction is easy because if you have a freemium plan, you can definitely go for wp.org. There&#8217;s a free version so everyone can use it.</p>\n\n\n\n<p>There&#8217;s a term, founder led marketing. So when you are a founder, yeah, you can just announce on your socials, like, yeah, I have a plugin. I developed it and I launched it on wp.org so you can try it. Everyone going to try it. No problem on that. But the thing is, there might be a hundred plus active installations on day one, but on day three it could go way below 10, 10 to 15.</p>\n\n\n\n<p>So where are the rest of the people went? They just came here to try the product, you didn&#8217;t ask for anything. You didn&#8217;t know how to contact with them. You didn&#8217;t know how to collect the data, how to collect the information that you don&#8217;t have in your mind, in your head. What&#8217;s the fuss about? What&#8217;s the problem they&#8217;re having? So they didn&#8217;t even bother to share?</p>\n\n\n\n<p>You need to ask first. Be the first person to ask the questions like, what are the problems you are having using my product? I eagerly want to know. I want to solve your problem. So when I am talking with each and every person, each and every client, as he&#8217;s valuable, we bring value to their life, they&#8217;re going to bring something for me too.</p>\n\n\n\n<p>[00:18:01] <strong>Nathan Wrigley:</strong> Yeah, I think the curious thing about a lot of the developers that I know who&#8217;ve brought a plugin to the market is that they&#8217;ve been focused a lot on the features. They&#8217;ve got this laundry list of features and they get really wrapped up in the features and they execute that, they build the features. And then maybe somewhere along the line they realise, oh, there&#8217;s this other feature that would be quite nice to have. Yeah, let&#8217;s do that. And then before you know it, the idea of launching the product just gets pushed back and back and back because, oh, there&#8217;s another feature and, oh, I&#8217;ve thought of another feature. And on it goes.</p>\n\n\n\n<p>And the whole time you haven&#8217;t been doing exactly what you said, kind of trying to figure out how to build up an audience, trying to figure out how to get influencers involved, how to put it out on, in this case, wordpress.org or whatever it may be. And that whole puzzle, that whole jigsaw piece, inside that puzzle needs to be thought out, I think for many people, at a much earlier date.</p>\n\n\n\n<p>I get quite a lot of email from people who would like to have some product or service distributed through something like a podcast. On some level, it&#8217;s amazing that the people would like me to help them, but also when you go to the property that they&#8217;ve got, you can see that the thing that they&#8217;ve built is amazing, but also the marketing side of things hasn&#8217;t really been taken care of. So the website is nowhere near the standard that the plugin is. Everything about it, you know, the documentation is nowhere near the standard that the plugin is and so on. So there&#8217;s this sort of real disconnect.</p>\n\n\n\n<p>So do you have any like do&#8217;s and don&#8217;ts? Have you got any, like a list of things that you highly recommend people do if they want to market a plugin? But also some things which you think, actually no, stay away from that, that&#8217;s snake oil, people have tried that and it doesn&#8217;t seem to work. Any order of any of those things.</p>\n\n\n\n<p>[00:19:35] <strong>Muntasir Sakib:</strong> Absolutely. If you&#8217;re talking about like developing features and releasing it every alternate week, these are the most common picture when we are thinking about WordPress ecosystem, or any other products. 80% people are doing that. But the problem occurs when, feature first development means you keep building what you want, not what your customers actually struggle with, right?</p>\n\n\n\n<p>So when you release a product, you have the roadmap. You make it public. You show the customers like, well, these features are coming next, but people don&#8217;t bother about what features are coming next, they&#8217;re mostly bothered about what you have right now, and are those working properly or not? You might have, like when you were thinking of any e-commerce, you might have 20 or 30 payment gateway integrations with it. But I don&#8217;t need all the payment gateway integrations, right? I need specifically like one or two, like maybe I need PayPal integrations or Stripe integrations or Wise or some other integrations like Klarna.</p>\n\n\n\n<p>The rest of the integrations you have are useless to me, so I don&#8217;t even bother whether they&#8217;re coming or not. I do bother about my product and I do bother about whether, as I am using your product, so even giving me the value of my requirements, like the PayPal is working fine, in the next update the PayPal is working still fine and it&#8217;s secured. When I click the update button, or if I enabled auto update, with an update the PayPal is not working. My business will go through the loss.</p>\n\n\n\n<p>So it&#8217;s your responsibility to take care of my business because I&#8217;m using your product. So you have to make sure that every specific niche I am giving the solution for, are working properly after every updates and everything.</p>\n\n\n\n<p>I often see companies who are trying to develop the update version, who are trying to give updates regular basis. They often consider giving it the quality assurance, the QA. The QA team mostly were doing nothing. They were just going through on the surface level. They bring the update, and then the people updated it, and the site crashed. And then they figured out, well, it might be your environment issues. It might be from your end because we are doing nothing. It&#8217;s working fine from our end. So let me see. Give me your backend credentials so that I can see what&#8217;s going on here. It&#8217;s a big no. It&#8217;s a big no for me. If you are talking about me, like it&#8217;s a big no. Why would I give my credentials to you? It&#8217;s your responsibility to take care of your product so that it&#8217;s working fine from my end.</p>\n\n\n\n<p>These are the common things, and apart from that, when we are talking about feature first development, this leads to slower performance. The more the features, the slower the performance is, and it&#8217;s non-negotiable. The higher support workload and our roadmap, as I said, a roadmap that is reactive, not strategic. So strategic roadmap is important. Reactive roadmap means you are actually way far behind from your competitors. So many founders think that features is equal to value, but features are not equal to value. In reality, clarity, reliability, and use case fit, drive adoption and revenue.</p>\n\n\n\n<p>[00:22:49] <strong>Nathan Wrigley:</strong> So the really interesting thing about this is that there&#8217;s really two completely different worlds in collision here. So if you are the developer, you are basically sat in a chair looking at a screen, wrangling code. And it&#8217;s this, you&#8217;ve got this small window on the universe. You&#8217;re just sort of staring into this thing. You&#8217;ve got complete control over it. And it&#8217;s clean and it&#8217;s, I don&#8217;t really know how to describe it. It&#8217;s all just right in front of you.</p>\n\n\n\n<p>Whereas the other side, the marketing side is the exact opposite. It&#8217;s like, turn away from the computer and look at the entire planet. Every single human being in it, all of the messiness of that, trying to find them, trying to figure out how you&#8217;re going to talk with them, trying to figure out how you&#8217;re going to let them know that you exist. Trying to figure out how you&#8217;re going to let them know that your product is exactly what they need. Trying to figure out how to do the SEO piece, and we could go on and on.</p>\n\n\n\n<p>There really are two very different universes colliding there. And I feel that in many cases, a really different personality type fits those things. Like, you know, the developer sitting in the chair concentrating on that code is a really different kind of personality type, if you know what I mean, than the person who can turn around, look at the world, cope with that messiness and figure all of that out. I&#8217;m not saying that they&#8217;re not possible by two people, I&#8217;m just saying they are very, very different things. One, much messier and harder to figure out than the other.</p>\n\n\n\n<p>But from what you are saying as a developer, you have to do both. You have to turn around and look at the world in all of its messiness because your users are going to kind of, you know, they&#8217;re the people that are going to tell you whether or not what you&#8217;re building is a good thing or what they need.</p>\n\n\n\n<p>[00:24:26] <strong>Muntasir Sakib:</strong> No, no, I think we got it wrong because I didn&#8217;t say that developers need to do both of the work, they need to code fresh and they need to look around all the users, what they&#8217;re saying and how their product is performing. It&#8217;s not their job.</p>\n\n\n\n<p>We need to be very specific. If I&#8217;m a developer, my only responsibility should be to do fresh code and to make sure that my product is working fine on every environment. And it&#8217;s the marketer&#8217;s duty to talk to the customers, to talk to the world, and if as a founder, I don&#8217;t need to jeopardise my business, my company, then I need to align with everything, with every team possible. Like there&#8217;s sales team, there&#8217;s marketing team, there&#8217;s support team, content team, developer team.</p>\n\n\n\n<p>The thing is, market research should be done by the marketers. Market research should be done, the customers should be talked with the marketers, with the salespeople. They need to come along with the ideas that, well, fine, these are the opportunities we have right now. So if we want to build a product, if we want to develop a product, we need to bring these three or four features before releasing the product in the market because these are the things people are having problem with. So I am giving you this list of features, or this list of things that you need to have in your product, and then it can go to the design team. The design team come up with a very beautiful design and then the developers start developing it.</p>\n\n\n\n<p>And then we need to figure out the fact that, well, the product is almost 80% done, so we need to reach to the influencers, we need to reach to some YouTube influencers who have great audience so that they can use it. So we can give them the beta version. They can use it, they can bring some beautiful solutions, some beautiful suggestions to make the product even more mature before going to the market. And we can share the thought with the developers so that they can update accordingly.</p>\n\n\n\n<p>[00:26:22] <strong>Nathan Wrigley:</strong> Right, I got it. Yeah, so I get the piece there. So really when I was talking about, you know, the developer facing one way and then facing the other way, the computer and the world, you are introducing then, in the middle, the developer turns around and instead of talking to the world, talks to the marketer.</p>\n\n\n\n<p>And then the marketer absorbs those messages, whatever it is that the developer thinks, okay, it&#8217;s ready, it&#8217;s nearly ready, here&#8217;s the features. They communicate with the marketing people, the marketing people turn that into real world action. And then they themselves turn around and look at that bigger world and figure out how to do that.</p>\n\n\n\n<p>I think the curious thing is, in our community, there&#8217;s so many of the solo developers who, when that thing that you&#8217;ve just suggested, gets suggested. That some of the budget goes to a marketer, it&#8217;s like, no, no, no, no, no, no, I can do it all. I&#8217;ll be fine, because we know it can work in some rare cases. But it&#8217;s not going to be as effective as getting somebody else on board.</p>\n\n\n\n<p>But I think in our community, there is a, I don&#8217;t really know how to encapsulate this, but there&#8217;s a little bit of a divide between the marketing side of things, the sort of sponsorship side of things, the affiliate side of things, all of those bits, and the developers. And it&#8217;s not always an easy conversation to have.</p>\n\n\n\n<p>I suppose, in the end it comes down to things like money and things like that, which our community is maybe not as comfortable talking about as other different communities.</p>\n\n\n\n<p>So is there anything that you think is a bad idea? I remember in the show notes that you sent to me, there were a few things where you thought, for example, you mentioned things like the one-time revenue trap of lifetime deals and things like that. Do you want to mention some of the gotchas, some of the things in the past that you&#8217;ve thought, nope, don&#8217;t do that, that&#8217;s a bad idea?</p>\n\n\n\n<p>[00:28:00] <strong>Muntasir Sakib:</strong> Yeah. You were talking about the solo developer. There are a lot of solo developers, I might say. I must say because they are a one person team, and every project they build, every line of code they write, it&#8217;s like their children. So it&#8217;s always normal to be biased to your product. Like, yes, my product is the best because I have developed it with all my passion, with all my hard work. Why aren&#8217;t people using it?</p>\n\n\n\n<p>And you might have a tight budget because when you are solo developer, the budget&#8217;s going to be tight. So you might not have that much money to spend on marketing before going to the market. And that&#8217;s fine. Welcome the community because the WordPress community is so helpful that even if you go to the community people and you tell them like, well, I am working on a product all by myself, and I want someone to come up with me and test the product and give me some valuable insights about what I can do better, before going to the market. And they&#8217;re always helpful. There are like hundreds and thousands of people who can help you, making your product even better by testing your beta versions, by testing your RC versions.</p>\n\n\n\n<p>The thing is you have to be vocal. You have to talk to the poeple. You have to ask for help because you are helpless, you are working day and night on your product, and you cannot let people know, you cannot talk to people. You are very shy to ask for help, to ask for a hand. So how do I know that you are building a very beautiful product? I am here to help you, you just need to ask me. You want to give it a try? Sure thing. I will definitely give it a try and have some suggestions for you if you may allow me. That&#8217;s it.</p>\n\n\n\n<p>And about the question is one time revenue, you think? Yeah. And whether it&#8217;s a trap or not. It&#8217;s a trap. It&#8217;s a trap. Nathan, I can say to you, like many WordPress founders rely on lifetime deals, one time license and large seasonal discounts. I mean Black Friday, Cyber Monday, the year end sales. Might going to create some cash upfront, but that doesn&#8217;t bring sustainability.</p>\n\n\n\n<p>Sustainability is something way more different than cashflow. Because sustainability comes with recurring revenue. Your support is recurring, but if you have only lifetime deals, then your revenue is not. So how can you go along with your support team year after year, when you are running just once from a customer?</p>\n\n\n\n<p>Because once a customer has got something lifetime from your end, you have to give him support. You have to provide him top-notch support for the rest of your lives, for the rest of products life. And then every year, fixed cost goes up. Teams, servers, your support team will go along. Your team will be bigger than the last year, along with your product. So your fixed cost will always go up. And lifetime buyers often create the highest support load while paying the least.</p>\n\n\n\n<p>So you have to have that in your mind that when I am working for a easy traction and I am giving them the lifetime deals, and I want to onboard thousands of customers, lifetime customers, you need to think that you need to give them support, you need to develop the product for these thousand customers who will not ever going to pay a single penny to you anymore. So this is a big burden for you.</p>\n\n\n\n<p>So real WordPress companies that scale, focus on renewals, annual plans, and clear upgrade perks. So here are the things, you might have like three to four pricing plans for one site, for ten sites and for unlimited sites. And I bought the one site license. And then I fell in love with your product, and I want to upgrade to ten site plans. So there should be a very, like one click upgradation plan, upgradation system where I can just go from one site to ten sites. And if you can&#8217;t give me that opportunity, and if you going to tell me like, okay, fine, buy the ten site license, give me the one site license key, and I&#8217;m going to dispatch that. I&#8217;m going to deactivate that and activate your license manually, that doesn&#8217;t make sense because that&#8217;s a hassle to me. I&#8217;m your customer, so you need to give me the smoother way. This is the thing.</p>\n\n\n\n<p>[00:32:09] <strong>Nathan Wrigley:</strong> When you&#8217;ve been working for some of the, I don&#8217;t know, agencies or companies where there&#8217;s obviously a marketing team which has been a part of the success. Do you know roughly, I mean, maybe it&#8217;s just a ballpark figure, do you know roughly how much of the wider team so, you know, think of Company X, which is a development company, but they&#8217;ve got in-house marketing as well. Do you know how much of the company, in terms of personnel or revenue, is given over to marketing as opposed to everything else? So, you know, is it typically like in the sort of 20%, 30%, 50%? What&#8217;s your rough estimate for those?</p>\n\n\n\n<p>[00:32:43] <strong>Muntasir Sakib:</strong> My rough estimate is your marketing budget should always be at least 30% of your total estimation cost. Because marketers need to talk to people, they need to reach out to the people, and they need to collaborate with most of the influencers who going to work for you, and you have to give them the honorarium to do the work for you.</p>\n\n\n\n<p>So if the budget is not standard enough, then they have the boundaries to not do their works. So you need to give them the free hand, explore the sides to work with the other WordPress companies, to collaborate with better partners, to collaborate with other companies and to onboard their clients as well, so that your client base will increase day by day.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> And in the old way, when I was talking about sort of 15 years ago, it felt like most things were driven by interaction with the WordPress community. Do you think that&#8217;s still like a viable way of doing things or, you know, in the case of, I don&#8217;t know, let&#8217;s say that you&#8217;ve got an LMS plugin or something like that. Your market really isn&#8217;t other WordPressers, your market is the entire world, you know, educators and what have you.</p>\n\n\n\n<p>So do you put much stock in sort of turning up to events, and sponsoring WordPress stuff, or do you sort of advise, focusing on your customers? I&#8217;m just trying to figure out where the community bit might fit into all that.</p>\n\n\n\n<p>[00:33:59] <strong>Muntasir Sakib:</strong> Well, the thing is, let&#8217;s talk about the sponsorship first because in WordCamps you need to be sponsored under your product. If we are talking about any LMS plugin that we have. We want to let the WordPress community know that, yeah, we exist and we sponsor to this event. And the most important thing is only in the WordCamps or the WordPress meetups you&#8217;re going to get along with other companies in person, so that you can connect with them, you can talk to them. You can figure out an opportunity to work with other companies. If I am an LMS company, I have an LMS plugin, my customer&#8217;s going to need some hosting plan. They might need some security plugins. They might need some SEO plugins.</p>\n\n\n\n<p>[00:34:39] <strong>Nathan Wrigley:</strong> It&#8217;s more of a sort of partnership opportunity.</p>\n\n\n\n<p>[00:34:42] <strong>Muntasir Sakib:</strong> Exactly.</p>\n\n\n\n<p>[00:34:42] <strong>Nathan Wrigley:</strong> Figuring out who, in some curious case that you may not yet have imagined, how you could collaborate in the future. So like you said, you know, hosting or whatever it may be, or maybe there&#8217;s a form plugin out there, which you kind of get the intuition that, oh, we could use bits of your form to onboard people to our platform, or whatever it may be. So it&#8217;s very much not about marketing to the end user. It&#8217;s more about figuring out partnerships and things like that. But also being a good custodian of an open source project, I guess, as well.</p>\n\n\n\n<p>[00:35:11] <strong>Muntasir Sakib:</strong> Of course, yeah. That&#8217;s true. Because in every other companies who are doing great in WordPress ecosystem, they have a very strong relationship with the other companies. They have the mutual connections with all the people, with all the companies their customers might going to need. And the partnerships, affiliates are the best way to do the marketing to grow, to scale your product in WordPress market. Because as I said at first, word of mouth is something that brings the most valuable customers in your back.</p>\n\n\n\n<p>[00:35:40] <strong>Nathan Wrigley:</strong> Yeah, I mean, you only have to look on Facebook and LinkedIn and things like that to realise that there&#8217;s a lot of people in the WordPress community who attend these events and hang out with other people at these events and make great friendships and partnerships and those kind of things. I presume they&#8217;re doing it because, A, it&#8217;s fun, but also there&#8217;s a real value to it, you know? I know all these people and so I know where to go when I&#8217;ve got a particular problem, or I just have an intuition that I want to spin my company off in a slightly different direction. I&#8217;ve now got some people that I know, some contacts that I&#8217;ve already made who might be able to help me with that.</p>\n\n\n\n<p>Okay. What about the, sort of last one, and it&#8217;s actually alluding to your, one of the questions that you wrote here. Is there anything about the sort of psychology of this, the sort of mindset? Because I think with the best will in the world, a lot of people in our space, they kind of see marketing as a bit of a, an icky thing. Something that they really don&#8217;t feel comfortable doing.</p>\n\n\n\n<p>Is there any kind of psychology here that you could recommend or some kind of mind shift that somebody like me, for example, who is terrible at marketing, that I might be able to undergo, some magic wand that you can wave to help me out?</p>\n\n\n\n<p>[00:36:41] <strong>Muntasir Sakib:</strong> We all are learners. We learn every day. I&#8217;m still a learner, and most of the world famous marketers are learners, even the passionate developers. You still learn how to develop well, how to write fresh code in even a better way.</p>\n\n\n\n<p>But the most important thing is there are some mindset differences. There are someone who is a builder, and there are someone who is a business owner. So the thin line between builders and business owners are builders think about features. They think about features, what to come along with next, what to give to our customers, whether they like it or not. But founders think, I build outcomes and value. I bring value to the customers.</p>\n\n\n\n<p>Another mindset, if we talk about like the short term revenue and the long-term sustainability. So when we are selling lifetime deals, one time license, that&#8217;s the short term revenue that give me an early traction, a good traction within a few months. But it&#8217;ll never going to be sustainable. If you want to be sustainable, you need to have a recurring plan, you need to have recurring customers, you need to onboard more customers, but your recurring customers should be like around 70 to 80% or even more than that, so that you can sustain all along.</p>\n\n\n\n<p>Then if I&#8217;m talking about another mindset that it can be the focus on the product versus focus on the user. Failing founders, like those who cannot scale, they think that what feature should we add next? But the scaling founders, if you talk to them, they&#8217;re going to think where my users are getting stuck, so I need to solve the problem first. I need to bring value to their life so that they come along with me. They&#8217;re going to be my best audience and they&#8217;re going to do the marketing for me.</p>\n\n\n\n<p>[00:38:24] <strong>Nathan Wrigley:</strong> This stuff is so intuitive to you because obviously it&#8217;s something that you&#8217;ve spent a long time thinking about. I&#8217;ve got to say, for me, a lot of this stuff is kind of intuitive, but not at the same time. I&#8217;m definitely more on the kind of builder side than on the marketing side. I don&#8217;t know what it is about marketing, I just struggle to do those kind of things.</p>\n\n\n\n<p>And you&#8217;ve written a lot of your thoughts up in three articles, which you&#8217;ve published on LinkedIn. I don&#8217;t know if they&#8217;ve been published elsewhere, but they&#8217;re definitely on LinkedIn. And they describe all of the different scenarios of, you know, what founders need to do, how plugins can have success, where the community lies, how you can get yourself involved in different things. But also quite a lot of work you&#8217;ve put into what not to do. So example, lifetime deals, which you don&#8217;t think are a particularly great idea.</p>\n\n\n\n<p>I&#8217;m going to link to all of those different bits and pieces in the show notes so that people can go and read those, and then hopefully having been armed with all of that knowledge, they&#8217;ll understand better what it is that we&#8217;ve been talking about.</p>\n\n\n\n<p>Where do we find you, Muntasir? Where do we go online? Apart from LinkedIn, obviously, where could we find you?</p>\n\n\n\n<p>[00:39:28] <strong>Muntasir Sakib:</strong> I&#8217;m always available on Facebook, on Twitter. And I am always available on LinkedIn as well. These are the platforms you are going to find me.</p>\n\n\n\n<p>[00:39:36] <strong>Nathan Wrigley:</strong> Well, I will link to the LinkedIn posts and I will endeavor to dig out your Twitter handle as well. So hopefully people can find you and if they&#8217;ve got questions, you are open to suggestions.</p>\n\n\n\n<p>So thank you so much for chatting to me today. A subject of great interest to me because, well, as I said, there&#8217;s just great interest for me. I won&#8217;t say more than that. But thank you very much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:39:56] <strong>Muntasir Sakib:</strong> Thank you, Nathan. Thank you for talking to me. And it&#8217;s great talking to you and sharing my knowledge and expertise with you.</p>\n</div></details>\n\n\n\n<p>So on the podcast today we have <a href="https://www.linkedin.com/in/muntasir-m-sakib/">Muntasir Sakib</a>.</p>\n\n\n\n<p>Muntasir has been active in the WordPress space since 2018, working with well-known plugins and companies such as Tutor LMS, Droip and more. He’s played a key role scaling products from their early days, helping them achieve wider adoption. He’s also been active in the WordPress community more broadly at events such as WordCamp Asia and WordCamp Sylhet.</p>\n\n\n\n<p>The focus of today’s episode is a crucial yet often overlooked topic, especially if you’re a plugin developer. It’s a chat about the moment when plugin development ends and real success can begin. In a WordPress marketplace that’s more crowded and competitive than ever, simply ‘build it and they will come’ does not mean users will. Muntasir wants to bust the myth by digging into why marketing is essential from day one, and not an afterthought left until launch day.</p>\n\n\n\n<p>We start by learning about Muntasir’s journey through the WordPress ecosystem, and his approach to balancing development and marketing for plugins. He explains the key differences between marketing in the WordPress ecosystem versus the SaaS world. In WordPress, you don’t control the full stack and your users expect openness and interoperability, making community focus and support critical.</p>\n\n\n\n<p>The discussion then turns to the practicalities of launching and growing a plugin. Why throwing new features at a product isn’t enough, and why listening to users and building community relationships is often more valuable than racing to add features no one has asked for.</p>\n\n\n\n<p>We talk about the do’s and don’ts gained from Muntasir’s experience, including the pitfalls of relying on lifetime deals for early revenue, and why a recurring revenue model is key for long-term sustainability.</p>\n\n\n\n<p>We also talk through the role of community, partnerships, and events like WordCamps, not just as marketing opportunities, but as places to build the relationships and collaborations that can help plugins thrive.</p>\n\n\n\n<p>If you’re a WordPress plugin developer wondering how to turn a finished product into a real success, or you’re trying to figure out where marketing fits into your roadmap, this episode is for you.</p>\n\n\n\n<h2 class="wp-block-heading">Useful links</h2>\n\n\n\n<p>Project / Events which Muntasir has been involved with:</p>\n\n\n\n<p><a href="https://tutorlms.com"> Tutor LMS</a></p>\n\n\n\n<p><a href="https://droip.com">Droip</a></p>\n\n\n\n<p><a href="https://easycommerce.dev">EasyCommerce</a></p>\n\n\n\n<p><a href="https://thumbpress.co">ThumbPress</a></p>\n\n\n\n<p><a href="https://www.joomshaper.com"> JoomShaper</a></p>\n\n\n\n<p> <a href="https://asia.wordcamp.org/2023/">WordCamp Asia 2023</a></p>\n\n\n\n<p><a href="https://sylhet.wordcamp.org/2023/">WordCamp Sylhet 2023</a></p>\n\n\n\n<p>Three of Muntasir&#8217;s articles on LinkedIn:</p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/why-marketing-still-missing-piece-most-wordpress-product-sakib-fdz0c/">Why Marketing Is Still the Missing Piece for Most WordPress Product Companies</a></p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/hidden-cost-lifetime-deals-what-plugin-owners-dont-realize-sakib-pbmqc/">The Hidden Cost of Lifetime Deals: What Plugin Owners Don&#8217;t Realize Until It&#8217;s Too Late</a></p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/after-5-years-10-plugins-heres-why-most-wordpress-products-sakib-fcw0c/">After 5 Years and 10+ Plugins: Here’s Why Most WordPress Products Fail to Scale</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 Dec 2025 15:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Nathan Wrigley";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Open Channels FM: Why Context Matters in Accessibility Conversations";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113262";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://openchannels.fm/why-context-matters-in-accessibility-conversations/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:177:"Discussions on digital accessibility should prioritize context and collaboration among teams, focusing on empathy and practical scenarios to enhance user experience and support.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 Dec 2025 11:05:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"Matt: Beware Unearned Wisdom";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150856";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://ma.tt/2025/12/beware-unearned-wisdom/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:3687:"<p>One of Carl Jung&#8217;s famous quotes is to &#8220;Beware unearned wisdom.&#8221; Sometimes it&#8217;s brought up in the context of psychedelics. From <em><a href="https://www.amazon.com/LSD-Mind-Universe-Diamonds-Heaven/dp/1620559706?tag=photomatt08-20">LSD and the Mind of the Universe by Christopher Bache</a></em>:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p id="1d2d">Psychedelics give us temporary access to realities beyond our pay grade, allowing us to experience things beyond our normal capacity.</p>\n\n\n\n<p id="b3a6">It’s all too easy to think that because we have had a deep and profound experience, we have become a deep and profound person, but this is a fool’s delusion.</p>\n\n\n\n<p id="7186">Even when psychedelics allow us to experience the person we are in the process of becoming, we have to face the fact that we have not become this person yet, nor have we fully internalised the wonderful qualities we may have temporarily touched.</p>\n</blockquote>\n\n\n\n<p>I&#8217;m starting to see some of the same things happening with vibe coding and LLM writing.</p>\n\n\n\n<p>Sam Kriss at the New York Times took on the inevitably meta task of writing <a href="https://www.nytimes.com/2025/12/03/magazine/chatbot-writing-style.html?unlocked_article_code=1.508.ClUh.Sb1fCpBAo94F&amp;smid=url-share&amp;ref=platformer.news">Why Does A.I. Write Like … That?</a> It&#8217;s a good read that will tickle your mind, as the mimetic effects of model training data overfit and influence society, even in how we speak and write when not using AI.</p>\n\n\n\n<p>I&#8217;m starting to get that &#8220;feel&#8221; now, sometimes when using software. The demo or functionality seems amazing, but when you begin to poke around the edges, it all crumbles. We think we have something amazing because a chatbot one-shot an application, but there may be a hidden technical debt there.</p>\n\n\n\n<p>A big focus for me in this coming year is &#8220;back to basics&#8221;: ensuring the core functionality is robust. You can&#8217;t build a house on a foundation of sand. It&#8217;s very exciting and tempting to go to the new shiny thing, but you only earn that right when the fundamentals are solid. </p>\n\n\n\n<p>It&#8217;s been funny <a href="https://www.wsj.com/tech/ai/openais-altman-declares-code-red-to-improve-chatgpt-as-google-threatens-ai-lead-7faf5ea6">hearing about OpenAI&#8217;s Code Red</a>, because about 18 months ago, I declared Code Blue on WordPress.com. In a hospital, Code Red means a fire, which I don&#8217;t think is the analogy OpenAI was going for, but I unfortunately learned <a href="https://ma.tt/2016/04/in-memoriam-chuck-mullenweg/">when my father passed</a> that Code Blue means all hands on deck because a patient has a cardiac or respiratory arrest; it signals a critical, life-threatening medical emergency. All the best specialists swarm in and, hopefully, save the patient. (BTW, on <a href="https://wordpress.com/">WordPress.com</a>, the team has done a fantastic job of shipping literally thousands of bug fixes and quality improvements, and keeping focus on that despite the pull to new initiatives. There&#8217;s much left to do, but it&#8217;s headed in the right direction.)</p>\n\n\n\n<p>The <a href="https://en.wikipedia.org/wiki/Cambrian_explosion">Cambrian explosion</a> of new stuff built by AI is just a phase, and AI-assisted coding can actually be incredible for maintenance and bug fixes. But the tools are only as good as the <a href="https://en.wikipedia.org/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy">questions we ask them</a>, so it will have to battle with human nature&#8217;s addiction to novelty.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 Dec 2025 04:21:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:104:"Open Channels FM: Open Channels FM Announces the Return of Do the Woo as a Dedicated WooCommerce Podcast";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113549";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:111:"https://openchannels.fm/open-channels-fm-announces-the-return-of-do-the-woo-as-a-dedicated-woocommerce-podcast/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:284:"PRESS RELEASE: The relaunch of the Do the Woo podcast under the Open Channels network aims to create a dedicated platform for the WooCommerce ecosystem. It will provide insights and discussions tailored for merchants, developers, and product teams, starting with guest Matt Mullenweg.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Dec 2025 15:19:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:78:"Open Channels FM: Relaunching Do the Woo Podcast for the WooCommerce Ecosystem";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113479";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:85:"https://openchannels.fm/relaunching-do-the-woo-podcast-for-the-woocommerce-ecosystem/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:352:"Today we are officially announcing the relaunch of Do the Woo as a fully dedicated WooCommerce podcast under the Open Channels network. The show returns with a new mission, a refined focus, and a commitment to becoming the central place where the entire WooCommerce ecosystem can learn, share, and connect. More information about the relaunch [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Dec 2025 12:03:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Katie Keith";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:103:"Open Channels FM: Do the Woo Podcast is Back with Conversations for Builders, Merchants, and Developers";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113449";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:108:"https://openchannels.fm/do-the-woo-podcast-is-back-with-conversations-for-builders-merchants-and-developers/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:216:"The "Do the Woo" podcast is returning, focusing on WooCommerce insights, featuring industry leaders. It will include lively discussions, audience Q&#038;As, and monthly episodes with hosts James Kemp and Katie Keith.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Dec 2025 12:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:26:"Matt: Cloudflare CMS Stats";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150858";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:43:"https://ma.tt/2025/12/cloudflare-cms-stats/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:684:"<p>Cloudflare released their Radar report for 2025, one fun stat was they analyzed the top 5,000 domains, and it had some interesting results <a href="https://radar.cloudflare.com/year-in-review/2025#website-technologies">for website technologies</a>. Open Source tech came in at 47% for WordPress and 4.7% for Drupal, <em>which wins the majority</em>! Then in proprietary there was Adobe at 16%, Contentful at 8%, Shopify at 1.9%&#8230;</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-150859" height="383" src="https://i0.wp.com/ma.tt/files/2025/12/cloudflare-website-tech-1024x649.png?resize=604%2C383&#038;quality=80&#038;ssl=1" width="604" /></figure>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Dec 2025 00:41:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Nex Playground";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150848";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2025/12/nex-playground/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:855:"<p>The Wall Street Journal has a fun article about the Nex Playground, <a href="https://www.wsj.com/business/entrepreneurship/nex-playground-toy-game-console-holiday-shopping-af47125f">The Hottest Toy of the Year Is Made by a Tech Startup You’ve Never Heard Of</a>. It&#8217;s a very fun way to game with friends and stay active, so afterward you have that same great feeling like after playing a sport. I think this is the first time one of <a href="https://audrey.co/">Audrey Capital&#8217;s companies</a> (we invested when it was <a href="https://www.homecourt.ai/">the Homecourt app</a>) is the hot Christmas item. <a href="https://www.amazon.com/Playground-AI-Powered-Transforms-Not-Machine-Specific/dp/B0D2JGYX3F?tag=photomatt08-20&amp;th=1">Here&#8217;s it on Amazon</a>, though it looks like it doesn&#8217;t ship before Christmas right now.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 15 Dec 2025 05:59:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Matt: Apple iWeb";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150841";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:33:"https://ma.tt/2025/12/apple-iweb/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1024:"<p>The new X/Twitter algorithim is hard to predict, but I&#8217;ve had <a href="https://x.com/photomatt/status/1999769782279938531">one go viral with over a million views now</a>, a quote-tweet of a cool demo video of Apple&#8217;s website builder from 2009, with themes and blog support and everything. Interesting to compare its interface to Gutenberg and WordPress today.</p>\n\n\n\n<figure class="wp-block-embed is-type-rich is-provider-twitter wp-block-embed-twitter"><div class="wp-block-embed__wrapper">\n<div class="embed-twitter"><blockquote class="twitter-tweet"><p dir="ltr" lang="en">We don’t even know how to build this anymore. <a href="https://t.co/Y21FIwVIft">https://t.co/Y21FIwVIft</a></p>&mdash; Matt Mullenweg (@photomatt) <a href="https://twitter.com/photomatt/status/1999769782279938531?ref_src=twsrc%5Etfw">December 13, 2025</a></blockquote></div>\n</div></figure>\n\n\n\n<p>For <a href="https://www.apple.com/welcomescreen/ilife/iweb-3/">the video to play on the webpage</a>, you have to visit in Safari.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 14 Dec 2025 05:57:55 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Matt: Winter Fun";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150836";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:33:"https://ma.tt/2025/12/winter-fun/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1017:"<p>The colors here have now gone blue for winter, and snow has started, <a href="https://wordpress.org/plugins/snow-fall/">thanks to the excellent Snow Fall plugin</a>. I also wanted to congratulate <a href="https://www.wealthfront.com/blog/wealthfront-ipo-public-company/">Wealthfront on their IPO</a>. Many on their team have been friends or advisors over the years, from David Fortunato responding to my email about their WordPress blog being on an old version when they launched, to the amazing <a href="https://adamnash.blog/">Adam Nash</a> who teaches <a href="https://cs007.blog/">CS 007 Personal Finance for Engineers at Stanford</a>, and he now runs the awesome <a href="https://www.daffy.org/">Daffy donor-advised tax fund startup</a>. I was an early customer, and even on their homepage as a testimonial in 2011, <a href="https://audrey.co/">Audrey Capital</a> has been an investor since 2013 and if you <a href="https://wlth.fr/XArG0h">sign up with this link we both get 5k extra managed for free</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 13 Dec 2025 04:43:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"Donncha: Make Photo Competitions Simple";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:28:"https://odd.blog/?p=89592184";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://odd.blog/2025/12/12/make-photo-competitions-simple/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:10072:"<p>Running a photography club competition used to mean juggling spreadsheets, chasing emails, and manually tallying votes. I built <a href="https://wordpress.org/plugins/photo-competition-manager/">Photo Competition Manager</a> to change that.</p>\n\n\n\n<p>This free WordPress plugin handles everything your club needs: member management, secure uploads, flexible voting, and beautiful results displays.</p>\n\n\n\n<p>This will suit a photography club that uses WordPress for their website and that has a projector for their meetings. If you already run a photo league with projected images or prints but collect votes from your club members using pen and paper you&#8217;re the perfect candidate to try this plugin.</p>\n\n\n\n<p>This is the very first release of this plugin. It has been used a couple of times to run several test photo competitions and one monthly league competition. However, bugs happen. I would love if your photography club used this plugin but I will need feedback to improve it. Run a couple of test competitions first to get used to how it works.</p>\n\n\n\n<h3 class="wp-block-heading">Getting Started in Minutes</h3>\n\n\n\n<p>The setup wizard creates all the required pages automatically. Select the pages you need, click a button, and you&#8217;re ready to go.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592186 not-transparent" height="679" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.47.34-1.avif" width="762" /></figure>\n</div>\n\n\n<p></p>\n\n\n\n<h3 class="wp-block-heading">Manage Your Membership</h3>\n\n\n\n<p>The Members page is your central roster. Add members individually or bulk import from CSV. Assign grades, track status, and send magic-link upload invitations with a single click.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592188 not-transparent" height="1041" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.47.05-1.avif" width="1270" /></figure>\n</div>\n\n\n<p>Each member gets a unique upload URL—no passwords to remember, no accounts to create. They click the link and upload.</p>\n\n\n\n<h3 class="wp-block-heading">Create and Track Competitions</h3>\n\n\n\n<p>The competitions dashboard shows a list of competitions, allowing you to edit them and send out upload emails to members. Only one competition may be active at a time, but a competition may have more than one category. </p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592190 not-transparent" height="600" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.47.20-1.avif" width="1278" /></figure>\n</div>\n\n\n<p>Create competitions with custom categories (Colour, Mono, Projected, etc), grade divisions (Beginner, Intermediate, Advanced), and submission quotas. Each competition can have its own rules without affecting your defaults.</p>\n\n\n\n<h3 class="wp-block-heading">Watch Submissions Roll In</h3>\n\n\n\n<p>As members upload, the submissions page displays thumbnails of every entry. You&#8217;ll see who&#8217;s submitted, which categories are filling up, and whose photos are still missing.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592191 not-transparent" height="580" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.48.00.avif" width="1016" /></figure>\n</div>\n\n\n<p></p>\n\n\n\n<h3 class="wp-block-heading">A Frictionless Upload Experience</h3>\n\n\n\n<p>When members click their magic link, they land on a clean upload form. They select their category, choose their image, and submit. The progress banner shows upload status in real time.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592193 not-transparent" height="982" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.43.06-1.avif" width="876" /></figure>\n</div>\n\n\n<p></p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592194 not-transparent" height="145" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.43.34.avif" width="821" /></figure>\n</div>\n\n\n<p></p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592195 not-transparent" height="739" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.43.54.avif" width="873" /></figure>\n</div>\n\n\n<p>The plugin handles validation automatically—file types, dimensions, and quota limits are all enforced before the image is accepted.</p>\n\n\n\n<h3 class="wp-block-heading">Complete Control Over Voting</h3>\n\n\n\n<p>The voting controls page is your competition command centre. From here you can:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Open and close voting for each category independently.</li>\n\n\n\n<li>Toggle the results display on or off.</li>\n\n\n\n<li>Enable slideshow mode for in-person club nights.</li>\n\n\n\n<li>Disable uploads once the submission deadline passes.</li>\n\n\n\n<li>Show a QR code for members to scan with their phones to vote.</li>\n</ul>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592196 not-transparent" height="674" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.48.33.avif" width="993" /></figure>\n</div>\n\n\n<p></p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592198 not-transparent" height="716" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.49.31-1.avif" width="993" /></figure>\n</div>\n\n\n<p>In the competition settings, you choose between token-based voting (unique links per member) or password-protected public voting. The voting controls page features a full-screen slideshow mode where members can vote together during meetings.</p>\n\n\n\n<p>On the night of the competition we do the following:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Close uploads and hide results.</li>\n\n\n\n<li>Show the slideshow with a 10 or 15-second delay as a preview.</li>\n\n\n\n<li>Display the QR code and make sure every member can scan it and open the voting page.</li>\n\n\n\n<li>Open voting and show the slideshow again.</li>\n\n\n\n<li>When everyone has voted, close voting.</li>\n\n\n\n<li>2 members of the club will then go through the images and offer a critique, using the slideshow again but in manual mode this time.</li>\n\n\n\n<li>Repeat for the next category.</li>\n\n\n\n<li>When all the voting is done, toggle the results page on and display the &#8220;top 3&#8221; results, and then the anonymous results page on the projector.</li>\n\n\n\n<li>Finally, an email is sent out to all members showing their score, ranking in their grade and the votes they received. Names are not attached to the votes for obvious reasons.<br /></li>\n</ul>\n\n\n\n<h3 class="wp-block-heading">Voting By Phone</h3>\n\n\n\n<p>Members can vote on the competition using their phones after they have scanned the QR code on the voting controls page.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex">\n<figure class="wp-block-image size-full"><img alt="" class="wp-image-89592202 not-transparent" height="1503" src="https://odd.blog/files/2025/12/voting1.avif" width="600" /></figure>\n\n\n\n<figure class="wp-block-image size-full"><img alt="" class="wp-image-89592203 not-transparent" height="661" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-18.31.11.avif" width="413" /></figure>\n</figure>\n\n\n\n<p></p>\n\n\n\n<h3 class="wp-block-heading">Results That Make Sense</h3>\n\n\n\n<p>When voting closes, the results dashboard breaks down every score by member grade. See vote distributions, identify your winners, and export everything to CSV for your records.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592199 not-transparent" height="1072" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-17.57.31.avif" width="1180" /></figure>\n</div>\n\n\n<p>The frontend includes a responsive top-3 podium display perfect for announcing winners, plus full results tables with filtering by grade and category.</p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592206 not-transparent" height="1170" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-18.27.44-1.avif" width="755" /></figure>\n</div>\n\n\n<p></p>\n\n\n<div class="wp-block-image">\n<figure class="aligncenter size-full"><img alt="" class="wp-image-89592207 not-transparent" height="1150" src="https://odd.blog/files/2025/12/Screenshot-2025-12-12-at-18.28.14.avif" width="1192" /></figure>\n</div>\n\n\n<p></p>\n\n\n\n<h3 class="wp-block-heading">Built for Photography Clubs</h3>\n\n\n\n<p>Photo Competition Manager was built specifically for the way camera clubs actually run competitions:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Magic-link authentication</strong> means members don&#8217;t need WordPress accounts to upload.</li>\n\n\n\n<li><strong>Grade-based scoring</strong> supports clubs that split their membership by experience level.</li>\n\n\n\n<li><strong>Slideshow mode</strong> turns any screen into a projection-ready display.</li>\n\n\n\n<li><strong>CSV export</strong> keeps your archives intact.</li>\n</ul>\n\n\n\n<h3 class="wp-block-heading">Get Started Free</h3>\n\n\n\n<p>Photo Competition Manager is free and GPL. Install it from the WordPress plugin directory or from the plugins page on your WordPress site in the usual way. Navigate to the Competitions menu to get started.</p>\n\n\n\n<p><a href="https://wordpress.org/plugins/photo-competition-manager/">Download Photo Competition Manager</a></p>\n\n\n\n<p>The source code is available on GitHub if you want to contribute or customise:</p>\n\n\n\n<p><a href="https://github.com/donnchawp/photo-competition-manager">View on GitHub</a></p>\n\n\n\n<p>Questions? Open an issue on GitHub or post in the WordPress support forum. I&#8217;d love to hear how your club uses it.</p>\n\n#Photography #photographyclub #WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 12 Dec 2025 19:11:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Donncha";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"Matt: Aldeas";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150817";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:29:"https://ma.tt/2025/12/aldeas/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1705:"<p>Tonight was a lot of threads connecting for me. At <a href="https://automattic.space/">Automattic&#8217;s Noho Space</a> we hosted an event for <a href="https://www.nytimes.com/2025/05/01/movies/martin-scorsese-pope-francis-documentary.html">Martin Scorsese&#8217;s new documentary about Pope Francis, called Aldeas</a>. There was a point in my life when I wanted to become a priest, and I had been inspired by meeting a Franciscan seminary student. I took it very seriously and considered that as a path for my life, but some combination of jazz and girls made me realize that the priesthood was not my destiny.</p>\n\n\n\n<p>The jazz led to building websites for Houston jazz musicians, which led to coding, which led to WordPress, which after a lot of twists and turns led to <a href="https://ma.tt/2019/08/tumblr-the-day-after/">Automattic acquiring Tumblr</a>. One of Tumblr&#8217;s <a href="https://en.wikipedia.org/wiki/Goncharov_(meme)">greatest memes was Goncharov</a>, directed by Martin Scorsese. The only reason Automattic, as a distributed company, has an office in NYC is because of the Tumblr acquisition. The office is filled with art from Tumblr artists so I had the very surreal experience of talking after Martin Scorsese, who at 83 is sharp as a tack and a gifted speaker, a few feet away from a <a href="https://en.wikipedia.org/wiki/Goncharov_(meme)#/media/File:Goncharov-poster.png">Goncharov poster</a> about how my Catholic upbringing led me down the path of starting WordPress, and how Pope Francis&#8217; life inspired the <a href="https://wordpress.org/news/2025/04/jubilee/">WordPress Jubilee</a> and <a href="https://ma.tt/2025/04/reflecting/">reflection</a>. Full circle.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 12 Dec 2025 05:45:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:94:"Open Channels FM: WordPress 6.9: From Streamlined Content Creation to Powerful Developer Tools";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113320";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:100:"https://openchannels.fm/wordpress-6-9-from-streamlined-content-creation-to-powerful-developer-tools/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:232:"In this episode, contributors Akshaya Rane, Birgit Pauli-Haack,  and Krupa Nanda discuss the collaborative process behind WordPress 6.9, highlighting features, performance upgrades, and emphasizing community involvement and testing.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 11 Dec 2025 10:40:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt: Year-end";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150805";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:31:"https://ma.tt/2025/12/year-end/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:230:"<p><a href="https://2025inreview.tumblr.com/">Tumblr has a fun 2025 in review</a>, and if you&#8217;re a <a href="https://pocketcasts.com/">Pocket Casts</a> user open the app to see all your stats for your listening this year.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 11 Dec 2025 03:40:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"WordPress.org blog: 2026 Global Partner Program Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19534";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/12/2026-global-partner-program/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:9308:"<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-19617" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<h2 class="wp-block-heading">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class="wp-block-heading">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class="wp-block-heading">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class="wp-block-heading">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class="wp-block-heading">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class="wp-block-heading">Program Benefits</h3>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td class="has-text-align-left"></td><td class="has-text-align-center"><strong>Global Leader</strong></td><td class="has-text-align-center"><strong>Regional Powerhouse</strong></td><td class="has-text-align-center"><strong>Community Builder</strong></td></tr><tr><td class="has-text-align-left"><br /><br /><br /><br /><strong>Best for:<br /></strong></td><td class="has-text-align-center">Established brands seeking global reach and year-round visibility.</td><td class="has-text-align-center">Companies aiming for regional dominance and strong brand recognition.</td><td class="has-text-align-center">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class="has-text-align-left">Sponsorship payable in full or through quarterly installments</td><td class="has-text-align-center">$180,000</td><td class="has-text-align-center">$110,000</td><td class="has-text-align-center">$60,000</td></tr><tr><td class="has-text-align-left">Top tier sponsorship benefits at all local <a href="https://central.wordcamp.org/">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"></td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Option to feature multiple brands across events</td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"></td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Dedicated sponsor landing page</td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Complimentary WordPress event tickets for your team</td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Recognition across all <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href="https://central.wordcamp.org/">WordCamps</a></td><td class="has-text-align-center">Quarterly</td><td class="has-text-align-center">Annually</td><td class="has-text-align-center"></td></tr><tr><td class="has-text-align-left">Inclusion of your company logo in signage and materials for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> events</td><td class="has-text-align-center">All signage &amp; materials for the year (digital and printed)</td><td class="has-text-align-center">Signage &amp; materials for 5 events per year (printed only)</td><td class="has-text-align-center">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class="has-text-align-left">Opportunity to be featured in an exclusive digital binder for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> event organizers</td><td class="has-text-align-center">Priority placement (logos &amp; text)</td><td class="has-text-align-center">Feature listing (text only)</td><td class="has-text-align-center">Feature listing (text only)</td></tr><tr><td class="has-text-align-left">Regular recognition in <a href="https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/">monthly education buzz report</a></td><td class="has-text-align-center"></td><td class="has-text-align-center"></td><td class="has-text-align-center"><img alt="✔" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" style="height: 1em;" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class="wp-block-heading">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class="wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained">\n<p class="has-text-align-center"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="mailto:support@wordcamp.org">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div class="wp-block-spacer" style="height: 25px;"></div>\n\n\n\n<p><em>Please see <a href="https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials">Rules for Sponsor Materials</a> for more details about terms of sponsorship. Please also see our <a href="https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf" rel="noreferrer noopener" target="_blank">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href="https://wordpressfoundation.org/donate/">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 17:16:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Harmony Romo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:20;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:100:"WPTavern: #197 – Johanne Courtright on Enhancing Gutenberg: Agency-Driven Block Editor Innovations";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=201629";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:113:"https://wptavern.com/podcast/197-johanne-courtright-on-enhancing-gutenberg-agency-driven-block-editor-innovations";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54861:"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, enhancing Gutenberg with agency driven block editor innovations.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. . Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Johanne Courtright. Johanne started working with WordPress back in 2011, moving over from a background in marketing agencies, Dreamweaver and Static HTML sites. Over the years, she&#8217;s become a skill developer, focusing on extending WordPress through custom queries, forms, integrations with APIs, and increasingly harnessing the power of the block editor and React.</p>\n\n\n\n<p>Johanne talks about her journey from the classic world of agency WordPress development to embracing Gutenberg, and the challenges and wins along the way. She shares her experience in building custom blocks, and enhancing existing ones to better serve agencies. Things like improving break points, color palettes, responsive designs, and navigation, all of which aren&#8217;t offered in Core yet. These features come together in her growing open source project Groundworx.</p>\n\n\n\n<p>We talk about the shifting landscape from classic themes to block-based themes, and why even in 2025, a lot of agencies and users are still hesitant to make the leap fully. Johanne explains where the block editor falls short for her use, and how Groundworx aims to plug these perceived gaps with a foundation of flexible, performant, agency focus blocks and templates.</p>\n\n\n\n<p>You will hear about her approach to building modular themes with theme.json, the realities of client work and scope creep, and how the 80 20 rule shapes what belongs in Core, and what&#8217;s best handled by plugins.</p>\n\n\n\n<p>We also get into the challenge of discovery in the WordPress plugin ecosystem, her wishlist for block editor improvements, and her take on the future of block-based businesses in WordPress.</p>\n\n\n\n<p>Whether you&#8217;re a developer eager to modernize your workflow, or just curious about extending Gutenberg for real world use, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Johanne Courtright.</p>\n\n\n\n<p>I am joined on the podcast by Johanne Courtright. Hello, Johanne.</p>\n\n\n\n<p>[00:03:21] <strong>Johanne Courtright:</strong> Hi. Nice to be here.</p>\n\n\n\n<p>[00:03:22] <strong>Nathan Wrigley:</strong> Yeah, very nice to have you with us. I put a tweet out not that long ago, seeing if anybody wanted to come on the WP Tavern Jukebox podcast, and Johanne was very kind and reached out to me. And we had a little bit of toing and froing. Not a lot, but a little bit. And I thought that the topic of conversation that she suggested was extremely curious.</p>\n\n\n\n<p>As you&#8217;ll discover in a moment, Johanne has been working hard trying to make the block editor, well, I&#8217;m going to use the word improved. Trying to add things to the block editor to make it more usable.</p>\n\n\n\n<p>That conversation though, probably would benefit from us knowing exactly who you are, and what your background is. Maybe if we stick to the WordPress bits and pieces, but would you mind just giving us a little biography? Tell us a bit about you.</p>\n\n\n\n<p>[00:04:00] <strong>Johanne Courtright:</strong> Sure. I got into WordPress in 2011, working for a marketing agency. It solved a big problem at the time coming from Dreamweaver, HTML static pages. My writing to that was a lot of convincing, but it was a very welcome change. WordPress made a huge impact on a lot of agencies.</p>\n\n\n\n<p>And so we used it for, primarily for home builders, and it was great. Discovered Advanced Custom Fields, tapped into that. Custom post types. It was a lot of fun for many years and I&#8217;ve worked for other agencies after that too, and my specialty has always been around extending as far as I can. Custom queries and forms, tapping into CRM and with APIs and all sorts of things. Anything that can be done with WordPress I was doing it, pretty much.</p>\n\n\n\n<p>[00:04:55] <strong>Nathan Wrigley:</strong> Are you self-taught then, or have you learned on the job? Or did you go through like a university program or something like that?</p>\n\n\n\n<p>[00:05:00] <strong>Johanne Courtright:</strong> Just learned on the job. Just looking for solution, and WordPress felt like it was a great fit. A lot of support online, a lot of documentation, just a lot of people providing enough documentation to be able to explore was very helpful. And there was Joomla and Drupal that was also contenders, but I didn&#8217;t like Drupal&#8217;s interface, and I wasn&#8217;t a fan of how unstable Joomla was from updating versions to versions. So for me, it was a pretty fast decision to go with WordPress.</p>\n\n\n\n<p>[00:05:35] <strong>Nathan Wrigley:</strong> I think WordPress is a really great thing to hang your coat on if you are learning, because there&#8217;s so much, like you said, documentation. So much of it is prebuilt, so you can just download a version of WordPress and dig in basically, and see how somebody else over many years, in the case of WordPress, 22 years, how that has been built.</p>\n\n\n\n<p>Whereas I always found when I was digging in, so this is prior to me using any CMS, I had those PHP books, paper books, where you try to learn. And you&#8217;d always learn from nothing and you&#8217;d have to start building up and anything that you did wrong, you kind of really didn&#8217;t know what was going on.</p>\n\n\n\n<p>And so I quickly moved into the CMS space, and probably a little bit like you, WordPress was able to scaffold my learning. And quite a lot of the things that I thought I wouldn&#8217;t be interested in, I could skip over. I don&#8217;t know, things like permissions and stuff. WordPress already did that, so I didn&#8217;t really have to worry about how all of that was taken care of. So it enabled me to learn more quickly. And then of course, there&#8217;s the whole community behind it, and knowledge bases and articles and that whole thing. So I well understand your story.</p>\n\n\n\n<p>However, you&#8217;ve gone in a much more developer direction, I think, than I ever did. Looking at the bits and pieces that you are doing now, I think it&#8217;s fair to say that you have become a really competent developer, not just with things like PHP and JavaScript, but also I think more recently with things like React as well. How are you finding all of that, the new React based WordPress? Is it still maintaining the interest or are you banging your head on the wall a lot?</p>\n\n\n\n<p>[00:06:58] <strong>Johanne Courtright:</strong> I started Gutenberg, I started to use it pretty much around the time it came out. I had a bit of a struggle because I had to learn React for it. I didn&#8217;t want to be left behind, so I really tried hard, took a course online to accelerate a bit of my learning. And then I faced a time where it was just too much work to be done.</p>\n\n\n\n<p>But the last agency I worked at, I started I think like four or five years ago, they were open. They wanted to tackle it. And so we&#8217;re a team of three to start, and we made like a core foundation of blocks that we needed over time, building off projects and versions.</p>\n\n\n\n<p>And so it was a lot of fun, but in the same time we were still stuck in the old world with ACF for some of it. And I wasn&#8217;t quite pleased on some of it, but I understand sometimes like the budget, because I&#8217;m allowed to be fully a hundred percent Gutenberg. So when I decided to start something on my own to solve those things, I went a hundred percent Gutenberg, Interactivity API, no jQuery as much as possible. I decided to dive in completely, a hundred percent, because I believed in it. I knew how to solve those issues.</p>\n\n\n\n<p>[00:08:11] <strong>Nathan Wrigley:</strong> Yeah, all of those things that you&#8217;ve mentioned, you know, things like custom fields and things like that, they&#8217;re really curious, aren&#8217;t they? I mean, they&#8217;re really interesting stuff that you can do there, and it&#8217;s very much time saving, but it does feel like in the future there are utterly different possibilities there. And blocks, and all of the different bits and pieces that we&#8217;ll get into that you are working on, afford the chance to build custom solutions for every single project, without necessarily relying on downloading a plugin. You know, writing a bit of code, which will achieve a bit of functionality for this particular block or that particular block.</p>\n\n\n\n<p>However, all of that stuff being said, and the sort of rainbow version that we&#8217;ve painted of Gutenberg, it&#8217;s pretty obvious to me that during the last few years, there must be parts of the block editor that you&#8217;ve found to be lacking. Because as we&#8217;re going to discover, you&#8217;ve got a project called Groundworx, which is an endeavor in lots of different ways to bring features into the block editor which you feel probably, I&#8217;m guessing you feel, should have been shipped a long time ago.</p>\n\n\n\n<p>And I think it&#8217;s fair to say that your endeavor here is not to create a new suite of blocks, which you would download and replace core blocks. You are trying to enhance the paragraph block or the whatever block it may be. So you&#8217;re taking the core block, adding functionality into it. Have I got that right? Is that the endeavor?</p>\n\n\n\n<p>[00:09:34] <strong>Johanne Courtright:</strong> I have some extra blocks, but I did enhance quite a bit of what was already there, but not too much that it would interfere if they were to ever support. I mean, I have to be cautious on what I&#8217;m adding. But essentially, if you take WordPress as is, it&#8217;s good enough for somebody who&#8217;s starting, but it&#8217;s not good enough for an agency.</p>\n\n\n\n<p>[00:09:57] <strong>Nathan Wrigley:</strong> What are the bits that you think are missing? And honestly, feel free to just dig deep here. I know for me what I found lacking, but it only maps to the things that I have had to do. But I&#8217;m curious what a different person having worked for agencies and built a suite of blocks, what are the, I don&#8217;t know, four, five different things that you really feel are missing?</p>\n\n\n\n<p>[00:10:15] <strong>Johanne Courtright:</strong> You have to be pixel perfect with agencies, and they work with break points, and in containers and whatnot. And so you have to really kind of like stretch it further. And you have to also provide user experience efficiencies, for example, colour palettes and things like that. So you have to make it easier. So having presets of colours that already predetermined based on their branding, is ideal. So they can choose those presets, it already applies all the colours and your set. And then they can still override each components, which is amazing. That was something very important.</p>\n\n\n\n<p>So efficiencies and ease of use was great. So a combination of some custom blocks, but a lot of pre-made templates that you can make for them, and colour palettes. So the more you embrace Gutenberg, the more you can make it happen. But if you have those solutions that are not quite fully Gutenberg, it becomes a little bit complex because you&#8217;re fighting Gutenberg.</p>\n\n\n\n<p>[00:11:13] <strong>Nathan Wrigley:</strong> Did you build your suite of blocks? And we&#8217;ll get into what that means in a minute, and we can highlight the different bits and pieces that you&#8217;ve got. But did you build that out of frustration or were there, I don&#8217;t know, particular things that a particular project needed that was pretty edge case that you thought you&#8217;d build? Or is this more a case of, okay, everybody needs these things, it&#8217;s curious that they&#8217;re missing in Core? What&#8217;s the approach? Is it kind of edge case stuff or is it more, everybody could benefit from these?</p>\n\n\n\n<p>[00:11:42] <strong>Johanne Courtright:</strong> It&#8217;s a little bit of everything. Most of the time, agencies would need those extra features I brought in. The problem is, I didn&#8217;t want to overwhelm normal users as well with so many options. And I think that&#8217;s where Gutenberg is shining essentially.</p>\n\n\n\n<p>The padding system, for example. It&#8217;s got increments, but it doesn&#8217;t have an overwhelming amount of like, this is the padding for this break point, this is the padding for this break point. But you can still tap into it by using clamp on your padding to adjust based on your screen resolution. So you can solve that problem without having to specify all those extra padding for each break point.</p>\n\n\n\n<p>So there&#8217;s a lot of different ways to set up your theme.json to compensate for the lack of extra features per breakpoint. And that&#8217;s what I&#8217;ve been doing. And my goal is to set up enough blocks and provide, I&#8217;ll have a theme.json that I want to share, so it&#8217;ll be easy for people to have a starting theme to start with. And I&#8217;m planning to release that for free. I was just, there&#8217;s a lot to be done and provide documentation. There&#8217;s just a lot. It&#8217;s hard to get everything done fast.</p>\n\n\n\n<p>[00:12:57] <strong>Nathan Wrigley:</strong> Yeah, no kidding. I mean, have you built your own themes then from the ground up, or do you tend to rely on, I don&#8217;t know, a default theme and then modify that?</p>\n\n\n\n<p>[00:13:06] <strong>Johanne Courtright:</strong> I actually prefer to use my own theme. In fact, coming from the old world, you would put everything in a theme. You would put just all your functionality. And then you learn over time that it&#8217;s probably better to have a plugin, but then you still had the crossover of the two dependencies. You have to be cautious to not crash your site if one wasn&#8217;t, like if you switched a theme or if you switch a plugin.</p>\n\n\n\n<p>And then Gutenberg made it easier to create that separation because you can set up, if you set up your theme properly, you can have essentially 90% of your theme set up in a way where it&#8217;s accent one for colour, accent two for colour base, and contrast. So if you label your things, your keys properly, all you have to do is change the values. Don&#8217;t change the key names. And just create labels that are meaningful. You can create another theme super easy from that initial theme by just changing those labels and those values, and leave the keys alone. Sure, you&#8217;ll have probably more colours on certain other themes, but your foundation will help you get there faster.</p>\n\n\n\n<p>[00:14:19] <strong>Nathan Wrigley:</strong> I know that many years ago when Full Site Editing, as it was called back then dropped, and so block themes became a thing. I know that there was a hope that it would, over a fairly short period of time, that it would replace what we&#8217;re now calling Classic Themes. There was this period of time where, you know, both were still massively in development. And I think the hope was that over time, Classic Themes would become more obsolete, and then block-based themes would become the default.</p>\n\n\n\n<p>It feels from where I&#8217;m standing now, so we&#8217;re recording this in December, 2025, it feels as if that kind of hasn&#8217;t really happened. That promise is still, we&#8217;re still somewhere in limbo. There&#8217;s a few people out there in the WordPress space who are promoting Full Site Editing and all of the things that that can do, but I also feel there&#8217;s a lot of people who are not willing to make that leap.</p>\n\n\n\n<p>And I guess part of the problem maybe is that it&#8217;s easy for somebody like you because you&#8217;re in it day in, day out. You know where every menu is. You know where to put the mouse to achieve the exact thing you want at the exact moment that you want. But I feel that for a novice user, maybe somebody who&#8217;s got the job of, I don&#8217;t know, finishing off a website or somebody who&#8217;s got the job of just tweaking a website once it&#8217;s been handed over, I think it&#8217;s really hard, and a lot of the interface is kind of counterintuitive.</p>\n\n\n\n<p>And when you stand over the shoulder, as I have done, of people who&#8217;ve never used WordPress before, and you watch them, you see them flailing around trying to figure out how it works, and you see the constant butting up against a UX problem. I don&#8217;t know when that moment&#8217;s going to be, where everything is all tied off and perfect, but it doesn&#8217;t seem like in the year 2025, the few weeks that we&#8217;ve got left, or anytime soon in 2026, as if the Classic Themes are going to go away.</p>\n\n\n\n<p>And I don&#8217;t know if that concerns you at all, because obviously you&#8217;ve really invested in all these blocks and theming and all of that kind of stuff. Does it bother you that this is still a problem that we haven&#8217;t solved?</p>\n\n\n\n<p>[00:16:18] <strong>Johanne Courtright:</strong> I think what&#8217;s out there right now, the third party, what they&#8217;re doing, I mean, they&#8217;re solving some issues, but they&#8217;re adding a whole new platform on another existing platform, and that&#8217;s why I don&#8217;t choose those solutions. I prefer embracing the Core vision and try to expand what&#8217;s already there.</p>\n\n\n\n<p>One of my struggles I have is that, let&#8217;s just pick Elementor. You have a lot of great options. I mean, for somebody who knows what they&#8217;re doing, it does a lot, but it also comes with a lot of extra bloat of divs and CSS that&#8217;s not quite built how I would&#8217;ve done it. You have to fight the styling. And WordPress does it so different now. With Gutenberg, it&#8217;s the opposite. It does very little, and it allows you to override all the classes. The way it&#8217;s built, it&#8217;s allowing you to override easily without having to use the important on the styling to override it.</p>\n\n\n\n<p>And I think that&#8217;s a major change of how you think, and how you approach theming in general. This is the way. This is the way how it should be done. And once I stopped fighting how the new way was, and understanding where they were heading with that, something clicked and it just like, yes, this is what I want, this is what I want. And I made that call that I&#8217;m not going back.</p>\n\n\n\n<p>No normal users want to touch Divi or Elementor. Somebody who doesn&#8217;t have the knowledge of basic CSS even, they don&#8217;t want to touch that. It&#8217;s overwhelming. They don&#8217;t know how to touch it. And in fact, they&#8217;re scared. And when you present them with Gutenberg, you give them an hour training over Zoom session, they are in love with it. They make edits themselves. They&#8217;re just happy. They rarely come back with more questions. They just know how to use it.</p>\n\n\n\n<p>[00:18:12] <strong>Nathan Wrigley:</strong> I think we&#8217;re fast approaching a period in WordPress when a lot of the admin UI is about to change. So there&#8217;s a lot of foundational work being put in at the moment to really modify it. So maybe some of that dissonance that users might face in the near future will go away. And maybe those kind of block-based themes, and Gutenberg use in general will spike. There certainly seems to be a lot of work being done in that regard anyway.</p>\n\n\n\n<p>Let&#8217;s just move on to some of the bits and pieces that you have been doing though. Because obviously there must be, well, dissatisfaction is the wrong word, but there&#8217;s obviously bits of the block editor where you feel that work could have been done differently.</p>\n\n\n\n<p>And so I&#8217;m going to point people in the direction of your work. So if you go to groundworx.dev, and worx is spelt with an X at the end. So it&#8217;s the word ground, and then WOR and then the letter X, dot dev. If you go there, you&#8217;ll be able to find the product menu. And if you hover over the product menu, you&#8217;ll be able to see a bunch of things called Groundworx core and things like that, Groundworx navigation.</p>\n\n\n\n<p>And I want to dwell on Groundworx core. So this is your endeavor to improve the blocks that WordPress offers, and offer some new ones and modifications to existing ones. Tell us what the philosophy behind this is then.</p>\n\n\n\n<p>[00:19:29] <strong>Johanne Courtright:</strong> So some of the more fun blocks where they have like animation and all that are custom blocks. But they&#8217;re flexible in the way they&#8217;re easy to set up, intuitive. But I think for me, offering the capability to someone who wants those type of things that are not offered, it&#8217;s not necessarily a frustration for those because it&#8217;s just in addition to, it&#8217;s nice to have, it&#8217;s not a must have, essentially. They&#8217;re really nice, already pre-made blocks with the inner blocks and content that you can change.</p>\n\n\n\n<p>One of the ones that are, I think, lacking, I know we have the accordion block that came in recently. Mine is different, where I can have an accordion, but I can also have a tab. A tab that can turn into an accordion based on a specific break point. So it won&#8217;t go from accordion, to tab, to accordion, back to tab at several different break points, but it will have one point where you&#8217;ll tell it to break.</p>\n\n\n\n<p>So you can have a tab that can turn into accordion, which is nice to have because, I mean, tabs are not very friendly, but you still want them. You still want them. They&#8217;re useful visually at larger desktops, but you don&#8217;t necessarily want to deal with tabs at a mobile, unless they&#8217;re very small text and very few. So you need something to shift that. And you want to keep consistency. With accordions that you already have, so it looks good altogether. So that&#8217;s what I created. I have an accordion, and a tab, but the tab can fall into an accordion as well. And when they do fall into an accordion, they all look consistent and the same.</p>\n\n\n\n<p>[00:21:13] <strong>Nathan Wrigley:</strong> So currently if you, I&#8217;ll put the link in the show notes by the way. So if you go to wptavern.com and you search for the episode with Johanne in, then you&#8217;ll find all of the show notes. It&#8217;s probably easier than me reading out URLs and what have you.</p>\n\n\n\n<p>Your kind of block suite falls into two main categories, as far as I&#8217;m concerned anyway. So you&#8217;ve got your purpose built 11 kind of custom blocks where you are doing something that Core didn&#8217;t do. Although we might discuss how Core might tackle some of those things in the near future.</p>\n\n\n\n<p>But then also, the bit that I find really interesting is the whole section where you&#8217;ve got extension to Core blocks. So as an example, I&#8217;ll give you some examples of things which, dear listener, if you don&#8217;t use Gutenberg, you may be surprised to know that the block editor currently does not do these things.</p>\n\n\n\n<p>So for example, you have the capacity to reverse the order of a stack, which is really nice. So you might want to just, I don&#8217;t know, put an image above something on a desktop. And then on mobile, you might just want to flip that, or you might just want to flip it because you are doing, I don&#8217;t know, copy and pasting rows, but you want the image left, image right, image left, image right, that kind of thing.</p>\n\n\n\n<p>You&#8217;ve also added in break points for certain widths. So for example, a tablet break point might be in there. You&#8217;ve got a full height sticky for the group block, which is nice and interesting as well. Three breakpoints for WordPress headings and paragraphs. That&#8217;s nice. So you could, I don&#8217;t know, change the font size or something like that depending on what you&#8217;re looking at.</p>\n\n\n\n<p>Column counts. So you&#8217;ve got the ability to have different breakpoints in the Core list block as well.</p>\n\n\n\n<p>You&#8217;ve got a whole thing about performance optimisation for the video block, and then you&#8217;ve got a responsive setting for any break point that you may set. I probably butchered all of that, but you get the idea. You&#8217;ve got a ton of stuff that you&#8217;ve built on top of Core WordPress blocks.</p>\n\n\n\n<p>Why do you, because I mean, all of that I guess is given away to everybody, but there&#8217;s got to be an expectation, I suppose, that some of this stuff will ship in Core. Does that bit worry you? Does it worry you that you put in all this hard work and then somebody maybe in the Core project thinks, oh, that&#8217;s a good idea, let&#8217;s add that to the roadmap and what have you.</p>\n\n\n\n<p>[00:23:16] <strong>Johanne Courtright:</strong> I mean, it&#8217;s always a worry when you release something for WordPress because everything is GPL, but it&#8217;s just part of the ecosystem. I mean, I reverse engineered their blocks to learn what I know now.</p>\n\n\n\n<p>[00:23:27] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s a good point. Yeah.</p>\n\n\n\n<p>[00:23:28] <strong>Johanne Courtright:</strong> And if they think it&#8217;s great idea then, you know, as long as they give me credit, I guess it&#8217;s fine.</p>\n\n\n\n<p>But I say, not everyone will need break points. I mean, this is really more like, I&#8217;d say agency type things that usually you want those things, those features. They&#8217;re nice to have, but break points are not necessarily, I have to have it kind of thing if you are just a normal user. It&#8217;s more, if you want fine tuning for, like if you&#8217;re a designer and you really want those fine tunings, then they&#8217;re there.</p>\n\n\n\n<p>[00:24:03] <strong>Nathan Wrigley:</strong> Does it kind of surprise you though that we are now, oh goodness knows how many years we&#8217;re into the Gutenberg project, but it&#8217;s many, many years. It&#8217;s more than you can count on one hand. Does it surprise you that this stuff is still missing? That somebody like you needs to build this functionality and, well, needs is maybe the wrong word, but desires to build this functionality. Does it surprise you that this kind of thing wasn&#8217;t in it when it shipped, that a layout system with all the break points taken care of and all of that completely customisable, does it still shock you that that isn&#8217;t there?</p>\n\n\n\n<p>[00:24:34] <strong>Johanne Courtright:</strong> I have not done a whole lot of research, but based on what I&#8217;ve read so far is there was no intention to support it. So that&#8217;s why I decided to do it because I was like, I&#8217;m not going to wait for them to do it because they&#8217;re not going to do it.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah. So it was never something that was intended that was missing. It was just, it was never, literally never intended. So somebody needed to ship it. It&#8217;s kind of like that WordPress 80 20 rule. That&#8217;s the other curious thing about WordPress usage. Somebody like you and somebody like me who is constantly in there and fiddling the entire time, you kind of have this expectation that a lot of this stuff, oh, everybody would need this because I need it.</p>\n\n\n\n<p>But the reality is, I guess most people are just logging in, changing a piece of text, maybe uploading an image, writing a blog post, clicking publish, and they&#8217;re done. And they&#8217;re relying on their agencies who&#8217;ve got the CSS, JavaScript, all of that React expertise that can build all of the different bits and pieces for them. So maybe it&#8217;s just me obsessing about these things because I&#8217;m in there all the time and I can see how they&#8217;re missing.</p>\n\n\n\n<p>[00:25:36] <strong>Johanne Courtright:</strong> I think the way I build themes these days is like extremely light. It&#8217;s like, there&#8217;s a theme.json, there&#8217;s very little CSS and very, very little JavaScript. Everything is moved towards plugins. It&#8217;s really meant for colours, font types, branding type things. I have very little things in my themes these days because I believe that somebody who has a website and tomorrow they want a different theme, even for Christmas, and they decide, oh, I want a Christmas theme, should be able to do it easily by just swapping the theme.</p>\n\n\n\n<p>[00:26:13] <strong>Nathan Wrigley:</strong> Clicking a button and it should all work, yeah.</p>\n\n\n\n<p>[00:26:14] <strong>Johanne Courtright:</strong> Click a button, and all of a sudden it&#8217;s the new font, it&#8217;s the new palette colour, and it just works with minimal effort to just change anything or tweak anything. That&#8217;s how I see it. You shouldn&#8217;t have things that are baked in your theme where if you change your theme, now all of a sudden it&#8217;s not available for that theme. Don&#8217;t lock your clients into essentially a theme with features, and then they&#8217;re stuck with your theme.</p>\n\n\n\n<p>[00:26:45] <strong>Nathan Wrigley:</strong> Okay, so that&#8217;s an interesting way of kind of spinning my question around in a sense. That whole thing that we have with clients where we have scope creep, you offer something, they agree to it, and then there&#8217;s this whole thing after you&#8217;ve built what they wanted, where they say, oh, but can we have, and then can we have, and what about this? We&#8217;ve got this idea as well. But that&#8217;s not the intention. The project was what we said it was going to be.</p>\n\n\n\n<p>And so in a sense, the WordPress project is a little bit like that. You know, it&#8217;s not trying to be every feature for every human being who ever thought a thing could be achieved. It&#8217;s more, here&#8217;s the foundational stuff, and if you really want those things, well, either build it yourself or go and find somebody who has built that for you.</p>\n\n\n\n<p>That kind of makes a lot of sense, doesn&#8217;t it? You know, if you&#8217;ve got this foundational platform, and I know the 80 20 rule, like I said, applies within WordPress. If 80% of the people need it, then it comes onto the scope of Core, and if it doesn&#8217;t reach that then it really doesn&#8217;t belong in Core. That&#8217;s kind of interesting because that reframes the whole thing and makes what you are saying true.</p>\n\n\n\n<p>Most of the things that you&#8217;ve got, that you&#8217;ve built on top of Core, and again, I&#8217;ll direct people to the URL on the WP Tavern website. They probably aren&#8217;t for 80% of the people, they probably are for the 20%, the people like you, the developers, the designers who are building websites. The inexperienced people, the 80%, maybe they don&#8217;t need this stuff. That&#8217;s an interesting reframing of it.</p>\n\n\n\n<p>[00:28:07] <strong>Johanne Courtright:</strong> Yeah, most people will probably be satisfied with just the basic theme that comes with WordPress. It&#8217;s got enough patterns at this point to have a good starting foundation. We need to get away from overbuilding our blocks in such a way where they&#8217;re rigid, this is the only thing it can do.</p>\n\n\n\n<p>So when I build my blocks, I build in such a way the HTML can be moved around with grid system CSS, where I can move things because I built it in such a way that it&#8217;s very flexible. So all you have to do after that is just you create like some styling to accommodate that other different behavior that you want.</p>\n\n\n\n<p>[00:28:51] <strong>Nathan Wrigley:</strong> So we&#8217;ve spoken just then about the bits and pieces that, you&#8217;ve extended WordPress Core and we described all of those. But there&#8217;s obviously bits that you felt were entirely missing that you thought might be useful to have. As I said a moment ago, some of these maybe are things that, I don&#8217;t know, maybe you&#8217;ll drop in the near future, or perhaps you&#8217;ll tweak in different ways because you did say that your accordion block behaves differently. But I know that the accordion block is coming to Core and what have you.</p>\n\n\n\n<p>But you&#8217;ve got things like an Accordion Block, you&#8217;ve got an Accordion Panel Block, a Tabs Block, Tabs Panel Block, Media Section Block, Media Content Split Block, that&#8217;s interesting. Card block, Card Reveal Block and many others. This is, I guess, is this you sort of dogfooding projects that you&#8217;ve had in the past where a client has wanted a particular thing and you&#8217;ve thought, oh yeah, I&#8217;ve now built that, let&#8217;s see if we can sort of make it more generic and add it into your suite of blocks?</p>\n\n\n\n<p>[00:29:43] <strong>Johanne Courtright:</strong> Those are pretty much blocks that keeps happening and being reused over and over and over. And they kind of become your basic foundation, if that makes sense. And they usually solve 90%, 95% of what you need for a site is essentially what&#8217;s part of the Core, is how I solved it. Another one that I solved that is very similar to what WordPress does was the Core Navigation.</p>\n\n\n\n<p>[00:30:09] <strong>Nathan Wrigley:</strong> Oh, you&#8217;ve got a whole other thing there, haven&#8217;t you? Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>[00:30:12] <strong>Johanne Courtright:</strong> Yeah, this one is completely free, so I mean, my navigation falls very similarly what WordPress does, where I have a custom post type, I have blocks in it, and essentially it will use those menus that I can reuse in different parts of navigations. And the major difference is that WordPress is only this big modal and then you have very little customisation. It can go left or right, I think center.</p>\n\n\n\n<p>[00:30:43] <strong>Nathan Wrigley:</strong> That&#8217;s more or less it really, isn&#8217;t it?</p>\n\n\n\n<p>[00:30:45] <strong>Johanne Courtright:</strong> Yes. And it is annoying because if you choose left or right, well, it also affects your desktop versus modal, I didn&#8217;t like that. But I did like the idea of having the blocks sitting into a custom post type. So mine in that way does that too. But I didn&#8217;t want to interfere with what WordPress had done, so I created my own custom post type for it. But I&#8217;m still following the same principle where I have my blocks sitting in that custom post types be shared so I can reuse them.</p>\n\n\n\n<p>[00:31:18] <strong>Nathan Wrigley:</strong> So you can use Core navigation blocks containing the pages and the posts and things like that. How do you build them up?</p>\n\n\n\n<p>[00:31:25] <strong>Johanne Courtright:</strong> Well, I essentially copied over the link and the sub menu and I brought over some of their features, because I did like how they were, but I changed the HTML in it and what it&#8217;s capable of doing. Had a couple different things. That allowed me the flexibility to create accordions, and all sorts of different things without having to worry about having, you know how some sites will have a mobile menu, but they&#8217;ll have the same menu for the desktop, but it&#8217;s like a clone, but you don&#8217;t see it. I didn&#8217;t want that. Everything had to be done from the same HTML structure, and all it had to do is just essentially fall back gracefully into that other mode. And what was important also for me was that it was all Interactivity API.</p>\n\n\n\n<p>[00:32:20] <strong>Nathan Wrigley:</strong> Oh, interesting. Okay, you&#8217;ve been leveraging that.</p>\n\n\n\n<p>[00:32:23] <strong>Johanne Courtright:</strong> Yeah. So they&#8217;re all leveraging that. I was inspired also by Gutenberg Times website to do the vertical menu.</p>\n\n\n\n<p>[00:32:31] <strong>Nathan Wrigley:</strong> Yes. Yeah, they&#8217;ve got the, I don&#8217;t know which theme they&#8217;re using, but that I think was a default theme. Was it 2020?</p>\n\n\n\n<p>[00:32:37] <strong>Johanne Courtright:</strong> I was like, this is different. I want one like that. So I did support it too.</p>\n\n\n\n<p>[00:32:41] <strong>Nathan Wrigley:</strong> Yeah, I see that. So on your navigation block, one of the options is to have this kind of full height column, which you can invoke and the menu, I guess slides out, but it then collapses back into that full size column. Have you had much feedback on that? Because it, I always worry that that&#8217;s going to consume quite a bit of the real estate when it&#8217;s not being invoked. Whereas, you know, a little hamburger icon, which is sitting at the top of the screen is obviously not consuming anything once you&#8217;ve scrolled past the navigation menu. Does it stay there all the time? If you&#8217;re not using the menu at that moment, does it live there all the time or, how does it work?</p>\n\n\n\n<p>[00:33:14] <strong>Johanne Courtright:</strong> The bar stays there all the time. It&#8217;s up to you to add links that are useful in terms of what you&#8217;re doing. But, yes, it does stay there. It takes a little bit of the space, but it&#8217;s fine. You can choose also at what break point it will be sitting at the top instead.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Oh, I see. Got it. Right. There is an option to remove it. Yeah, yeah, yeah. Okay.</p>\n\n\n\n<p>[00:33:38] <strong>Johanne Courtright:</strong> Yeah. So you&#8217;re not, let&#8217;s just say you wanted to stop doing that at laptop or something, or tablet, then you just choose the option and it will just break to the other one at the top instead.</p>\n\n\n\n<p>[00:33:49] <strong>Nathan Wrigley:</strong> Okay. And you&#8217;ve built a suite of blocks, so six at the moment that work in concert together to build that. So you&#8217;ve got the Navigation Block, which I&#8217;m guessing is kind of the wrapper for that, I&#8217;m not sure. But then you&#8217;ve got the Branding Block, which I presume holds logos and things like that. The Menu Block, which is the responsive bit where you can display stack menu items and things like that. Sub Menus, which I guess allows you to create those accordions where there&#8217;s a parent item, but things hidden underneath. A Link Block where you can just add a single thing, which I guess isn&#8217;t inside any other navigation anywhere. And then a spacer block, just something to create a bit of breathing room to separate one thing from another. And those six things, you just build in your custom post type, and once you&#8217;ve built them there, you can then invoke it and construct it entirely in the block editor.</p>\n\n\n\n<p>You see this kind of stuff is really cool and really clever. Just the idea that you can build that in a, in this GUI, the block editor. Build it, style it, do all of the bits and pieces that you need to make it look nice inside the settings panel. It&#8217;s so great. The promise of Gutenberg delivered, really. This is the kind of stuff that it was always supposed to do, but people only seem to be getting to it now.</p>\n\n\n\n<p>[00:34:57] <strong>Johanne Courtright:</strong> You know, you did ask me a few times if there was a feature I wish was in WordPress, and I do have one right now. Theme.json, you can specify specific colours for your buttons and your texts, your background, but I wish there was a way for us to set up other variables or some other things to specify more colours. So for example, my navigation, I have a lot more colours than two. I wish there was a way for me to set those up instead of using CSS and then the variable name and then manually injecting those.</p>\n\n\n\n<p>[00:35:34] <strong>Nathan Wrigley:</strong> Right. Overriding things. Yeah.</p>\n\n\n\n<p>[00:35:36] <strong>Johanne Courtright:</strong> Allow me to have custom keys or something where I can just say, oh, put your colours here, and then it will just generate whatever it needs to do. So if there was a way for me to have a block and specify, say, this is going to be the selector, this is the selector and this is the key. And then in the theme.json, all the person has to do is set up the key and the colour and it just applies it. That would be a nice feature.</p>\n\n\n\n<p>[00:36:04] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s curious, you know, if for example, I was to go to, I don&#8217;t know, Squarespace or something like that and build my website with their technology, I guess there&#8217;s an expectation that what you get is what you get. This is it. You know, you pay your $20 a month or whatever it may be, I have no idea, and the features that you have are what you have. Maybe you can put in a support request somewhere and ask for another feature, but basically it&#8217;s very unlikely, I imagine, to happen.</p>\n\n\n\n<p>Whereas just about everybody on the developer side of things, fiddling with WordPress, is constantly coming up with new ideas and different ways it can be adapted. And so there&#8217;s always this sense of, oh, I could build this thing into it, or I could do, and so it kind of breeds, not dissatisfaction, that&#8217;s the wrong word, but a curiosity for what it could do.</p>\n\n\n\n<p>So you&#8217;ve just given a perfect example there. You&#8217;ve got this use case, which I don&#8217;t think I would probably make much use of. I think I&#8217;m probably happy with the two colours, but clearly in your scenarios that&#8217;s a way that you would like to adapt it.</p>\n\n\n\n<p>And that&#8217;s why the platform is so cool. Maybe at some point somebody will listen to that request and will implement that for you in Core. If not, you maybe have to suffer the CSS load that you&#8217;ve got in the meantime. But that is really what separates it. You know, we&#8217;ve got this idea that, if you contribute, and you put your ideas in and you show up and you, you know, you offer your time, then that kind of stuff can be changed.</p>\n\n\n\n<p>[00:37:28] <strong>Johanne Courtright:</strong> I have to say, I know that it creates a lot of friction at the moment and how they&#8217;re guarding and guiding very specifically. And they&#8217;re clear in their vision and they want to follow that vision, and it creates some frustration for some people who want things done differently. But I appreciate that they&#8217;re doing that because it was a long term project. The frustration probably comes from, I wish it was there, what it is today, many years ago, when it came out. But I do appreciate that there&#8217;s somebody with a vision who stick to their vision because I think it&#8217;s the right way.</p>\n\n\n\n<p>[00:38:10] <strong>Nathan Wrigley:</strong> Yeah, and interestingly, everybody else&#8217;s vision can also be lived. So, you know, there&#8217;s a variety of different page builders, and I know that&#8217;s not your thing, but it is the thing of many millions of people. They love that, and that&#8217;s their preferred way of doing it. You can&#8217;t do that on these other proprietary platforms. There isn&#8217;t a different entire UX and UI that you can inject into it, but we have that, you know? And if you want to use a page builder, or you want to use whatever it is that you want to use, that&#8217;s the way it is.</p>\n\n\n\n<p>I suppose the only thing we&#8217;ve got to be mindful of is the flame was that sometimes occur. You know, people saying, well, my tool is the best tool. Anybody else that&#8217;s using anything else is missing out or what have you, or maybe stronger language than that. And just recognise that, well, the reason that you can do that is because there&#8217;s this foundational stuff, the WordPress Core.</p>\n\n\n\n<p>[00:39:00] <strong>Johanne Courtright:</strong> They&#8217;re allowing it.</p>\n\n\n\n<p>[00:39:01] <strong>Nathan Wrigley:</strong> Yeah, and it&#8217;s allowing you to have that, and you don&#8217;t have to use Gutenberg. But it does feel, it really does feel as if in the latter part of 2025, it does feel as if there&#8217;s a little bit more excitement around the Block Editor and the different bits and pieces. I don&#8217;t know if you&#8217;ve picked up on that, but there seems to be more stories. There seems to be more people shipping products that latch onto the block editor. Yours obviously is an example of that.</p>\n\n\n\n<p>[00:39:24] <strong>Johanne Courtright:</strong> The biggest hurdle is to learn it&#8217;s a different mindset, different language, it&#8217;s different in so many ways. There&#8217;s just too much to learn to jump from old way to new way. And it&#8217;s very overwhelming for a lot of people. It&#8217;s very, very overwhelming.</p>\n\n\n\n<p>[00:39:45] <strong>Nathan Wrigley:</strong> Genuinely don&#8217;t know how we bridge that gap, to be honest, because I think you&#8217;re right. If you&#8217;ve been familiar with using WordPress in its classic form, then it is, it&#8217;s seismic. But more or less, every developer that I know has at least some curiosity in Gutenberg and things like that, so probably.</p>\n\n\n\n<p>[00:40:00] <strong>Johanne Courtright:</strong> Once people fully decide to embrace it and take the time to reverse engineer and understand it, they&#8217;re like, oh, wow. All the cool stuff I can do. Yes. You know? And they change their mind completely. It&#8217;s a bit challenging because I mean, even like, let&#8217;s just say Tailwind, which is the CSS framework. I mean, it&#8217;s great. Tailwind is amazing, but when you start trying to use it with WordPress, that&#8217;s another one that fights WordPress. I stopped using it. I&#8217;m just going with SCSS and I build my own stuff. Now I have very little CSS into my blocks and it&#8217;s just, there&#8217;s no real point to have CSS framework in WordPress. You don&#8217;t need that.</p>\n\n\n\n<p>[00:40:44] <strong>Nathan Wrigley:</strong> I&#8217;m going to pivot the subject a little bit, and it&#8217;s because of a tweet that I saw yesterday, I believe it was. A friend of mine tweeted that he&#8217;s yet to see a block solution. So I don&#8217;t think that those were the words that he used, but he&#8217;s yet to see an out and out successful business built on top of blocks. So the example might be that, for example, on WordPress Core, you&#8217;ve got all of these really successful products. So you&#8217;ve got things like Gravity Forms and things like that, that have made real, they&#8217;ve got a real stable business going on. And he was questioning, have we seen that with blocks yet?</p>\n\n\n\n<p>So you are trying to make that happen. You are trying to sell a commercial product. I know that there&#8217;s, free versions and things like that, but you&#8217;re trying to sell a commercial product. How is that? What is the landscape for that at the moment? Because I&#8217;m guessing it&#8217;s not like you are printing money at the moment. I don&#8217;t know how difficult that is and whether or not it&#8217;s been the fountain of cash that maybe you&#8217;d hoped it would be.</p>\n\n\n\n<p>[00:41:44] <strong>Johanne Courtright:</strong> I don&#8217;t expect it to be a fountain of cash. I love what I do. I do it for myself first, and if other people happen to enjoy it, then But if they don&#8217;t, that&#8217;s fine, I&#8217;m using it.</p>\n\n\n\n<p>[00:41:59] <strong>Nathan Wrigley:</strong> That&#8217;s very sanguine approach. I think his thought when he made that tweet is that maybe we&#8217;re on the cusp of something. Because it feels like there&#8217;s a certain speed that the flywheel needs to achieve before people become really interested in it. I&#8217;m not sure that that has yet happened. But give it some more time, give it some more interesting products, some more attention, some more marketing and what have you. And definitely a lot of the stuff shipping in 6.9, which is actually coming out today. And then 7 next year, and all of the AI bits and pieces that are going to be put in as well. You never know. Maybe with a fair wind, we&#8217;ll be printing money for you.</p>\n\n\n\n<p>[00:42:38] <strong>Johanne Courtright:</strong> I do have a message for Matt if he listens. He needs to work on his plugin and themes website. It&#8217;s not usable at the moment. It doesn&#8217;t leave room for new development, new plugins to be seen. It needs to be feeling more like a community.</p>\n\n\n\n<p>I come from a background where I did a lot of desktop customisation. We had featured skins and themes and wallpapers and there was, people were excited. There was somebody reviewing. Think about it about how Apple does their Apple store, where they had like featured apps. Somebody went and tested a few of those plugins and featured them. They pick them. We need more, something like that.</p>\n\n\n\n<p>We also need to have a better search. Search is awful. It&#8217;s all stuffed keywords. And if you&#8217;ve been around for a while, if you&#8217;re new, there&#8217;s no way for you to rank for anything. There needs to be true categories and easier ways to find what you&#8217;re looking for.</p>\n\n\n\n<p>[00:43:37] <strong>Nathan Wrigley:</strong> Do you know, that&#8217;s a whole interesting other conversation, isn&#8217;t it? Maybe we&#8217;ll have that one time. But I get what you mean. When the iPhone came out, don&#8217;t know if you sort of remember or go back that far, but when the iPhone came out, it was this curious but beautiful object that had a lovely screen and could play songs and things. But the moment the app store came along for the iPhone, that&#8217;s I think when it became really interesting.</p>\n\n\n\n<p>And it does feel with the advent of blocks, like there&#8217;s an opportunity similar to that in that WordPress is no longer just these plugins and themes. We&#8217;ve got this whole other thing now, these blocks, these mini applications if you like, which really in many ways have full capabilities like plugins would do. And being able to surface those and find a block or a.</p>\n\n\n\n<p>[00:44:26] <strong>Johanne Courtright:</strong> You should be able to set, are you supporting Gutenberg? Is it using jQuery? Is it using those basic little things like check, check, check? And if some people are looking for those things, they should be able to find you.</p>\n\n\n\n<p>Right now it&#8217;s useless. It&#8217;s very useless, even for me looking for a plugin. Most of the plugins I found these days are because I use Google or AI, or there&#8217;s other means, but it&#8217;s very hard to find. I don&#8217;t even rank in the first 40 some pages for my navigation, so it&#8217;s ridiculous. Look for navigation, you won&#8217;t find me.</p>\n\n\n\n<p>[00:45:04] <strong>Nathan Wrigley:</strong> Okay, so maybe that&#8217;s work to be done in 2026. But hopefully somebody has heard your plea there and you never know. If they have and they want to reach out to you, well, obviously we know that you&#8217;ve got the Groundworx with an X, .dev website. Is there another place where you hang out online that people could find you if they wanted to have a chat?</p>\n\n\n\n<p>[00:45:23] <strong>Johanne Courtright:</strong> I&#8217;ve been hanging out a lot on X these days. I get a lot more response there. It seems to be WordPress community hangs out there a lot, so I think that&#8217;s going to be my platform of choice for a while.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Okay. In which case, into the show notes, along with the links to all of the bits and pieces that we mentioned, I will bury the link to Johanne&#8217;s X profile as well, so you can go and connect there.</p>\n\n\n\n<p>Thank you so much for chatting to me today. It&#8217;s really interesting getting your insight into all of the bits and pieces that you&#8217;ve done extending Gutenberg, but also all of the bits and pieces that you&#8217;ve done with new stuff as well. Go check it out. It&#8217;s Groundworx.dev. Johanne, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:46:01] <strong>Johanne Courtright:</strong> Thank you for inviting me. Thank you so much. It was great.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href="https://x.com/groundworxdev">Johanne Courtright</a>.</p>\n\n\n\n<p>Johanne started working with WordPress back in 2011, moving over from a background in marketing agencies, Dreamweaver, and static HTML sites. Over the years, she’s become a skilled developer, focusing on extending WordPress through custom queries, forms, integrations with APIs, and increasingly, harnessing the power of the block editor and React.</p>\n\n\n\n<p>Johanne talks about her journey from the classic world of agency WordPress development to embracing Gutenberg, and the challenges and wins along the way. She shares her experience in building custom blocks and enhancing existing ones to better serve agencies, things like improved breakpoints, color palettes, responsive designs, and navigation, all of which aren’t offered in Core yet. These features come together in her growing open-source project, Groundworx.</p>\n\n\n\n<p>We talk about the shifting landscape from classic themes to block-based themes, and why, even in 2025, a lot of agencies and users are still hesitant to make the leap fully. Johanne explains where the block editor falls short for her use, and how Groundworx aims to plug these perceived gaps with a foundation of flexible, performant, agency-focused blocks and templates.</p>\n\n\n\n<p>You’ll hear about her approach to building modular themes with theme.json, the realities of client work and scope creep, and how the 80/20 rule shapes what belongs in Core and what’s best handled by plugins.</p>\n\n\n\n<p>We also get into the challenge of discovery in the WordPress plugin ecosystem, her wishlist for Block Editor improvements, and her take on the future of block-based businesses in WordPress.</p>\n\n\n\n<p>Whether you’re a developer eager to modernise your workflow, or just curious about extending Gutenberg for real-world use, this episode is for you.</p>\n\n\n\n<h2 class="wp-block-heading">Useful links</h2>\n\n\n\n<p><a href="https://groundworx.dev/products/groundworx-core/">Groundworx Core</a></p>\n\n\n\n<p><a href="https://groundworx.dev/products/groundworx-navigation/">Groundworx Navigation</a></p>\n\n\n\n<p><a href="https://gutenbergtimes.com">Gutenberg Times</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 15:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Nathan Wrigley";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:21;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Matt: Dries OSS";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150795";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:32:"https://ma.tt/2025/12/dries-oss/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:734:"<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>A more accurate framing would be that Fizzy is <a href="https://en.wikipedia.org/wiki/Source-available_software">source available</a>. You can read it, run it, and modify it. But DHH&#8217;s company is keeping the SaaS rights because they want to be able to build a sustainable business. That is defensible and generous, but it is <em>not</em> open source.</p>\n</blockquote>\n\n\n\n<p>Dries Buytaert follows up <a href="https://ma.tt/2025/12/dhh-open-source/">on my response to DHH</a> with <a href="https://dri.es/source-available-is-not-open-source-and-that-is-okay">&#8216;Source available&#8217; is not open source (and that&#8217;s okay)</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 03:13:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:22;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:81:"Open Channels FM: Growth, Hackathons, and Gratitude Lessons from an Eventful 2025";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113334";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:86:"https://openchannels.fm/growth-hackathons-and-gratitude-lessons-from-an-eventful-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:219:"Zach Stepek and Carl Alexander recap their 2025 experiences, highlighting personal growth, industry events, business developments, and health journeys. They emphasize gratitude and reflect on goals for a promising 2026.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 09 Dec 2025 14:36:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:23;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:31:"Matt: DHH &amp;amp; Open Source";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150789";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:38:"https://ma.tt/2025/12/dhh-open-source/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:4992:"<p>I might have a new prayer: God, give me confidence of DHH <a href="https://x.com/dhh/status/1996627792008827342">claiming his proprietary license is Open Source</a>.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-150790" height="179" src="https://i0.wp.com/ma.tt/files/2025/12/dhh-tweet-1024x303.png?resize=604%2C179&#038;quality=80&#038;ssl=1" width="604" /></figure>\n\n\n\n<p>37signals/Basecamp has a great new product called <a href="https://www.fizzy.do/">Fizzy</a>, whose brilliance and innovative qualities are being distracted from by its co-creator David Heinmeier Hansson’s insistence on calling it open source. &#8220;One more thing&#8230;  Fizzy is open source and 100% free to run yourself.&#8221;</p>\n\n\n\n<p>Thanks to Freedom of Speech, DHH is free to describe his proprietary software as Open Source, a form of <a href="https://ma.tt/2025/10/greenwashing/">greenwashing</a>, and even though he wants to “Well akshually” <a href="https://x.com/codejake/status/1996629945150591448">denigrate those saying why this is BS</a>, we as free citizens are free to explain why, despite how fast he talks and confident he sounds, he’s not always right.</p>\n\n\n\n<p>Myself and other “Actually Open Source” leaders (including DHH) who release software under licenses that meet <a href="https://opensource.org/osd">a common definition of Open Source</a> benefit from decades of prior art and an incredible foundation that lays out the philosophy and definition of what defines open source.</p>\n\n\n\n<p>For the layperson, though, it might be helpful to break things down in an analogy of authoritarian vs democratic regimes, or a core question of who holds the power.</p>\n\n\n\n<p>Proprietary licenses may grant things that feel like freedoms; for example, Fizzy’s O’Saasy license lets you download the source code, run it yourself, modify it, and <a href="https://github.com/basecamp/fizzy">use a public bug tracker, and you can see the software&#8217;s source control history</a>. That’s cool! Also, in the past several years, there have been Middle Eastern countries that have just now allowed women to drive cars. That’s great! However, as a free person choosing to use this software, or choosing to live in a country, you have to ask yourself: Am I still free?</p>\n\n\n\n<p>No, you’re not. You are allowed to do some things that are in and of themselves good, but ultimately, it’s not built on a foundation of <a href="https://ma.tt/2014/01/four-freedoms/">an inalienable right </a>or constitution; it’s at the whim of the leader. <a href="https://www.fizzy.do/license">O’Saasy license has this restriction</a>:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>No licensee or downstream recipient may use the Software (including any modified or derivative versions) to directly compete with the original Licensor by offering it to third parties as a hosted, managed, or Software-as-a-Service (SaaS) product or cloud service where the primary value of the service is the functionality of the Software itself.</p>\n</blockquote>\n\n\n\n<p>Oh wow, I can’t compete with the leader. In how they choose to operate their business today, or however they might choose to in the future. My freedoms are at their whim. This violates rule 5 of the OSI definition of Open Source: “The license must not discriminate against any person or group of persons.”</p>\n\n\n\n<p>I’d like to choose software and live in a society that doesn’t discriminate.</p>\n\n\n\n<p>It’s not uncommon for people trying to take away your freedom to want to use the same words as those in truly free societies. North Korea calls itself the Democratic People&#8217;s Republic of Korea. Why? <a href="https://www.google.com/search?q=why+does+north+korea+call+itself+democratic">Per Google&#8217;s AI</a>:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p><strong>Socialist Definition of Democracy</strong> During the Cold War, the Soviet Union and its allies used &#8220;democracy&#8221; to mean &#8220;people&#8217;s power&#8221; through a single ruling party, representing the working class, as opposed to the multi-party &#8220;bourgeois&#8221; democracy of the West. North Korea adopted this lexicon, as did other communist states like the German Democratic Republic (East Germany).</p>\n</blockquote>\n\n\n\n<p>Yeah, really democratic. In that sense, you can say O&#8217;Saasy is an “open” “source” license. Perhaps a bubble of people will agree with you. But the rest of the world will use common sense and see that as a <strong>fraud</strong>. And most disappointingly for <a href="https://37signals.com/">37signals</a>, a company that prides itself on high integrity, it&#8217;s <strong>false advertising</strong>.</p>\n\n\n\n<p>(For what it&#8217;s worth, <a href="https://x.com/photomatt/status/1996353545717924209">I tried to resolve this quietly with Jason Fried a few days ago</a>.)</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 09 Dec 2025 05:30:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:24;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"Matt: Happy Birthday Kinsey";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150776";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:32:"https://ma.tt/2025/12/kinsey-70/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:3384:"<p>Yesterday I had the great honor and privilege of attending a colleague’s 70<sup>th</sup> birthday party. You may not have heard his name before, but <a href="https://kinsey.nyc/">Kinsey Wilson</a> has been at the center of shaping journalism with a movie-worthy career that started at the bottom as a crime reporter in Chicago, and has taken him to the highest echelons at NPR, the New York Times, and, most recently, we’ve been lucky to have him at Automattic.</p>\n\n\n\n<p>Kinsey brings a journalistic curiosity and passion for finding truth, paired with a deep optimism and creativity for seeing around the corner for how technology can transform how we consume and produce media.</p>\n\n\n\n<p>While <a href="https://en.wikipedia.org/wiki/Kinsey_Wilson">his Wikipedia page</a> or <a href="https://kinsey.nyc/about/">biography</a> provides appetizers to some of what he&#8217;s done, Kinsey has led such a rich and beautiful life that any attempt to summarize it ends up being criminally reductive. The best you can hope for is to give a taste of his person through vignettes.</p>\n\n\n\n<p>A beautiful snippet from the montage of accolades at his birthday was how Kinsey was someone you’d follow into battle. I’ve learned so much from seeing the empathy, candor, and integrity he brings to every team he leads, which engenders an incredible loyalty I&#8217;ve rarely seen in my career. When he left NPR, 62 colleagues made <a href="https://web.archive.org/web/20141107124059/http://www.infinitekinsey.com/playlist/">an “Infinite Kinsey” website of accolades</a>. </p>\n\n\n\n<p>That sort of thing is rare, and it’s been an honor and a privilege to work alongside him to democratize publishing.</p>\n\n\n\n<p>One of those colleagues, <a href="https://elisehu.com/">Elise Hu</a>, introduced us while he was at the New York Times and while my intention when I first met him was to get more WordPress at the Times, my imagination was sparked by thinking of how he could bring his experience to help shape WordPress and Automattic, hence my pivot into recruiting him.</p>\n\n\n\n<p>Kinsey&#8217;s impact on journalism (and podcasting!) at NPR and New York Times is easy to understand, but less well-known is how he came into Automattic and got deep into understanding WordPress and seeing it as a platform that could enable the newsrooms and journalists to accomplish their mission in a more efficient way with the project he leads, <a href="https://newspack.com/">Newspack</a>. </p>\n\n\n\n<p>He’s a fierce steward of the <a href="https://en.wikipedia.org/wiki/Fourth_Estate">Fourth Estate</a>. </p>\n\n\n\n<p>Newspack and its team’s close relationship to customers invents solutions on top of WordPress that delight its users and percolate and influence everything we do at <a href="https://automattic.com/">Automattic</a>. They&#8217;re one of the teams that sets the bar for others in the company.</p>\n\n\n\n<p>To Kinsey, I’ll leave you with a quote from one of my other inspirations, Charlie Munger, who at the <a href="https://www.wsj.com/finance/investing/charlie-munger-life-final-years-berkshire-7c20c18e">tender age of 99 shared a wish with a visitor</a>, <em>“Oh, to be 86 again.”</em></p>\n\n\n\n<p>I’ll try not to be too tech-bro optimist and say that 70 is the new 40, but I look forward to seeing the ripples that you have on the future of publishing for many years to come. </p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 07 Dec 2025 21:37:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:25;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"Matt: Self-driving";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150768";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:35:"https://ma.tt/2025/12/self-driving/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1455:"<p>There has been some lovely writing about self-driving this week, first in the New York Times where <a href="https://www.nytimes.com/2025/12/02/opinion/self-driving-cars.html">Jonathan Slotkin makes the medical case for autonomous vehicles</a>. But I was really taken by <a href="https://www.economist.com/finance-and-economics/2025/11/27/self-driving-cars-will-transform-urban-economies">The Economist&#8217;s look at how self-driving cars will transform urban economies</a>. It&#8217;s behind a paywall. I enjoyed how they thought about the second-order effects of self-driving.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>America is home to 1m taxi and bus drivers, as well as over 3m truck drivers—adding up to 3% of the working population. Other potential losers are less obvious. Without car accidents there will, for instance, be less demand for personal-injury lawyers. If people stop buying cars, dealers and used-car salesmen will go. </p>\n</blockquote>\n\n\n\n<p><span style="margin: 0px; padding: 0px;">It&#8217;s fascinating to think a few chess moves down the line, for example, fewer personal-injury lawyers funding politicians might lead to some form of <a href="https://en.wikipedia.org/wiki/Tort_reform" target="_blank">Tort Reform</a>, an area of society that, like gun control, has centrist changes most Americans would agree with, but has been captured by special intere</span>sts.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 06 Dec 2025 23:54:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:26;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Matt: AI Native";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150762";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:32:"https://ma.tt/2025/12/ai-native/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:126:"<p>James LePage has a great write-up, <a href="https://j.cv/sotw-2025/">SOTW 2025:The Year WordPress Became AI-Native</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 06 Dec 2025 05:47:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:27;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:111:"Gutenberg Times: State of the Word,  WordPress 6.9 “Gene”, Playground Year-Review —  Weekend Edition #352";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://gutenbergtimes.com/?p=43310";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:107:"https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-gene-playground-year-review-weekend-edition-352/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:28795:"<p>Hi there, </p>\n\n\n\n<p>How did the upgrade to WordPress 6.9 go for you and those around you? Did anything break? Or are you waiting for 6.9.1 to come out? </p>\n\n\n\n<p>Once in a while I get a question on how I keep up with the fast progress and the vast range of updates in Gutenberg and WordPress Core. Here is one source of information I am grateful for: Contributors working on the Gutenberg project started posting their so-called <a href="https://github.com/WordPress/gutenberg/issues?q=is%3Aissue%20state%3Aopen%20label%3A%22%5BType%5D%20Iteration%22">&#8220;Iteration for WordPress 7.0&#8221;</a> issues on GitHub. I bookmarked this list and once in a while I will check up on the progress, especially when I get lost in the weeds of single PRs and need to align again on big picture goals. It&#8217;s not a comprehensive list, though. </p>\n\n\n\n<p>From the conversations at State of the Word 2025, I learned that the community is embracing the educational initiatives of Campus Connect and WordPress Credits. Seeing more generations stream into the ecosystem warms this perpetual community organizer&#8217;s heart.  Equally exciting is the foundational work the AI Team has accomplished to ready the ecosystem for the era of Artificialle Interlligence (AI) when LLMs and helper agents elevate research, publishing and amplification for people. </p>\n\n\n\n<p>What did stand out for you after watching the State of the Word video? Email me or leave a comment. </p>\n\n\n\n<p>Below is another walk-through of the buzz around block editor, plugins and Playground. Enjoy, and have a wonderful weekend. </p>\n\n\n\n<p>Yours, <img alt="💕" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f495.png" style="height: 1em;" /><br /><em>Birgit</em></p>\n\n\n\n\n\n\n\n<h2 class="wp-block-heading" id="0-word-press-release-information">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href="https://wordpress.org/news/2025/12/gene/"><strong>WordPress 6.9 &#8220;Gene&#8221;</strong></a> was released during State of the Word 2025, with most of the release leads present at the in-person event. You can <a href="https://youtu.be/U_DF4-23C8Q?si=3Y2KdtWyKasFJD7p&amp;t=2495">revisit the moment on YouTube</a>  41:35  minutes into the recording, with the demonstration of the major features by Matias Ventura. </p>\n\n\n\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-43463" height="341" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Release-Edition-Featured-Image-6.9-scaled-1.webp?resize=652%2C341&#038;ssl=1" width="652" /></figure>\n</div></div>\n\n\n\n<p><strong>Nicholas Garofalo</strong> wrote <a href="https://wordpress.org/news/2025/12/sotw-2025/"><strong>State of the Word 2025: Innovation Shaped by Community</strong></a>. Matt Mullenweg and Mary Hubbard, our Executive Director, delivered WordPress&#8217;s yearly update, which included an exciting live launch of WordPress 6.9. The keynote dug into how we&#8217;re mixing in AI with features like the Abilities API and MCP adapter, highlighted the awesome growth of our global community across 81 WordCamps, and showed off cool tools like Telex that help you create AI-powered blocks. Some major highlights were new collaboration features, upgraded developer APIs, and more ways to connect learners around the globe to opportunities on the open web.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Rae Morey,</strong> The Repository, reports on the annual keynote in detail in her post <a href="https://www.therepository.email/state-of-the-word-2025-ai-education-and-a-community-holding-steady-through-a-rollercoaster-year"><strong>State of the Word 2025: AI, Education, and a Community Holding Steady Through a “Rollercoaster” Year</strong></a>. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>You can watch the entire <strong><a href="https://youtu.be/U_DF4-23C8Q?si=3Y2KdtWyKasFJD7p&amp;t=2495">State of the Word</a></strong> event on YouTube. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>James Le Page</strong> elaborated in <a href="https://j.cv/sotw-2025/"><strong>SOTW 2025:The Year WordPress Became AI-Native</strong></a> how WordPress delivered four foundational AI components in version 6.9, six months after forming its first dedicated AI team. The Abilities API creates unified registries for AI agents, while the WP AI Client provides provider-agnostic LLM interfaces. The MCP Adapter exposes capabilities externally, and the AI Experiments Plugin demonstrates practical implementations. Looking ahead, version 7.0 will introduce client-side abilities and a Workflows API for chaining actions, positioning WordPress to remain central as AI reshapes content consumption and creation across the open web.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><img alt="🔥" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f525.png" style="height: 1em;" /> Save the Date! <strong>January 13, 7pm UTC</strong> Join  James LePage and Jamie Marsland for a hallway hangout on all things WordPress AI. If you are interested, <a href="https://x.com/pootlepress/status/1996927536865906896">comment on the tweet</a> or ping Jamie Marsland. </p>\n\n\n\n<figure class="wp-block-image size-full"><a href="https://x.com/pootlepress/status/1996927536865906896"><img alt="" class="wp-image-43458" height="365" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Jamie-James-WordPress-AI.jpeg?resize=652%2C365&#038;ssl=1" width="652" /></a></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In <strong><a href="https://www.youtube.com/watch?v=ysRLeRGOZko&amp;t=1s">WordPress 6.9 Is Out! The Main Features You Need to Know</a></strong>, Karol Kroll gives you a walk-through of the new version on his YouTube channel. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Maddy Osma</strong>n reported on <a href="https://wordpress.com/blog/2025/12/02/wordpress-6-9-for-site-owners/"><strong>What’s New for Bloggers, Creators, and Site Owners</strong></a> in WordPress 6.9. and highlights collaboration tools like block-level notes and hide-show toggles, new creative blocks including Accordion and Term Query for enriched storytelling, plus performance improvements loading styles on demand. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In his post <a href="https://make.wordpress.org/core/2025/12/01/ability-to-hide-blocks/"><strong>Ability to Hide Blocks in WordPress 6.9</strong></a>, <strong>Aki Hamano</strong>, sponsored triage co-release lead, shared more detail about this new WordPress features and how to disable it. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Rhys Wynne</strong> discussed the release of <a href="https://dwinrhys.com/2025/12/03/wordpress-6-9-released-what-new-features-are-there/"><strong>WordPress 6.9</strong></a>, noting it contains more visible features compared to version 6.8. He highlights three key improvements: the Notes,; the Accordion block, and the Command Palette. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>On the Hostinger Blog, <strong>Bud Kraus</strong> explained the <strong><a href="https://www.hostinger.com/blog/wordpress-6-9">many features of WordPress 6.9</a></strong>, highlighting Notes, Accordion and Terms Query blocks and the Command Palette. Kraus emphasizes developer enhancements like the Abilities API, improved Block Bindings, and removal of legacy Internet Explorer code. He notes this release marks the official start of Phase Three collaboration features while balancing practical user improvements.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Carlo Daniele</strong> reported on the latest WordPress release for Kinsta. In <a href="https://kinsta.com/blog/wordpress-6-9/"><strong>New features, new blocks, new APIs: here is what’s new in WordPress 6.9</strong></a>, he discusses key features like the Command Palette, Notes, and new blocks. He also covers updates for developers, including the streaming block parser, custom Social Link icons, the Abilities API, Block Bindings, and improvements to the Interactivity API and DataViews.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>Earlier this week, I worked on the release of Gutenberg 22.2. You can read my release post on the Make Blog: <a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/"><strong>What’s new in Gutenberg 22.2 (03 December)?</strong></a>. The highlights are: </p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#cover-block-video-embeds">Cover block video embeds</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#breadcrumbs-block-enhancements">Breadcrumbs block enhancements</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#styling-options-for-the-math-block">Styling options for the Math block.</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#other-notable-highlights">Other Notable Highlights</a>, like Button block pseudo-state styling and DataViews upgrades.</li>\n</ul>\n\n\n\n<figure class="wp-block-image size-large"><a href="https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/"><img alt="Use video from YouTube for your cover background. " class="wp-image-43446" height="416" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/gb-22-2-embed-1.png?resize=652%2C416&#038;ssl=1" width="652" /></a></figure>\n\n\n\n\n\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">\n<p><img alt="🎙" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f399.png" style="height: 1em;" /> The latest episode is <a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/">Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2</a> with <strong>JC Palmes</strong>, WebDev Studios</p>\n\n\n\n<figure class="wp-block-image size-full is-style-no-vertical-margin"><img alt="Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack" class="wp-image-43283" height="186" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1" width="652" /></figure>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h2 class="wp-block-heading" id="0-p">Plugins and Tools for #nocode site builders</h2>\n\n\n\n<p><strong>Bernhard Kau</strong>, a PHP developer from Berlin and community organizer, started an <a href="https://kau-boys.com/category/advent-calendar">Advent Calendar</a> to showcase recommended plugins. The Dec. 3 edition featured <a href="https://kau-boys.com/4252/advent-calendar/block-editor-reverse-columns-on-mobile-a-small-block-options-plugin"><strong>Block Editor: Reverse Columns on Mobile – a small block options plugin</strong></a>. He likes it for its ability to solve mobile layout issues with just 250 lines of code, managing columns, group blocks, and media-text arrangements. Instead of needing to add custom CSS classes manually, the plugin uses simple checkboxes to order image and text correctly on mobile and supports RTL languages and various flex layouts. While some believe fewer plugins are better, Kau prefers targeted solutions that do exactly what he would code himself, making features easy for content editors on no-code sites without overcomplicating the functionality. If you need a guide through the forest of plugins in the WordPress ecosystem you should follow Bernhard Kau&#8217;s blog. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Jake Spurlock</strong> <a href="https://jakespurlock.com/2025/12/placeholders-ad-wireframing/"><strong>released Placeholders, a WordPress plugin</strong></a> that simplifies wireframing ad layouts by offering fourteen Gutenberg blocks for common IAB advertising sizes. Each block shows clean wireframe-style placeholders with accurate dimensions, customizable colors, and alignment options, all without needing an actual ad setup. This free plugin empowers designers and developers to create mock placements for design phases, client presentations, and layout testing. Future updates may add custom sizes, layout templates, and ad management features. The <a href="https://wordpress.org/plugins/placeholders/">plugin is available</a> on the WordPress repository.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Joop Laan</strong> has created a new plugin called <strong><a href="https://wordpress.org/plugins/inline-context/?preview=1">Inline Context</a></strong>. It adds expandable tooltip popovers to your content for easy definitions, references, and clarifications without interrupting reading. You can highlight text, provide rich-text explanations, and categorize notes with custom icons and colors. This plugin is great for editorial sites, documentation, and research platforms. It&#8217;s fully keyboard-accessible and ready for translation. Laan also offers a <a href="https://wordpress.org/plugins/inline-context/?preview=1">live preview of the plugin in Playground</a> to see it in action.</p>\n\n\n<div class="ng-block-edc9a60377a44b1a wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #fdfcea; border-radius: 12px;"><div class="ng-block-b30029f9ac66a59d wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong> <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/" rel="noreferrer noopener" target="_blank">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. </p></div></div></div></div>\n\n<div class="ng-block-e4059481510229ef wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>The previous years are also available: <br /><strong><strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/">2020</a> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/">2021</a></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/">2022</a></strong></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023">2023</a></strong> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/"><strong>2024</strong></a></p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<h2 class="wp-block-heading" id="3-building-themes-for-fse-and-word-press">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p>Last month, <strong>JuanMa Garrido</strong> and <strong>Jonathan Bossenger</strong> invited user to the <a href="https://wordpress.tv/2025/12/02/developer-hours-wordpress-6-9-block-bindings-interactivity-api/"><strong>Developer Hours: WordPress 6.9 Block Bindings &amp; Interactivity API</strong></a>. The recording is now available on WordPress TV. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p><strong>Ronald Huereca</strong> discusses the <a href="https://dlxplugins.com/tutorials/how-to-manage-the-admin-wide-command-palette-in-wordpress-6-9/">Admin-Wide Command Palette</a> which now operates in the entire admin area with CMD/CTRL-K. He shows how to disable the palette selectively using the wp-core-commands script handle, enable it on the frontend, and create custom commands using React hooks and registerPlugin. Huereca includes code snippets for different contexts—block editor only, admin excluding editor, or both—and suggests using separate script endpoints for new commands in existing block plugins to prevent iframe issues.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p><strong>Brian Coords</strong> shared a tutorial on <a href="https://www.briancoords.com/building-a-woo-product-category-image-block-with-wordpress-6-9/"><strong>creating a Woo Product Category Image Block with WordPress 6.9</strong></a>, using the Block Bindings API and a new Terms Query Loop to show product category images without custom blocks. The method registers bindings using PHP on the server to get term meta thumbnails and uses JavaScript for the editor preview through WooCommerce&#8217;s data package. A block variation allows for easy insertion. Coords mentions this solves issues where taxonomy term images aren&#8217;t standard in WordPress, but he notes the increasing clutter in the block inserter due to more specialized variations.</p>\n\n\n\n<figure class="wp-block-image size-full"><a href="https://www.briancoords.com/building-a-woo-product-category-image-block-with-wordpress-6-9/"><img alt="" class="wp-image-43444" height="344" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-06-at-10.04.14.png?resize=652%2C344&#038;ssl=1" width="652" /></a></figure>\n\n\n\n<p><strong>Felix Arntz</strong> <a href="https://www.linkedin.com/posts/felixarntz_many-people-have-asked-me-over-the-past-few-activity-7400592023696867328-xeDW?utm_source=share&amp;utm_medium=member_desktop&amp;rcm=ACoAAAAkKaoBHI9qqM4OcmXfJb1QeGFMlLI6W4o">address on LinkedIn</a> frequently asked question, on how he built the Gutenberg-like UI in his <a href="https://wordpress.org/plugins/ai-services/">AI Services</a> plugin for WordPress. In a new npm package called<a href="https://www.npmjs.com/package/wp-interface"> <strong>wp-interface</strong></a> he provided an abstracted solution anyone can use to get started integrating it into their plugins. </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>On his livestream, <strong>Jonathan Bossenger</strong> tested WordPress 6.9 and showed <strong><a href="https://www.youtube.com/watch?v=TKG11gdQEoo">how to use its Block Bindings updates in a custom plugin</a></strong>. He explored custom post types and meta fields, worked with block bindings, and updated custom fields. Watch him solve debugging issues, add a year field, and improve a custom plugin.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p>In his blog post <a href="https://alex.kirk.at/2025/11/29/wordpress-development-without-a-computer/"><strong>WordPress Development Without a Computer</strong></a>, <strong>Alex Kirk</strong>, long time WordPress contributor, outlines how he envisions AI-assisted fixes on the fly on a WordPress site. &#8220;With AI coding assistants that run in the browser—like Claude Code, OpenAI Codex, GitHub Copilot Workspace, or similar tools—combined with WordPress Playground for testing, you can now do WordPress plugin development without a computer.&#8221; Kirk provides a step-by-step instructions on how to make it possible today.  </p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In his livestream, <strong>JuanMa Garrido</strong> discussed the <strong><a href="https://www.youtube.com/watch?v=hlbT0fnIe8E">Interactivity Router</a></strong> package, highlighting its ability to load content without full page reloads. He demonstrated client-side navigation in query loop blocks and interactive lightbox behavior. The session included enabling client-side navigation, performance comparisons, and practical API documentation examples.</p>\n\n\n\n<figure class="wp-block-image size-full"><a href="https://www.youtube.com/watch?v=hlbT0fnIe8E"><img alt="" class="wp-image-43455" height="335" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/JuanMa-Garrido-interactivity-router.jpeg?resize=600%2C335&#038;ssl=1" width="600" /></a></figure>\n\n\n\n<h3 class="wp-block-heading" id="what-s-new-in-playground">What&#8217;s new in Playground</h3>\n\n\n\n<p>In this <a href="https://make.wordpress.org/playground/2025/12/03/wordpress-playground-2025-year-in-review/">2025 Year in Review</a>, Playground architect <strong>Adam Zieliński</strong> lists transformative achievements including supporting ninety-nine percent of WordPress plugins, running PHPMyAdmin and Laravel alongside substantial performance gains through OpCache and concurrent workers. New PHP extensions like XDebug enable modern debugging workflows while state-of-the-art MySQL emulation powers comprehensive database management. Developer tools now include file browsers, Blueprint editors, and one-click Gutenberg branch previews. </p>\n\n\n\n<p>The community contributed translations across six languages, earned forty-eight contributor badges, and demonstrated Playground at WordCamps globally, establishing it as essential infrastructure for testing, teaching, and building WordPress.</p>\n\n\n\n<figure class="wp-block-image size-large"><a href="https://playground.wordpress.com"><img alt="Playground default screen. " class="wp-image-43442" height="350" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-06-at-09.49.53.png?resize=652%2C350&#038;ssl=1" width="652" /></a></figure>\n\n\n<div class="ng-block-39130f10258a9737 wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #f8f8f8; border-radius: 8px;"><div class="ng-block-b4adfaf2f9044983 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong><a href="https://gutenbergtimes.com/need-a-zip-from-master/">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p></div></div></div></div>\n\n<div class="ng-block-e7ee1b31b2dffd79 wp-block-newsletterglue-image ng-block size-full is-resized" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px;"><a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json"><img alt="" class="wp-image-42874 ng-image" height="45" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2025-11-15-at-12.06.44.png?resize=196%2C45&#038;ssl=1" style="border-style: none; border-color: transparent;" width="196" /></a></div></div></div></div>\n\n<div class="ng-block-ab3549befbc64bca wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>Now also available via <a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href="mailto:pauli@gutenbergtimes.com">Email me </a>with your experience.</p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p class="has-text-align-center has-small-font-size"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href="mailto:pauli@gutenbergtimes.com">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p class="has-text-align-center has-small-font-size">For questions to be answered on the <a href="http://gutenbergtimes.com/podcast">Gutenberg Changelog</a>, <br />send them to <a href="mailto:changelog@gutenbergtimes.com">changelog@gutenbergtimes.com</a></p>\n\n\n<div class="ng-block-1fd1713d9c717189 wp-block-newsletterglue-separator ng-block" style="color: #666666;" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; color: #666666;"><hr style="background-color: transparent; color: transparent; margin: 0; border: 0; border-top: 1px solid #666666; width: 560px; height: 0;" /></div></div></div></div>\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%"><div class="ng-block-4d9d3f31b0680d94 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 14px; font-family: Helvetica; line-height: 0.2; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong>Featured Image: </strong></p></div></div></div></div></div>\n\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 06 Dec 2025 03:38:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Birgit Pauli-Haack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:28;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt: Unifi 5G";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150758";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:31:"https://ma.tt/2025/12/unifi-5g/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1187:"<p>One of my favorite hobbies is home networking and wifi, and once you go down that rabbit hole one of the best companies you can follow is <a href="https://ui.com/">Unifi</a>. They&#8217;re such a cool company in so many ways, from having a <a href="https://ir.ui.com/company/board-of-directors">4-person board of directors</a>, as a public stock. You can clearly tell they delight in bringing great design to hardware, in a Apple-like attention to detail. </p>\n\n\n\n<p>They ship such cool products regularly, across an entire ecosystem that spans cameras to access control, it&#8217;s hard to describe everything they can cover, and they&#8217;ll even have random stuff that integrates into their system like EV charging or digital signage. I get as excited when they ship a new generation of hardware as I do for an iPhone launch.</p>\n\n\n\n<p>But what&#8217;s exciting is that they just launched <a href="https://blog.ui.com/article/introducing-unifi-5g">5G bridging, with some fun devices that connect everything</a>. I imagine someday I&#8217;ll have a Unifi puck hooked up to Starlink, providing amazing routing and connectivity anywhere in the world, powered by some PoE battery.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 05 Dec 2025 05:34:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:29;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"WordPress.org blog: State of the Word 2025: Innovation Shaped by Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19447";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://wordpress.org/news/2025/12/sotw-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:28824:"<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href="https://wordpress.org/book/2015/11/wordcamp-2006/"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Globe graphic noting 43% of websites and 60.5% CMS market share" class="wp-image-19500" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class="wp-block-heading">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href="https://wordpress.org/download/releases/6-9/">WordPress 6.9</a>.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="WordPress 6.9 Gene album cover art" class="wp-image-19511" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation. </p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Photo of WordPress release leads pressing the button to release 6.9" class="wp-image-19457" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href="https://en.wikipedia.org/wiki/WordPress#History">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere" class="wp-image-19510" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href="https://telex.automattic.ai/">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class="wp-block-video"><video controls="controls" height="2160" src="https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4" width="3840"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-19503" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href="https://wordpress.org/education/campus-connect/">Campus Connect</a> and <a href="https://wordpress.org/education/credits/">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href="https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-19505" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /><figcaption class="wp-element-caption">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Various Wapuu artwork examples" class="wp-image-19506" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href="https://events.wordpress.org/managua/2025/wordpress-youth-day/">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class="wp-block-video"><video controls="controls" height="2160" src="https://wordpress.org/news/files/2025/12/wapu-513.mp4" width="3840"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class="wp-block-heading">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href="https://profiles.wordpress.org/matveb/">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class="wp-block-list">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href="https://wordpress.org/plugins/plugin-check/">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href="https://wordpress.org/data-liberation/">Data Liberation</a>, noting improvements to the <a href="https://wordpress.org/plugins/wordpress-importer/">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href="https://playground.wordpress.net/">Playground</a> ecosystem, including <a href="https://developer.wordpress.com/studio/">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> (Automattic), <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> (Google), and <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="" class="wp-image-19462" height="572" src="https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1" width="1024" /><figcaption class="wp-element-caption">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class="wp-block-heading">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Q&amp;A" class="wp-image-19512" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href="https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class="wp-block-heading">TBPN Podcast Appearance</h2>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href="https://www.beeper.com/">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class="wp-block-heading">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class="wp-block-heading">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href="https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia</a> in Mumbai, India,<a href="https://europe.wordcamp.org/2026/">WordCamp Europe</a> in Kraków, Poland, and <a href="https://us.wordcamp.org/2026/">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 18:26:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"Nicholas Garofalo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:30;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:88:"WPTavern: #196 – Topher DeRosia on How Public Contributions Shape Careers in WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=201513";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:102:"https://wptavern.com/podcast/196-topher-derosia-on-how-public-contributions-shape-careers-in-wordpress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:51892:"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how public contributions can shape careers in WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Topher DeRosia. Topher is a web developer with over 30 years of experience, and he&#8217;s been deeply involved in the WordPress community for the past 15 years. He&#8217;s attended nearly 80 WordCamps around the world, contributed to projects like HeroPress, and has made it his mission to highlight the power and value of open source and remote work, especially in the WordPress ecosystem.</p>\n\n\n\n<p>In this episode, Topher joins me to talk about the value of working in public, and how sharing your work openly can create unexpected and lasting opportunities. Whether that&#8217;s boosting your career, finding a sense of purpose, or building connections across the globe.</p>\n\n\n\n<p>We start with Topher&#8217;s personal journey, discovering the WordPress community and the profound impact it has had on his life and family. The conversation explores what makes open source communities, like WordPress, so unique, and while working transparently can lead to moments of serendipity and even job offers from people who have seen your contributions many years before.</p>\n\n\n\n<p>Topher shares stories about giving back, the motivation that comes from helping others, and the long-term satisfaction that comes from being generous with your time and expertise.</p>\n\n\n\n<p>We also discussed the tension between the philanthropic and commercial aspects of WordPress, and how individuals and companies navigate that balance.</p>\n\n\n\n<p>Towards the end, Topher reflects on building a body of work over time, trusting in the slow and organic process instead of seeking instant influencer success. He explains why he still chooses to create and share resources for free, motivated by the hope of helping the next person just starting out.</p>\n\n\n\n<p>If you&#8217;ve ever wondered about the power of sharing your work, finding meaning in open communities, or how to make a difference over the long term, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Topher DeRosia.</p>\n\n\n\n<p>I am joined on the podcast by Topher DeRosia. Hello.</p>\n\n\n\n<p>[00:03:19] <strong>Topher DeRosia:</strong> Hello there.</p>\n\n\n\n<p>[00:03:20] <strong>Nathan Wrigley:</strong> It&#8217;s very nice to chat to Topher. We&#8217;ve done this before. We&#8217;ve had many chats online, but I just want to pay a special thanks to Topher for reasons I won&#8217;t bore the audience with, Topher has sort of joined me at extremely late notice, like minutes of notice.</p>\n\n\n\n<p>We had a bit of back and forth yesterday about topics that we may cover, and the one that&#8217;s going to be covered today is the one that we decided. But he wasn&#8217;t expecting this, and so he&#8217;s arrived and I&#8217;m extremely grateful. So firstly, my deepest thanks for carving out a bit of your day unexpectedly.</p>\n\n\n\n<p>[00:03:50] <strong>Topher DeRosia:</strong> You&#8217;re very welcome. This is always fun, and fit my day perfectly.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> Yeah, okay. Thank you. So what we decided to talk about was, and I&#8217;ll encapsulate it in a sentence that Topher wrote to me, and then we&#8217;ll just sort of get into it and see where we go. Topher said, he&#8217;d like to talk about the value of doing things in public, and how this can come back to you later as a way of potentially, I don&#8217;t know, boosting your career or just offering some guiding light to the community and what have you.</p>\n\n\n\n<p>So first of all, in order to give us some idea, I&#8217;m sure that there are people who know you, having listened to the things that you&#8217;ve done or consumed the HeroPress website or what have you. Will you just give us a little potted bio of yourself related to, I guess the WordPress community, makes most sense in this context?</p>\n\n\n\n<p>[00:04:30] <strong>Topher DeRosia:</strong> Sure. I have been a web developer for 30 years, which is old, but I got into WordPress about 15 years ago and I did not know there was a community for several years. And Brian Richards said to me, hey, we should do a WordCamp. And I said, what&#8217;s a WordCamp? And then of course, my life changed forever after.</p>\n\n\n\n<p>Oh, you know what? We started with a meetup, but like 2 weeks later he said we should do a WordCamp. And he said, we should do it this summer. And we were talking, like we were talking in June. So we went from never hearing of it before, to having a WordCamp suddenly. And I&#8217;ve been in, all in on the community ever since. I&#8217;ve been to nearly 80 WordCamps, all over the world. I&#8217;ve been making stuff, building stuff, meeting people ever since.</p>\n\n\n\n<p>[00:05:12] <strong>Nathan Wrigley:</strong> Wow.</p>\n\n\n\n<p>[00:05:13] <strong>Topher DeRosia:</strong> It&#8217;s pretty great.</p>\n\n\n\n<p>[00:05:13] <strong>Nathan Wrigley:</strong> Yeah, 80. Gosh, that&#8217;s profound. I mean, I don&#8217;t consider myself to have a high attendee account, but 80, that really is remarkable.</p>\n\n\n\n<p>So I think it&#8217;s fair to say that the profundity of the effect of discovering that community is pretty important in your life. You know, it&#8217;s had a material impact in every way.</p>\n\n\n\n<p>[00:05:31] <strong>Topher DeRosia:</strong> Hugely. My wife got into the community. My children, both my kids have spoken at WordCamp US. My wife has spoken. My kids have friends in other countries that I don&#8217;t know because of the WordPress community. Every parent has that fear of, what if something happened to us? What would happen to the kids? And we have family that would take care of them, you know? It&#8217;s nice to know we also have that backup where there are people all over the world who would say, hey, we got room, come on.</p>\n\n\n\n<p>[00:05:55] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s pretty amazing. I joined the WordPress community, so I&#8217;d been involved in lots of open source projects, things like Magento and Drupal and things like that. And I know that Drupal has, there&#8217;s definitely stuff in the Drupal space that you can attend. But I never did.</p>\n\n\n\n<p>And to be honest with you, I didn&#8217;t know that that stuff existed until after the fact. And then in about 2014, something like that, I discovered WordPress. And just like you, I had no conception that it was more than some downloadable bit of software. Honestly didn&#8217;t even know that it was done by volunteers. I just had probably some assumption that there was an organization or a company behind it that in some way monetised it and made it free and what have you.</p>\n\n\n\n<p>And then just got this intuition, I guess, with social networks, the way that they were at that time, you could find groups and discover that there were all these ancillary groups of people doing things with WordPress, you know, groups focusing around page builders and groups focusing around plugins.</p>\n\n\n\n<p>And then for me to discover that there were actual events that you could attend was, just like you, really remarkable. And I attended the first one and I kind of thought, oh, we&#8217;ll just see how this goes. I&#8217;m a bit of an awkward character in person, so I sort of stood around at the back. But it didn&#8217;t take me long to sort of be welcomed in. And just like you, completely changed my life. And ever since then, a sizable proportion of my free time has been devoted to curious WordPress things. It&#8217;s amazing.</p>\n\n\n\n<p>I can&#8217;t quite work out what it is about a project like WordPress that inculcates that, fosters that, makes that possible. Because I imagine if you attended, I don&#8217;t know, a Cisco networking conference or something like that, it&#8217;s not going to have the same feel. So I don&#8217;t know if you want to speak to that for a little bit, why you think the community works.</p>\n\n\n\n<p>[00:07:36] <strong>Topher DeRosia:</strong> Yeah. I have two thoughts about it. One is that I think it&#8217;s absolutely because of the people. And it may be chance that the right people found WordPress and got together at the same time. But to that point, that it&#8217;s the people, I recently went to two non WordPress conferences in one week.</p>\n\n\n\n<p>I went to one for higher education in technology. The people who attended were from universities and colleges, and they were looking for ways to manage web stuff on their entire campus. So do you offer a blog to all 24,000 students, you know? That kind of thing. It was my first time there, but I saw a number of people who were greeting each other and not having seen each other since last year, and the year before, and the year before. And it was very much like a WordCamp. And people talked about how this group is so wonderful and they wait all year long to come back here. And I thought, oh, okay, so this is WordCamp.</p>\n\n\n\n<p>And then while I was there, I met somebody who worked at Umbraco, which is an open source .net based CMS. And they&#8217;ve been around for 20, more than 20 years, but it&#8217;s a very small community, like 0.01% of the market share. And I told her, you know, who I am, what I do, and she&#8217;s like, oh, we would love to have you come to our conference this weekend in Chicago. Can I pay you to come? I was like, oh wow, sure.</p>\n\n\n\n<p>So I went and it was about a hundred people and it was WordCamp. Everybody there loved the software, loved the community, everybody was friends. It was the same. And expanding just a little more, HeroPress says it&#8217;s about people leveraging WordPress to make their lives better. But in actuality, what it is, is open source and remote work combined. It allows people in Malaysia to pick up software and compete on a relatively equal basis with somebody in New York. And in our world, that&#8217;s WordPress. But it&#8217;s exactly the same with every open source remote work option, Drupal, Umbraco, anything.</p>\n\n\n\n<p>[00:09:45] <strong>Nathan Wrigley:</strong> Maybe open source then is, forgive me, the secret sauce. Maybe that&#8217;s the component, the bit that binds those communities together in a way that perhaps, I don&#8217;t know, something where a proprietary thing or something was locked down, or profit was the whole point, maybe that is the bit. The fact that there&#8217;s a bunch of people gathering together in a kind of philanthropic way. You know, there&#8217;s no expectation that my attendance will definitely lead to finance, let&#8217;s put it that way.</p>\n\n\n\n<p>Like I said, I don&#8217;t really have much experience outside the WordPress world, and so my assumption was that there was something a little bit unique. But from what you&#8217;ve said, this same exact thing is happening probably a thousand times over throughout the globe, but your expectation there is that the open source component is the bit, the bit that unlocks it.</p>\n\n\n\n<p>[00:10:32] <strong>Topher DeRosia:</strong> Yeah, I agree. WordPress has the advantage of a very large user base, which is good and bad. There are certainly more wonderful people in it than if there were fewer. But at that scale, you are just as likely to have really terrible people. I know people that have left the WordPress community because they&#8217;ve been treated horrendously, abused, and it breaks my heart. And I want to say, oh, WordPress is different, you won&#8217;t find that here, but you will. It&#8217;s too big a community to not have that.</p>\n\n\n\n<p>[00:11:01] <strong>Nathan Wrigley:</strong> I wonder what it is then about that sort of spirit of giving back that creates some kind of, I don&#8217;t know, hive mind, for want of a better word. You know, there&#8217;s just this ethic that you&#8217;re all combined on this slightly higher purpose. So in the case of WordPress, and you mentioned Drupal and you mentioned the other CMS with the small market share, the principle there is that you&#8217;re working on something, and I guess publishing is the point. You are enabling people who may or may not have a voice to get on the internet and do something, publish something, write something, put images, videos or what have you.</p>\n\n\n\n<p>There is some kind of higher calling there. It&#8217;s very hard to sort of grasp that, and to really understand it. But do you know what I mean? You&#8217;re doing something which, at the end of your days, you can look back and say, there was something there. There was something meaningful, there was something significant and important. And that feeling, that thing, whatever that thing is, is important, and enough to propel people to give up hours and weeks of their lives to do this.</p>\n\n\n\n<p>[00:12:04] <strong>Topher DeRosia:</strong> I think most people enjoy making other people, I don&#8217;t know, so many things, more successful, happier, more stable. And there are open source projects that will shrivel up and die because no one ever says thank you. People work on a project for years and years and they think, you know what? Nobody cares. I&#8217;m going to go play Frisbee.</p>\n\n\n\n<p>But I think the WordPress community is large enough, and we have these events that everybody goes to, that you run into people who have been impacted by the work you do.</p>\n\n\n\n<p>There&#8217;s a, boy, can&#8217;t remember his first name. Heisel. He&#8217;s Dutch but lived in England and now he lives in Malta or something. Anyway, I met him for the first time at WordCamp London and he walked up to me and said, hey, I need to shake your hand. I said, okay. He said, a few years ago I lost my job and I didn&#8217;t know what I was going to do and I needed to support my family, and I got on OS Training and learned WordPress from your videos, and now I support my family with WordPress. I about broke down in tears right there.</p>\n\n\n\n<p>And that kind of thing happens to lots and lots of people. People who say, you know what? This plugin you wrote, it changed my life. I make a living with this now. I support my family.</p>\n\n\n\n<p>[00:13:19] <strong>Nathan Wrigley:</strong> Do you know what&#8217;s kind of interesting there is that, I guess you did none of it with the expectation of that person wandering up. You know, it&#8217;s not like, Topher, you sat down and thought, the more thanks I get, the more I&#8217;m going to do. There isn&#8217;t that kind of expectation. But it certainly helps, doesn&#8217;t it? When somebody does come up and express those thoughts to you. I bet you that carried you through the next days, weeks, or months. You know, the capacity to drag that out of your brain.</p>\n\n\n\n<p>[00:13:42] <strong>Topher DeRosia:</strong> It still is. That was years ago.</p>\n\n\n\n<p>[00:13:43] <strong>Nathan Wrigley:</strong> Yeah, yeah. Isn&#8217;t that interesting?</p>\n\n\n\n<p>[00:13:45] <strong>Topher DeRosia:</strong> I do think though that you don&#8217;t do it for the thanks, but it&#8217;s a lot easier to do if you think it matters. When people say thank you, it feels good, but it lets you know that what I&#8217;m doing matters. It&#8217;s making a difference. It&#8217;s making somebody&#8217;s life better. It&#8217;s making the world better. That&#8217;s a huge motivator.</p>\n\n\n\n<p>[00:14:04] <strong>Nathan Wrigley:</strong> That&#8217;s the big thing. So this is a curious question, right? And it&#8217;s not really related to WordPress. Did you have those same intuitions at an early age? Was there some part of you can remember even as, I don&#8217;t know, let&#8217;s say a 15-year-old or 17-year-old or something like that. Where you had already made the leap that life is better when you are being helpful? Or did you learn that later?</p>\n\n\n\n<p>Because I kind of have the intuition that quite a few people in our community probably figured that out at some point fairly early on. And it enables them, I&#8217;m obviously not suggesting that people who didn&#8217;t make that intuition early on can&#8217;t join the community or what have you. But I&#8217;m surrounded by people who seem to have this almost bottomless capacity to give. And I&#8217;m always struck by how did that begin for them? Where did that start for them? So because I&#8217;ve got you on the line, I&#8217;m asking you directly.</p>\n\n\n\n<p>[00:14:58] <strong>Topher DeRosia:</strong> When I was in college, I just randomly became interested in motivations. What makes people do things? What makes somebody mean all the time? What makes somebody happy all the time? What makes somebody be kind?</p>\n\n\n\n<p>And I thought through the process of how gratitude is an influencer. If you say to somebody, thank you for what you&#8217;re doing, it makes them feel good. It makes them want to do it more. If they&#8217;re, you know, working at a food pantry and you say, hey, thank you for what you&#8217;re doing, it&#8217;s changing lives, just feeding children. It makes them want to do that more. If that person at a food pantry were faced every day with angry people who abused them verbally and stuff like that, they&#8217;d be a lot less inclined to do that.</p>\n\n\n\n<p>[00:15:37] <strong>Nathan Wrigley:</strong> Yeah. I listened to a podcast not that long ago, and I actually can&#8217;t remember which one it was because I listened to several in this line. But essentially it was trying to peel back the latest studies in what causes some people to be happy. And I am not going to explain this and have the expectation that everything I say is true, nor that this is the limit of that. But a fairly reliable indicator of happiness, whatever that means, but on a fairly profound level, happiness can be boiled down to these two things, apparently.</p>\n\n\n\n<p>One of them is that you are giving of your time. So it may be that you are, as you say, working in a soup kitchen. Or that you are doing something in the community. Or you are just putting into your children or what have you. There is a real connection apparently between the capacity to give something from which you expect nothing in return. Humans apparently find great, deep satisfaction from that.</p>\n\n\n\n<p>And the other one is friendship. If you have people that you regard as friends, on a deep level. So obviously acquaintances, we can all have many, many thousands of those, especially online nowadays. But it&#8217;s that core little group of really impactful, meaningful people who in the time of crisis, you know are going to have your back.</p>\n\n\n\n<p>Those two things apparently are a real predictor of one&#8217;s happiness. And both of them seem to stray into our community, you know? Although it&#8217;s an online thing, you&#8217;re still giving your time, and you know that in a fairly ephemeral way that you maybe can never grasp, people will be benefiting from that. And also you make friends. So there you go, it&#8217;s the root to happiness.</p>\n\n\n\n<p>[00:17:19] <strong>Topher DeRosia:</strong> It is.</p>\n\n\n\n<p>[00:17:20] <strong>Nathan Wrigley:</strong> So all of that, having said all of that, you have this wealth of experience in the community. You&#8217;ve done so many projects in the community. And as I said at the top of the show, the thing that you wanted to talk about was, not just the mere fact of doing things in the community, but about the fact that you are doing things in the community in a sort of public way, and how that can sort of impact in the future. So just tell us a little bit about why you wanted to get into that, or maybe some anecdotal evidence of how that&#8217;s helped you.</p>\n\n\n\n<p>[00:17:50] <strong>Topher DeRosia:</strong> Very little of it in my life has been deliberate. I&#8217;ve done some things and then later thought, oh, wow, I didn&#8217;t realise that this would be the consequence. I made videos for OS Training for a lot of years, they&#8217;re behind a paywall, they paid me by the video. I wasn&#8217;t thinking, oh, I&#8217;m going to go teach the world. It was a client, I made videos.</p>\n\n\n\n<p>And years later, Brin Wilson from WinningWP got a hold of me on Post Status and said, hey, I want to start a YouTube channel. Would you make videos for me? I said, sure, but why me? He said, well, I&#8217;ve seen your work. You&#8217;ve done this, you have given evidence to the world that you know what you&#8217;re doing. And that was a good contract. And I got it because I had previously done something else.</p>\n\n\n\n<p>With HeroPress, I didn&#8217;t set out to become a relatively known person. I was just doing it. But I remember the first time I talked to a stranger from India and introduced myself and they said, oh, of course we know you. I said, what do you mean of course? You live 5,000 miles away from me. How on earth would you know me? And, boy, it is just stuff like that.</p>\n\n\n\n<p>I have some plugins on wordpress.org. I think cumulatively they have 12 installs. They&#8217;re not big plugins, but they&#8217;re there. And people look and say, oh, Topher knows how to make plugins.</p>\n\n\n\n<p>I contribute to the photos project. And people who aren&#8217;t necessarily contributors don&#8217;t necessarily understand the different kinds of contribution. They just see my name on the contributor list like, oh, Topher builds WordPress because I take a lot of photos or something. But just the fact that I&#8217;m out there doing that makes a difference.</p>\n\n\n\n<p>I&#8217;ve been blogging for years. I did blogs in the GoDaddy Garage back in the day, I wrote on OS Training, I wrote all over the place. And recently I thought, boy, I wish I had had all that on my own site.</p>\n\n\n\n<p>And then it occurred to me that WordPress does a lot of RSS, and so does YouTube. And so I built a site called topher.how. Found everything I&#8217;ve ever done and just used WP All Import and pulled it all into one place. So now at topher.how you can see stuff I&#8217;ve done decades ago, and it&#8217;s nice. It&#8217;s a place to say, look, here&#8217;s stuff I did. But I have gotten, no, you know, I&#8217;m not going to say I&#8217;ve gotten jobs, I&#8217;ve gotten consideration, interviews, interest because people who know who I am, because I did something once long ago.</p>\n\n\n\n<p>[00:20:11] <strong>Nathan Wrigley:</strong> Yeah, I guess the interview phase, to get yourself over the line, you&#8217;ve still got to sort of show your metal, haven&#8217;t you? But that whole thing of just being represented by your past, it&#8217;s really curious. We live in a world which is so dominated by, I don&#8217;t know, the financial motivation for this, that, and the other.</p>\n\n\n\n<p>It is curious when nowadays you can have a legacy which is not the CV, it&#8217;s not the line items on the CV. It can be much more ephemeral stuff. Things that you did, videos that you made, blogs that you contributed to.</p>\n\n\n\n<p>The people out there making the decisions about who&#8217;s going to get those jobs, well, you have proved that that kind of history of being online definitely works, and in unexpected ways. It&#8217;s not like there&#8217;s always a through line between, okay, I&#8217;m going to make these YouTube videos so that in a few years time I&#8217;ll have this credible body of evidence that will make it so that anybody can employ me. It&#8217;s much more ephemeral than that. It&#8217;s more, I&#8217;m doing this video because I think itll be helpful, and then serendipitously that then leads to something in the future.</p>\n\n\n\n<p>[00:21:14] <strong>Topher DeRosia:</strong> Yeah, very much so. Before we started recording, you mentioned my background here. It&#8217;s a piece of fabric on a photo stand. And I bought it just the other day because, you know, I&#8217;ve been making videos for years, I&#8217;ve never appeared on camera. Always been a screencast. And I recently got a client that said, well, we want you on camera. And so I got this thing.</p>\n\n\n\n<p>But the interesting part is that the client is a company in Bangladesh. And I know them quite well, they know me quite well because of stuff we&#8217;ve done together in the past in the WordPress community. And when they needed videos, they came to me, because they know me and they know that&#8217;s what I do. That wouldn&#8217;t happen if I hadn&#8217;t been out doing stuff years ago. What are the chances I would know somebody, me in Michigan, I would know somebody in Bangladesh?</p>\n\n\n\n<p>[00:22:01] <strong>Nathan Wrigley:</strong> Right. Right, I mean, the world of 50 years ago, it&#8217;s tending to zero basically, you know, unless you&#8217;d been on plane or somebody had been on a plane in the opposite direction and you&#8217;d met where you are. The opportunities afforded are amazing, and it&#8217;s that kind of long tail that you&#8217;ve got as well. That I suppose is going to be hard for somebody that&#8217;s younger to listen to because, you know, they kind of see this mountain that they&#8217;ve got to climb and this great body of work that they&#8217;ve got to build up over decades. I guess that&#8217;s, it&#8217;s not all about that either, it&#8217;s about sort of just chipping away at it and doing things piecemeal.</p>\n\n\n\n<p>[00:22:31] <strong>Topher DeRosia:</strong> I have a funny story about that. Early in my WordPress career, I got to know Pippen Williamson. You may remember him.</p>\n\n\n\n<p>[00:22:39] <strong>Nathan Wrigley:</strong> Yeah. I do.</p>\n\n\n\n<p>[00:22:39] <strong>Topher DeRosia:</strong> And he was very well known in the WordPress community. I got to know a few people who were very well known. I was like, man, that&#8217;s cool, everybody knows these people. Wonder if people will ever know me? We were talking about it, he and I, and he quickly urged me, do not seek to be known because that will only lead to tears. If you&#8217;re doing it for the wrong reason, then it will just turn out badly.</p>\n\n\n\n<p>And so I thought, well, you know, maybe in 10 years. Well, here we are. And I didn&#8217;t set out to be known. I&#8217;ve never bought a banner ad saying, look at Topher. I just went to WordCamp and spoke. I wrote blog posts, I made videos. I shook a lot of hands. I listened to a lot of stories.</p>\n\n\n\n<p>[00:23:18] <strong>Nathan Wrigley:</strong> It&#8217;s about sort of spreading the network organically really, isn&#8217;t it? Which I suppose in a sense leads to, okay, rather than the word fame, I&#8217;m going to use the word notoriety because I think they&#8217;ve got two very different endpoints. But the idea of seeking fame is tied up with, you know, you just want random people to know you because they know you, and that&#8217;s the kind of end game, you know? Oh, you are famous because you&#8217;re famous, that sort of flavor to it.</p>\n\n\n\n<p>Whereas notoriety for me has much more, there&#8217;s a body, a corpus of work behind you that leads to that understanding that, okay, that&#8217;s Topher. I know Topher because he did this, this, this, and this. It&#8217;s not famous because they&#8217;re famous. It&#8217;s more, there&#8217;s the guy who made those videos that I watched. Or there&#8217;s the guy that wrote that blog that I read all the time. That kind of thing. And so it&#8217;s not fame for fame sake, it&#8217;s accidental fame more, if you know what I mean?</p>\n\n\n\n<p>[00:24:10] <strong>Topher DeRosia:</strong> Yeah. I heard the term not too long ago that I like called community known.</p>\n\n\n\n<p>[00:24:14] <strong>Nathan Wrigley:</strong> Okay. That&#8217;s nice.</p>\n\n\n\n<p>[00:24:15] <strong>Topher DeRosia:</strong> Within a community, you you could say famous, very well known. Outside that community, people do not care and have no idea who you are.</p>\n\n\n\n<p>[00:24:22] <strong>Nathan Wrigley:</strong> That&#8217;s right. Yeah, it&#8217;s curious, inside of our community, there&#8217;s this one person whose name kind of precedes all others, and it would be Matt Mullenweg. But I&#8217;m willing to bet that if Matt was walking down the street, more or less anywhere, that his life is just the same as yours and mine. Nobody&#8217;s going to know who he is unless randomly they happen to be a WordPresser. But he&#8217;s fairly thin on the ground. You know, it&#8217;s not like he&#8217;s Scarlett Johansson or George Clooney or something like that, where that fame is probably quite an oppressive thing in their life. You know, the capacity to just walk down the street.</p>\n\n\n\n<p>So yeah, anyway, the point being that you&#8217;ve done stuff over time without the intention of it being this fame for being famous. It&#8217;s more about being community known, as you said. But that has had amazing consequences.</p>\n\n\n\n<p>And that kind of leads me to this next thing. I wonder, this question comes up all the time, but I do wonder if it&#8217;s more material now than it ever has been. I wonder if the community can always cope with the commercial pressure that is being born by the community?</p>\n\n\n\n<p>So for example, you know, you up to events and there&#8217;s a lot of people trying to sell you things. And maybe WordCamps from 15 years ago would&#8217;ve felt very much more a room full of like-minded individuals. Whereas now if you go to WordCamps, maybe there&#8217;s more of a feeling of, okay, that bit over there is more commercial, that bit over there is less commercial. But there&#8217;s always that kind of commercial angle.</p>\n\n\n\n<p>I don&#8217;t really know where I&#8217;m going with that, but the commercial side of things, I don&#8217;t know if you&#8217;ve got a feeling on, or a intuition on that?</p>\n\n\n\n<p>[00:25:54] <strong>Topher DeRosia:</strong> Sort of. Something I&#8217;ve noticed over the years is that it&#8217;s entirely possible to write a plugin, start selling it, have it be successful, build a business, hire people, maybe get a relatively large business, maybe hundreds of employees. And it feels good, it looks good, it&#8217;s great, it&#8217;s wonderful until it starts going, or getting hard. And then people who never thought this would happen start having to make difficult decisions that hurt people.</p>\n\n\n\n<p>If things aren&#8217;t going well, we need to let some people go. Maybe we need to let a lot of people go. Maybe we need to reorganise, whatever. And people look at this golden company, the pinnacle of WordPress, open source, love, family, peace, blah, blah, blah, and they&#8217;re letting people go. And you think, what? They&#8217;re just another business. They were just in it for the money. And they&#8217;re not, but it can feel that way when you&#8217;ve been let go.</p>\n\n\n\n<p>And at some point it has to be about the money. If you&#8217;re building a plugin because you love it and you&#8217;re selling it because people need it, that&#8217;s cool. If you&#8217;re running a business and people are depending on you for their livelihoods, you have to make the decisions. You have to do some hard things sometimes. And it&#8217;s never going to be comfortable. And at some point it&#8217;s going to look like you&#8217;re just another company. I&#8217;ve never been in this position, but I think it can be incredibly difficult to maintain a culture that we associate with the stereotype of WordPress community, in a full on company.</p>\n\n\n\n<p>[00:27:27] <strong>Nathan Wrigley:</strong> Yeah, I do know exactly what you mean. I think we, let&#8217;s say for example, let&#8217;s go back to Cisco. I used that example a minute ago. Let&#8217;s say that I work for Cisco. It&#8217;s pretty obvious what the goal there is. The goal is to ship loads of units of networking hardware all over the world, and then next year ship more than we ship this year and innovate more and.</p>\n\n\n\n<p>[00:27:45] <strong>Topher DeRosia:</strong> And you have investors that are going to hold your feet to the fire.</p>\n\n\n\n<p>[00:27:47] <strong>Nathan Wrigley:</strong> Right. Okay, so make money, make the investors happy, make the shareholders happy, and so on. That is so straightforward a bargain. But we in our community have this extra layer underpinning it of this philanthropic bit, which forms the basis of it. It&#8217;s literally the bedrock of it.</p>\n\n\n\n<p>And so that whole thing is propping everything else up on top of it, which I genuinely don&#8217;t know how the shifting sands of that all work. We&#8217;ve managed to get through 22 years plus, of that building up slowly over time, there being arguments here, there and everywhere. Minor arguments, some bigger arguments. We&#8217;ve somehow worked it through.</p>\n\n\n\n<p>But I don&#8217;t suppose that will ever get perfectly resolved. It&#8217;s going to be just part of the understanding that if you&#8217;re in open source, there&#8217;s a commercial bit. And if you can&#8217;t cope with that, well, that&#8217;s something you&#8217;re going to have to think about and look at. But also there&#8217;s going to be this whole philanthropic side, and that has to carry on and has to be funded, and figured out, and made important and advertised and all of that. I don&#8217;t have the brain to figure all that out, but it&#8217;s part of the jigsaw puzzle.</p>\n\n\n\n<p>[00:28:52] <strong>Topher DeRosia:</strong> Yeah. It&#8217;s truly something I&#8217;ve never had to deal with, and I hope I don&#8217;t, the scales of money. I had a job once when I was very young. We&#8217;re at home, we were newly married and money was tight, and we were talking about where to get $20 for groceries and things like that.</p>\n\n\n\n<p>And at work I was allocating hardware for new employees and, oh, let&#8217;s pick up two or three extra computers at $4,000 each because we might need them. That scale of money is, it&#8217;s something I&#8217;ve tried to be aware of.</p>\n\n\n\n<p>I look at a WordPress plugin company that has employees and I think, oh man, you have so much more money than I do, so much more. And maybe they do, but they also have so many more bills than I do. Just because they have several employees, and they&#8217;re doing well and things look great on Black Friday, doesn&#8217;t mean that they&#8217;re super wealthy or anything.</p>\n\n\n\n<p>[00:29:42] <strong>Nathan Wrigley:</strong> Yeah. I genuinely struggle with this component. I don&#8217;t think I&#8217;ll ever resolve it. I&#8217;m just aware that it exists. I&#8217;m aware that there&#8217;s people who are very polemic about it. There are people on the far this side, and there&#8217;s people on the opposite side who maybe are kind of struggling to shout across the gap. But then there&#8217;s people sitting in the middle who are somehow managing to figure it all out, or at least be sanguine about it, and not worrying too much about it. Time will tell. In the year 2026, I&#8217;m sure that it won&#8217;t get figured out, but it will probably carry on.</p>\n\n\n\n<p>I&#8217;ve got every hope that WordPress is exciting enough to carry on and that people will continue to use it. So I don&#8217;t worry too much about that. It&#8217;s just more whether or not the two sides of the argument, in an increasingly polemic world, whether the commercial side of WordPress and the non-commercial side of WordPress can figure out some way to walk upon the same path.</p>\n\n\n\n<p>[00:30:28] <strong>Topher DeRosia:</strong> There&#8217;s an element to WordPress that I think will carry on, even if it looks like WordPress is starting to fail. And that&#8217;s going to be the earliest people, the smallest contributors. Things have been really shaken up in WordPress in the last year or two, and I have friends who&#8217;ve left the community. And business is getting bigger and WordPress itself is changing. Gutenberg is a big thing now and AI is moving in and all that. So much is changing.</p>\n\n\n\n<p>And I have people say, why do you stay? Why do you keep doing WordPress? Specifically, why do I keep doing HeroPress? And I think my experience tells me that there will always be a 17-year-old picking up a computer at the library for the first time and discovering WordPress and starting a new life. And I want to be there for that person.</p>\n\n\n\n<p>[00:31:18] <strong>Nathan Wrigley:</strong> Yeah. So it&#8217;s going back to the 17-year-old you as well. You know, that bit that we had earlier where you figured out you had this intuition that there were some things in life which mattered more.</p>\n\n\n\n<p>One of the things that I think is really, like it&#8217;s so difficult to square this argument though, the whole thing where you see incredible wealth being generated by WordPress and you see incredible endeavors being put into WordPress by people who are really struggling to make ends meet. And I simply don&#8217;t have the capacity to figure out the solution to that. I cannot square that circle. But that is such a bit of cognitive dissonance that so much wealth is generated, on the one hand, and yet so much of the foundational work is created by people who may be struggling to put food on the table and what have you. And that is really challenging.</p>\n\n\n\n<p>[00:32:12] <strong>Topher DeRosia:</strong> Yeah, it is challenging. I don&#8217;t think it&#8217;ll ever be solved. I think it&#8217;s a universal problem of humanity. But similar to other areas, I think WordPress does better than other communities. There have been a bunch of discussions in the past about inclusivity, diversity in the WordPress community. And even people who point out the problems and say, look, we messed up here, this is bad, we need to change it, will say WordPress is probably the best of the IT world. There are problems. It&#8217;s bad. There are things we need to change, but we&#8217;re way ahead.</p>\n\n\n\n<p>[00:32:47] <strong>Nathan Wrigley:</strong> Okay, so that&#8217;s a really, sorry to interrupt. I got really caught up in what you just said then. I wasn&#8217;t expecting that to hit me quite as hard as it did. That was really interesting. That sort of sanguine approach to it. It&#8217;s never going to be perfect. We&#8217;re probably going to have division and factional fighting, I&#8217;m going to do air quotes around the word fighting, but you know what I mean, like infighting and what have you. But we do all right. Given how it could be, it&#8217;s okay. These things are just a part of the evolution of it. It&#8217;s a journey, not a destination. Yeah, that was interesting.</p>\n\n\n\n<p>[00:33:18] <strong>Topher DeRosia:</strong> We do have to take care though to not rest on our laurels, as it were. To say, oh, you know what? It&#8217;s okay, we&#8217;re better than everybody else, and so we don&#8217;t need to work on it. As soon as we do that, then we will not be better than everybody else.</p>\n\n\n\n<p>[00:33:30] <strong>Nathan Wrigley:</strong> And it&#8217;s curious because I think the people that I end up talking to when I attend things like WordCamps have that intuition. I think some, on some innate level, they get the bit that you just said. They know that it&#8217;s not perfect. And they know that work needs to be done. And they&#8217;re there for that thing. They want to fight the good fight, and make it so that this platform is available to the 17-year-old that you just described, so that they can pick this stuff up and publish their own stuff online, and have their own voice, and create their own identity and all of that. And it&#8217;s, yeah, really interesting.</p>\n\n\n\n<p>I think I have one more question. So we were talking about the impact of you doing stuff in the open. You obviously did all of that stuff in the open. You did everything, you put everything online, you got HeroPress and all of that kind of stuff. Would you still advocate that in the year 2025, 2026? Do you still think that&#8217;s probably the best way forward?</p>\n\n\n\n<p>The reason I&#8217;m asking that is because we see so much out there in the world, beguiling stuff. TikTok, YouTube, all these people getting YouTube famous, making giant amounts of money and all of that kind stuff. They&#8217;re doing it kind of purposefully in order to gain wealth. So it&#8217;s less that philanthropic side.</p>\n\n\n\n<p>If you could replay your life, would you do that? Is there any part of you which thinks you&#8217;d go down that route of being the kind of influencer, or are you happy that your life would replay in, if you were the youngster that you were many, many years ago and you were now that youngster, would you still do it the same way, do you think?</p>\n\n\n\n<p>[00:35:00] <strong>Topher DeRosia:</strong> I think I would. A couple years ago I did a video tip of the week on HeroPress. It was a video on YouTube. And people would say to me, you know what? It&#8217;s good that you offer this free stuff. You should put something behind a paywall and make money off it. And I think, oh, you know, that&#8217;d be cool. I could make money and pay the bills. But then I think, anything I put behind a paywall is not going to be able to help a 17-year-old who&#8217;s making a dollar a week. And that&#8217;s where my heart is. And I struggle.</p>\n\n\n\n<p>I&#8217;m doing a project right now that I would love to tell you about. Over the years, I&#8217;ve done support a lot. And I, early on, made a rule, if I get asked a question more than three times, I&#8217;m making documentation. And so I can just say, oh, here, go check this out. And over the years I&#8217;ve had many clients come back to me three months after I built a site and say, you know, you taught me how to use the WordPress admin and I don&#8217;t remember, can you show me again?</p>\n\n\n\n<p>So, I don&#8217;t know, a year ago I thought, I&#8217;m going to make a course for beginners, and it&#8217;s going to have videos that are one minute long about how to make a link, how to put in a picture, how to edit your form. Stuff that we all take for granted every day. But somebody who just got a website three months ago and used it once, they don&#8217;t remember.</p>\n\n\n\n<p>So I started down that road. I got MemberPress, I set up a site, and I made a list of videos to make. I was going to sell it to my clients as part of, you know, you bought a website, for an extra X dollars, here&#8217;s all this documentation you can have. A WordPresser at that educational conference said to me, I want to sponsor you to make those videos. You pick the topic, but do it on our hosting platform, just so that our name is there.</p>\n\n\n\n<p>And she gave me some money to do it. And she said, I want you to put them on your own YouTube channel. I didn&#8217;t have one. All these years, I didn&#8217;t have my own YouTube channel for my own videos. I want you to put them on your own YouTube channel, and once you get 2000 subscribers, I will pay you for every video you make. Just to put them on my own YouTube channel. I get to pick the topics. It&#8217;s just to get their name out. And I thought, wow, okay.</p>\n\n\n\n<p>So I pivoted, rather than make a course behind a paywall, I am doing this thing, but they&#8217;re all going on YouTube. And I started three weeks ago, and I&#8217;m putting up a video Monday, Wednesday, Friday, and I have 57 subscribers.</p>\n\n\n\n<p>[00:37:19] <strong>Nathan Wrigley:</strong> There&#8217;s a little road to go. That&#8217;s so nice.</p>\n\n\n\n<p>[00:37:23] <strong>Topher DeRosia:</strong> But this goes back to doing stuff in public so that it&#8217;s more significant later. Maybe in a year or two or five, I&#8217;ll have thousands of subscribers. And life experience has shown me that I need to not assume that I&#8217;m going to have thousands of subscribers within a month. That&#8217;s not how this works. You do stuff now, you build your foundation and you grow it. And eventually it gets big.</p>\n\n\n\n<p>HeroPress happened that way. You know, I did a few essays, and I did a few more and I did a few more. And then one day I thought, oh, I have 200 essays, and now I have 300. I never set a goal of how many or anything like that. I just did one at a time, and then suddenly there&#8217;s this big site full of stuff.</p>\n\n\n\n<p>And so that&#8217;s my current project is to make these videos, helping people figure out how to use WordPress. It&#8217;s not going to be just the beginners, it&#8217;s going to be, well, have a heart for beginners in any area, so I&#8217;m going to do some beginning programming stuff. I&#8217;ve built some cool stuff like WP Podcasts, aggregates podcasts. It wasn&#8217;t hard. It&#8217;s WP All Import, pulling them into the posts type. It&#8217;s not that big a deal. But I can make a 10 minute video on how I did that, and some developer&#8217;s going to go, wow, I never realised you can do this kind of stuff. So I&#8217;m pretty excited about it.</p>\n\n\n\n<p>[00:38:40] <strong>Nathan Wrigley:</strong> Yeah, your life seems to represent that kind of long term approach, and I can completely empathise with that. Obviously my thing is podcasting, and I have the same sort of story that I just began it and kept doing it and kept doing it, and people obviously, you know, found that there was something there for them, or they didn&#8217;t.</p>\n\n\n\n<p>But there was something that kept that propelled. And now I look back and there&#8217;s a few episodes that I can look back to and, it&#8217;s pretty amazing what that brought in its train. Most of it completely unexpected, most of it never intended, and now podcasting in the WordPress space is kind of what I do.</p>\n\n\n\n<p>And it just goes to show, if you do things with the right intention, and you do things for the long game, there is a way to make it work. You know, obviously you&#8217;ve got to keep the wolf from the door, and if you live in a part of the world where it&#8217;s incredibly important that you earn lots of money in order to just meet the bare essentials, then you&#8217;ve obviously got to take care of that at the beginning. But then after that, there&#8217;s these opportunities on top of that to sort of grow who you are, grow the community that we&#8217;re in. And maybe in the long term, over 2, 3, 5, 10, in your case, probably approaching 20 years in the WordPress space, it has an impact. It&#8217;s slowly but surely. Slow and steady wins the game, as they say.</p>\n\n\n\n<p>[00:39:57] <strong>Topher DeRosia:</strong> It does, yep.</p>\n\n\n\n<p>[00:39:58] <strong>Nathan Wrigley:</strong> In which case, I will say thank you for that conversation. It was very unexpected and really, really powerful in some regard there. You really made me think on a couple of occasions as we were chatting there, and I really appreciate that.</p>\n\n\n\n<p>So, Topher, where can we find you if somebody wants to see some of the stuff? You&#8217;ve already mentioned one. It&#8217;s probably topher.how. I don&#8217;t know if that&#8217;s the one you want to drop again.</p>\n\n\n\n<p>[00:40:17] <strong>Topher DeRosia:</strong> Yeah, let&#8217;s say topher.how. But if you search Google for Topher1Kenobi, you&#8217;ll find me pretty much everywhere.</p>\n\n\n\n<p>[00:40:24] <strong>Nathan Wrigley:</strong> Love that.</p>\n\n\n\n<p>[00:40:25] <strong>Topher DeRosia:</strong> I&#8217;ve never found anyone else use that name.</p>\n\n\n\n<p>[00:40:26] <strong>Nathan Wrigley:</strong> And it&#8217;s the number one, like the numeral one.</p>\n\n\n\n<p>[00:40:29] <strong>Topher DeRosia:</strong> Yeah.</p>\n\n\n\n<p>[00:40:30] <strong>Nathan Wrigley:</strong> Not the wan.</p>\n\n\n\n<p>[00:40:31] <strong>Topher DeRosia:</strong> My personal blog is at topher1kenobi.com. There&#8217;s HeroPress. I did an episode the other day with Christos Paloukas, and he said, hey, send me your links.</p>\n\n\n\n<p>[00:40:40] <strong>Nathan Wrigley:</strong> An essay.</p>\n\n\n\n<p>[00:40:40] <strong>Topher DeRosia:</strong> I sent him 15 links.</p>\n\n\n\n<p>[00:40:44] <strong>Nathan Wrigley:</strong> Do that to me as well. Whatever you do send me, then I will put them into the show notes. wptavern.com, search for the episode with Topher. It&#8217;s T-O-P-H-E-R. If you just look for that, you&#8217;ll probably find it. And thank you so much for chatting to me today. It was very pleasurable. Thank you.</p>\n\n\n\n<p>[00:40:59] <strong>Topher DeRosia:</strong> Yeah, I had a really good time too. Thanks.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href="https://topher.how">Topher DeRosia</a>.</p>\n\n\n\n<p>Topher is a web developer with over 30 years of experience, and he’s been deeply involved in the WordPress community for the past 15 years. He’s attended nearly 80 WordCamps around the world, contributed to projects like HeroPress, and has made it his mission to highlight the power and value of open source and remote work, especially in the WordPress ecosystem.</p>\n\n\n\n<p>In this episode, Topher joins me to talk about the value of working in public, and how sharing your work openly can create unexpected and lasting opportunities, whether that’s boosting your career, finding a sense of purpose, or building connections across the globe.</p>\n\n\n\n<p>We start with Topher’s personal journey, discovering the WordPress community and the profound impact it had on his life and family. The conversation explores what makes open source communities, like WordPress, so unique, and why working transparently can lead to moments of serendipity, and even job offers from people who have seen your contributions many years before.</p>\n\n\n\n<p>Topher shares stories about giving back, the motivation that comes from helping others, and the long-term satisfaction that comes from being generous with your time and expertise.</p>\n\n\n\n<p>We also discuss the tension between the philanthropic and commercial aspects of WordPress, and how individuals and companies navigate that balance.</p>\n\n\n\n<p>Towards the end, Topher reflects on building a body of work over time, trusting in the slow and organic process instead of seeking instant ‘influencer’ success. He explains why he still chooses to create and share resources for free, motivated by the hope of helping the next person just starting out.</p>\n\n\n\n<p>If you’ve ever wondered about the power of sharing your work, finding meaning in open communities, or how to make a difference over the long term, this episode is for you.</p>\n\n\n\n<h2 class="wp-block-heading">Useful links</h2>\n\n\n\n<p><a href="https://topher.how">Topher.How</a></p>\n\n\n\n<p><a href="https://mediaforge.pro">Media Forge Productions</a></p>\n\n\n\n<p><a href="https://heropress.com">HeroPress</a></p>\n\n\n\n<p><a href="https://heropress.com">Hallway Chats</a></p>\n\n\n\n<p><a href="https://heropress.com">WP Photos Info</a></p>\n\n\n\n<p><a href="https://wp-wallpaper.com">WP Wallpaper</a></p>\n\n\n\n<p><a href="https://topher1kenobe.com">topher1kenobe.com</a></p>\n\n\n\n<p><a href="https://www.youtube.com/@topher1kenobe">YouTube</a></p>\n\n\n\n<p><a href="https://www.linkedin.com/in/topher1kenobe/">LinkedIn</a></p>\n\n\n\n<p><a href="https://fosstodon.org/@topher1kenobe">Mastodon</a></p>\n\n\n\n<p><a href="https://bsky.app/profile/topher1kenobe.bsky.social">Bluesky</a></p>\n\n\n\n<p><a href="https://www.facebook.com/topher1kenobe">Facebook</a></p>\n\n\n\n<p><a href="https://www.last.fm/user/topher1kenobe">Last.fm</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 15:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Nathan Wrigley";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:31;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:118:"Open Channels FM: Empowering WordPress Accessibility with Community, Practical Tools, Education, and Real-World Impact";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=112396";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:122:"https://openchannels.fm/empowering-wordpress-accessibility-with-community-practical-tools-education-and-real-world-impact/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"In this episode, host Anne Bovelett sits down with Troy Chaplin, a well-known figure in the WordPress community and an advocate for web accessibility. Together, they dive into the importance of accessibility in web development, sharing personal stories about what sparked their passion for the topic and how it has influenced their careers. You’ll hear [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 10:12:39 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:32;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Matt: State of the Word";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150742";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:42:"https://ma.tt/2025/12/state-of-the-word-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:461:"<p>Though the stream didn&#8217;t work as we hoped, the recording of this year&#8217;s <a href="https://wordpress.org/state-of-the-word/">State of the Word</a>, which in many ways was our best one yet, <a href="https://www.youtube.com/watch?v=U_DF4-23C8Q">is up now</a>.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 07:54:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:33;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:44:"WordPress.org blog: WordPress 6.9 “Gene”";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19398";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/news/2025/12/gene/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:76854:"<figure class="wp-block-image size-large"><img alt="WordPress 6.9 Release Edition Featured Image" class="wp-image-19404" height="535" src="https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1" width="1024" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris. </p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class="wp-block-heading">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href="https://wordpress.org/wordpress-6.9.zip">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class="wp-block-heading">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class="wp-block-image size-full"><img alt="View of people interacting with notes in a post." class="wp-image-19428" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1" width="1360" /></figure>\n\n\n\n<h2 class="wp-block-heading">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class="wp-block-image size-full"><img alt="Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts." class="wp-image-19430" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1" width="1360" /></figure>\n\n\n\n<h2 class="wp-block-heading">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class="wp-block-image size-full"><img alt="&quot;Novem&quot; text selected and stretching across the interface." class="wp-image-19431" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1" width="1360" /></figure>\n\n\n\n<h2 class="wp-block-heading">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Abstract view of circles around a plugin icon with sparkles, indicating AI functionality." class="wp-image-19432" height="632" src="https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1" width="1024" /></figure>\n\n\n\n<h2 class="wp-block-heading">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class="wp-block-heading">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class="wp-block-heading">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href="https://wordpress.org/download/releases/6-9">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class="wp-block-heading">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href="https://learn.wordpress.org/">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href="https://learn.wordpress.org/social-learning/">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href="https://wordpress.org/documentation/wordpress-version/version-6.9">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href="https://make.wordpress.org/core/wordpress-6-9-field-guide/">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class="wp-block-heading">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class="wp-block-list">\n<li>Release Lead: <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a>, <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a>, <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a>, <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a>, <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href="https://wordpress.org/about/">democratize publishing</a> and embody the <a href="https://opensource.org/osd-annotated">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class="has-small-font-size"><a href="https://profiles.wordpress.org/o-o/">2046</a> · <a href="https://profiles.wordpress.org/aakashverma1/">Aakash Verma</a> · <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a> · <a href="https://profiles.wordpress.org/aaronrobertshaw/">Aaron Robertshaw</a> · <a href="https://profiles.wordpress.org/aarti1318/">Aarti Chauhan</a> · <a href="https://profiles.wordpress.org/thehercules/">Aashish Sharma</a> · <a href="https://profiles.wordpress.org/aatospaja/">aatospaja</a> · <a href="https://profiles.wordpress.org/abduremon/">Abdur Rahman Emon</a> · <a href="https://profiles.wordpress.org/hurayraiit/">Abu Hurayra</a> · <a href="https://profiles.wordpress.org/kawauso/">Adam Harley (Kawauso)</a> · <a href="https://profiles.wordpress.org/adamsilverstein/">Adam Silverstein</a> · <a href="https://profiles.wordpress.org/zieladam/">Adam Zieliński</a> · <a href="https://profiles.wordpress.org/adityab98/">Aditya Bansode</a> · <a href="https://profiles.wordpress.org/b1ink0/">Aditya Dhade</a> · <a href="https://profiles.wordpress.org/adityashah2411/">aditya shah</a> · <a href="https://profiles.wordpress.org/iamadisingh/">Aditya Singh</a> · <a href="https://profiles.wordpress.org/aduth/">aduth</a> · <a href="https://profiles.wordpress.org/agulbra/">agulbra</a> · <a href="https://profiles.wordpress.org/elazzabi/">Ahmed</a> · <a href="https://profiles.wordpress.org/chaion07/">Ahmed Kabir Chaion</a> · <a href="https://profiles.wordpress.org/ajaxstardust/">ajaxStardust</a> · <a href="https://profiles.wordpress.org/ajitbohra/">Ajit Bohra</a> · <a href="https://profiles.wordpress.org/akanshusingh/">Akanshu Singh</a> · <a href="https://profiles.wordpress.org/akeda/">Akeda Bagus</a> · <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a> · <a href="https://profiles.wordpress.org/atachibana/">Akira Tachibana</a> · <a href="https://profiles.wordpress.org/wpfy/">Akramul Hasan</a> · <a href="https://profiles.wordpress.org/akshat2802/">Akshat Kakkad</a> · <a href="https://profiles.wordpress.org/akshaydhere/">Akshay Dhere</a> · <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a> · <a href="https://profiles.wordpress.org/aljullu/">Albert Juh&#233; Lluveras</a> · <a href="https://profiles.wordpress.org/alejandrogonzalvo/">alejandrogonzalvo</a> · <a href="https://profiles.wordpress.org/alexcu21/">Alex Cuadra</a> · <a href="https://profiles.wordpress.org/ajlende/">Alex Lende</a> · <a href="https://profiles.wordpress.org/alexclassroom/">Alex Lion (阿力獅)</a> · <a href="https://profiles.wordpress.org/alexstine/">Alex Stine</a> · <a href="https://profiles.wordpress.org/alexandrebuffet/">Alexandre Buffet</a> · <a href="https://profiles.wordpress.org/alexus450/">Alexei Samarschi</a> · <a href="https://profiles.wordpress.org/alexius08/">Alexis Pandaan</a> · <a href="https://profiles.wordpress.org/alordiel/">alordiel</a> · <a href="https://profiles.wordpress.org/mrfoxtalbot/">Alvaro G&#243;mez</a> · <a href="https://profiles.wordpress.org/alh0319/">Amber Hinds</a> · <a href="https://profiles.wordpress.org/amin7/">Amin</a> · <a href="https://profiles.wordpress.org/theaminuldev/">Aminul Islam</a> · <a href="https://profiles.wordpress.org/aialvi/">Aminul Islam Alvi</a> · <a href="https://profiles.wordpress.org/amitbhosale/">Amit Bhosale</a> · <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a> · <a href="https://profiles.wordpress.org/anatolbroder/">Anatol Broder</a> · <a href="https://profiles.wordpress.org/anlino/">Anders Nor&#233;n</a> · <a href="https://profiles.wordpress.org/afercia/">Andrea Fercia</a> · <a href="https://profiles.wordpress.org/awetz583/">Andrea Roenning</a> · <a href="https://profiles.wordpress.org/andraganescu/">Andrei Draganescu</a> · <a href="https://profiles.wordpress.org/andrewhoyer/">Andrew Hoyer</a> · <a href="https://profiles.wordpress.org/nacin/">Andrew Nacin</a> · <a href="https://profiles.wordpress.org/azaozz/">Andrew Ozz</a> · <a href="https://profiles.wordpress.org/andrewserong/">Andrew Serong</a> · <a href="https://profiles.wordpress.org/oandregal/">André Maneiro</a> · <a href="https://profiles.wordpress.org/afragen/">Andy Fragen</a> · <a href="https://profiles.wordpress.org/mymothersdaughter/">Anita C</a> · <a href="https://profiles.wordpress.org/ankit-k-gupta/">Ankit K Gupta</a> · <a href="https://profiles.wordpress.org/ankitkumarshah/">Ankit Kumar Shah</a> · <a href="https://profiles.wordpress.org/ankitmaru/">Ankit Panchal</a> · <a href="https://profiles.wordpress.org/annezazu/">Anne McCarthy</a> · <a href="https://profiles.wordpress.org/annebovelett/">Anne-Mieke Bovelett</a> · <a href="https://profiles.wordpress.org/antonvlasenko/">Anton Vlasenko</a> · <a href="https://profiles.wordpress.org/antoniosejas/">Antonio Sejas</a> · <a href="https://profiles.wordpress.org/anujrathore24/">Anuj Singh</a> · <a href="https://profiles.wordpress.org/anveshika/">Anveshika Srivastava</a> · <a href="https://profiles.wordpress.org/apmeyer/">apmeyer</a> · <a href="https://profiles.wordpress.org/aristath/">Ari Stathopoulos</a> · <a href="https://profiles.wordpress.org/fliespl/">Arkadiusz Rzadkowolski</a> · <a href="https://profiles.wordpress.org/armandovias/">Armando</a> · <a href="https://profiles.wordpress.org/artemiosans/">Artemio Morales</a> · <a href="https://profiles.wordpress.org/arthur791004/">Arthur Chu</a> · <a href="https://profiles.wordpress.org/artpi/">Artur Piszek</a> · <a href="https://profiles.wordpress.org/artz91/">ArtZ91</a> · <a href="https://profiles.wordpress.org/asafm7/">asafm7</a> · <a href="https://profiles.wordpress.org/asdofindia/">asdofindia</a> · <a href="https://profiles.wordpress.org/ashfame/">Ashish Kumar (Ashfame)</a> · <a href="https://profiles.wordpress.org/akashdev/">Ashraful Haque Akash</a> · <a href="https://profiles.wordpress.org/askapache/">askapache</a> · <a href="https://profiles.wordpress.org/aslamdoctor/">Aslam Doctor</a> · <a href="https://profiles.wordpress.org/aurooba/">Aurooba Ahmed</a> · <a href="https://profiles.wordpress.org/aut0poietic/">aut0poietic</a> · <a href="https://profiles.wordpress.org/aksl95/">Axel DUCORON</a> · <a href="https://profiles.wordpress.org/ayeshrajans/">Ayesh Karunaratne</a> · <a href="https://profiles.wordpress.org/azharderaiya/">Azhar Deraiya</a> · <a href="https://profiles.wordpress.org/beryldlg/">B&#233;ryl de La Grandi&#232;re</a> · <a href="https://profiles.wordpress.org/bartnv/">bartnv</a> · <a href="https://profiles.wordpress.org/bchecketts/">bchecketts</a> · <a href="https://profiles.wordpress.org/beee/">Beee</a> · <a href="https://profiles.wordpress.org/scruffian/">Ben Dwyer</a> · <a href="https://profiles.wordpress.org/benazeer/">Benazeer</a> · <a href="https://profiles.wordpress.org/rainbowgeek/">Benjamin Denis</a> · <a href="https://profiles.wordpress.org/benjamin_zekavica/">Benjamin Zekavica</a> · <a href="https://profiles.wordpress.org/bvl/">Benny</a> · <a href="https://profiles.wordpress.org/benoitchantre/">Benoit Chantre</a> · <a href="https://profiles.wordpress.org/kau-boy/">Bernhard Kau</a> · <a href="https://profiles.wordpress.org/bernhard reiter/">Bernhard Reiter</a> · <a href="https://profiles.wordpress.org/bernhard-reiter/">bernhard-reiter</a> · <a href="https://profiles.wordpress.org/bgermann/">bgermann</a> · <a href="https://profiles.wordpress.org/bhattaganesh/">bhattaganesh</a> · <a href="https://profiles.wordpress.org/bhaveshdesai/">Bhavesh Desai</a> · <a href="https://profiles.wordpress.org/bidbmak/">BiDbMAK</a> · <a href="https://profiles.wordpress.org/mbigul/">Bigul Malayi</a> · <a href="https://profiles.wordpress.org/birgire/">Birgir Erlendsson (birgire)</a> · <a href="https://profiles.wordpress.org/bph/">Birgit Pauli-Haack</a> · <a href="https://profiles.wordpress.org/rainynewt/">Bishal Shrestha</a> · <a href="https://profiles.wordpress.org/bobbyleenoblestudios/">bobbyleenoblestudios</a> · <a href="https://profiles.wordpress.org/bogdanungureanu/">BogdanUngureanu</a> · <a href="https://profiles.wordpress.org/gitlost/">bonger</a> · <a href="https://profiles.wordpress.org/bor0/">Boro Sitnikovski</a> · <a href="https://profiles.wordpress.org/burlesonbrad/">Brad Griffin</a> · <a href="https://profiles.wordpress.org/bradley2083/">brad hogan</a> · <a href="https://profiles.wordpress.org/bjorsch/">Brad Jorsch</a> · <a href="https://profiles.wordpress.org/bradshawtm/">bradshawtm</a> · <a href="https://profiles.wordpress.org/bhubbard/">Brandon Hubbard</a> · <a href="https://profiles.wordpress.org/kraftbj/">Brandon Kraft</a> · <a href="https://profiles.wordpress.org/heybran/">Brandon Zhang</a> · <a href="https://profiles.wordpress.org/bgoewert/">Brennan Goewert</a> · <a href="https://profiles.wordpress.org/brhodes/">brhodes</a> · <a href="https://profiles.wordpress.org/ironprogrammer/">Brian Alexander</a> · <a href="https://profiles.wordpress.org/bacoords/">Brian Coords</a> · <a href="https://profiles.wordpress.org/bgardner/">Brian Gardner</a> · <a href="https://profiles.wordpress.org/masteradhoc/">Brian Haas</a> · <a href="https://profiles.wordpress.org/brumack/">brumack</a> · <a href="https://profiles.wordpress.org/bschneidewind/">Bryan Schneidewind</a> · <a href="https://profiles.wordpress.org/bshuchter/">bshuchter</a> · <a href="https://profiles.wordpress.org/burnuser/">burnuser</a> · <a href="https://profiles.wordpress.org/byteninjaa0/">byteninjaa0</a> · <a href="https://profiles.wordpress.org/cedche99/">C&#233;dric Chevillard</a> · <a href="https://profiles.wordpress.org/callumbw95/">Callum Bridgford-Whittick</a> · <a href="https://profiles.wordpress.org/snicco/">Calvin Alkan</a> · <a href="https://profiles.wordpress.org/karl94/">Carlo Cannas</a> · <a href="https://profiles.wordpress.org/cbravobernal/">Carlos Bravo</a> · <a href="https://profiles.wordpress.org/carlosgprim/">Carlos G. P.</a> · <a href="https://profiles.wordpress.org/carlsteffen/">CarlSteffen</a> · <a href="https://profiles.wordpress.org/poena/">Carolina Nymark</a> · <a href="https://profiles.wordpress.org/corazondejaguar/">Carolina Romo</a> · <a href="https://profiles.wordpress.org/ciobanucatalin/">Catalin Ciobanu</a> · <a href="https://profiles.wordpress.org/catgofire/">catgofire</a> · <a href="https://profiles.wordpress.org/cbirdsong/">cbirdsong</a> · <a href="https://profiles.wordpress.org/ccharel/">ccharel</a> · <a href="https://profiles.wordpress.org/cbutlerjr/">Chad Butler</a> · <a href="https://profiles.wordpress.org/shireling/">Chad Chadbourne</a> · <a href="https://profiles.wordpress.org/cherrygot/">Chakrapani Gautam</a> · <a href="https://profiles.wordpress.org/chihsuan/">Chi-Hsuan Huang</a> · <a href="https://profiles.wordpress.org/chillifish/">Chillifish</a> · <a href="https://profiles.wordpress.org/chloed/">ChloeD</a> · <a href="https://profiles.wordpress.org/chouby/">Chouby</a> · <a href="https://profiles.wordpress.org/czarate/">Chris Zarate</a> · <a href="https://profiles.wordpress.org/chriscct7/">chriscct7</a> · <a href="https://profiles.wordpress.org/chrisdotdotdot/">chrisdotdotdot</a> · <a href="https://profiles.wordpress.org/chrismattix/">chrismattix</a> · <a href="https://profiles.wordpress.org/christinecooper/">christinecooper</a> · <a href="https://profiles.wordpress.org/apermo/">Christoph Daum</a> · <a href="https://profiles.wordpress.org/nyiriland/">Christy Nyiri</a> · <a href="https://profiles.wordpress.org/cikrimcin/">cikrimcin</a> · <a href="https://profiles.wordpress.org/butterflymedia/">Ciprian Popescu</a> · <a href="https://profiles.wordpress.org/chrisvendiadvertisingcom/">cjhaas</a> · <a href="https://profiles.wordpress.org/ckoerner/">ckoerner</a> · <a href="https://profiles.wordpress.org/claimableperch/">claimableperch</a> · <a href="https://profiles.wordpress.org/codeamp/">Code Amp</a> · <a href="https://profiles.wordpress.org/codebuddy/">codebuddy</a> · <a href="https://profiles.wordpress.org/coleatkinson1/">coleatkinson1</a> · <a href="https://profiles.wordpress.org/costdev/">Colin Stewart</a> · <a href="https://profiles.wordpress.org/colind/">ColinD</a> · <a href="https://profiles.wordpress.org/ogrecooper/">Cooper Dalrymple</a> · <a href="https://profiles.wordpress.org/coralietixeront/">Coralie Tixeront</a> · <a href="https://profiles.wordpress.org/salzano/">Corey Salzano</a> · <a href="https://profiles.wordpress.org/coreyw/">Corey Worrell</a> · <a href="https://profiles.wordpress.org/cornwell/">Cornwell</a> · <a href="https://profiles.wordpress.org/cr0ybot/">Cory Hughart</a> · <a href="https://profiles.wordpress.org/courane01/">Courtney Robertson</a> · <a href="https://profiles.wordpress.org/cucocreative/">cucocreative</a> · <a href="https://profiles.wordpress.org/cwhitmore/">Cullen Whitmore</a> · <a href="https://profiles.wordpress.org/cyrille37/">Cyrille37</a> · <a href="https://profiles.wordpress.org/daanvandenbergh/">Daan van den Bergh</a> · <a href="https://profiles.wordpress.org/acketon/">Dakota Chichester</a> · <a href="https://profiles.wordpress.org/damchtlv/">damchtlv</a> · <a href="https://profiles.wordpress.org/damir-webthemer/">Damir</a> · <a href="https://profiles.wordpress.org/colorful-tones/">Damon Cook</a> · <a href="https://profiles.wordpress.org/dancameron/">Dan Cameron</a> · <a href="https://profiles.wordpress.org/danielpw/">Dan Waldschmidt</a> · <a href="https://profiles.wordpress.org/danielbachhuber/">Daniel Bachhuber</a> · <a href="https://profiles.wordpress.org/danieliser/">Daniel Iser</a> · <a href="https://profiles.wordpress.org/talldanwp/">Daniel Richards</a> · <a href="https://profiles.wordpress.org/mte90/">Daniele Scasciafratte</a> · <a href="https://profiles.wordpress.org/daniellacatus/">daniellacatus</a> · <a href="https://profiles.wordpress.org/danielmorell/">danielmorell</a> · <a href="https://profiles.wordpress.org/dscqbus/">Danny Schmarsel</a> · <a href="https://profiles.wordpress.org/dannyreaktiv/">dannyreaktiv</a> · <a href="https://profiles.wordpress.org/nerrad/">Darren Ethier (nerrad)</a> · <a href="https://profiles.wordpress.org/darshitrajyaguru97/">Darshit Rajyaguru</a> · <a href="https://profiles.wordpress.org/dryanpress/">Dave Ryan</a> · <a href="https://profiles.wordpress.org/daveguitaruno/">daveguitaruno</a> · <a href="https://profiles.wordpress.org/davilera/">David Aguilera</a> · <a href="https://profiles.wordpress.org/darerodz/">David Arenas</a> · <a href="https://profiles.wordpress.org/dartiss/">David Artiss</a> · <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a> · <a href="https://profiles.wordpress.org/dpcalhoun/">David Calhoun</a> · <a href="https://profiles.wordpress.org/dlh/">David Herrera</a> · <a href="https://profiles.wordpress.org/justlevine/">David Levine</a> · <a href="https://profiles.wordpress.org/davidperez/">David Perez</a> · <a href="https://profiles.wordpress.org/djivad/">David Riviera</a> · <a href="https://profiles.wordpress.org/get_dave/">David Smith</a> · <a href="https://profiles.wordpress.org/davidb/">DavidB</a> · <a href="https://profiles.wordpress.org/dawidadach/">dawidadach</a> · <a href="https://profiles.wordpress.org/dsas/">Dean Sas</a> · <a href="https://profiles.wordpress.org/dkarfa/">Debabrata Karfa</a> · <a href="https://profiles.wordpress.org/debarghyabanerjee/">DEBARGHYA BANERJEE</a> · <a href="https://profiles.wordpress.org/denis-de-bernardy/">Denis de Bernardy</a> · <a href="https://profiles.wordpress.org/dingo_d/">Denis Žoljom</a> · <a href="https://profiles.wordpress.org/realloc/">Dennis Ploetner</a> · <a href="https://profiles.wordpress.org/dmsnell/">Dennis Snell</a> · <a href="https://profiles.wordpress.org/dennysdionigi/">Dennys Dionigi</a> · <a href="https://profiles.wordpress.org/densinakum/">Densi Nakum</a> · <a href="https://profiles.wordpress.org/derekherman/">derekherman</a> · <a href="https://profiles.wordpress.org/devasheeshkaul/">Devasheesh Kaul</a> · <a href="https://profiles.wordpress.org/dhananjaykuber/">Dhananjay Kuber</a> · <a href="https://profiles.wordpress.org/dhrumilk/">Dhrumil Kumbhani</a> · <a href="https://profiles.wordpress.org/dhruval04/">Dhruval Shah</a> · <a href="https://profiles.wordpress.org/dhruvang21/">Dhruvang21</a> · <a href="https://profiles.wordpress.org/dhruvik18/">Dhruvik Malaviya</a> · <a href="https://profiles.wordpress.org/diebombe/">diebombe</a> · <a href="https://profiles.wordpress.org/dilipbheda/">Dilip Bheda</a> · <a href="https://profiles.wordpress.org/dilip2615/">Dilip Modhavadiya</a> · <a href="https://profiles.wordpress.org/dd32/">Dion Hulse</a> · <a href="https://profiles.wordpress.org/divinenephron/">divinenephron</a> · <a href="https://profiles.wordpress.org/djcowan/">dj.cowan</a> · <a href="https://profiles.wordpress.org/ocean90/">Dominik Schilling</a> · <a href="https://profiles.wordpress.org/dominiquepijnenburg/">dominiquepijnenburg</a> · <a href="https://profiles.wordpress.org/donalirl/">donalirl</a> · <a href="https://profiles.wordpress.org/doughamlin/">doughamlin</a> · <a href="https://profiles.wordpress.org/dougmelvin/">DougMelvin</a> · <a href="https://profiles.wordpress.org/drawcard/">drawcard</a> · <a href="https://profiles.wordpress.org/dretzlaff/">dretzlaff</a> · <a href="https://profiles.wordpress.org/drewapicture/">Drew Jaynes</a> · <a href="https://profiles.wordpress.org/drivingralle/">Drivingralle</a> · <a href="https://profiles.wordpress.org/dsawyers/">dsawyers</a> · <a href="https://profiles.wordpress.org/dustintechsmith/">dustintechsmith</a> · <a href="https://profiles.wordpress.org/eclev91/">eclev91</a> · <a href="https://profiles.wordpress.org/eduwass/">eduwass</a> · <a href="https://profiles.wordpress.org/ehti/">Ehti</a> · <a href="https://profiles.wordpress.org/elialum/">elialum</a> · <a href="https://profiles.wordpress.org/eliezerspp/">Eliezer Pe&#241;a</a> · <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a> · <a href="https://profiles.wordpress.org/elvismdev/">Elvis Morales</a> · <a href="https://profiles.wordpress.org/emaildano/">emaildano</a> · <a href="https://profiles.wordpress.org/codex-m/">Emerson Maningo</a> · <a href="https://profiles.wordpress.org/emlebrun/">Emilie LEBRUN</a> · <a href="https://profiles.wordpress.org/emranahmed/">Emran Ahmed</a> · <a href="https://profiles.wordpress.org/enaanfarhan/">Enaan Farhan</a> · <a href="https://profiles.wordpress.org/lopo/">Enrico Battocchi</a> · <a href="https://profiles.wordpress.org/nrqsnchz/">Enrique S&#225;nchez</a> · <a href="https://profiles.wordpress.org/epeicher/">epeicher</a> · <a href="https://profiles.wordpress.org/ekazda/">Eric</a> · <a href="https://profiles.wordpress.org/ericlewis/">Eric Andrew Lewis</a> · <a href="https://profiles.wordpress.org/ethitter/">Erick Hitter</a> · <a href="https://profiles.wordpress.org/kebbet/">Erik</a> · <a href="https://profiles.wordpress.org/ejoling/">Erik Joling</a> · <a href="https://profiles.wordpress.org/im3dabasia1/">Eshaan Dabasiya</a> · <a href="https://profiles.wordpress.org/ethanscorey/">ethanscorey</a> · <a href="https://profiles.wordpress.org/circlecube/">Evan Mullins</a> · <a href="https://profiles.wordpress.org/etobiesen/">Even Tobiesen</a> · <a href="https://profiles.wordpress.org/fabiankaegy/">Fabian Kägy</a> · <a href="https://profiles.wordpress.org/gaambo/">Fabian Todt</a> · <a href="https://profiles.wordpress.org/faisalahammad/">Faisal Ahammad</a> · <a href="https://profiles.wordpress.org/faisal03/">Faisal Alvi</a> · <a href="https://profiles.wordpress.org/fakhriaz/">fakhriaz</a> · <a href="https://profiles.wordpress.org/falgunihdesai/">Falguni Desai</a> · <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> · <a href="https://profiles.wordpress.org/ffffelix/">Felix Renicks</a> · <a href="https://profiles.wordpress.org/fellyph/">Fellyph Cintra</a> · <a href="https://profiles.wordpress.org/mista-flo/">Florian TIAR</a> · <a href="https://profiles.wordpress.org/frantorres/">Francisco Torres</a> · <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a> · <a href="https://profiles.wordpress.org/frogdesk/">FrogDesk Strategy</a> · <a href="https://profiles.wordpress.org/takahashi_fumiki/">Fumiki Takahashi</a> · <a href="https://profiles.wordpress.org/gaeldenysiak/">Gael Denysiak</a> · <a href="https://profiles.wordpress.org/gajendrasingh/">Gajendra Singh</a> · <a href="https://profiles.wordpress.org/ecgan/">Gan Eng Chin</a> · <a href="https://profiles.wordpress.org/garrett-eclipse/">Garrett Hyder</a> · <a href="https://profiles.wordpress.org/garyj/">Gary Jones</a> · <a href="https://profiles.wordpress.org/pento/">Gary Pendergast</a> · <a href="https://profiles.wordpress.org/guddu1315/">Gaurang Dabhi</a> · <a href="https://profiles.wordpress.org/gautam23/">Gautam Mehta</a> · <a href="https://profiles.wordpress.org/soulseekah/">Gennady Kovshenin</a> · <a href="https://profiles.wordpress.org/mamaduka/">George Mamadashvili</a> · <a href="https://profiles.wordpress.org/georgestephanis/">George Stephanis</a> · <a href="https://profiles.wordpress.org/stoyanovgs/">Georgi Stoyanov</a> · <a href="https://profiles.wordpress.org/gernberg/">gernberg</a> · <a href="https://profiles.wordpress.org/giuliorubelli/">giuliorubelli</a> · <a href="https://profiles.wordpress.org/glendaviesnz/">Glen Davies</a> · <a href="https://profiles.wordpress.org/ingeniumed/">Gopal Krishnan</a> · <a href="https://profiles.wordpress.org/grantmkin/">Grant M. Kinney</a> · <a href="https://profiles.wordpress.org/gziolo/">Greg Ziółkowski</a> · <a href="https://profiles.wordpress.org/guido07111975/">Guido</a> · <a href="https://profiles.wordpress.org/wido/">Guido Scialfa</a> · <a href="https://profiles.wordpress.org/guillaumeturpin/">Guillaume TURPIN</a> · <a href="https://profiles.wordpress.org/gulamdastgir04/">Gulamdastgir Momin</a> · <a href="https://profiles.wordpress.org/adrock42/">H. Adam Lenz</a> · <a href="https://profiles.wordpress.org/kabir93/">H. Kabir</a> · <a href="https://profiles.wordpress.org/hanimbarek/">hanimbarek</a> · <a href="https://profiles.wordpress.org/hanneslsm/">hanneslsm</a> · <a href="https://profiles.wordpress.org/hage/">Hans-Gerd Gerhards</a> · <a href="https://profiles.wordpress.org/hardik2221/">Hardik Raval</a> · <a href="https://profiles.wordpress.org/hareesh-pillai/">Hareesh S</a> · <a href="https://profiles.wordpress.org/harshgajipara/">Harsh Gajipara</a> · <a href="https://profiles.wordpress.org/harshalkadu/">Harshal Kadu</a> · <a href="https://profiles.wordpress.org/harshbhonsle08/">harshbhonsle08</a> · <a href="https://profiles.wordpress.org/harshdeepgill/">harshdeepgill</a> · <a href="https://profiles.wordpress.org/haruncpi/">Harun</a> · <a href="https://profiles.wordpress.org/helen/">Helen Hou-Sandi</a> · <a href="https://profiles.wordpress.org/helgatheviking/">HelgaTheViking</a> · <a href="https://profiles.wordpress.org/hideishi/">Hidenori ISHIKAWA</a> · <a href="https://profiles.wordpress.org/hilayt24/">Hilay Trivedi</a> · <a href="https://profiles.wordpress.org/panchalhimani711/">Himani Panchal</a> · <a href="https://profiles.wordpress.org/abcd95/">Himanshu Pathak</a> · <a href="https://profiles.wordpress.org/hiroshisato/">Hiroshi Sato</a> · <a href="https://profiles.wordpress.org/hbhalodia/">Hit Bhalodia</a> · <a href="https://profiles.wordpress.org/hitendra-chopda/">Hitendra Chopda</a> · <a href="https://profiles.wordpress.org/hiteshtalpada/">Hitesh Talpada</a> · <a href="https://profiles.wordpress.org/hozefasmile/">Hozefa Saleh</a> · <a href="https://profiles.wordpress.org/hrohh/">Hrohh</a> · <a href="https://profiles.wordpress.org/hugod/">hugod</a> · <a href="https://profiles.wordpress.org/hugosolar/">hugosolar</a> · <a href="https://profiles.wordpress.org/humanify/">humanify</a> · <a href="https://profiles.wordpress.org/huubl/">huubl</a> · <a href="https://profiles.wordpress.org/huzaifaalmesbah/">Huzaifa Al Mesbah</a> · <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a> · <a href="https://profiles.wordpress.org/iandunn/">Ian Dunn</a> · <a href="https://profiles.wordpress.org/ignatiusjeroe/">ignatiusjeroe</a> · <a href="https://profiles.wordpress.org/igorradovanov/">Igor Radovanov</a> · <a href="https://profiles.wordpress.org/ikriv/">ikriv</a> · <a href="https://profiles.wordpress.org/imokweb/">imokweb</a> · <a href="https://profiles.wordpress.org/imranhasanraaz/">Imran</a> · <a href="https://profiles.wordpress.org/indirabiswas27/">Indira Biswas</a> · <a href="https://profiles.wordpress.org/ipstenu/">Ipstenu (Mika Epstein)</a> · <a href="https://profiles.wordpress.org/iqbal1hossain/">Iqbal Hossain</a> · <a href="https://profiles.wordpress.org/isabel_brison/">Isabel Brison</a> · <a href="https://profiles.wordpress.org/ishikaatxecurify/">Ishika Bansal</a> · <a href="https://profiles.wordpress.org/ivanottinger/">Ivan Ottinger</a> · <a href="https://profiles.wordpress.org/jabe/">Jabe</a> · <a href="https://profiles.wordpress.org/jacobcassidy/">Jacob Cassidy</a> · <a href="https://profiles.wordpress.org/jagirbahesh/">Jagir Bahesh</a> · <a href="https://profiles.wordpress.org/jaiminp/">Jaimin Prajapati</a> · <a href="https://profiles.wordpress.org/jakariaistauk/">Jakaria Istauk</a> · <a href="https://profiles.wordpress.org/whyisjake/">Jake Spurlock</a> · <a href="https://profiles.wordpress.org/jakeparis/">jakeparis</a> · <a href="https://profiles.wordpress.org/jameskoster/">James Koster</a> · <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> · <a href="https://profiles.wordpress.org/jhmonroe/">James Monroe</a> · <a href="https://profiles.wordpress.org/q0rban/">James Sansbury</a> · <a href="https://profiles.wordpress.org/jamestitus299/">James Titus</a> · <a href="https://profiles.wordpress.org/codente/">Jamie</a> · <a href="https://profiles.wordpress.org/jamieburchell/">Jamie Burchell</a> · <a href="https://profiles.wordpress.org/jamesmarsland/">Jamie Marsland</a> · <a href="https://profiles.wordpress.org/janthiel/">janthiel</a> · <a href="https://profiles.wordpress.org/jsnajdr/">Jarda Snajdr</a> · <a href="https://profiles.wordpress.org/jarekmorawski/">jarekmorawski</a> · <a href="https://profiles.wordpress.org/jasalt/">Jarkko Saltiola</a> · <a href="https://profiles.wordpress.org/jason_the_adams/">Jason Adams</a> · <a href="https://profiles.wordpress.org/madtownlems/">Jason LeMahieu (MadtownLems)</a> · <a href="https://profiles.wordpress.org/jasonsa19/">Jason Sauerwald</a> · <a href="https://profiles.wordpress.org/javiercasares/">Javier Casares</a> · <a href="https://profiles.wordpress.org/jonmcpartland/">Jay McPartland</a> · <a href="https://profiles.wordpress.org/shovan_jaya/">Jayaram</a> · <a href="https://profiles.wordpress.org/jdahir0789/">Jaydip</a> · <a href="https://profiles.wordpress.org/audrasjb/">Jean-Baptiste Audras</a> · <a href="https://profiles.wordpress.org/krokodok/">Jeff Chi</a> · <a href="https://profiles.wordpress.org/jeffmatson/">Jeff Matson</a> · <a href="https://profiles.wordpress.org/jffng/">Jeff Ong</a> · <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> · <a href="https://profiles.wordpress.org/cheffheid/">Jeffrey de Wit</a> · <a href="https://profiles.wordpress.org/jeffr0/">Jeffro</a> · <a href="https://profiles.wordpress.org/jeflopodev/">jeflopo</a> · <a href="https://profiles.wordpress.org/jdy68/">Jenny Dupuy</a> · <a href="https://profiles.wordpress.org/jeremiahbratton/">Jeremiah Bratton</a> · <a href="https://profiles.wordpress.org/jeremyfelt/">Jeremy Felt</a> · <a href="https://profiles.wordpress.org/jkmassel/">Jeremy Massel</a> · <a href="https://profiles.wordpress.org/slimndap/">Jeroen Schmit</a> · <a href="https://profiles.wordpress.org/jeryj/">jeryj</a> · <a href="https://profiles.wordpress.org/jesin/">Jesin A</a> · <a href="https://profiles.wordpress.org/jessedyck/">jessedyck</a> · <a href="https://profiles.wordpress.org/luminuu/">Jessica Lyschik</a> · <a href="https://profiles.wordpress.org/jigar-bhanushali/">Jigar Bhanushali</a> · <a href="https://profiles.wordpress.org/jigar9998/">Jigar Panchal</a> · <a href="https://profiles.wordpress.org/jikamens/">jikamens</a> · <a href="https://profiles.wordpress.org/jnweaver/">jnweaver</a> · <a href="https://profiles.wordpress.org/jojo256/">Joan Namunina</a> · <a href="https://profiles.wordpress.org/jobata/">JoAnne Obata</a> · <a href="https://profiles.wordpress.org/jochent/">JochenT</a> · <a href="https://profiles.wordpress.org/jodamo5/">jodamo5</a> · <a href="https://profiles.wordpress.org/joedolson/">Joe Dolson</a> · <a href="https://profiles.wordpress.org/joehoyle/">Joe Hoyle</a> · <a href="https://profiles.wordpress.org/joemcgill/">Joe McGill</a> · <a href="https://profiles.wordpress.org/joen/">Joen Asmussen</a> · <a href="https://profiles.wordpress.org/timse201/">Johannes J&#252;lg</a> · <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a> · <a href="https://profiles.wordpress.org/brandbrilliance/">John Brand</a> · <a href="https://profiles.wordpress.org/johnny5/">John Godley</a> · <a href="https://profiles.wordpress.org/johnjamesjacoby/">John James Jacoby</a> · <a href="https://profiles.wordpress.org/mindctrl/">John Parris</a> · <a href="https://profiles.wordpress.org/johnregan3/">John Regan</a> · <a href="https://profiles.wordpress.org/johnvieth/">JohnVieth</a> · <a href="https://profiles.wordpress.org/jonsurrell/">Jon Surrell</a> · <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a> · <a href="https://profiles.wordpress.org/jrchamp/">Jonathan Champ</a> · <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a> · <a href="https://profiles.wordpress.org/n2erjo00/">Joni Erkkil&#228;</a> · <a href="https://profiles.wordpress.org/spacedmonkey/">Jonny Harris</a> · <a href="https://profiles.wordpress.org/jonoaldersonwp/">Jono Alderson</a> · <a href="https://profiles.wordpress.org/jordesign/">jordesign</a> · <a href="https://profiles.wordpress.org/jorgefilipecosta/">Jorge Costa</a> · <a href="https://profiles.wordpress.org/josvelasco/">Jos Velasco</a> · <a href="https://profiles.wordpress.org/josephscott/">Joseph Scott</a> · <a href="https://profiles.wordpress.org/jhabdas/">Josh Habdas</a> · <a href="https://profiles.wordpress.org/verygoode/">Joshua Goode</a> · <a href="https://profiles.wordpress.org/jrmd/">jrmd</a> · <a href="https://profiles.wordpress.org/juanfra/">Juan Aldasoro</a> · <a href="https://profiles.wordpress.org/juampick/">Juan Cook</a> · <a href="https://profiles.wordpress.org/juanmaguitar/">JuanMa Garrido</a> · <a href="https://profiles.wordpress.org/juliengardair/">juliengardair</a> · <a href="https://profiles.wordpress.org/jrf/">Juliette Reinders Folmer</a> · <a href="https://profiles.wordpress.org/justinahinon/">Justin Ahinon</a> · <a href="https://profiles.wordpress.org/greenshady/">Justin Tadlock</a> · <a href="https://profiles.wordpress.org/itsroy69/">Jyotirmoy Roy</a> · <a href="https://profiles.wordpress.org/kadamwhite/">K. Adam White</a> · <a href="https://profiles.wordpress.org/kevin940726/">Kai Hao</a> · <a href="https://profiles.wordpress.org/trepmal/">Kailey (trepmal)</a> · <a href="https://profiles.wordpress.org/kaitohm/">Kaito Hanamori</a> · <a href="https://profiles.wordpress.org/kakomap/">Kakoma</a> · <a href="https://profiles.wordpress.org/kalpeshh/">Kalpesh</a> · <a href="https://profiles.wordpress.org/karinchristen/">Karin Christen</a> · <a href="https://profiles.wordpress.org/karolmanijak/">Karol Manijak</a> · <a href="https://profiles.wordpress.org/karthickmurugan/">Karthick Murugan</a> · <a href="https://profiles.wordpress.org/karthikeya01/">Karthikeya Bethu</a> · <a href="https://profiles.wordpress.org/kasparsd/">Kaspars</a> · <a href="https://profiles.wordpress.org/codebykat/">Kat Hagan</a> · <a href="https://profiles.wordpress.org/katinthehatsite/">Kateryna K. a11n</a> · <a href="https://profiles.wordpress.org/zoonini/">Kathryn Presner</a> · <a href="https://profiles.wordpress.org/katrinadtl/">Katrina Massey</a> · <a href="https://profiles.wordpress.org/kausaralm/">Kausar Alam</a> · <a href="https://profiles.wordpress.org/khushdoms/">Kaushik Domadiya</a> · <a href="https://profiles.wordpress.org/onlykawshar/">Kawshar Ahmed</a> · <a href="https://profiles.wordpress.org/kaygee79/">kaygee79</a> · <a href="https://profiles.wordpress.org/mt8biz/">Kazuto Takeshita</a> · <a href="https://profiles.wordpress.org/ryelle/">Kelly Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/kellychoffman/">Kelly Hoffman</a> · <a href="https://profiles.wordpress.org/tinypixel/">Kelly Mears</a> · <a href="https://profiles.wordpress.org/kgagne/">Ken Gagne</a> · <a href="https://profiles.wordpress.org/kerfred/">Kerfred</a> · <a href="https://profiles.wordpress.org/gwwar/">Kerry Liu</a> · <a href="https://profiles.wordpress.org/kesselb/">kesselb</a> · <a href="https://profiles.wordpress.org/kevinlearynet/">Kevin Leary</a> · <a href="https://profiles.wordpress.org/khoipro/">Khoi Pro</a> · <a href="https://profiles.wordpress.org/khushipatel15/">Khushi Patel</a> · <a href="https://profiles.wordpress.org/killerbishop/">killerbishop</a> · <a href="https://profiles.wordpress.org/iamkingsleyf/">Kingsley Felix</a> · <a href="https://profiles.wordpress.org/kirasong/">Kira Schroder</a> · <a href="https://profiles.wordpress.org/kishanjasani/">Kishan Jasani</a> · <a href="https://profiles.wordpress.org/kitchin/">kitchin</a> · <a href="https://profiles.wordpress.org/kjellr/">Kjell Reigstad</a> · <a href="https://profiles.wordpress.org/kkmuffme/">kkmuffme</a> · <a href="https://profiles.wordpress.org/kleor/">Kleor</a> · <a href="https://profiles.wordpress.org/knutsp/">Knut Sparhell</a> · <a href="https://profiles.wordpress.org/obenland/">Konstantin Obenland</a> · <a href="https://profiles.wordpress.org/xkon/">Konstantinos Xenos</a> · <a href="https://profiles.wordpress.org/kpapazov/">kpapazov</a> · <a href="https://profiles.wordpress.org/kprocyszyn/">kprocyszyn</a> · <a href="https://profiles.wordpress.org/krishaamer/">krishaamer</a> · <a href="https://profiles.wordpress.org/krunal265/">Krunal Bhimajiyani</a> · <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a> · <a href="https://profiles.wordpress.org/kshaner/">kshaner</a> · <a href="https://profiles.wordpress.org/kub1x/">kub1x</a> · <a href="https://profiles.wordpress.org/kubiq/">kubiq</a> · <a href="https://profiles.wordpress.org/kunalpuri123/">kunalpuri123</a> · <a href="https://profiles.wordpress.org/kushsharma/">Kush Sharma</a> · <a href="https://profiles.wordpress.org/kush123/">Kushagra Goyal</a> · <a href="https://profiles.wordpress.org/lgadzhev/">Lachezar Gadzhev</a> · <a href="https://profiles.wordpress.org/lakrisgubben/">lakrisgubben</a> · <a href="https://profiles.wordpress.org/lakshyajeet/">Lakshyajeet Singh Goyal</a> · <a href="https://profiles.wordpress.org/lalitkumawat/">Lalit Kumawat</a> · <a href="https://profiles.wordpress.org/lancewillett/">Lance Willett</a> · <a href="https://profiles.wordpress.org/newyorkerlaura/">Laura Byrne</a> · <a href="https://profiles.wordpress.org/laurisaarni/">Lauri Saarni</a> · <a href="https://profiles.wordpress.org/ldanielgiuliani/">ldanielgiuliani</a> · <a href="https://profiles.wordpress.org/leewillis77/">Lee Willis</a> · <a href="https://profiles.wordpress.org/leedxw/">leedxw</a> · <a href="https://profiles.wordpress.org/leemon/">leemon</a> · <a href="https://profiles.wordpress.org/0mirka00/">Lena Morita</a> · <a href="https://profiles.wordpress.org/leonidasmilossis/">Leonidas Milosis</a> · <a href="https://profiles.wordpress.org/levinbaria/">Levin Baria</a> · <a href="https://profiles.wordpress.org/lgseo/">lgseo</a> · <a href="https://profiles.wordpress.org/lilgames/">LilGames</a> · <a href="https://profiles.wordpress.org/liviopv/">liviopv</a> · <a href="https://profiles.wordpress.org/logiclink/">logiclink</a> · <a href="https://profiles.wordpress.org/logicrays/">LogicRays Technologies</a> · <a href="https://profiles.wordpress.org/lordandy1984/">lordandy1984</a> · <a href="https://profiles.wordpress.org/lovor/">Lovro Hrust</a> · <a href="https://profiles.wordpress.org/lucasms/">Lucas Martins</a> · <a href="https://profiles.wordpress.org/gigitux/">Luigi Teschio</a> · <a href="https://profiles.wordpress.org/luisherranz/">luisherranz</a> · <a href="https://profiles.wordpress.org/lukasfritzedev/">LukasFritzeDev</a> · <a href="https://profiles.wordpress.org/wpfed/">Lukasz</a> · <a href="https://profiles.wordpress.org/lukecavanagh/">Luke Cavanagh</a> · <a href="https://profiles.wordpress.org/maccyd/">maccyd</a> · <a href="https://profiles.wordpress.org/madhavishah01/">Madhavi Shah</a> · <a href="https://profiles.wordpress.org/madhudollu/">Madhu Dollu</a> · <a href="https://profiles.wordpress.org/onemaggie/">Maggie Cabrera</a> · <a href="https://profiles.wordpress.org/maikuolan/">Maikuolan</a> · <a href="https://profiles.wordpress.org/manfcarlo/">manfcarlo</a> · <a href="https://profiles.wordpress.org/manhatthien98/">manhatthien98</a> · <a href="https://profiles.wordpress.org/sirlouen/">Manuel Camargo</a> · <a href="https://profiles.wordpress.org/manzoorwanijk/">Manzoor Wani</a> · <a href="https://profiles.wordpress.org/maorb/">maorb</a> · <a href="https://profiles.wordpress.org/mdxfr/">Marc</a> · <a href="https://profiles.wordpress.org/marc4/">Marc Armengou</a> · <a href="https://profiles.wordpress.org/pagelab/">Marcio Duarte</a> · <a href="https://profiles.wordpress.org/mciampini/">Marco Ciampini</a> · <a href="https://profiles.wordpress.org/leadclown/">Marcus</a> · <a href="https://profiles.wordpress.org/mkaz/">Marcus Kazmierczak</a> · <a href="https://profiles.wordpress.org/marian1/">marian1</a> · <a href="https://profiles.wordpress.org/plari/">Marie</a> · <a href="https://profiles.wordpress.org/tyxla/">Marin Atanasov</a> · <a href="https://profiles.wordpress.org/santosguillamot/">Mario Santos</a> · <a href="https://profiles.wordpress.org/mariohamann/">mariohamann</a> · <a href="https://profiles.wordpress.org/marius84/">mariushosting</a> · <a href="https://profiles.wordpress.org/bozzmedia/">Marty</a> · <a href="https://profiles.wordpress.org/martythornley/">MartyThornley</a> · <a href="https://profiles.wordpress.org/marybaum/">Mary Baum</a> · <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a> · <a href="https://profiles.wordpress.org/mat-lipe/">Mat Lipe</a> · <a href="https://profiles.wordpress.org/mathiscode/">mathiscode</a> · <a href="https://profiles.wordpress.org/mmaattiiaass/">Matias Benedetto</a> · <a href="https://profiles.wordpress.org/matveb/">Matias Ventura</a> · <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> · <a href="https://profiles.wordpress.org/mattyrob/">Matt Robinson</a> · <a href="https://profiles.wordpress.org/mattwest/">Matt West</a> · <a href="https://profiles.wordpress.org/matteoenna/">Matteo Enna</a> · <a href="https://profiles.wordpress.org/pfefferle/">Matthias Pfefferle</a> · <a href="https://profiles.wordpress.org/mattryanwalker/">mattryanwalker</a> · <a href="https://profiles.wordpress.org/maxschmeling/">Max Schmeling</a> · <a href="https://profiles.wordpress.org/maxpertici/">Maxime Pertici</a> · <a href="https://profiles.wordpress.org/mayanktripathi32/">Mayank Tripathi</a> · <a href="https://profiles.wordpress.org/mayur8991/">Mayur Prajapati</a> · <a href="https://profiles.wordpress.org/faithcoder/">Md Abdullah Al Arif</a> · <a href="https://profiles.wordpress.org/mabfahad/">Md Abdullah Al Fahad</a> · <a href="https://profiles.wordpress.org/hmbashar/">Md Abul Bashar</a> · <a href="https://profiles.wordpress.org/ismail0071/">MD ISMAIL</a> · <a href="https://profiles.wordpress.org/kawsar007/">MD Kawsar Chowdhury</a> · <a href="https://profiles.wordpress.org/masummollaalhaz/">Md Masum Molla Alhaz</a> · <a href="https://profiles.wordpress.org/obiplabon/">Md Obidullah (obiPlabon)</a> · <a href="https://profiles.wordpress.org/wprashed/">Md Rashed Hossain</a> · <a href="https://profiles.wordpress.org/sabbir20/">Md Sabbir Hossain</a> · <a href="https://profiles.wordpress.org/najmulsaju/">Md. Najmul Islam</a> · <a href="https://profiles.wordpress.org/mehedi_csit/">Md.Mehedi Hasan</a> · <a href="https://profiles.wordpress.org/mdmoreau/">mdmoreau</a> · <a href="https://profiles.wordpress.org/mdviralsampat/">mdviralsampat</a> · <a href="https://profiles.wordpress.org/immeet94/">Meet Makadia</a> · <a href="https://profiles.wordpress.org/megane9988/">megane9988</a> · <a href="https://profiles.wordpress.org/meher/">Meher Bala</a> · <a href="https://profiles.wordpress.org/melchoyce/">Mel Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/mfgmicha/">Micha Krapp</a> · <a href="https://profiles.wordpress.org/mburridge/">Michael Burridge</a> · <a href="https://profiles.wordpress.org/michaelkeck/">Michael Keck</a> · <a href="https://profiles.wordpress.org/mnelson4/">Michael Nelson</a> · <a href="https://profiles.wordpress.org/xmic/">Michael Sumner</a> · <a href="https://profiles.wordpress.org/michaelreetz/">michaelreetz</a> · <a href="https://profiles.wordpress.org/czapla/">Michal Czaplinski</a> · <a href="https://profiles.wordpress.org/marktimemedia/">Michelle Schulp Hunt</a> · <a href="https://profiles.wordpress.org/mcsf/">Miguel Fonseca</a> · <a href="https://profiles.wordpress.org/migueluy/">Miguel Lezama</a> · <a href="https://profiles.wordpress.org/simison/">Mikael Korpela</a> · <a href="https://profiles.wordpress.org/mobius5150/">Mike</a> · <a href="https://profiles.wordpress.org/mikefitzman/">Mike Fitzpatrick</a> · <a href="https://profiles.wordpress.org/mikehansenme/">Mike Hansen</a> · <a href="https://profiles.wordpress.org/mikejolley/">Mike Jolley</a> · <a href="https://profiles.wordpress.org/mmcalister/">Mike McAlister</a> · <a href="https://profiles.wordpress.org/ritterml/">Mike Ritter</a> · <a href="https://profiles.wordpress.org/mikinc860/">Mikin Chauhan</a> · <a href="https://profiles.wordpress.org/firestar300/">Milan Ricoul</a> · <a href="https://profiles.wordpress.org/multidots1896/">Minal Diwan</a> · <a href="https://profiles.wordpress.org/369work/">Miroku</a> · <a href="https://profiles.wordpress.org/missveronicatv/">missveronica</a> · <a href="https://profiles.wordpress.org/presstoke/">Mitchell Austin</a> · <a href="https://profiles.wordpress.org/mkeck/">mkeck</a> · <a href="https://profiles.wordpress.org/mlaetitia1986/">mlaetitia1986</a> · <a href="https://profiles.wordpress.org/mleray/">mleray</a> · <a href="https://profiles.wordpress.org/mleraygp/">mleraygp</a> · <a href="https://profiles.wordpress.org/mobarak/">Mobarak Ali</a> · <a href="https://profiles.wordpress.org/opurockey/">Mohammad Rockeybul Alam</a> · <a href="https://profiles.wordpress.org/mohkatz/">Mohammed Kateregga</a> · <a href="https://profiles.wordpress.org/mosescursor/">Moses Cursor Ssebunya</a> · <a href="https://profiles.wordpress.org/mrwweb/">mrwweb</a> · <a href="https://profiles.wordpress.org/mtg169/">mtg169</a> · <a href="https://profiles.wordpress.org/mujuonly/">mujuonly</a> · <a href="https://profiles.wordpress.org/mukesh27/">Mukesh Panchal</a> · <a href="https://profiles.wordpress.org/mukulsingh27/">Mukul Singh</a> · <a href="https://profiles.wordpress.org/faguni22/">Mumtahina Faguni</a> · <a href="https://profiles.wordpress.org/sedmikrasky/">N&#250;ria Nadal i Rovira</a> · <a href="https://profiles.wordpress.org/vyasnaman/">Naman Vyas</a> · <a href="https://profiles.wordpress.org/nanisamireddy/">NANI SAMIREDDY</a> · <a href="https://profiles.wordpress.org/narenin/">Narendra Sishodiya</a> · <a href="https://profiles.wordpress.org/nareshbheda/">Naresh Bheda</a> · <a href="https://profiles.wordpress.org/muddassirnasim/">Nasim Miah</a> · <a href="https://profiles.wordpress.org/n8finch/">Nate Finch</a> · <a href="https://profiles.wordpress.org/naveendwivedi/">Naveen Dwivedi</a> · <a href="https://profiles.wordpress.org/navi161/">Navneet Kaur</a> · <a href="https://profiles.wordpress.org/bugnumber9/">Nazar Hotsa</a> · <a href="https://profiles.wordpress.org/nazmul111/">Nazmul Hosen</a> · <a href="https://profiles.wordpress.org/greatislander/">Ned Zimmerman</a> · <a href="https://profiles.wordpress.org/nexbridge/">nexbridge</a> · <a href="https://profiles.wordpress.org/nextendweb/">Nextendweb</a> · <a href="https://profiles.wordpress.org/neychok/">Neycho Kalaydzhiev</a> · <a href="https://profiles.wordpress.org/nickchomey/">Nick</a> · <a href="https://profiles.wordpress.org/nickstarkloff/">Nick</a> · <a href="https://profiles.wordpress.org/ndiego/">Nick Diego</a> · <a href="https://profiles.wordpress.org/celloexpressions/">Nick Halsey</a> · <a href="https://profiles.wordpress.org/nickbrazilian/">nickbrazilian</a> · <a href="https://profiles.wordpress.org/nickjbedford/">nickjbedford</a> · <a href="https://profiles.wordpress.org/nickpagz/">nickpagz</a> · <a href="https://profiles.wordpress.org/nickwilmot/">nickwilmot</a> · <a href="https://profiles.wordpress.org/nico23/">Nico</a> · <a href="https://profiles.wordpress.org/nidhidhandhukiya/">nidhidhandhukiya</a> · <a href="https://profiles.wordpress.org/nielslange/">Niels Lange</a> · <a href="https://profiles.wordpress.org/nigelnelles/">nigelnelles</a> · <a href="https://profiles.wordpress.org/ntsekouras/">Nik Tsekouras</a> · <a href="https://profiles.wordpress.org/smushytaco/">Nikan Radan</a> · <a href="https://profiles.wordpress.org/nikunj8866/">Nikunj Hatkar</a> · <a href="https://profiles.wordpress.org/nimeshatxecurify/">Nimesh</a> · <a href="https://profiles.wordpress.org/ninomiho/">Nino Mihovilic</a> · <a href="https://profiles.wordpress.org/ninos-ego/">Ninos</a> · <a href="https://profiles.wordpress.org/noahtallen/">Noah Allen</a> · <a href="https://profiles.wordpress.org/othernoel/">Noel Santos</a> · <a href="https://profiles.wordpress.org/noruzzaman/">Noruzzaman</a> · <a href="https://profiles.wordpress.org/nosilver4u/">nosilver4u</a> · <a href="https://profiles.wordpress.org/oceantober/">oceantober</a> · <a href="https://profiles.wordpress.org/oferlaor/">oferlaor</a> · <a href="https://profiles.wordpress.org/okat/">okat</a> · <a href="https://profiles.wordpress.org/yasunocco/">Okawa Yasuno</a> · <a href="https://profiles.wordpress.org/oglekler/">Olga Gleckler</a> · <a href="https://profiles.wordpress.org/domainsupport/">Oliver Campion</a> · <a href="https://profiles.wordpress.org/alshakero/">Omar Alshaker</a> · <a href="https://profiles.wordpress.org/gabertronic/">Ophelia Rose</a> · <a href="https://profiles.wordpress.org/optimizingmatters/">Optimizing Matters</a> · <a href="https://profiles.wordpress.org/owi/">owi</a> · <a href="https://profiles.wordpress.org/paaljoachim/">Paal Joachim Romdahl</a> · <a href="https://profiles.wordpress.org/pablohoneyhoney/">Pablo Honey</a> · <a href="https://profiles.wordpress.org/palak678/">Palak Patel</a> · <a href="https://profiles.wordpress.org/paragoninitiativeenterprises/">Paragon Initiative Enterprises</a> · <a href="https://profiles.wordpress.org/parinpanjari/">Parin Panjari</a> · <a href="https://profiles.wordpress.org/parthvataliya/">Parth vataliya</a> · <a href="https://profiles.wordpress.org/techpartho/">Partho Hore</a> · <a href="https://profiles.wordpress.org/swissspidy/">Pascal Birchler</a> · <a href="https://profiles.wordpress.org/pateljaymin/">Patel Jaymin</a> · <a href="https://profiles.wordpress.org/patricia70/">Patricia BT</a> · <a href="https://profiles.wordpress.org/lumiblog/">Patrick Lumumba</a> · <a href="https://profiles.wordpress.org/patpiwo/">Patrick Piwowarczyk</a> · <a href="https://profiles.wordpress.org/pryley/">Paul</a> · <a href="https://profiles.wordpress.org/pbearne/">Paul Bearne</a> · <a href="https://profiles.wordpress.org/pbiron/">Paul Biron</a> · <a href="https://profiles.wordpress.org/paulbonneau/">Paul Bonneau</a> · <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a> · <a href="https://profiles.wordpress.org/paulopmt1/">Paulo Trentin</a> · <a href="https://profiles.wordpress.org/paulstanos/">paulstanos</a> · <a href="https://profiles.wordpress.org/pcarvalho/">pcarvalho</a> · <a href="https://profiles.wordpress.org/pedrofigueroa1989/">Pedro Figueroa</a> · <a href="https://profiles.wordpress.org/peroks/">Per Egil Roksvaag</a> · <a href="https://profiles.wordpress.org/peteringersoll/">Peter Ingersoll</a> · <a href="https://profiles.wordpress.org/westi/">Peter Westwood</a> · <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a> · <a href="https://profiles.wordpress.org/petitphp/">petitphp</a> · <a href="https://profiles.wordpress.org/philipjohn/">Philip John</a> · <a href="https://profiles.wordpress.org/philsola/">Philip Sola</a> · <a href="https://profiles.wordpress.org/tyrannous/">Philipp Bammes</a> · <a href="https://profiles.wordpress.org/phillsav/">Phill</a> · <a href="https://profiles.wordpress.org/piskvorky/">piskvorky</a> · <a href="https://profiles.wordpress.org/poojabhimani/">Pooja Bhimani</a> · <a href="https://profiles.wordpress.org/poojapadamad/">poojapadamad</a> · <a href="https://profiles.wordpress.org/porg/">porg</a> · <a href="https://profiles.wordpress.org/prab18hat/">prab18hat</a> · <a href="https://profiles.wordpress.org/praful2111/">Praful Patel</a> · <a href="https://profiles.wordpress.org/pranjalpratapsingh/">Pranjal Pratap Singh</a> · <a href="https://profiles.wordpress.org/prasadkarmalkar/">Prasad Karmalkar</a> · <a href="https://profiles.wordpress.org/prasadgupte/">prasadgupte</a> · <a href="https://profiles.wordpress.org/pmbaldha/">Prashant Baldha</a> · <a href="https://profiles.wordpress.org/pratiklondhe/">Pratik Londhe</a> · <a href="https://profiles.wordpress.org/presskopp/">Presskopp</a> · <a href="https://profiles.wordpress.org/prettyboymp/">prettyboymp</a> · <a href="https://profiles.wordpress.org/puggan/">puggan</a> · <a href="https://profiles.wordpress.org/quentinr64600/">quentinr64600</a> · <a href="https://profiles.wordpress.org/rachelbaker/">Rachel Baker</a> · <a href="https://profiles.wordpress.org/rafiq91/">Rafiqul Islam</a> · <a href="https://profiles.wordpress.org/ralucastn/">Raluca</a> · <a href="https://profiles.wordpress.org/superpoincare/">Ramanan</a> · <a href="https://profiles.wordpress.org/ramiy/">Rami Yushuvaev</a> · <a href="https://profiles.wordpress.org/rahmohn/">Ramon Ahnert</a> · <a href="https://profiles.wordpress.org/rcorrales/">Ramon Corrales</a> · <a href="https://profiles.wordpress.org/ramonopoly/">Ramon James</a> · <a href="https://profiles.wordpress.org/ravichudasama01/">Ravi Chudasama</a> · <a href="https://profiles.wordpress.org/ravigadhiyawp/">Ravi Gadhiya</a> · <a href="https://profiles.wordpress.org/rcrdortiz/">rcrdortiz</a> · <a href="https://profiles.wordpress.org/rehanali/">Rehan Ali</a> · <a href="https://profiles.wordpress.org/rejaulalomkhan/">Rejaul Alom Khan</a> · <a href="https://profiles.wordpress.org/tabrisrp/">Remy Perona</a> · <a href="https://profiles.wordpress.org/espellcaste/">Renato Alves</a> · <a href="https://profiles.wordpress.org/renishsurani/">renishsurani</a> · <a href="https://profiles.wordpress.org/retrofox/">retrofox</a> · <a href="https://profiles.wordpress.org/rezwanshiblu1952/">Rezwan Shiblu</a> · <a href="https://profiles.wordpress.org/youknowriad/">Riad Benguella</a> · <a href="https://profiles.wordpress.org/riadev/">riadev</a> · <a href="https://profiles.wordpress.org/richtabor/">Rich Tabor</a> · <a href="https://profiles.wordpress.org/rockfire/">Richard Korthuis</a> · <a href="https://profiles.wordpress.org/riddhidave/">Riddhi Dave</a> · <a href="https://profiles.wordpress.org/rinatkhaziev/">Rinat</a> · <a href="https://profiles.wordpress.org/rinkalpagdar/">Rinkal Pagdar</a> · <a href="https://profiles.wordpress.org/rishabhwp/">Rishabh Gupta</a> · <a href="https://profiles.wordpress.org/rishavdutta/">Rishav Dutta</a> · <a href="https://profiles.wordpress.org/rishit30g/">Rishit Gupta</a> · <a href="https://profiles.wordpress.org/ristojovanovic/">Risto Jovanovic</a> · <a href="https://profiles.wordpress.org/devrito/">Ritoban</a> · <a href="https://profiles.wordpress.org/noisysocks/">Robert Anderson</a> · <a href="https://profiles.wordpress.org/miqrogroove/">Robert Chapin</a> · <a href="https://profiles.wordpress.org/robertghetau/">Robert Ghetau</a> · <a href="https://profiles.wordpress.org/sanchothefat/">Robert O\'Rourke</a> · <a href="https://profiles.wordpress.org/robmcclel/">Robmcclel</a> · <a href="https://profiles.wordpress.org/rodrigosprimo/">Rodrigo Primo</a> · <a href="https://profiles.wordpress.org/roelof/">roelof</a> · <a href="https://profiles.wordpress.org/rollybueno/">Rolly Bueno</a> · <a href="https://profiles.wordpress.org/ronak44/">Ronak prajapati</a> · <a href="https://profiles.wordpress.org/room34/">Room 34 Creative Services, LLC</a> · <a href="https://profiles.wordpress.org/costasovo/">Rostislav Woln&#253;</a> · <a href="https://profiles.wordpress.org/rotemg/">Rotem Gelbart</a> · <a href="https://profiles.wordpress.org/rayhatron/">Rufaro Madamombe</a> · <a href="https://profiles.wordpress.org/rutvikbhambhi2004/">Rutvik Bhambhi</a> · <a href="https://profiles.wordpress.org/rmccue/">Ryan McCue</a> · <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a> · <a href="https://profiles.wordpress.org/skierpage/">S Page</a> · <a href="https://profiles.wordpress.org/soean/">S&#246;ren W&#252;nsch</a> · <a href="https://profiles.wordpress.org/sabbir1991/">Sabbir Ahmed</a> · <a href="https://profiles.wordpress.org/devsabbirahmed/">Sabbir Sam</a> · <a href="https://profiles.wordpress.org/sachinrajcp123/">SACHINRAJ CP</a> · <a href="https://profiles.wordpress.org/sahiljadhav1617/">Sahil Jadhav</a> · <a href="https://profiles.wordpress.org/sainathpoojary/">Sainath Poojary</a> · <a href="https://profiles.wordpress.org/sajjad67/">Sajjad Hossain Sagor</a> · <a href="https://profiles.wordpress.org/sakibmoon/">sakibmoon</a> · <a href="https://profiles.wordpress.org/samueljseay/">Sam</a> · <a href="https://profiles.wordpress.org/sam_a/">sam_a</a> · <a href="https://profiles.wordpress.org/samirmalpande/">Samir Malpande</a> · <a href="https://profiles.wordpress.org/viralsampat/">Sampat Viral</a> · <a href="https://profiles.wordpress.org/sjapaget/">Samuel Paget</a> · <a href="https://profiles.wordpress.org/otto42/">Samuel Wood (Otto)</a> · <a href="https://profiles.wordpress.org/sandeepdahiya/">Sandeep Dahiya</a> · <a href="https://profiles.wordpress.org/sandipsinh007/">Sandip Sinh</a> · <a href="https://profiles.wordpress.org/ourvalley/">Sandy McFadden</a> · <a href="https://profiles.wordpress.org/mikachan/">Sarah Norris</a> · <a href="https://profiles.wordpress.org/tinkerbelly/">sarah semark</a> · <a href="https://profiles.wordpress.org/sarthaknagoshe2002/">Sarthak Nagoshe</a> · <a href="https://profiles.wordpress.org/satishprajapati/">Satish Prajapati</a> · <a href="https://profiles.wordpress.org/saurabhdhariwal/">saurabh.dhariwal</a> · <a href="https://profiles.wordpress.org/saxonafletcher/">Saxon Fletcher</a> · <a href="https://profiles.wordpress.org/scholdstrom/">scholdstrom</a> · <a href="https://profiles.wordpress.org/swb1192/">Scott Buscemi</a> · <a href="https://profiles.wordpress.org/sc0ttkclark/">Scott Kingsley Clark</a> · <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a> · <a href="https://profiles.wordpress.org/wonderboymusic/">Scott Taylor</a> · <a href="https://profiles.wordpress.org/scribu/">scribu</a> · <a href="https://profiles.wordpress.org/sebastianpisula/">Sebastian Pisula</a> · <a href="https://profiles.wordpress.org/seifradwane/">Seif Radwane</a> · <a href="https://profiles.wordpress.org/sergeybiryukov/">Sergey Biryukov</a> · <a href="https://profiles.wordpress.org/smrubenstein/">Seth Rubenstein</a> · <a href="https://profiles.wordpress.org/shsajalchowdhury/">SH Sajal Chowdhury</a> · <a href="https://profiles.wordpress.org/shadialaghbari/">Shadi G شادي جـ</a> · <a href="https://profiles.wordpress.org/shailu25/">Shail Mehta</a> · <a href="https://profiles.wordpress.org/sh4lin/">Shalin Shah</a> · <a href="https://profiles.wordpress.org/shanemuir/">Shane Muirhead</a> · <a href="https://profiles.wordpress.org/iamshashank/">Shashank Jain</a> · <a href="https://profiles.wordpress.org/shekh0109/">Shashank Shekhar</a> · <a href="https://profiles.wordpress.org/sajib1223/">Shazzad Hossain Khan</a> · <a href="https://profiles.wordpress.org/designsimply/">Sheri Grey</a> · <a href="https://profiles.wordpress.org/shiponkarmakar/">Shipon Karmakar</a> · <a href="https://profiles.wordpress.org/shreya0shrivastava/">Shreya Shrivastava</a> · <a href="https://profiles.wordpress.org/iamshubhamsp/">Shubham Patil</a> · <a href="https://profiles.wordpress.org/shyamgadde/">Shyamsundar Gadde</a> · <a href="https://profiles.wordpress.org/sidharthpandita/">sidharthpandita</a> · <a href="https://profiles.wordpress.org/siliconforks/">siliconforks</a> · <a href="https://profiles.wordpress.org/shilpaashokan94/">Silpa TA</a> · <a href="https://profiles.wordpress.org/simonefontana/">simonefontana</a> · <a href="https://profiles.wordpress.org/slaffik/">Slava Abakumov</a> · <a href="https://profiles.wordpress.org/smerriman/">smerriman</a> · <a href="https://profiles.wordpress.org/snehapatil02/">Sneha Patil</a> · <a href="https://profiles.wordpress.org/maia12345/">Sophie Dimitrov</a> · <a href="https://profiles.wordpress.org/sourabhjain/">Sourabh Jain</a> · <a href="https:/